/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestIssueResourceNoPrioritySet
extends RestFuncTest {
    private IssueClient issueClient;

    public void testUnassignedIssueHasNoValue() throws Exception {
        Issue issue = this.issueClient.get("TST-2", new Issue.Expand[0]);
        TestIssueResourceNoPrioritySet.assertNull((Object)issue.fields.priority);
        TestIssueResourceNoPrioritySet.assertNull((Object)issue.fields.reporter);
        Issue issue2 = this.issueClient.get("TST-1", new Issue.Expand[0]);
        TestIssueResourceNoPrioritySet.assertEquals((String)"Blocker", (String)issue2.fields.priority.name());
        TestIssueResourceNoPrioritySet.assertEquals((String)"admin", (String)issue2.fields.reporter.name);
        this.administration.fieldConfigurations().defaultFieldConfiguration().hideFields("Priority");
        TestIssueResourceNoPrioritySet.assertNull((Object)this.issueClient.get((String)"TST-2", (Issue.Expand[])new Issue.Expand[0]).fields.priority);
        TestIssueResourceNoPrioritySet.assertNull((Object)this.issueClient.get((String)"TST-1", (Issue.Expand[])new Issue.Expand[0]).fields.priority);
        TestIssueResourceNoPrioritySet.assertNull((Object)this.issueClient.get((String)"TST-1", (Issue.Expand[])new Issue.Expand[0]).fields.duedate);
        this.administration.fieldConfigurations().defaultFieldConfiguration().hideFields("Due Date");
        TestIssueResourceNoPrioritySet.assertNull((Object)this.issueClient.get((String)"TST-1", (Issue.Expand[])new Issue.Expand[0]).fields.duedate);
        this.administration.fieldConfigurations().defaultFieldConfiguration().showFields("Due Date");
        this.navigation.issue().setDueDate("TST-1", "10/May/11");
        TestIssueResourceNoPrioritySet.assertTrue((boolean)this.issueClient.get((String)"TST-1", (Issue.Expand[])new Issue.Expand[0]).fields.duedate.startsWith("2011-05-"));
    }

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestIssueResourceNoPrioritySet.xml");
        this.issueClient = new IssueClient((JIRAEnvironmentData)this.getEnvironmentData());
    }
}

