/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestIssueResourceNames
extends FuncTestCase {
    private IssueClient issueClient;

    public void testIssueRepresentationShouldContainExpandableNamesField() throws Exception {
        this.administration.restoreData("TestIssueResourceCustomFields.xml");
        Issue minimal = this.issueClient.get("HSP-1", new Issue.Expand[0]);
        Assert.assertThat((String)"names should not be expanded by default", (Object)minimal.names, (Matcher)CoreMatchers.equalTo(null));
        Assert.assertThat((Object)minimal.expand, (Matcher)Matchers.containsString((String)Issue.Expand.names.name()));
        Issue expanded = this.issueClient.get("HSP-1", new Issue.Expand[]{Issue.Expand.names});
        HashSet fields = Sets.newHashSet((Iterable)Iterables.filter((Iterable)expanded.fields.idSet(), (Predicate)new NonNullFields(expanded)));
        Set names = expanded.names.keySet();
        TestIssueResourceNames.assertTrue((String)("Found in 'fields' but not in 'names': " + Sets.difference((Set)fields, names)), (boolean)Sets.difference((Set)fields, names).isEmpty());
    }

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.issueClient = new IssueClient((JIRAEnvironmentData)this.getEnvironmentData());
    }

    private static class NonNullFields
    implements Predicate<String> {
        private final Issue expanded;

        public NonNullFields(Issue expanded) {
            this.expanded = expanded;
        }

        public boolean apply(@Nullable String fieldId) {
            return this.expanded.fields.get(fieldId) != null;
        }
    }
}

