/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.matcher.LinkedIssuesMatcher;
import com.atlassian.jira.rest.api.issue.FieldOperation;
import com.atlassian.jira.rest.api.issue.IssueUpdateRequest;
import com.atlassian.jira.rest.api.issue.ResourceRef;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import com.atlassian.jira.testkit.client.restclient.IssueLink;
import com.atlassian.jira.testkit.client.restclient.IssueType;
import com.atlassian.jira.testkit.client.restclient.LinkRequest;
import com.atlassian.jira.testkit.client.restclient.Priority;
import com.atlassian.jira.testkit.client.restclient.Status;
import com.atlassian.jira.testkit.client.restclient.StatusCategory;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

@WebTest(value={Category.FUNC_TEST, Category.REST, Category.ISSUE_LINKS})
public class TestIssueResourceIssueLinks
extends RestFuncTest {
    private IssueClient issueClient;

    public void testIssueLinksDisabled() throws Exception {
        this.restoreData(false);
        Issue issue = this.issueClient.get("LNK-4", new Issue.Expand[0]);
        TestIssueResourceIssueLinks.assertNull((Object)issue.fields.issuelinks);
    }

    public void testNoIssueLinks() throws Exception {
        this.restoreData(true);
        Issue issue = this.issueClient.get("LNK-5", new Issue.Expand[0]);
        TestIssueResourceIssueLinks.assertEquals((String)"Object should have no issue links", (int)0, (int)issue.fields.issuelinks.size());
    }

    public void testNoOutwardIssueLinks() throws Exception {
        this.restoreData(true);
        Issue issue = this.issueClient.get("LNK-1", new Issue.Expand[0]);
        List links = issue.fields.issuelinks;
        for (IssueLink link : links) {
            TestIssueResourceIssueLinks.assertNull((Object)link.outwardIssue());
        }
    }

    public void testNoVisibleLinks() throws Exception {
        this.restoreData(true);
        Issue issue = ((IssueClient)this.issueClient.loginAs("reporter")).get("LNK-2", new Issue.Expand[0]);
        TestIssueResourceIssueLinks.assertEquals((String)"Object should have no visible issue links", (int)0, (int)issue.fields.issuelinks.size());
    }

    public void testInvisibleIssueNotShown() throws Exception {
        this.restoreData(true);
        Issue issue = ((IssueClient)this.issueClient.loginAs("reporter")).get("LNK-4", new Issue.Expand[0]);
        List links = issue.fields.issuelinks;
        TestIssueResourceIssueLinks.assertEquals((int)1, (int)links.size());
        TestIssueResourceIssueLinks.assertEquals((String)"LNK-1", (String)((IssueLink)links.get(0)).outwardIssue().key());
    }

    public void testSeveralIssueLinks() throws Exception {
        this.restoreData(true);
        Issue issue = this.issueClient.get("LNK-4", new Issue.Expand[0]);
        List links = issue.fields.issuelinks;
        TestIssueResourceIssueLinks.assertEquals((int)2, (int)links.size());
        TestIssueResourceIssueLinks.assertEquals((String)((IssueLink)links.get(0)).outwardIssue().key(), (String)"LNK-1");
        TestIssueResourceIssueLinks.assertEquals((String)((IssueLink)links.get(1)).outwardIssue().key(), (String)"LNK-3");
    }

    public void testEachIssueLinkShouldContainAllTheInformationNecessaryForClientsToRenderIt() throws Exception {
        this.restoreData(true);
        Issue issue = ((IssueClient)this.issueClient.loginAs("reporter")).get("LNK-6", new Issue.Expand[0]);
        List links = issue.fields.issuelinks;
        TestIssueResourceIssueLinks.assertEquals((int)1, (int)links.size());
        IssueLink linktoLnk1 = (IssueLink)links.get(0);
        Assert.assertThat((Object)linktoLnk1.type(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)new IssueLink.Type().id("10000").name("Duplicate").inward("is duplicated by").outward("duplicates").self(this.getBaseUrlPlus("/rest/api/2/issueLinkType/10000")))));
        Assert.assertThat((Object)linktoLnk1.inwardIssue(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(null)));
        Assert.assertThat((Object)linktoLnk1.outwardIssue(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)new IssueLink.IssueLinkRef().id("10000").key("LNK-1").self(this.getRestApiUrl("/issue/10000")).fields(new IssueLink.IssueLinkRef.Fields().summary("1 visible link").issueType(new IssueType().id("1").self(this.getRestApiUrl("/issuetype/1")).name("Bug").subtask(false).description("A problem which impairs or prevents the functions of the product.").iconUrl(this.getBaseUrlPlus("/images/icons/issuetypes/bug.png"))).status(new Status().id("1").name("Open").self(this.getRestApiUrl("/status/1")).description("The issue is open and ready for the assignee to start work on it.").iconUrl(this.getBaseUrlPlus("/images/icons/statuses/open.png")).statusCategory(new StatusCategory(this.getRestApiUrl("statuscategory/2"), Long.valueOf(2L), "new", "blue-gray", "To Do"))).priority(new Priority().id("3").name("Major").self(this.getRestApiUrl("/priority/3")).iconUrl(this.getBaseUrlPlus("/images/icons/priorities/major.png")))))));
    }

    public void testIssueEditShouldHandleAddLinkOperation() throws Exception {
        this.restoreData(true);
        String fromIssueKey = "LNK-1";
        String lnk5_key = "LNK-5";
        String lnk6_key = "LNK-6";
        String lnk6_id = "10010";
        String duplicate_name = "Duplicate";
        String duplicate_id = "10000";
        Assert.assertThat((String)"Link already exists, test needs to be updated", (Object)this.issueClient.get("LNK-1", new Issue.Expand[0]), (Matcher)Matchers.not(LinkedIssuesMatcher.hasLinkWithOutwardIssue("LNK-5", "Duplicate")));
        Assert.assertThat((String)"Link already exists, test needs to be updated", (Object)this.issueClient.get("LNK-1", new Issue.Expand[0]), (Matcher)Matchers.not(LinkedIssuesMatcher.hasLinkWithOutwardIssue("LNK-6", "Duplicate")));
        this.issueClient.edit("LNK-1", new IssueUpdateRequest().update("issuelinks", Arrays.asList(new FieldOperation().operation("add").value((Object)new LinkRequest().type(ResourceRef.withName((String)"Duplicate")).outwardIssue(ResourceRef.withKey((String)"LNK-5"))))));
        Assert.assertThat((Object)this.issueClient.get("LNK-1", new Issue.Expand[0]), LinkedIssuesMatcher.hasLinkWithOutwardIssue("LNK-5", "Duplicate"));
        this.issueClient.edit("LNK-1", new IssueUpdateRequest().update("issuelinks", Arrays.asList(new FieldOperation().operation("add").value((Object)new LinkRequest().type(ResourceRef.withId((String)"10000")).outwardIssue(ResourceRef.withId((String)"10010"))))));
        Assert.assertThat((Object)this.issueClient.get("LNK-1", new Issue.Expand[0]), LinkedIssuesMatcher.hasLinkWithOutwardIssue("LNK-6", "Duplicate"));
    }

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.issueClient = new IssueClient((JIRAEnvironmentData)this.getEnvironmentData());
    }

    private void restoreData(boolean issueLinkingEnabled) throws IOException {
        this.administration.restoreData("TestIssueResourceIssueLinks.xml");
        if (!issueLinkingEnabled) {
            this.administration.issueLinking().disable();
        }
    }
}

