/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.rest.api.util.StringList;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Component;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import com.atlassian.jira.testkit.client.restclient.IssueType;
import com.atlassian.jira.testkit.client.restclient.Priority;
import com.atlassian.jira.testkit.client.restclient.Progress;
import com.atlassian.jira.testkit.client.restclient.Project;
import com.atlassian.jira.testkit.client.restclient.Resolution;
import com.atlassian.jira.testkit.client.restclient.SearchClient;
import com.atlassian.jira.testkit.client.restclient.SearchRequest;
import com.atlassian.jira.testkit.client.restclient.SearchResult;
import com.atlassian.jira.testkit.client.restclient.Status;
import com.atlassian.jira.testkit.client.restclient.User;
import com.atlassian.jira.testkit.client.restclient.Version;
import com.atlassian.jira.testkit.client.restclient.Vote;
import com.atlassian.jira.testkit.client.restclient.Watches;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestIssueResourceFields
extends RestFuncTest {
    private static final Long DEFAULT_AVATAR_ID = 10011L;
    private IssueClient issueClient;
    private SearchClient searchClient;

    public void testExpandos() throws Exception {
        this.administration.restoreData("TestIssueResourceFields.xml");
        Issue minimal = this.issueClient.get("HSP-1", new Issue.Expand[0]);
        Assert.assertThat((Object)minimal.expand, (Matcher)Matchers.containsString((String)Issue.Expand.renderedFields.name()));
        Assert.assertThat((Object)minimal.renderedFields, (Matcher)Matchers.equalTo(null));
        Issue expanded = this.issueClient.get("HSP-1", new Issue.Expand[]{Issue.Expand.renderedFields});
        TestIssueResourceFields.assertNotNull((Object)expanded.renderedFields.environment);
        TestIssueResourceFields.assertNotNull((Object)expanded.renderedFields.description);
        TestIssueResourceFields.assertEquals((int)1, (int)expanded.renderedFields.comment.getComments().size());
        TestIssueResourceFields.assertNotNull((Object)expanded.renderedFields.timetracking);
        TestIssueResourceFields.assertEquals((int)1, (int)expanded.renderedFields.worklog.worklogs.size());
    }

    public void testRenderedTextFields() throws Exception {
        this.administration.restoreData("TestIssueResourceFields.xml");
        Issue expanded = this.issueClient.get("HSP-1", new Issue.Expand[]{Issue.Expand.renderedFields});
        TestIssueResourceFields.assertEquals((String)"Curabitur bibendum molestie eros vel pretium.\n", (String)expanded.fields.environment);
        TestIssueResourceFields.assertEquals((String)"Curabitur bibendum molestie eros vel pretium.<br/>\n", (String)expanded.renderedFields.environment);
        TestIssueResourceFields.assertEquals((String)"Suspendisse a mi augue. Donec quis.\n", (String)expanded.fields.description);
        TestIssueResourceFields.assertEquals((String)"Suspendisse a mi augue. Donec quis.<br/>\n", (String)expanded.renderedFields.description);
    }

    public void testRenderedDateFields() throws Exception {
        this.administration.restoreData("TestIssueResourceFields.xml");
        Issue expanded = this.issueClient.get("HSP-1", new Issue.Expand[]{Issue.Expand.renderedFields});
        TestIssueResourceFields.assertEquals((String)"2010-06-11T12:17:45.383+1000", (String)expanded.fields.created);
        TestIssueResourceFields.assertEquals((String)"11/Jun/10 12:17 PM", (String)expanded.renderedFields.created);
        TestIssueResourceFields.assertEquals((String)"2010-06-11T12:25:16.265+1000", (String)expanded.fields.updated);
        TestIssueResourceFields.assertEquals((String)"11/Jun/10 12:25 PM", (String)expanded.renderedFields.updated);
        TestIssueResourceFields.assertEquals((String)"2010-06-11T12:19:10.488+1000", (String)expanded.fields.resolutiondate);
        TestIssueResourceFields.assertEquals((String)"11/Jun/10 12:19 PM", (String)expanded.renderedFields.resolutiondate);
        TestIssueResourceFields.assertEquals((String)"2010-06-23", (String)expanded.fields.duedate);
        TestIssueResourceFields.assertEquals((String)"23/Jun/10", (String)expanded.renderedFields.duedate);
    }

    public void testSystemFields() throws Exception {
        this.administration.restoreData("TestIssueResourceFields.xml");
        Issue json = this.issueClient.get("HSP-1", new Issue.Expand[]{Issue.Expand.renderedFields, Issue.Expand.transitions});
        TestIssueResourceFields.assertEquals((String)"10000", (String)json.id);
        TestIssueResourceFields.assertEquals((String)"HSP-1", (String)json.key);
        TestIssueResourceFields.assertEquals((String)(this.getBaseUrl() + "/rest/api/2/issue/10000"), (String)json.self);
        TestIssueResourceFields.assertNotNull((Object)json.fields);
        TestIssueResourceFields.assertNotNull((Object)json.transitions);
        TestIssueResourceFields.assertNotNull((Object)json.renderedFields);
        TestIssueResourceFields.assertEquals((int)2, (int)json.transitions.size());
        Issue.Fields fields = json.fields;
        TestIssueResourceFields.assertNotNull((Object)fields.summary);
        TestIssueResourceFields.assertEquals((String)"Donec posuere tellus nulla; vitae pellentesque.", (String)fields.summary);
        Vote votes = fields.votes;
        TestIssueResourceFields.assertEquals((int)0, (int)votes.votes);
        TestIssueResourceFields.assertEquals((boolean)false, (boolean)votes.hasVoted);
        TestIssueResourceFields.assertEquals((String)(this.getBaseUrl() + "/rest/api/2/issue/HSP-1/votes"), (String)votes.self);
        Watches watchers = fields.watches;
        TestIssueResourceFields.assertEquals((long)1L, (long)watchers.watchCount);
        TestIssueResourceFields.assertEquals((boolean)true, (boolean)watchers.isWatching);
        TestIssueResourceFields.assertEquals((String)(this.getBaseUrl() + "/rest/api/2/issue/HSP-1/watchers"), (String)watchers.self);
        TestIssueResourceFields.assertNotNull((Object)fields.security);
        TestIssueResourceFields.assertEquals((String)"Insecure", (String)fields.security.name);
        TestIssueResourceFields.assertNotNull((Object)fields.resolutiondate);
        this.assertEqualDateStrings("2010-06-11T12:19:10.488+1000", fields.resolutiondate);
        TestIssueResourceFields.assertNotNull((Object)fields.environment);
        TestIssueResourceFields.assertEquals((String)"Curabitur bibendum molestie eros vel pretium.<br/>\n", (String)json.renderedFields.environment);
        TestIssueResourceFields.assertNotNull((Object)fields.updated);
        this.assertEqualDateStrings("2010-06-11T12:25:16.265+1000", fields.updated);
        TestIssueResourceFields.assertNotNull((Object)fields.created);
        this.assertEqualDateStrings("2010-06-11T12:17:45.383+1000", fields.created);
        TestIssueResourceFields.assertNotNull((Object)fields.description);
        TestIssueResourceFields.assertEquals((String)"Suspendisse a mi augue. Donec quis.<br/>\n", (String)json.renderedFields.description);
        TestIssueResourceFields.assertNotNull((Object)fields.duedate);
        TestIssueResourceFields.assertEquals((String)"2010-06-23", (String)fields.duedate);
        this.checkLabels(fields);
        TestIssueResourceFields.assertNotNull((Object)fields.timetracking);
        this.checkIssueType(fields);
        this.checkStatus(fields);
        this.checkAssignee(fields);
        this.checkReporter(fields);
        this.checkResolution(fields);
        this.checkProject(fields);
        this.checkPriority(fields);
        this.checkProgress(fields);
        this.checkComponents(fields);
        this.checkFixVersions(fields);
        this.checkVersions(fields);
    }

    public void testFieldsParam() throws Exception {
        this.administration.restoreData("TestIssueResourceFields.xml");
        HashSet fieldsToInclude = Sets.newHashSet((Object[])new String[]{"summary", "status", "assignee"});
        Issue json = this.issueClient.getPartially("HSP-2", new StringList[]{StringList.fromList((String[])new String[]{"summary"}), StringList.fromList((String[])new String[]{"status", "assignee"})});
        Issue.Fields fields = json.fields;
        TestIssueResourceFields.assertNotNull((Object)fields);
        for (String field : fieldsToInclude) {
            TestIssueResourceFields.assertNotNull((String)("field was not returned: " + field), (Object)fields.get(field));
        }
        Sets.SetView notReturnedFields = Sets.difference((Set)fields.idSet(), (Set)fieldsToInclude);
        for (String field : notReturnedFields) {
            TestIssueResourceFields.assertNull((String)("field was returned: " + field), (Object)fields.get(field));
        }
    }

    public void testNoCommentsInSearch() throws Exception {
        this.administration.restoreData("TestIssueResourceFields.xml");
        SearchRequest search = new SearchRequest().jql("KEY = HSP-2");
        SearchResult result = this.searchClient.getSearch(search);
        TestIssueResourceFields.assertEquals((int)1, (int)result.issues.size());
        Issue json = (Issue)result.issues.get(0);
        TestIssueResourceFields.assertNull((Object)json.fields.comment);
    }

    public void testAddingCommentsInSearch() throws Exception {
        this.administration.restoreData("TestIssueResourceFields.xml");
        SearchRequest search = new SearchRequest().jql("KEY = HSP-2").fields(new String[]{"*navigable", "comment"});
        SearchResult result = this.searchClient.getSearch(search);
        TestIssueResourceFields.assertEquals((int)1, (int)result.issues.size());
        Issue json = (Issue)result.issues.get(0);
        TestIssueResourceFields.assertNotNull((Object)json.fields.comment);
        TestIssueResourceFields.assertEquals((Object)0, (Object)json.fields.comment.getTotal());
    }

    public void testFieldsParamWithCustomFields() throws Exception {
        this.administration.restoreData("TestIssueResourceFields.xml");
        Issue json = this.issueClient.getPartially("HSP-2", new StringList[]{StringList.fromList((String[])new String[]{"summary", "status", "assignee", "customfield_10001"})});
        Issue.Fields fields = json.fields;
        TestIssueResourceFields.assertNotNull((Object)fields);
        TestIssueResourceFields.assertNotNull((Object)fields.get("summary"));
        TestIssueResourceFields.assertNotNull((Object)fields.get("status"));
        TestIssueResourceFields.assertNotNull((Object)fields.get("assignee"));
        TestIssueResourceFields.assertNotNull((Object)fields.get("customfield_10001"));
        Set idSet = fields.idSet();
        idSet.remove("summary");
        idSet.remove("status");
        idSet.remove("assignee");
        idSet.remove("customfield_10001");
        for (String id : idSet) {
            TestIssueResourceFields.assertNull((Object)fields.get(id));
        }
    }

    public void testFieldsNotShown() throws Exception {
        this.administration.restoreData("TestIssueResourceFields.xml");
        Issue json = this.issueClient.get("HSP-2", new Issue.Expand[0]);
        Issue.Fields fields = json.fields;
        TestIssueResourceFields.assertNotNull((Object)fields);
        try {
            fields.get("customfield_10100");
            TestIssueResourceFields.fail((String)"Customfield 10100 should not be present for this type of issue");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        json = this.issueClient.get("HSP-3", new Issue.Expand[0]);
        fields = json.fields;
        TestIssueResourceFields.assertNotNull((Object)fields);
        TestIssueResourceFields.assertNotNull((Object)fields.get("customfield_10100"));
        TestIssueResourceFields.assertEquals((Object)"Elizabeth", (Object)fields.get("customfield_10100"));
    }

    public void testPriorityIssueTypeAndStatusIconUrlShouldBeReturnedCorrectlyIfItIsAnAbsoluteUrl() throws Exception {
        this.administration.restoreData("TestIssueResourceFields.xml");
        Issue hsp2 = this.issueClient.get("HSP-2", new Issue.Expand[0]);
        Assert.assertThat((Object)hsp2.fields.issuetype.iconUrl, (Matcher)Matchers.equalTo((Object)"http://127.0.0.1:8090/jira/images/icons/task.gif"));
        Assert.assertThat((Object)hsp2.fields.priority.iconUrl(), (Matcher)Matchers.equalTo((Object)"http://127.0.0.1:8090/jira/images/icons/priority_critical.gif"));
        Assert.assertThat((Object)hsp2.fields.status.iconUrl(), (Matcher)Matchers.equalTo((Object)"http://127.0.0.1:8090/jira/images/icons/status_open.gif"));
    }

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.issueClient = new IssueClient((JIRAEnvironmentData)this.getEnvironmentData());
        this.searchClient = new SearchClient((JIRAEnvironmentData)this.getEnvironmentData());
    }

    private void checkFixVersions(Issue.Fields fields) {
        TestIssueResourceFields.assertNotNull((Object)fields.fixVersions);
        List versions = fields.fixVersions;
        TestIssueResourceFields.assertEquals((String)(this.getBaseUrl() + "/rest/api/2/version/10000"), (String)((Version)versions.get((int)0)).self);
        TestIssueResourceFields.assertEquals((String)"Test Version Description 1", (String)((Version)versions.get((int)0)).description);
        TestIssueResourceFields.assertEquals((String)"New Version 1", (String)((Version)versions.get((int)0)).name);
        TestIssueResourceFields.assertFalse((boolean)((Version)versions.get((int)0)).archived);
        TestIssueResourceFields.assertFalse((boolean)((Version)versions.get((int)0)).released);
        TestIssueResourceFields.assertEquals((String)this.getRestApiUrl("version/10002"), (String)((Version)versions.get((int)1)).self);
        TestIssueResourceFields.assertEquals((String)"Test Version Description 5", (String)((Version)versions.get((int)1)).description);
        TestIssueResourceFields.assertEquals((String)"New Version 5", (String)((Version)versions.get((int)1)).name);
        TestIssueResourceFields.assertFalse((boolean)((Version)versions.get((int)1)).archived);
        TestIssueResourceFields.assertFalse((boolean)((Version)versions.get((int)1)).released);
    }

    private void checkVersions(Issue.Fields fields) {
        TestIssueResourceFields.assertNotNull((Object)fields.versions);
        List versions = fields.versions;
        TestIssueResourceFields.assertEquals((String)this.getRestApiUrl("version/10000"), (String)((Version)versions.get((int)0)).self);
        TestIssueResourceFields.assertEquals((String)"Test Version Description 1", (String)((Version)versions.get((int)0)).description);
        TestIssueResourceFields.assertEquals((String)"New Version 1", (String)((Version)versions.get((int)0)).name);
        TestIssueResourceFields.assertFalse((boolean)((Version)versions.get((int)0)).archived);
        TestIssueResourceFields.assertFalse((boolean)((Version)versions.get((int)0)).released);
        TestIssueResourceFields.assertEquals((String)this.getRestApiUrl("version/10002"), (String)((Version)versions.get((int)1)).self);
        TestIssueResourceFields.assertEquals((String)"Test Version Description 5", (String)((Version)versions.get((int)1)).description);
        TestIssueResourceFields.assertEquals((String)"New Version 5", (String)((Version)versions.get((int)1)).name);
        TestIssueResourceFields.assertFalse((boolean)((Version)versions.get((int)1)).archived);
        TestIssueResourceFields.assertFalse((boolean)((Version)versions.get((int)1)).released);
    }

    private void checkComponents(Issue.Fields fields) {
        TestIssueResourceFields.assertNotNull((Object)fields.components);
        List components = fields.components;
        TestIssueResourceFields.assertEquals((String)(this.getBaseUrl() + "/rest/api/2/component/10001"), (String)((Component)components.get((int)0)).self);
        TestIssueResourceFields.assertEquals((String)"New Component 2", (String)((Component)components.get((int)0)).name);
        TestIssueResourceFields.assertEquals((String)(this.getBaseUrl() + "/rest/api/2/component/10002"), (String)((Component)components.get((int)1)).self);
        TestIssueResourceFields.assertEquals((String)"New Component 3", (String)((Component)components.get((int)1)).name);
    }

    private void checkPriority(Issue.Fields fields) {
        TestIssueResourceFields.assertNotNull((Object)fields.priority);
        Priority priority = fields.priority;
        TestIssueResourceFields.assertEquals((String)(this.getBaseUrl() + "/rest/api/2/priority/3"), (String)priority.self());
        TestIssueResourceFields.assertEquals((String)(this.getBaseUrl() + "/images/icons/priorities/major.png"), (String)priority.iconUrl());
        TestIssueResourceFields.assertEquals((String)"Major", (String)priority.name());
        TestIssueResourceFields.assertEquals((String)"3", (String)priority.id());
    }

    private void checkProgress(Issue.Fields fields) {
        TestIssueResourceFields.assertNotNull((Object)fields.progress);
        Progress progress = fields.progress;
        TestIssueResourceFields.assertEquals((Object)7200L, (Object)progress.progress());
        TestIssueResourceFields.assertEquals((Object)648000L, (Object)progress.total());
        TestIssueResourceFields.assertEquals((Object)1L, (Object)progress.percent());
        TestIssueResourceFields.assertNotNull((Object)fields.aggregateprogress);
        Progress aggregateprogress = fields.aggregateprogress;
        TestIssueResourceFields.assertEquals((Object)7200L, (Object)aggregateprogress.progress());
        TestIssueResourceFields.assertEquals((Object)648000L, (Object)aggregateprogress.total());
        TestIssueResourceFields.assertEquals((Object)1L, (Object)aggregateprogress.percent());
        TestIssueResourceFields.assertNotNull((Object)fields.workratio);
        TestIssueResourceFields.assertEquals((Object)1L, (Object)fields.workratio);
    }

    private void checkProject(Issue.Fields fields) {
        TestIssueResourceFields.assertNotNull((Object)fields.project);
        Project project = fields.project;
        TestIssueResourceFields.assertEquals((String)(this.getBaseUrl() + "/rest/api/2/project/10000"), (String)project.self);
        TestIssueResourceFields.assertEquals((String)"10000", (String)project.id);
        TestIssueResourceFields.assertEquals((String)"HSP", (String)project.key);
        Assert.assertThat((Object)project.avatarUrls, (Matcher)Matchers.equalTo(this.createProjectAvatarUrls(10000L, 10011L)));
    }

    private void checkResolution(Issue.Fields fields) {
        TestIssueResourceFields.assertNotNull((Object)fields.resolution);
        Resolution resolution = fields.resolution;
        TestIssueResourceFields.assertEquals((String)(this.getBaseUrl() + "/rest/api/2/resolution/1"), (String)resolution.self);
        TestIssueResourceFields.assertEquals((String)"1", (String)resolution.id);
        TestIssueResourceFields.assertEquals((String)"Fixed", (String)resolution.name);
    }

    private void checkAssignee(Issue.Fields fields) {
        TestIssueResourceFields.assertNotNull((Object)fields.assignee);
        User user = fields.assignee;
        TestIssueResourceFields.assertEquals((String)(this.getBaseUrl() + "/rest/api/2/user?username=admin"), (String)user.self);
        TestIssueResourceFields.assertEquals((String)"admin", (String)user.name);
        TestIssueResourceFields.assertEquals((String)"Administrator", (String)user.displayName);
        Assert.assertThat((Object)user.avatarUrls, (Matcher)Matchers.equalTo(this.createUserAvatarUrls(10062L)));
    }

    private void checkReporter(Issue.Fields fields) {
        TestIssueResourceFields.assertNotNull((Object)fields.reporter);
        User user = fields.reporter;
        TestIssueResourceFields.assertEquals((String)(this.getBaseUrl() + "/rest/api/2/user?username=admin"), (String)user.self);
        TestIssueResourceFields.assertEquals((String)"admin", (String)user.name);
        TestIssueResourceFields.assertEquals((String)"Administrator", (String)user.displayName);
        Assert.assertThat((Object)user.avatarUrls, (Matcher)Matchers.equalTo(this.createUserAvatarUrls(10062L)));
    }

    private void checkStatus(Issue.Fields fields) {
        TestIssueResourceFields.assertNotNull((Object)fields.status);
        Status status = fields.status;
        TestIssueResourceFields.assertEquals((String)(this.getBaseUrl() + "/rest/api/2/status/5"), (String)status.self());
        TestIssueResourceFields.assertEquals((String)"Resolved", (String)status.name());
        TestIssueResourceFields.assertEquals((String)"5", (String)status.id());
        TestIssueResourceFields.assertEquals((String)(this.getBaseUrl() + "/images/icons/statuses/resolved.png"), (String)status.iconUrl());
    }

    private void checkIssueType(Issue.Fields fields) {
        TestIssueResourceFields.assertNotNull((Object)fields.issuetype);
        IssueType issueType = fields.issuetype;
        TestIssueResourceFields.assertEquals((String)(this.getBaseUrl() + "/rest/api/2/issuetype/1"), (String)issueType.self);
        TestIssueResourceFields.assertEquals((String)"1", (String)issueType.id);
        TestIssueResourceFields.assertEquals((String)"Bug", (String)issueType.name);
        TestIssueResourceFields.assertEquals((String)(this.getBaseUrl() + "/images/icons/issuetypes/bug.png"), (String)issueType.iconUrl);
        TestIssueResourceFields.assertFalse((boolean)issueType.subtask);
    }

    private void checkLabels(Issue.Fields fields) {
        TestIssueResourceFields.assertNotNull((Object)fields.labels);
        List labels = fields.labels;
        TestIssueResourceFields.assertEquals((int)3, (int)labels.size());
        TestIssueResourceFields.assertEquals((String)"bad", (String)((String)labels.get(0)));
        TestIssueResourceFields.assertEquals((String)"big", (String)((String)labels.get(1)));
        TestIssueResourceFields.assertEquals((String)"wolf", (String)((String)labels.get(2)));
    }

    private Map<String, String> createUserAvatarUrls(Long avatarId) {
        return ImmutableMap.builder().put((Object)"24x24", (Object)this.getBaseUrlPlus("secure/useravatar?size=small&avatarId=" + avatarId)).put((Object)"16x16", (Object)this.getBaseUrlPlus("secure/useravatar?size=xsmall&avatarId=" + avatarId)).put((Object)"32x32", (Object)this.getBaseUrlPlus("secure/useravatar?size=medium&avatarId=" + avatarId)).put((Object)"48x48", (Object)this.getBaseUrlPlus("secure/useravatar?avatarId=" + avatarId)).build();
    }

    private Map<String, String> createProjectAvatarUrls(Long projectId, Long avatarId) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (DEFAULT_AVATAR_ID.equals(avatarId)) {
            builder.put((Object)"24x24", (Object)this.getBaseUrlPlus("secure/projectavatar?size=small&avatarId=" + avatarId)).put((Object)"16x16", (Object)this.getBaseUrlPlus("secure/projectavatar?size=xsmall&avatarId=" + avatarId)).put((Object)"32x32", (Object)this.getBaseUrlPlus("secure/projectavatar?size=medium&avatarId=" + avatarId)).put((Object)"48x48", (Object)this.getBaseUrlPlus("secure/projectavatar?avatarId=" + avatarId));
        } else {
            builder.put((Object)"24x24", (Object)this.getBaseUrlPlus("secure/projectavatar?size=small&pid=" + projectId + "&avatarId=" + avatarId)).put((Object)"16x16", (Object)this.getBaseUrlPlus("secure/projectavatar?size=xsmall&pid=" + projectId + "&avatarId=" + avatarId)).put((Object)"32x32", (Object)this.getBaseUrlPlus("secure/projectavatar?size=medium&pid=" + projectId + "&avatarId=" + avatarId)).put((Object)"48x48", (Object)this.getBaseUrlPlus("secure/projectavatar?pid=" + projectId + "&avatarId=" + avatarId));
        }
        return builder.build();
    }
}

