/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.rest.api.util.StringList;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.BeanClient;
import com.atlassian.jira.testkit.client.restclient.FieldMetaData;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.IssueBean;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import com.atlassian.jira.testkit.client.restclient.IssuePickerBean;
import com.atlassian.jira.testkit.client.restclient.LabelSuggestionBean;
import com.atlassian.jira.testkit.client.restclient.LabelSuggestionsBean;
import com.atlassian.jira.testkit.client.restclient.SectionBean;
import com.atlassian.jira.testkit.client.restclient.User;
import com.atlassian.jira.testkit.client.restclient.UserBean;
import com.atlassian.jira.testkit.client.restclient.UserPickerResultBean;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import java.util.EnumSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestIssueResourceEditMeta
extends RestFuncTest {
    private IssueClient issueClient;
    private BeanClient beanClient;

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.issueClient = new IssueClient((JIRAEnvironmentData)this.getEnvironmentData());
        this.beanClient = new BeanClient((JIRAEnvironmentData)this.getEnvironmentData());
    }

    private void importData() {
        this.administration.restoreData("TestIssueResourceEditMeta.xml");
    }

    public void testEditmetaViaExpand() throws Exception {
        this.importData();
        Issue issue = this.issueClient.get("TST-1", new Issue.Expand[0]);
        TestIssueResourceEditMeta.assertNull((Object)issue.editmeta);
        issue = this.issueClient.get("TST-1", new Issue.Expand[]{Issue.Expand.editmeta});
        TestIssueResourceEditMeta.assertNotNull((Object)issue.editmeta);
        TestIssueResourceEditMeta.assertTrue((boolean)issue.editmeta.fields.containsKey("summary"));
        TestIssueResourceEditMeta.assertTrue((boolean)issue.editmeta.fields.containsKey("description"));
        TestIssueResourceEditMeta.assertTrue((boolean)issue.editmeta.fields.containsKey("timetracking"));
        TestIssueResourceEditMeta.assertTrue((boolean)issue.editmeta.fields.containsKey("issuetype"));
        TestIssueResourceEditMeta.assertTrue((boolean)issue.editmeta.fields.containsKey("labels"));
        TestIssueResourceEditMeta.assertTrue((boolean)issue.editmeta.fields.containsKey("assignee"));
        TestIssueResourceEditMeta.assertTrue((boolean)issue.editmeta.fields.containsKey("security"));
        TestIssueResourceEditMeta.assertTrue((boolean)issue.editmeta.fields.containsKey("resolution"));
        TestIssueResourceEditMeta.assertTrue((boolean)issue.editmeta.fields.containsKey("attachment"));
        TestIssueResourceEditMeta.assertTrue((boolean)issue.editmeta.fields.containsKey("comment"));
        TestIssueResourceEditMeta.assertTrue((boolean)issue.editmeta.fields.containsKey("worklog"));
        issue = this.issueClient.getPartially("TST-1", EnumSet.of(Issue.Expand.editmeta), new StringList[]{StringList.fromList((String[])new String[]{"summary", "description"})});
        TestIssueResourceEditMeta.assertNotNull((Object)issue.editmeta);
        TestIssueResourceEditMeta.assertTrue((boolean)issue.editmeta.fields.containsKey("summary"));
        TestIssueResourceEditMeta.assertTrue((boolean)issue.editmeta.fields.containsKey("description"));
        TestIssueResourceEditMeta.assertEquals((int)2, (int)issue.editmeta.fields.size());
    }

    public void testEditMetaAutoCompleteUrls() throws Exception {
        this.importData();
        this.backdoor.getTestkit().userHistory().addIssue("admin", "TST-2");
        this.backdoor.getTestkit().userHistory().addIssue("admin", "TST-3");
        Issue issue = this.issueClient.get("TST-1", new Issue.Expand[0]);
        TestIssueResourceEditMeta.assertNull((Object)issue.editmeta);
        issue = this.issueClient.get("TST-1", new Issue.Expand[]{Issue.Expand.editmeta});
        TestIssueResourceEditMeta.assertNotNull((Object)issue.editmeta);
        FieldMetaData assignee = (FieldMetaData)issue.editmeta.fields.get("assignee");
        TestIssueResourceEditMeta.assertTrue((boolean)StringUtils.isNotBlank((String)assignee.autoCompleteUrl));
        List assigneeSuggestions = this.beanClient.getUsersFromUrl(assignee.autoCompleteUrl + "a");
        TestIssueResourceEditMeta.assertEquals((int)1, (int)assigneeSuggestions.size());
        TestIssueResourceEditMeta.assertEquals((String)"admin", (String)((User)assigneeSuggestions.get((int)0)).displayName);
        FieldMetaData reporter = (FieldMetaData)issue.editmeta.fields.get("reporter");
        TestIssueResourceEditMeta.assertTrue((boolean)StringUtils.isNotBlank((String)reporter.autoCompleteUrl));
        List reporterSuggestions = this.beanClient.getUsersFromUrl(reporter.autoCompleteUrl + "a");
        TestIssueResourceEditMeta.assertEquals((int)1, (int)reporterSuggestions.size());
        TestIssueResourceEditMeta.assertEquals((String)"admin", (String)((User)reporterSuggestions.get((int)0)).displayName);
        FieldMetaData issueLinks = (FieldMetaData)issue.editmeta.fields.get("issuelinks");
        TestIssueResourceEditMeta.assertTrue((boolean)StringUtils.isNotBlank((String)issueLinks.autoCompleteUrl));
        IssuePickerBean issuePickerBean = this.beanClient.getIssueSuggestionsFromUrl(issueLinks.autoCompleteUrl + "TS");
        TestIssueResourceEditMeta.assertEquals((int)2, (int)((SectionBean)issuePickerBean.sections.get((int)0)).issues.size());
        SectionBean sectionBean = (SectionBean)issuePickerBean.sections.get(0);
        TestIssueResourceEditMeta.assertTrue((boolean)this.containsBeanWithKey(sectionBean.issues, "TST-2"));
        TestIssueResourceEditMeta.assertTrue((boolean)this.containsBeanWithKey(sectionBean.issues, "TST-3"));
        FieldMetaData labels = (FieldMetaData)issue.editmeta.fields.get("labels");
        TestIssueResourceEditMeta.assertTrue((boolean)StringUtils.isNotBlank((String)labels.autoCompleteUrl));
        LabelSuggestionsBean labelSuggestionBean = this.beanClient.getLabelSuggestionsFromUrl(labels.autoCompleteUrl + "b");
        TestIssueResourceEditMeta.assertEquals((int)2, (int)labelSuggestionBean.suggestions.size());
        TestIssueResourceEditMeta.assertEquals((String)"bar", (String)((LabelSuggestionBean)labelSuggestionBean.suggestions.get((int)0)).label);
        TestIssueResourceEditMeta.assertEquals((String)"bob", (String)((LabelSuggestionBean)labelSuggestionBean.suggestions.get((int)1)).label);
        FieldMetaData userPickerCF = (FieldMetaData)issue.editmeta.fields.get("customfield_10010");
        TestIssueResourceEditMeta.assertTrue((boolean)StringUtils.isNotBlank((String)userPickerCF.autoCompleteUrl));
        UserPickerResultBean userPickerResultBean = this.beanClient.getUserPickResultsFromUrl(userPickerCF.autoCompleteUrl + "a");
        TestIssueResourceEditMeta.assertEquals((int)1, (int)userPickerResultBean.users.size());
        TestIssueResourceEditMeta.assertEquals((String)"admin", (String)((UserBean)userPickerResultBean.users.get((int)0)).name);
        FieldMetaData multiUserPickerCF = (FieldMetaData)issue.editmeta.fields.get("customfield_10110");
        TestIssueResourceEditMeta.assertTrue((boolean)StringUtils.isNotBlank((String)multiUserPickerCF.autoCompleteUrl));
        UserPickerResultBean multiUserPickerResultBean = this.beanClient.getUserPickResultsFromUrl(multiUserPickerCF.autoCompleteUrl + "a");
        TestIssueResourceEditMeta.assertEquals((int)1, (int)multiUserPickerResultBean.users.size());
        TestIssueResourceEditMeta.assertEquals((String)"admin", (String)((UserBean)multiUserPickerResultBean.users.get((int)0)).name);
        FieldMetaData labelCF = (FieldMetaData)issue.editmeta.fields.get("customfield_10210");
        TestIssueResourceEditMeta.assertTrue((boolean)StringUtils.isNotBlank((String)labelCF.autoCompleteUrl));
        LabelSuggestionsBean labelSuggestionsBean = this.beanClient.getLabelSuggestionsFromUrl(labelCF.autoCompleteUrl + "b");
        TestIssueResourceEditMeta.assertEquals((int)1, (int)labelSuggestionsBean.suggestions.size());
        TestIssueResourceEditMeta.assertEquals((String)"bob", (String)((LabelSuggestionBean)labelSuggestionsBean.suggestions.get((int)0)).label);
    }

    public void testFieldsFilteredByPermissions() {
        this.importData();
        Issue issue = this.issueClient.get("TST-1", new Issue.Expand[0]);
        TestIssueResourceEditMeta.assertNull((Object)issue.editmeta);
        issue = ((IssueClient)this.issueClient.loginAs("fry")).get("TST-1", new Issue.Expand[]{Issue.Expand.editmeta});
        TestIssueResourceEditMeta.assertNotNull((Object)issue.editmeta);
        TestIssueResourceEditMeta.assertTrue((boolean)issue.editmeta.fields.containsKey("summary"));
        TestIssueResourceEditMeta.assertTrue((boolean)issue.editmeta.fields.containsKey("description"));
        TestIssueResourceEditMeta.assertTrue((boolean)issue.editmeta.fields.containsKey("timetracking"));
        TestIssueResourceEditMeta.assertTrue((boolean)issue.editmeta.fields.containsKey("issuetype"));
        TestIssueResourceEditMeta.assertTrue((boolean)issue.editmeta.fields.containsKey("labels"));
        TestIssueResourceEditMeta.assertTrue((boolean)issue.editmeta.fields.containsKey("security"));
        TestIssueResourceEditMeta.assertTrue((boolean)issue.editmeta.fields.containsKey("resolution"));
        TestIssueResourceEditMeta.assertTrue((boolean)issue.editmeta.fields.containsKey("attachment"));
        TestIssueResourceEditMeta.assertFalse((boolean)issue.editmeta.fields.containsKey("comment"));
        TestIssueResourceEditMeta.assertFalse((boolean)issue.editmeta.fields.containsKey("worklog"));
        TestIssueResourceEditMeta.assertFalse((boolean)issue.editmeta.fields.containsKey("assignee"));
    }

    public void testNothingWhenNoEditPermissions() {
        this.importData();
        Issue issue = ((IssueClient)this.issueClient.loginAs("fry")).get("PH-1", new Issue.Expand[]{Issue.Expand.editmeta});
        TestIssueResourceEditMeta.assertNotNull((Object)issue.editmeta);
        TestIssueResourceEditMeta.assertTrue((boolean)issue.editmeta.fields.isEmpty());
    }

    private boolean containsBeanWithKey(List<IssueBean> issueBeans, String key) {
        for (IssueBean issueBean : issueBeans) {
            if (!issueBean.key.equals(key)) continue;
            return true;
        }
        return false;
    }
}

