/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.rest.api.issue.FieldOperation;
import com.atlassian.jira.rest.api.issue.IssueFields;
import com.atlassian.jira.rest.api.issue.IssueUpdateRequest;
import com.atlassian.jira.rest.api.issue.JsonTypeBean;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import com.atlassian.jira.testkit.client.restclient.Response;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestIssueResourceCustomFields
extends RestFuncTest {
    private IssueClient issueClient;

    public void testTextField() throws Exception {
        this.administration.restoreData("TestIssueResourceCustomFields.xml");
        Issue issue = this.issueClient.get("HSP-1", new Issue.Expand[]{Issue.Expand.schema, Issue.Expand.renderedFields});
        String textField = (String)issue.fields.get("customfield_10021");
        TestIssueResourceCustomFields.assertNotNull((Object)textField);
        TestIssueResourceCustomFields.assertEquals((String)"this is *text*", (String)textField);
        TestIssueResourceCustomFields.assertEquals((String)"com.atlassian.jira.plugin.system.customfieldtypes:textfield", (String)((JsonTypeBean)issue.schema.get("customfield_10021")).getCustom());
        String renderedField = (String)issue.renderedFields.getCustomField("customfield_10021");
        TestIssueResourceCustomFields.assertEquals((String)"<p>this is <b>text</b></p>", (String)renderedField);
        this.issueClient.edit("HSP-1", new IssueUpdateRequest().update("customfield_10021", new FieldOperation[]{new FieldOperation("set", null)}));
        issue = this.issueClient.get("HSP-1", new Issue.Expand[]{Issue.Expand.schema});
        textField = (String)issue.fields.get("customfield_10021");
        TestIssueResourceCustomFields.assertNull((Object)textField);
    }

    public void testTextArea() throws Exception {
        this.administration.restoreData("TestIssueResourceCustomFields.xml");
        Issue issue = this.issueClient.get("HSP-1", new Issue.Expand[]{Issue.Expand.schema, Issue.Expand.renderedFields});
        String textArea = (String)issue.fields.get("customfield_10013");
        TestIssueResourceCustomFields.assertNotNull((Object)textArea);
        TestIssueResourceCustomFields.assertEquals((String)"lots of text here, *brother*!", (String)textArea);
        TestIssueResourceCustomFields.assertEquals((String)"com.atlassian.jira.plugin.system.customfieldtypes:textarea", (String)((JsonTypeBean)issue.schema.get("customfield_10013")).getCustom());
        String renderedField = (String)issue.renderedFields.getCustomField("customfield_10013");
        TestIssueResourceCustomFields.assertEquals((String)"<p>lots of text here, <b>brother</b>!</p>", (String)renderedField);
        this.issueClient.edit("HSP-1", new IssueUpdateRequest().update("customfield_10013", new FieldOperation[]{new FieldOperation("set", null)}));
        issue = this.issueClient.get("HSP-1", new Issue.Expand[]{Issue.Expand.schema});
        textArea = (String)issue.fields.get("customfield_10013");
        TestIssueResourceCustomFields.assertNull((Object)textArea);
    }

    public void testDatePicker() throws Exception {
        this.administration.restoreData("TestIssueResourceCustomFields.xml");
        Issue issue = this.issueClient.get("HSP-1", new Issue.Expand[]{Issue.Expand.schema, Issue.Expand.renderedFields});
        String datePickerCF = (String)issue.fields.get("customfield_10012");
        TestIssueResourceCustomFields.assertNotNull((Object)datePickerCF);
        TestIssueResourceCustomFields.assertEquals((String)"2010-06-23", (String)datePickerCF);
        TestIssueResourceCustomFields.assertEquals((String)"com.atlassian.jira.plugin.system.customfieldtypes:datepicker", (String)((JsonTypeBean)issue.schema.get("customfield_10012")).getCustom());
        String renderedField = (String)issue.renderedFields.getCustomField("customfield_10012");
        TestIssueResourceCustomFields.assertEquals((String)"23/Jun/10", (String)renderedField);
        this.issueClient.edit("HSP-1", new IssueUpdateRequest().update("customfield_10012", new FieldOperation[]{new FieldOperation("set", null)}));
        issue = this.issueClient.get("HSP-1", new Issue.Expand[]{Issue.Expand.schema});
        datePickerCF = (String)issue.fields.get("customfield_10012");
        TestIssueResourceCustomFields.assertNull((Object)datePickerCF);
        IssueUpdateRequest updateRequest = new IssueUpdateRequest().update("customfield_10012", new FieldOperation[]{new FieldOperation("set", (Object)"1981-00-0")});
        Response response = this.issueClient.updateResponse("HSP-1", updateRequest);
        TestIssueResourceCustomFields.assertEquals((int)400, (int)response.statusCode);
        TestIssueResourceCustomFields.assertEquals((String)"Error parsing date string: 1981-00-0", (String)((String)response.entity.errors.get("customfield_10012")));
        updateRequest = new IssueUpdateRequest().update("customfield_10012", new FieldOperation[]{new FieldOperation("set", (Object)"1981-13-1")});
        response = this.issueClient.updateResponse("HSP-1", updateRequest);
        TestIssueResourceCustomFields.assertEquals((int)400, (int)response.statusCode);
        TestIssueResourceCustomFields.assertEquals((String)"Error parsing date string: 1981-13-1", (String)((String)response.entity.errors.get("customfield_10012")));
    }

    public void testDateTime() throws Exception {
        this.administration.restoreData("TestIssueResourceCustomFields.xml");
        Issue issue = this.issueClient.get("HSP-1", new Issue.Expand[]{Issue.Expand.schema, Issue.Expand.renderedFields});
        String dateTimeCF = (String)issue.fields.get("customfield_10001");
        TestIssueResourceCustomFields.assertNotNull((Object)dateTimeCF);
        this.assertEqualDateStrings("2010-06-16T15:26:00.000+1000", dateTimeCF);
        TestIssueResourceCustomFields.assertEquals((String)"com.atlassian.jira.plugin.system.customfieldtypes:datetime", (String)((JsonTypeBean)issue.schema.get("customfield_10001")).getCustom());
        String renderedField = (String)issue.renderedFields.getCustomField("customfield_10001");
        TestIssueResourceCustomFields.assertEquals((String)"16/Jun/10 3:26 PM", (String)renderedField);
        this.issueClient.edit("HSP-1", new IssueUpdateRequest().update("customfield_10001", new FieldOperation[]{new FieldOperation("set", null)}));
        issue = this.issueClient.get("HSP-1", new Issue.Expand[]{Issue.Expand.schema});
        dateTimeCF = (String)issue.fields.get("customfield_10001");
        TestIssueResourceCustomFields.assertNull((Object)dateTimeCF);
        IssueUpdateRequest updateRequest = new IssueUpdateRequest().update("customfield_10001", new FieldOperation[]{new FieldOperation("set", (Object)"1981-00-00T15:12:00.000+1000")});
        Response response = this.issueClient.updateResponse("HSP-1", updateRequest);
        TestIssueResourceCustomFields.assertEquals((int)400, (int)response.statusCode);
        TestIssueResourceCustomFields.assertEquals((String)"Error parsing time: 1981-00-00T15:12:00.000+1000", (String)((String)response.entity.errors.get("customfield_10001")));
        updateRequest = new IssueUpdateRequest().update("customfield_10001", new FieldOperation[]{new FieldOperation("set", (Object)"1981-13-01T15:12:00.000+1000")});
        response = this.issueClient.updateResponse("HSP-1", updateRequest);
        TestIssueResourceCustomFields.assertEquals((int)400, (int)response.statusCode);
        TestIssueResourceCustomFields.assertEquals((String)"Error parsing time: 1981-13-01T15:12:00.000+1000", (String)((String)response.entity.errors.get("customfield_10001")));
    }

    public void testFloat() throws Exception {
        this.administration.restoreData("TestIssueResourceCustomFields.xml");
        Issue issue = this.issueClient.get("HSP-1", new Issue.Expand[]{Issue.Expand.schema});
        Double floatCF = (Double)issue.fields.get("customfield_10018");
        TestIssueResourceCustomFields.assertEquals((String)"com.atlassian.jira.plugin.system.customfieldtypes:float", (String)((JsonTypeBean)issue.schema.get("customfield_10018")).getCustom());
        TestIssueResourceCustomFields.assertEquals((Object)42.0, (Object)floatCF);
        this.issueClient.edit("HSP-1", new IssueUpdateRequest().update("customfield_10018", new FieldOperation[]{new FieldOperation("set", null)}));
        issue = this.issueClient.get("HSP-1", new Issue.Expand[]{Issue.Expand.schema});
        floatCF = (Double)issue.fields.get("customfield_10018");
        TestIssueResourceCustomFields.assertNull((Object)floatCF);
    }

    public void testImportId() throws Exception {
        this.administration.restoreData("TestIssueLinkCheck.xml");
        Issue issue = this.issueClient.get("ANOT-1", new Issue.Expand[]{Issue.Expand.schema});
        Double bugzillaId = (Double)issue.fields.get("customfield_10000");
        TestIssueResourceCustomFields.assertEquals((String)"com.atlassian.jira.plugin.system.customfieldtypes:importid", (String)((JsonTypeBean)issue.schema.get("customfield_10000")).getCustom());
        TestIssueResourceCustomFields.assertEquals((Object)2.0, (Object)bugzillaId);
        this.issueClient.edit("ANOT-1", new IssueUpdateRequest().update("customfield_10000", new FieldOperation[]{new FieldOperation("set", null)}));
        issue = this.issueClient.get("ANOT-1", new Issue.Expand[]{Issue.Expand.schema});
        bugzillaId = (Double)issue.fields.get("customfield_10000");
        TestIssueResourceCustomFields.assertEquals((Object)2.0, (Object)bugzillaId);
    }

    public void testSelect() throws Exception {
        this.administration.restoreData("TestIssueResourceCustomFields.xml");
        Issue issue = this.issueClient.get("HSP-1", new Issue.Expand[]{Issue.Expand.schema});
        Map selectList = (Map)issue.fields.get("customfield_10020");
        TestIssueResourceCustomFields.assertEquals((String)"com.atlassian.jira.plugin.system.customfieldtypes:select", (String)((JsonTypeBean)issue.schema.get("customfield_10020")).getCustom());
        Map options = selectList;
        TestIssueResourceCustomFields.assertEquals((String)(this.getBaseUrl() + "/rest/api/2/customFieldOption/10011"), (String)((String)options.get("self")));
        TestIssueResourceCustomFields.assertEquals((String)"Select!", (String)((String)options.get("value")));
        this.issueClient.edit("HSP-1", new IssueUpdateRequest().update("customfield_10020", new FieldOperation[]{new FieldOperation("set", null)}));
        issue = this.issueClient.get("HSP-1", new Issue.Expand[]{Issue.Expand.schema});
        selectList = (Map)issue.fields.get("customfield_10020");
        TestIssueResourceCustomFields.assertNull((Object)selectList);
    }

    public void testRadioButtons() throws Exception {
        this.administration.restoreData("TestIssueResourceCustomFields.xml");
        Issue issue = this.issueClient.get("HSP-1", new Issue.Expand[]{Issue.Expand.schema});
        Assert.assertThat((Object)((JsonTypeBean)issue.schema.get("customfield_10019")).getCustom(), (Matcher)Matchers.equalTo((Object)"com.atlassian.jira.plugin.system.customfieldtypes:radiobuttons"));
        Map radioButtons = (Map)issue.fields.get("customfield_10019");
        Assert.assertThat(radioButtons.get("self"), (Matcher)Matchers.equalTo((Object)(this.getBaseUrl() + "/rest/api/2/customFieldOption/10010")));
        Assert.assertThat(radioButtons.get("value"), (Matcher)Matchers.equalTo((Object)"Radio Ga Ga"));
        Assert.assertThat((String)"id must be a string=10010", radioButtons.get("id"), (Matcher)Matchers.equalTo((Object)"10010"));
        this.issueClient.edit("HSP-1", new IssueUpdateRequest().update("customfield_10019", new FieldOperation[]{new FieldOperation("set", null)}));
        issue = this.issueClient.get("HSP-1", new Issue.Expand[]{Issue.Expand.schema});
        radioButtons = (Map)issue.fields.get("customfield_10019");
        TestIssueResourceCustomFields.assertNull((Object)radioButtons);
    }

    public void testProject() throws Exception {
        this.administration.restoreData("TestIssueResourceCustomFields.xml");
        Issue issue = this.issueClient.get("HSP-1", new Issue.Expand[]{Issue.Expand.schema});
        Map projectPicker = (Map)issue.fields.get("customfield_10007");
        TestIssueResourceCustomFields.assertEquals((String)"com.atlassian.jira.plugin.system.customfieldtypes:project", (String)((JsonTypeBean)issue.schema.get("customfield_10007")).getCustom());
        TestIssueResourceCustomFields.assertEquals((Object)(this.getBaseUrl() + "/rest/api/2/project/10001"), projectPicker.get("self"));
        TestIssueResourceCustomFields.assertEquals((Object)"MKY", projectPicker.get("key"));
        this.issueClient.edit("HSP-1", new IssueUpdateRequest().update("customfield_10007", new FieldOperation[]{new FieldOperation("set", null)}));
        issue = this.issueClient.get("HSP-1", new Issue.Expand[]{Issue.Expand.schema});
        projectPicker = (Map)issue.fields.get("customfield_10007");
        TestIssueResourceCustomFields.assertNull((Object)projectPicker);
    }

    public void testMultiVersion() throws Exception {
        List multiVersion;
        this.administration.restoreData("TestIssueResourceCustomFields.xml");
        Issue issue = this.issueClient.get("HSP-1", new Issue.Expand[]{Issue.Expand.schema});
        List versions = multiVersion = (List)issue.fields.get("customfield_10011");
        TestIssueResourceCustomFields.assertEquals((String)"com.atlassian.jira.plugin.system.customfieldtypes:multiversion", (String)((JsonTypeBean)issue.schema.get("customfield_10011")).getCustom());
        TestIssueResourceCustomFields.assertEquals((int)2, (int)versions.size());
        HashSet<Map<String, String>> expected = new HashSet<Map<String, String>>(2);
        expected.add(MapBuilder.newBuilder().add("self", this.getBaseUrl() + "/rest/api/2/version/10000").add("name", "New Version 1").toMap());
        expected.add(MapBuilder.newBuilder().add("self", this.getBaseUrl() + "/rest/api/2/version/10002").add("name", "New Version 5").toMap());
        HashSet found = new HashSet(2);
        found.add(MapBuilder.newBuilder().add("self", ((Map)versions.get(0)).get("self")).add("name", ((Map)versions.get(0)).get("name")).toMap());
        found.add(MapBuilder.newBuilder().add("self", ((Map)versions.get(1)).get("self")).add("name", ((Map)versions.get(1)).get("name")).toMap());
        TestIssueResourceCustomFields.assertEquals(found, expected);
        this.issueClient.edit("HSP-1", new IssueUpdateRequest().update("customfield_10011", new FieldOperation[]{new FieldOperation("set", null)}));
        issue = this.issueClient.get("HSP-1", new Issue.Expand[]{Issue.Expand.schema});
        multiVersion = (List)issue.fields.get("customfield_10011");
        TestIssueResourceCustomFields.assertNull((Object)multiVersion);
        IssueUpdateRequest updateRequest = new IssueUpdateRequest().fields(new IssueFields().customField(Long.valueOf(10011L), Collections.singletonList(EasyMap.build((Object)"id", (Object)"10005"))));
        Response response = this.issueClient.updateResponse("HSP-1", updateRequest);
        TestIssueResourceCustomFields.assertEquals((int)400, (int)response.statusCode);
        TestIssueResourceCustomFields.assertEquals((String)"Version id '10005' is not valid", (String)((String)response.entity.errors.get("customfield_10011")));
    }

    public void testVersion() throws Exception {
        Map version;
        this.administration.restoreData("TestIssueResourceCustomFields.xml");
        Issue issue = this.issueClient.get("HSP-1", new Issue.Expand[]{Issue.Expand.schema});
        Map v4 = version = (Map)issue.fields.get("customfield_10009");
        TestIssueResourceCustomFields.assertEquals((String)"com.atlassian.jira.plugin.system.customfieldtypes:version", (String)((JsonTypeBean)issue.schema.get("customfield_10009")).getCustom());
        TestIssueResourceCustomFields.assertEquals((String)(this.getBaseUrl() + "/rest/api/2/version/10001"), (String)((String)v4.get("self")));
        TestIssueResourceCustomFields.assertEquals((String)"New Version 4", (String)((String)v4.get("name")));
        this.issueClient.edit("HSP-1", new IssueUpdateRequest().update("customfield_10009", new FieldOperation[]{new FieldOperation("set", null)}));
        issue = this.issueClient.get("HSP-1", new Issue.Expand[]{Issue.Expand.schema});
        version = (Map)issue.fields.get("customfield_10009");
        TestIssueResourceCustomFields.assertNull((Object)version);
        IssueUpdateRequest updateRequest = new IssueUpdateRequest().fields(new IssueFields().customField(Long.valueOf(10009L), (Object)EasyMap.build((Object)"id", (Object)"10005")));
        Response response = this.issueClient.updateResponse("HSP-1", updateRequest);
        TestIssueResourceCustomFields.assertEquals((int)400, (int)response.statusCode);
        TestIssueResourceCustomFields.assertEquals((String)"Version id '10005' is not valid", (String)((String)response.entity.errors.get("customfield_10009")));
    }

    public void testUserPicker() throws Exception {
        this.administration.restoreData("TestIssueResourceCustomFields.xml");
        Issue issue = this.issueClient.get("HSP-1", new Issue.Expand[]{Issue.Expand.schema});
        Map userPicker = (Map)issue.fields.get("customfield_10022");
        TestIssueResourceCustomFields.assertEquals((String)"com.atlassian.jira.plugin.system.customfieldtypes:userpicker", (String)((JsonTypeBean)issue.schema.get("customfield_10022")).getCustom());
        Map fred = userPicker;
        TestIssueResourceCustomFields.assertEquals((String)(this.getBaseUrl() + "/rest/api/2/user?username=fred"), (String)((String)fred.get("self")));
        TestIssueResourceCustomFields.assertEquals((String)"fred", (String)((String)fred.get("name")));
        TestIssueResourceCustomFields.assertEquals((String)"Fred Normal", (String)((String)fred.get("displayName")));
        this.issueClient.edit("HSP-1", new IssueUpdateRequest().update("customfield_10022", new FieldOperation[]{new FieldOperation("set", null)}));
        issue = this.issueClient.get("HSP-1", new Issue.Expand[]{Issue.Expand.schema});
        userPicker = (Map)issue.fields.get("customfield_10022");
        TestIssueResourceCustomFields.assertNull((Object)userPicker);
    }

    public void testUrl() throws Exception {
        this.administration.restoreData("TestIssueResourceCustomFields.xml");
        Issue issue = this.issueClient.get("HSP-1", new Issue.Expand[]{Issue.Expand.schema, Issue.Expand.renderedFields});
        String url = (String)issue.fields.get("customfield_10010");
        TestIssueResourceCustomFields.assertEquals((String)"com.atlassian.jira.plugin.system.customfieldtypes:url", (String)((JsonTypeBean)issue.schema.get("customfield_10010")).getCustom());
        TestIssueResourceCustomFields.assertEquals((String)"http://www.atlassian.com", (String)url);
        String renderedField = (String)issue.renderedFields.getCustomField("customfield_10010");
        TestIssueResourceCustomFields.assertNull((Object)renderedField);
        this.issueClient.edit("HSP-1", new IssueUpdateRequest().update("customfield_10010", new FieldOperation[]{new FieldOperation("set", null)}));
        issue = this.issueClient.get("HSP-1", new Issue.Expand[]{Issue.Expand.schema});
        url = (String)issue.fields.get("customfield_10010");
        TestIssueResourceCustomFields.assertNull((Object)url);
    }

    public void testMultiSelect() throws Exception {
        this.administration.restoreData("TestIssueResourceCustomFields.xml");
        Issue issue = this.issueClient.get("HSP-1", new Issue.Expand[]{Issue.Expand.schema});
        List multiSelect = (List)issue.fields.get("customfield_10017");
        TestIssueResourceCustomFields.assertEquals((String)"com.atlassian.jira.plugin.system.customfieldtypes:multiselect", (String)((JsonTypeBean)issue.schema.get("customfield_10017")).getCustom());
        TestIssueResourceCustomFields.assertEquals((int)2, (int)multiSelect.size());
        boolean option2Present = false;
        boolean option3Present = false;
        List expectedValues = EasyList.build((Object)"Option 2", (Object)"Option 3");
        for (Map option : multiSelect) {
            TestIssueResourceCustomFields.assertTrue((boolean)expectedValues.contains(option.get("value")));
            if (((String)option.get("value")).equals("Option 2")) {
                option2Present = true;
                TestIssueResourceCustomFields.assertEquals((String)"10007", (String)((String)option.get("id")));
                TestIssueResourceCustomFields.assertEquals((String)(this.getBaseUrl() + "/rest/api/2/customFieldOption/10007"), (String)((String)option.get("self")));
            }
            if (!((String)option.get("value")).equals("Option 3")) continue;
            option3Present = true;
            TestIssueResourceCustomFields.assertEquals((String)"10008", (String)((String)option.get("id")));
            TestIssueResourceCustomFields.assertEquals((String)(this.getBaseUrl() + "/rest/api/2/customFieldOption/10008"), (String)((String)option.get("self")));
        }
        TestIssueResourceCustomFields.assertTrue((option2Present && option3Present ? 1 : 0) != 0);
        this.issueClient.edit("HSP-1", new IssueUpdateRequest().update("customfield_10017", new FieldOperation[]{new FieldOperation("set", null)}));
        issue = this.issueClient.get("HSP-1", new Issue.Expand[]{Issue.Expand.schema});
        multiSelect = (List)issue.fields.get("customfield_10017");
        TestIssueResourceCustomFields.assertNull((Object)multiSelect);
    }

    public void testMultiCheckboxes() throws Exception {
        this.administration.restoreData("TestIssueResourceCustomFields.xml");
        Issue issue = this.issueClient.get("HSP-1", new Issue.Expand[]{Issue.Expand.schema});
        List multiCheckbox = (List)issue.fields.get("customfield_10016");
        TestIssueResourceCustomFields.assertEquals((String)"com.atlassian.jira.plugin.system.customfieldtypes:multicheckboxes", (String)((JsonTypeBean)issue.schema.get("customfield_10016")).getCustom());
        TestIssueResourceCustomFields.assertEquals((int)1, (int)multiCheckbox.size());
        Map option1 = (Map)multiCheckbox.get(0);
        TestIssueResourceCustomFields.assertEquals((String)"10014", (String)((String)option1.get("id")));
        TestIssueResourceCustomFields.assertEquals((String)(this.getBaseUrl() + "/rest/api/2/customFieldOption/10014"), (String)((String)option1.get("self")));
        TestIssueResourceCustomFields.assertEquals((String)"check out my stats", (String)((String)option1.get("value")));
        this.issueClient.edit("HSP-1", new IssueUpdateRequest().update("customfield_10016", new FieldOperation[]{new FieldOperation("set", null)}));
        issue = this.issueClient.get("HSP-1", new Issue.Expand[]{Issue.Expand.schema});
        multiCheckbox = (List)issue.fields.get("customfield_10016");
        TestIssueResourceCustomFields.assertNull((Object)multiCheckbox);
    }

    public void testMultiUserPicker() throws Exception {
        List multiUser;
        this.administration.restoreData("TestIssueResourceCustomFields.xml");
        Issue issue = this.issueClient.get("HSP-1", new Issue.Expand[]{Issue.Expand.schema});
        List users = multiUser = (List)issue.fields.get("customfield_10006");
        TestIssueResourceCustomFields.assertEquals((String)"com.atlassian.jira.plugin.system.customfieldtypes:multiuserpicker", (String)((JsonTypeBean)issue.schema.get("customfield_10006")).getCustom());
        TestIssueResourceCustomFields.assertEquals((int)2, (int)users.size());
        Map admin = (Map)users.get(0);
        TestIssueResourceCustomFields.assertEquals((String)(this.getBaseUrl() + "/rest/api/2/user?username=admin"), (String)((String)admin.get("self")));
        TestIssueResourceCustomFields.assertEquals((String)"admin", (String)((String)admin.get("name")));
        TestIssueResourceCustomFields.assertEquals((String)"Administrator", (String)((String)admin.get("displayName")));
        Map fred = (Map)users.get(1);
        TestIssueResourceCustomFields.assertEquals((String)(this.getBaseUrl() + "/rest/api/2/user?username=fred"), (String)((String)fred.get("self")));
        TestIssueResourceCustomFields.assertEquals((String)"fred", (String)((String)fred.get("name")));
        TestIssueResourceCustomFields.assertEquals((String)"Fred Normal", (String)((String)fred.get("displayName")));
        this.issueClient.edit("HSP-1", new IssueUpdateRequest().update("customfield_10006", new FieldOperation[]{new FieldOperation("set", null)}));
        issue = this.issueClient.get("HSP-1", new Issue.Expand[]{Issue.Expand.schema});
        multiUser = (List)issue.fields.get("customfield_10006");
        TestIssueResourceCustomFields.assertNull((Object)multiUser);
    }

    public void testMultiGroupPicker() throws Exception {
        this.administration.restoreData("TestIssueResourceCustomFields.xml");
        Issue issue = this.issueClient.get("HSP-1", new Issue.Expand[]{Issue.Expand.schema});
        List groups = (List)issue.fields.get("customfield_10005");
        TestIssueResourceCustomFields.assertEquals((String)"com.atlassian.jira.plugin.system.customfieldtypes:multigrouppicker", (String)((JsonTypeBean)issue.schema.get("customfield_10005")).getCustom());
        TestIssueResourceCustomFields.assertEquals((int)2, (int)groups.size());
        Map developers = (Map)groups.get(0);
        TestIssueResourceCustomFields.assertEquals((String)"jira-developers", (String)((String)developers.get("name")));
        Map users = (Map)groups.get(1);
        TestIssueResourceCustomFields.assertEquals((String)"jira-users", (String)((String)users.get("name")));
        this.issueClient.edit("HSP-1", new IssueUpdateRequest().update("customfield_10005", new FieldOperation[]{new FieldOperation("set", null)}));
        issue = this.issueClient.get("HSP-1", new Issue.Expand[]{Issue.Expand.schema});
        groups = (List)issue.fields.get("customfield_10005");
        TestIssueResourceCustomFields.assertNull((Object)groups);
    }

    public void testGroupPicker() throws Exception {
        this.administration.restoreData("TestIssueResourceCustomFields.xml");
        Issue issue = this.issueClient.get("HSP-1", new Issue.Expand[]{Issue.Expand.schema});
        Map group = (Map)issue.fields.get("customfield_10002");
        TestIssueResourceCustomFields.assertEquals((String)"com.atlassian.jira.plugin.system.customfieldtypes:grouppicker", (String)((JsonTypeBean)issue.schema.get("customfield_10002")).getCustom());
        TestIssueResourceCustomFields.assertEquals((String)"jira-developers", (String)((String)group.get("name")));
        this.issueClient.edit("HSP-1", new IssueUpdateRequest().update("customfield_10002", new FieldOperation[]{new FieldOperation("set", null)}));
        issue = this.issueClient.get("HSP-1", new Issue.Expand[]{Issue.Expand.schema});
        group = (Map)issue.fields.get("customfield_10002");
        TestIssueResourceCustomFields.assertNull((Object)group);
    }

    public void testCascadingSelect() throws Exception {
        this.administration.restoreData("TestIssueResourceCustomFields.xml");
        Issue issue = this.issueClient.get("HSP-1", new Issue.Expand[]{Issue.Expand.schema});
        Map option = (Map)issue.fields.get("customfield_10000");
        TestIssueResourceCustomFields.assertEquals((String)"com.atlassian.jira.plugin.system.customfieldtypes:cascadingselect", (String)((JsonTypeBean)issue.schema.get("customfield_10000")).getCustom());
        if (option.get("value").equals("Option 2")) {
            TestIssueResourceCustomFields.assertEquals((Object)"Option 2", option.get("value"));
            TestIssueResourceCustomFields.assertEquals((Object)(this.getBaseUrl() + "/rest/api/2/customFieldOption/10001"), option.get("self"));
            TestIssueResourceCustomFields.assertNull(option.get("children"));
            Map child = (Map)option.get("child");
            TestIssueResourceCustomFields.assertEquals((Object)"Sub-option I", child.get("value"));
            TestIssueResourceCustomFields.assertEquals((Object)(this.getBaseUrl() + "/rest/api/2/customFieldOption/10004"), child.get("self"));
            TestIssueResourceCustomFields.assertNull(child.get("child"));
            TestIssueResourceCustomFields.assertNull(child.get("children"));
        }
        this.issueClient.edit("HSP-1", new IssueUpdateRequest().update("customfield_10000", new FieldOperation[]{new FieldOperation("set", null)}));
        issue = this.issueClient.get("HSP-1", new Issue.Expand[]{Issue.Expand.schema});
        option = (Map)issue.fields.get("customfield_10000");
        TestIssueResourceCustomFields.assertNull((Object)option);
    }

    public void testLabels() throws Exception {
        this.administration.restoreData("TestIssueResourceCustomFields.xml");
        Issue issue = this.issueClient.get("HSP-1", new Issue.Expand[]{Issue.Expand.schema});
        List labels = (List)issue.fields.get("customfield_10004");
        TestIssueResourceCustomFields.assertEquals((String)"com.atlassian.jira.plugin.system.customfieldtypes:labels", (String)((JsonTypeBean)issue.schema.get("customfield_10004")).getCustom());
        TestIssueResourceCustomFields.assertEquals(Arrays.asList("wack", "whoa"), (Object)labels);
        this.issueClient.edit("HSP-1", new IssueUpdateRequest().update("customfield_10004", new FieldOperation[]{new FieldOperation("set", null)}));
        issue = this.issueClient.get("HSP-1", new Issue.Expand[]{Issue.Expand.schema});
        labels = (List)issue.fields.get("customfield_10004");
        TestIssueResourceCustomFields.assertNull((Object)labels);
    }

    public void testEmptyFieldsReturned() throws Exception {
        this.administration.restoreData("TestIssueResourceCustomFields.xml");
        this.navigation.issue().createIssue("homosapien", "Bug", "some issue");
        Issue issue = this.issueClient.get("HSP-2", new Issue.Expand[0]);
        Issue.Fields fields = issue.fields;
        TestIssueResourceCustomFields.assertTrue((boolean)fields.has("customfield_10000"));
        TestIssueResourceCustomFields.assertNull((Object)fields.get("customfield_10000"));
        TestIssueResourceCustomFields.assertTrue((boolean)fields.has("customfield_10012"));
        TestIssueResourceCustomFields.assertNull((Object)fields.get("customfield_10012"));
        TestIssueResourceCustomFields.assertTrue((boolean)fields.has("customfield_10001"));
        TestIssueResourceCustomFields.assertNull((Object)fields.get("customfield_10001"));
        TestIssueResourceCustomFields.assertTrue((boolean)fields.has("customfield_10013"));
        TestIssueResourceCustomFields.assertNull((Object)fields.get("customfield_10013"));
        TestIssueResourceCustomFields.assertTrue((boolean)fields.has("customfield_10002"));
        TestIssueResourceCustomFields.assertNull((Object)fields.get("customfield_10002"));
        TestIssueResourceCustomFields.assertTrue((boolean)fields.has("customfield_10003"));
        TestIssueResourceCustomFields.assertNull((Object)fields.get("customfield_10003"));
        TestIssueResourceCustomFields.assertTrue((boolean)fields.has("customfield_10016"));
        TestIssueResourceCustomFields.assertNull((Object)fields.get("customfield_10016"));
        TestIssueResourceCustomFields.assertTrue((boolean)fields.has("customfield_10017"));
        TestIssueResourceCustomFields.assertNull((Object)fields.get("customfield_10017"));
        TestIssueResourceCustomFields.assertTrue((boolean)fields.has("customfield_10005"));
        TestIssueResourceCustomFields.assertNull((Object)fields.get("customfield_10005"));
        TestIssueResourceCustomFields.assertTrue((boolean)fields.has("customfield_10006"));
        TestIssueResourceCustomFields.assertNull((Object)fields.get("customfield_10006"));
        TestIssueResourceCustomFields.assertTrue((boolean)fields.has("customfield_10018"));
        TestIssueResourceCustomFields.assertNull((Object)fields.get("customfield_10018"));
        TestIssueResourceCustomFields.assertTrue((boolean)fields.has("customfield_10007"));
        TestIssueResourceCustomFields.assertNull((Object)fields.get("customfield_10007"));
        TestIssueResourceCustomFields.assertTrue((boolean)fields.has("customfield_10019"));
        TestIssueResourceCustomFields.assertNull((Object)fields.get("customfield_10019"));
        TestIssueResourceCustomFields.assertTrue((boolean)fields.has("customfield_10008"));
        TestIssueResourceCustomFields.assertNull((Object)fields.get("customfield_10008"));
        TestIssueResourceCustomFields.assertTrue((boolean)fields.has("customfield_10020"));
        TestIssueResourceCustomFields.assertNull((Object)fields.get("customfield_10020"));
        TestIssueResourceCustomFields.assertTrue((boolean)fields.has("customfield_10009"));
        TestIssueResourceCustomFields.assertNull((Object)fields.get("customfield_10009"));
        TestIssueResourceCustomFields.assertTrue((boolean)fields.has("customfield_10021"));
        TestIssueResourceCustomFields.assertNull((Object)fields.get("customfield_10021"));
        TestIssueResourceCustomFields.assertTrue((boolean)fields.has("customfield_10010"));
        TestIssueResourceCustomFields.assertNull((Object)fields.get("customfield_10010"));
        TestIssueResourceCustomFields.assertTrue((boolean)fields.has("customfield_10022"));
        TestIssueResourceCustomFields.assertNull((Object)fields.get("customfield_10022"));
        TestIssueResourceCustomFields.assertTrue((boolean)fields.has("customfield_10011"));
        TestIssueResourceCustomFields.assertNull((Object)fields.get("customfield_10011"));
    }

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.issueClient = new IssueClient((JIRAEnvironmentData)this.getEnvironmentData());
    }
}

