/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.rest.api.util.StringList;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.FieldMetaData;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import com.atlassian.jira.testkit.client.restclient.IssueCreateMeta;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestIssueResourceCreateMeta
extends RestFuncTest {
    private IssueClient issueClient;
    private static final Set<String> defaultRequiredFields = ImmutableSet.builder().add((Object)"project").add((Object)"versions").add((Object)"components").add((Object)"description").add((Object)"duedate").add((Object)"environment").add((Object)"fixVersions").add((Object)"issuetype").add((Object)"labels").add((Object)"worklog").add((Object)"priority").add((Object)"reporter").add((Object)"security").add((Object)"summary").add((Object)"timetracking").build();
    private static final Set<String> hasDefaultValueFields = ImmutableSet.builder().add((Object)"assignee").add((Object)"priority").build();
    private static final Set<String> subtaskRequiredFields = ImmutableSet.builder().addAll(defaultRequiredFields).add((Object)"parent").build();
    private static final Set<String> testBugRequiredFields = ImmutableSet.builder().add((Object)"project").add((Object)"versions").add((Object)"description").add((Object)"issuetype").add((Object)"priority").add((Object)"reporter").add((Object)"summary").add((Object)"customfield_10000").build();
    private static final Map<String, IssueCreateMeta.JsonType> sharedFieldTypes = ImmutableMap.builder().put((Object)"project", (Object)IssueCreateMeta.JsonType.system((String)"project", (String)"project")).put((Object)"versions", (Object)IssueCreateMeta.JsonType.systemArray((String)"version", (String)"versions")).put((Object)"assignee", (Object)IssueCreateMeta.JsonType.system((String)"user", (String)"assignee")).put((Object)"attachment", (Object)IssueCreateMeta.JsonType.systemArray((String)"attachment", (String)"attachment")).put((Object)"description", (Object)IssueCreateMeta.JsonType.system((String)"string", (String)"description")).put((Object)"environment", (Object)IssueCreateMeta.JsonType.system((String)"string", (String)"environment")).put((Object)"fixVersions", (Object)IssueCreateMeta.JsonType.systemArray((String)"version", (String)"fixVersions")).put((Object)"issuetype", (Object)IssueCreateMeta.JsonType.system((String)"issuetype", (String)"issuetype")).put((Object)"issuelinks", (Object)IssueCreateMeta.JsonType.systemArray((String)"issuelinks", (String)"issuelinks")).put((Object)"worklog", (Object)IssueCreateMeta.JsonType.systemArray((String)"worklog", (String)"worklog")).put((Object)"priority", (Object)IssueCreateMeta.JsonType.system((String)"priority", (String)"priority")).put((Object)"reporter", (Object)IssueCreateMeta.JsonType.system((String)"user", (String)"reporter")).put((Object)"resolution", (Object)IssueCreateMeta.JsonType.system((String)"resolution", (String)"resolution")).put((Object)"security", (Object)IssueCreateMeta.JsonType.system((String)"securitylevel", (String)"security")).put((Object)"summary", (Object)IssueCreateMeta.JsonType.system((String)"string", (String)"summary")).put((Object)"customfield_10000", (Object)IssueCreateMeta.JsonType.custom((String)"date", (String)"com.atlassian.jira.plugin.system.customfieldtypes:datepicker", (Long)10000L)).put((Object)"customfield_10001", (Object)IssueCreateMeta.JsonType.custom((String)"datetime", (String)"com.atlassian.jira.plugin.system.customfieldtypes:datetime", (Long)10001L)).build();
    private static final Map<String, IssueCreateMeta.JsonType> defaultFieldTypes = ImmutableMap.builder().putAll(sharedFieldTypes).put((Object)"duedate", (Object)IssueCreateMeta.JsonType.system((String)"date", (String)"duedate")).put((Object)"components", (Object)IssueCreateMeta.JsonType.systemArray((String)"component", (String)"components")).put((Object)"labels", (Object)IssueCreateMeta.JsonType.systemArray((String)"string", (String)"labels")).put((Object)"timetracking", (Object)IssueCreateMeta.JsonType.system((String)"timetracking", (String)"timetracking")).build();
    private static final Map<String, IssueCreateMeta.JsonType> subTaskFieldTypes = ImmutableMap.builder().putAll(defaultFieldTypes).put((Object)"parent", (Object)IssueCreateMeta.JsonType.system((String)"issuelink", (String)"parent")).build();
    private static final Map<String, IssueCreateMeta.JsonType> testBugFieldTypes = ImmutableMap.builder().putAll(sharedFieldTypes).build();
    private static final Map<String, String> fieldsNamesValues = ImmutableMap.builder().put((Object)"assignee", (Object)"Assignee").put((Object)"attachment", (Object)"Attachment").put((Object)"components", (Object)"Component/s").put((Object)"customfield_10000", (Object)"datePickerCF").put((Object)"customfield_10001", (Object)"dateTimeCF").put((Object)"description", (Object)"Description").put((Object)"duedate", (Object)"Due Date").put((Object)"environment", (Object)"Environment").put((Object)"fixVersions", (Object)"Fix Version/s").put((Object)"issuelinks", (Object)"Linked Issues").put((Object)"issuetype", (Object)"Issue Type").put((Object)"labels", (Object)"Labels").put((Object)"parent", (Object)"Parent").put((Object)"priority", (Object)"Priority").put((Object)"project", (Object)"Project").put((Object)"reporter", (Object)"Reporter").put((Object)"resolution", (Object)"Resolution").put((Object)"security", (Object)"Security Level").put((Object)"summary", (Object)"Summary").put((Object)"timetracking", (Object)"Time Tracking").put((Object)"versions", (Object)"Affects Version/s").put((Object)"worklog", (Object)"Log Work").build();
    private static final Long DEFAULT_AVATAR_ID = 10011L;

    public void testWithNullParams() throws Exception {
        IssueCreateMeta meta = this.issueClient.getCreateMeta(null, null, null, null, new IssueCreateMeta.Expand[]{IssueCreateMeta.Expand.fields});
        TestIssueResourceCreateMeta.assertEquals((int)2, (int)meta.projects.size());
        IssueCreateMeta.Project project1 = (IssueCreateMeta.Project)meta.projects.get(0);
        this.assertPlanetExpressProject(project1);
        TestIssueResourceCreateMeta.assertEquals((int)5, (int)project1.issuetypes.size());
        IssueCreateMeta.IssueType project1Bug = (IssueCreateMeta.IssueType)project1.issuetypes.get(0);
        IssueCreateMeta.IssueType project1NewFeature = (IssueCreateMeta.IssueType)project1.issuetypes.get(1);
        IssueCreateMeta.IssueType project1Task = (IssueCreateMeta.IssueType)project1.issuetypes.get(2);
        IssueCreateMeta.IssueType project1Improvement = (IssueCreateMeta.IssueType)project1.issuetypes.get(3);
        IssueCreateMeta.IssueType project1SubTask = (IssueCreateMeta.IssueType)project1.issuetypes.get(4);
        this.assertBug(project1Bug);
        this.assertNewFeature(project1NewFeature);
        this.assertTask(project1Task);
        this.assertImprovement(project1Improvement);
        this.assertSubTask(project1SubTask);
        IssueCreateMeta.Project project2 = (IssueCreateMeta.Project)meta.projects.get(1);
        this.assertTestProject(project2);
        TestIssueResourceCreateMeta.assertEquals((int)3, (int)project2.issuetypes.size());
        IssueCreateMeta.IssueType project2Bug = (IssueCreateMeta.IssueType)project2.issuetypes.get(0);
        IssueCreateMeta.IssueType project2Improvement = (IssueCreateMeta.IssueType)project2.issuetypes.get(1);
        IssueCreateMeta.IssueType project2NewFeature = (IssueCreateMeta.IssueType)project2.issuetypes.get(2);
        this.assertBug(project2Bug);
        this.assertImprovement(project2Improvement);
        this.assertNewFeature(project2NewFeature);
        this.assertRequiredFields(project1Bug.fields, defaultRequiredFields);
        this.assertRequiredFields(project1NewFeature.fields, defaultRequiredFields);
        this.assertRequiredFields(project1Task.fields, defaultRequiredFields);
        this.assertRequiredFields(project1Improvement.fields, defaultRequiredFields);
        this.assertRequiredFields(project1SubTask.fields, subtaskRequiredFields);
        this.assertRequiredFields(project2Bug.fields, testBugRequiredFields);
        this.assertRequiredFields(project2Improvement.fields, defaultRequiredFields);
        this.assertRequiredFields(project2NewFeature.fields, defaultRequiredFields);
        this.assertFieldNamesAndTypes(project1Bug.fields, defaultFieldTypes);
        this.assertFieldNamesAndTypes(project1NewFeature.fields, defaultFieldTypes);
        this.assertFieldNamesAndTypes(project1Task.fields, defaultFieldTypes);
        this.assertFieldNamesAndTypes(project1Improvement.fields, defaultFieldTypes);
        this.assertFieldNamesAndTypes(project1SubTask.fields, subTaskFieldTypes);
        this.assertFieldNamesAndTypes(project2Bug.fields, testBugFieldTypes);
        this.assertFieldNamesAndTypes(project2Improvement.fields, defaultFieldTypes);
        this.assertFieldNamesAndTypes(project2NewFeature.fields, defaultFieldTypes);
    }

    public void testWithProjectIds() throws Exception {
        List<StringList> projectIds = Arrays.asList(new StringList("10000"));
        IssueCreateMeta meta = this.issueClient.getCreateMeta(projectIds, null, null, null, new IssueCreateMeta.Expand[]{IssueCreateMeta.Expand.fields});
        TestIssueResourceCreateMeta.assertEquals((int)1, (int)meta.projects.size());
        IssueCreateMeta.Project project2 = (IssueCreateMeta.Project)meta.projects.get(0);
        this.assertTestProject(project2);
        TestIssueResourceCreateMeta.assertEquals((int)3, (int)project2.issuetypes.size());
        IssueCreateMeta.IssueType project2Bug = (IssueCreateMeta.IssueType)project2.issuetypes.get(0);
        IssueCreateMeta.IssueType project2Improvement = (IssueCreateMeta.IssueType)project2.issuetypes.get(1);
        IssueCreateMeta.IssueType project2NewFeature = (IssueCreateMeta.IssueType)project2.issuetypes.get(2);
        this.assertBug(project2Bug);
        this.assertImprovement(project2Improvement);
        this.assertNewFeature(project2NewFeature);
        this.assertRequiredFields(project2Bug.fields, testBugRequiredFields);
        this.assertRequiredFields(project2Improvement.fields, defaultRequiredFields);
        this.assertRequiredFields(project2NewFeature.fields, defaultRequiredFields);
        this.assertFieldNamesAndTypes(project2Bug.fields, testBugFieldTypes);
        this.assertFieldNamesAndTypes(project2Improvement.fields, defaultFieldTypes);
        this.assertFieldNamesAndTypes(project2NewFeature.fields, defaultFieldTypes);
    }

    public void testWithProjectKeys() throws Exception {
        List<StringList> projectKeys = Arrays.asList(new StringList("PEXPRESS"));
        IssueCreateMeta meta = this.issueClient.getCreateMeta(null, projectKeys, null, null, new IssueCreateMeta.Expand[]{IssueCreateMeta.Expand.fields});
        TestIssueResourceCreateMeta.assertEquals((int)1, (int)meta.projects.size());
        IssueCreateMeta.Project project1 = (IssueCreateMeta.Project)meta.projects.get(0);
        this.assertPlanetExpressProject(project1);
        TestIssueResourceCreateMeta.assertEquals((int)5, (int)project1.issuetypes.size());
        IssueCreateMeta.IssueType project1Bug = (IssueCreateMeta.IssueType)project1.issuetypes.get(0);
        IssueCreateMeta.IssueType project1NewFeature = (IssueCreateMeta.IssueType)project1.issuetypes.get(1);
        IssueCreateMeta.IssueType project1Task = (IssueCreateMeta.IssueType)project1.issuetypes.get(2);
        IssueCreateMeta.IssueType project1Improvement = (IssueCreateMeta.IssueType)project1.issuetypes.get(3);
        IssueCreateMeta.IssueType project1SubTask = (IssueCreateMeta.IssueType)project1.issuetypes.get(4);
        this.assertBug(project1Bug);
        this.assertNewFeature(project1NewFeature);
        this.assertTask(project1Task);
        this.assertImprovement(project1Improvement);
        this.assertSubTask(project1SubTask);
        this.assertRequiredFields(project1Bug.fields, defaultRequiredFields);
        this.assertRequiredFields(project1NewFeature.fields, defaultRequiredFields);
        this.assertRequiredFields(project1Task.fields, defaultRequiredFields);
        this.assertRequiredFields(project1Improvement.fields, defaultRequiredFields);
        this.assertRequiredFields(project1SubTask.fields, subtaskRequiredFields);
        this.assertFieldNamesAndTypes(project1Bug.fields, defaultFieldTypes);
        this.assertFieldNamesAndTypes(project1NewFeature.fields, defaultFieldTypes);
        this.assertFieldNamesAndTypes(project1Task.fields, defaultFieldTypes);
        this.assertFieldNamesAndTypes(project1Improvement.fields, defaultFieldTypes);
        this.assertFieldNamesAndTypes(project1SubTask.fields, subTaskFieldTypes);
    }

    public void testWithIssueTypes() throws Exception {
        this.subtestByIssueTypes(Arrays.asList(new StringList("2,3")), null);
        this.subtestByIssueTypes(Arrays.asList(new StringList(Arrays.asList("2", "3"))), null);
        this.subtestByIssueTypes(Arrays.asList(new StringList("2")), Arrays.asList("Task"));
        this.subtestByIssueTypes(Arrays.asList(new StringList("2,3")), Arrays.asList("Task"));
        this.subtestByIssueTypes(null, Arrays.asList("New Feature", "Task"));
    }

    private void subtestByIssueTypes(List<StringList> issueTypeIds, List<String> issueTypeNames) {
        IssueCreateMeta meta = this.issueClient.getCreateMeta(null, null, issueTypeIds, issueTypeNames, new IssueCreateMeta.Expand[]{IssueCreateMeta.Expand.fields});
        TestIssueResourceCreateMeta.assertEquals((int)2, (int)meta.projects.size());
        IssueCreateMeta.Project project1 = (IssueCreateMeta.Project)meta.projects.get(0);
        this.assertPlanetExpressProject(project1);
        TestIssueResourceCreateMeta.assertEquals((int)2, (int)project1.issuetypes.size());
        IssueCreateMeta.IssueType project1NewFeature = (IssueCreateMeta.IssueType)project1.issuetypes.get(0);
        IssueCreateMeta.IssueType project1Task = (IssueCreateMeta.IssueType)project1.issuetypes.get(1);
        this.assertNewFeature(project1NewFeature);
        this.assertTask(project1Task);
        IssueCreateMeta.Project project2 = (IssueCreateMeta.Project)meta.projects.get(1);
        this.assertTestProject(project2);
        TestIssueResourceCreateMeta.assertEquals((int)1, (int)project2.issuetypes.size());
        IssueCreateMeta.IssueType project2NewFeature = (IssueCreateMeta.IssueType)project2.issuetypes.get(0);
        this.assertNewFeature(project2NewFeature);
        this.assertRequiredFields(project1NewFeature.fields, defaultRequiredFields);
        this.assertRequiredFields(project1Task.fields, defaultRequiredFields);
        this.assertRequiredFields(project2NewFeature.fields, defaultRequiredFields);
        this.assertFieldNamesAndTypes(project1NewFeature.fields, defaultFieldTypes);
        this.assertFieldNamesAndTypes(project1Task.fields, defaultFieldTypes);
        this.assertFieldNamesAndTypes(project2NewFeature.fields, defaultFieldTypes);
        this.assertDefaultValueFields(project1NewFeature.fields, hasDefaultValueFields);
        this.assertDefaultValueFields(project1Task.fields, hasDefaultValueFields);
        this.assertDefaultValueFields(project2NewFeature.fields, hasDefaultValueFields);
    }

    public void testWithAllParams() throws Exception {
        List<StringList> projectIds = Arrays.asList(new StringList("10000"));
        List<StringList> projectKeys = Arrays.asList(new StringList("TST"));
        List<StringList> issueTypeIds = Arrays.asList(new StringList("2"));
        List<String> issueTypeNames = Arrays.asList("Task");
        IssueCreateMeta meta = this.issueClient.getCreateMeta(projectIds, projectKeys, issueTypeIds, issueTypeNames, new IssueCreateMeta.Expand[]{IssueCreateMeta.Expand.fields});
        TestIssueResourceCreateMeta.assertEquals((int)1, (int)meta.projects.size());
        IssueCreateMeta.Project project2 = (IssueCreateMeta.Project)meta.projects.get(0);
        this.assertTestProject(project2);
        TestIssueResourceCreateMeta.assertEquals((int)1, (int)project2.issuetypes.size());
        IssueCreateMeta.IssueType project2NewFeature = (IssueCreateMeta.IssueType)project2.issuetypes.get(0);
        this.assertNewFeature(project2NewFeature);
        this.assertRequiredFields(project2NewFeature.fields, defaultRequiredFields);
        this.assertFieldNamesAndTypes(project2NewFeature.fields, defaultFieldTypes);
    }

    public void testWithBadParams() throws Exception {
        List<StringList> projectIds = Arrays.asList(new StringList("-1,10000"));
        List<StringList> projectKeys = Arrays.asList(new StringList("TST,ABC,XYZ"));
        List<StringList> issueTypeIds = Arrays.asList(new StringList("1,300"));
        List<String> issueTypeNames = Arrays.asList("Bug", "ASDASD");
        IssueCreateMeta meta = this.issueClient.getCreateMeta(projectIds, projectKeys, issueTypeIds, issueTypeNames, new IssueCreateMeta.Expand[]{IssueCreateMeta.Expand.fields});
        TestIssueResourceCreateMeta.assertEquals((int)1, (int)meta.projects.size());
        IssueCreateMeta.Project project = (IssueCreateMeta.Project)meta.projects.get(0);
        TestIssueResourceCreateMeta.assertEquals((String)"10000", (String)project.id);
        TestIssueResourceCreateMeta.assertEquals((int)1, (int)project.issuetypes.size());
        IssueCreateMeta.IssueType issueType = (IssueCreateMeta.IssueType)project.issuetypes.get(0);
        TestIssueResourceCreateMeta.assertEquals((String)"1", (String)issueType.id);
    }

    public void testWithNoProjectBrowsePermission() throws Exception {
        List<StringList> projectKeys = Arrays.asList(new StringList("TST"));
        IssueCreateMeta meta = ((IssueClient)this.issueClient.loginAs("fry")).getCreateMeta(null, projectKeys, null, null, new IssueCreateMeta.Expand[]{IssueCreateMeta.Expand.fields});
        TestIssueResourceCreateMeta.assertEquals((int)0, (int)meta.projects.size());
    }

    public void testWithLimitedProjectBrowsePermission() throws Exception {
        IssueCreateMeta meta = ((IssueClient)this.issueClient.loginAs("fry")).getCreateMeta(null, null, null, null, new IssueCreateMeta.Expand[]{IssueCreateMeta.Expand.fields});
        TestIssueResourceCreateMeta.assertEquals((int)1, (int)meta.projects.size());
        IssueCreateMeta.Project project1 = (IssueCreateMeta.Project)meta.projects.get(0);
        this.assertPlanetExpressProject(project1);
        TestIssueResourceCreateMeta.assertEquals((int)5, (int)project1.issuetypes.size());
        IssueCreateMeta.IssueType project1Bug = (IssueCreateMeta.IssueType)project1.issuetypes.get(0);
        IssueCreateMeta.IssueType project1NewFeature = (IssueCreateMeta.IssueType)project1.issuetypes.get(1);
        IssueCreateMeta.IssueType project1Task = (IssueCreateMeta.IssueType)project1.issuetypes.get(2);
        IssueCreateMeta.IssueType project1Improvement = (IssueCreateMeta.IssueType)project1.issuetypes.get(3);
        IssueCreateMeta.IssueType project1SubTask = (IssueCreateMeta.IssueType)project1.issuetypes.get(4);
        this.assertBug(project1Bug);
        this.assertNewFeature(project1NewFeature);
        this.assertTask(project1Task);
        this.assertImprovement(project1Improvement);
        this.assertSubTask(project1SubTask);
        ImmutableSet frysFields = ImmutableSet.builder().add((Object)"project").add((Object)"versions").add((Object)"components").add((Object)"description").add((Object)"environment").add((Object)"issuetype").add((Object)"labels").add((Object)"priority").add((Object)"security").add((Object)"summary").add((Object)"timetracking").build();
        ImmutableSet frysSubtaskRequiredFields = ImmutableSet.builder().addAll((Iterable)frysFields).add((Object)"parent").build();
        ImmutableMap defaultFieldTypes = ImmutableMap.builder().put((Object)"project", (Object)IssueCreateMeta.JsonType.system((String)"project", (String)"project")).put((Object)"versions", (Object)IssueCreateMeta.JsonType.systemArray((String)"version", (String)"versions")).put((Object)"attachment", (Object)IssueCreateMeta.JsonType.systemArray((String)"attachment", (String)"attachment")).put((Object)"description", (Object)IssueCreateMeta.JsonType.system((String)"string", (String)"description")).put((Object)"environment", (Object)IssueCreateMeta.JsonType.system((String)"string", (String)"environment")).put((Object)"issuetype", (Object)IssueCreateMeta.JsonType.system((String)"issuetype", (String)"issuetype")).put((Object)"priority", (Object)IssueCreateMeta.JsonType.system((String)"priority", (String)"priority")).put((Object)"resolution", (Object)IssueCreateMeta.JsonType.system((String)"resolution", (String)"resolution")).put((Object)"security", (Object)IssueCreateMeta.JsonType.system((String)"securitylevel", (String)"security")).put((Object)"summary", (Object)IssueCreateMeta.JsonType.system((String)"string", (String)"summary")).put((Object)"customfield_10000", (Object)IssueCreateMeta.JsonType.custom((String)"date", (String)"com.atlassian.jira.plugin.system.customfieldtypes:datepicker", (Long)10000L)).put((Object)"customfield_10001", (Object)IssueCreateMeta.JsonType.custom((String)"datetime", (String)"com.atlassian.jira.plugin.system.customfieldtypes:datetime", (Long)10001L)).put((Object)"components", (Object)IssueCreateMeta.JsonType.systemArray((String)"component", (String)"components")).put((Object)"labels", (Object)IssueCreateMeta.JsonType.systemArray((String)"string", (String)"labels")).put((Object)"timetracking", (Object)IssueCreateMeta.JsonType.system((String)"timetracking", (String)"timetracking")).put((Object)"issuelinks", (Object)IssueCreateMeta.JsonType.systemArray((String)"issuelinks", (String)"issuelinks")).build();
        ImmutableMap subTaskFieldTypes = ImmutableMap.builder().putAll((Map)defaultFieldTypes).put((Object)"parent", (Object)IssueCreateMeta.JsonType.system((String)"issuelink", (String)"parent")).build();
        this.assertRequiredFields(project1Bug.fields, (Set<String>)frysFields);
        this.assertRequiredFields(project1NewFeature.fields, (Set<String>)frysFields);
        this.assertRequiredFields(project1Task.fields, (Set<String>)frysFields);
        this.assertRequiredFields(project1Improvement.fields, (Set<String>)frysFields);
        this.assertRequiredFields(project1SubTask.fields, (Set<String>)frysSubtaskRequiredFields);
        this.assertFieldNamesAndTypes(project1Bug.fields, (Map<String, IssueCreateMeta.JsonType>)defaultFieldTypes);
        this.assertFieldNamesAndTypes(project1NewFeature.fields, (Map<String, IssueCreateMeta.JsonType>)defaultFieldTypes);
        this.assertFieldNamesAndTypes(project1Task.fields, (Map<String, IssueCreateMeta.JsonType>)defaultFieldTypes);
        this.assertFieldNamesAndTypes(project1Improvement.fields, (Map<String, IssueCreateMeta.JsonType>)defaultFieldTypes);
        this.assertFieldNamesAndTypes(project1SubTask.fields, (Map<String, IssueCreateMeta.JsonType>)subTaskFieldTypes);
    }

    public void testWithNoProjectCreatePermission() throws Exception {
        List<StringList> projectKeys = Arrays.asList(new StringList("TST"));
        IssueCreateMeta meta = ((IssueClient)this.issueClient.loginAs("farnsworth")).getCreateMeta(null, projectKeys, null, null, new IssueCreateMeta.Expand[]{IssueCreateMeta.Expand.fields});
        TestIssueResourceCreateMeta.assertEquals((int)0, (int)meta.projects.size());
    }

    public void testWithLimitedProjectCreatePermission() throws Exception {
        IssueCreateMeta meta = ((IssueClient)this.issueClient.loginAs("farnsworth")).getCreateMeta(null, null, null, null, new IssueCreateMeta.Expand[]{IssueCreateMeta.Expand.fields});
        TestIssueResourceCreateMeta.assertEquals((int)1, (int)meta.projects.size());
        IssueCreateMeta.Project project1 = (IssueCreateMeta.Project)meta.projects.get(0);
        this.assertPlanetExpressProject(project1);
        TestIssueResourceCreateMeta.assertEquals((int)5, (int)project1.issuetypes.size());
        IssueCreateMeta.IssueType project1Bug = (IssueCreateMeta.IssueType)project1.issuetypes.get(0);
        IssueCreateMeta.IssueType project1NewFeature = (IssueCreateMeta.IssueType)project1.issuetypes.get(1);
        IssueCreateMeta.IssueType project1Task = (IssueCreateMeta.IssueType)project1.issuetypes.get(2);
        IssueCreateMeta.IssueType project1Improvement = (IssueCreateMeta.IssueType)project1.issuetypes.get(3);
        IssueCreateMeta.IssueType project1SubTask = (IssueCreateMeta.IssueType)project1.issuetypes.get(4);
        this.assertBug(project1Bug);
        this.assertNewFeature(project1NewFeature);
        this.assertTask(project1Task);
        this.assertImprovement(project1Improvement);
        this.assertSubTask(project1SubTask);
        HashSet<String> farnsworthsFields = new HashSet<String>(defaultRequiredFields);
        farnsworthsFields.remove("reporter");
        ImmutableSet subtaskRequiredFields = ImmutableSet.builder().addAll(farnsworthsFields).add((Object)"parent").build();
        HashMap<String, IssueCreateMeta.JsonType> farnsworthFieldTypes = new HashMap<String, IssueCreateMeta.JsonType>(defaultFieldTypes);
        farnsworthFieldTypes.remove("reporter");
        ImmutableMap subTaskFieldTypes = ImmutableMap.builder().putAll(farnsworthFieldTypes).put((Object)"parent", (Object)IssueCreateMeta.JsonType.system((String)"issuelink", (String)"parent")).build();
        this.assertRequiredFields(project1Bug.fields, farnsworthsFields);
        this.assertRequiredFields(project1NewFeature.fields, farnsworthsFields);
        this.assertRequiredFields(project1Task.fields, farnsworthsFields);
        this.assertRequiredFields(project1Improvement.fields, farnsworthsFields);
        this.assertRequiredFields(project1SubTask.fields, (Set<String>)subtaskRequiredFields);
        this.assertFieldNamesAndTypes(project1Bug.fields, farnsworthFieldTypes);
        this.assertFieldNamesAndTypes(project1NewFeature.fields, farnsworthFieldTypes);
        this.assertFieldNamesAndTypes(project1Task.fields, farnsworthFieldTypes);
        this.assertFieldNamesAndTypes(project1Improvement.fields, farnsworthFieldTypes);
        this.assertFieldNamesAndTypes(project1SubTask.fields, (Map<String, IssueCreateMeta.JsonType>)subTaskFieldTypes);
    }

    public void testWithoutFields() throws Exception {
        IssueCreateMeta meta = this.issueClient.getCreateMeta(null, null, null, null, new IssueCreateMeta.Expand[0]);
        TestIssueResourceCreateMeta.assertEquals((int)2, (int)meta.projects.size());
        IssueCreateMeta.Project project1 = (IssueCreateMeta.Project)meta.projects.get(0);
        this.assertPlanetExpressProject(project1);
        TestIssueResourceCreateMeta.assertEquals((int)5, (int)project1.issuetypes.size());
        IssueCreateMeta.IssueType project1Bug = (IssueCreateMeta.IssueType)project1.issuetypes.get(0);
        IssueCreateMeta.IssueType project1NewFeature = (IssueCreateMeta.IssueType)project1.issuetypes.get(1);
        IssueCreateMeta.IssueType project1Task = (IssueCreateMeta.IssueType)project1.issuetypes.get(2);
        IssueCreateMeta.IssueType project1Improvement = (IssueCreateMeta.IssueType)project1.issuetypes.get(3);
        IssueCreateMeta.IssueType project1SubTask = (IssueCreateMeta.IssueType)project1.issuetypes.get(4);
        this.assertBug(project1Bug);
        this.assertNewFeature(project1NewFeature);
        this.assertTask(project1Task);
        this.assertImprovement(project1Improvement);
        this.assertSubTask(project1SubTask);
        IssueCreateMeta.Project project2 = (IssueCreateMeta.Project)meta.projects.get(1);
        this.assertTestProject(project2);
        TestIssueResourceCreateMeta.assertEquals((int)3, (int)project2.issuetypes.size());
        IssueCreateMeta.IssueType project2Bug = (IssueCreateMeta.IssueType)project2.issuetypes.get(0);
        IssueCreateMeta.IssueType project2Improvement = (IssueCreateMeta.IssueType)project2.issuetypes.get(1);
        IssueCreateMeta.IssueType project2NewFeature = (IssueCreateMeta.IssueType)project2.issuetypes.get(2);
        this.assertBug(project2Bug);
        this.assertImprovement(project2Improvement);
        this.assertNewFeature(project2NewFeature);
        TestIssueResourceCreateMeta.assertNull((Object)project1Bug.fields);
        TestIssueResourceCreateMeta.assertNull((Object)project1NewFeature.fields);
        TestIssueResourceCreateMeta.assertNull((Object)project1Task.fields);
        TestIssueResourceCreateMeta.assertNull((Object)project1Improvement.fields);
        TestIssueResourceCreateMeta.assertNull((Object)project1SubTask.fields);
        TestIssueResourceCreateMeta.assertNull((Object)project2Bug.fields);
        TestIssueResourceCreateMeta.assertNull((Object)project2Improvement.fields);
        TestIssueResourceCreateMeta.assertNull((Object)project2NewFeature.fields);
    }

    public void testAllowedValuesForFields() throws Exception {
        String[] fieldsNames;
        String cfProjectName = this.administration.customFields().addCustomField("com.atlassian.jira.plugin.system.customfieldtypes:project", "Project Custom Field");
        String cfVersionName = this.administration.customFields().addCustomField("com.atlassian.jira.plugin.system.customfieldtypes:version", "Version Custom Field");
        List<StringList> projectIds = Arrays.asList(new StringList("10000"));
        IssueCreateMeta meta = this.issueClient.getCreateMeta(projectIds, null, null, null, new IssueCreateMeta.Expand[]{IssueCreateMeta.Expand.fields});
        TestIssueResourceCreateMeta.assertEquals((int)1, (int)meta.projects.size());
        IssueCreateMeta.Project project2 = (IssueCreateMeta.Project)meta.projects.get(0);
        this.assertTestProject(project2);
        TestIssueResourceCreateMeta.assertEquals((int)3, (int)project2.issuetypes.size());
        IssueCreateMeta.IssueType project2Bug = (IssueCreateMeta.IssueType)project2.issuetypes.get(0);
        this.assertBug(project2Bug);
        this.assertRequiredFields(project2Bug.fields, testBugRequiredFields);
        for (String fieldName : fieldsNames = new String[]{cfProjectName, cfVersionName, "issuetype", "security", "fixVersions", "resolution", "project", "versions", "priority"}) {
            FieldMetaData fieldMetaData = (FieldMetaData)project2Bug.fields.get(fieldName);
            TestIssueResourceCreateMeta.assertNotNull((String)String.format("Field with name '%s' doesn't exists.", fieldName), (Object)fieldMetaData);
            this.assertFieldHasNonIterableAllowedValuesItems(fieldMetaData);
        }
    }

    private void assertFieldHasNonIterableAllowedValuesItems(FieldMetaData fieldMetaData) {
        List allowedValues = fieldMetaData.allowedValues;
        TestIssueResourceCreateMeta.assertNotNull((String)String.format("Field '%s' has null allowedValues!", fieldMetaData.name), (Object)allowedValues);
        TestIssueResourceCreateMeta.assertFalse((String)String.format("Field '%s' has empty allowedValues!", fieldMetaData.name), (boolean)allowedValues.isEmpty());
        for (Object value : allowedValues) {
            TestIssueResourceCreateMeta.assertFalse((String)String.format("Field '%s' has value that is an instance of Iterable! Value: %s", fieldMetaData.name, value), (boolean)(value instanceof Iterable));
        }
    }

    private void assertPlanetExpressProject(IssueCreateMeta.Project project) {
        TestIssueResourceCreateMeta.assertEquals((String)"10001", (String)project.id);
        TestIssueResourceCreateMeta.assertEquals((String)"PEXPRESS", (String)project.key);
        TestIssueResourceCreateMeta.assertEquals((String)"Planet Express", (String)project.name);
        TestIssueResourceCreateMeta.assertEquals((String)(this.getBaseUrl() + "/rest/api/2/project/10001"), (String)project.self);
        Assert.assertThat((Object)project.avatarUrls, (Matcher)Matchers.equalTo(this.createProjectAvatarUrls(10001L, 10011L)));
    }

    private void assertTestProject(IssueCreateMeta.Project project) {
        TestIssueResourceCreateMeta.assertEquals((String)"10000", (String)project.id);
        TestIssueResourceCreateMeta.assertEquals((String)"TST", (String)project.key);
        TestIssueResourceCreateMeta.assertEquals((String)"Test", (String)project.name);
        TestIssueResourceCreateMeta.assertEquals((String)(this.getBaseUrl() + "/rest/api/2/project/10000"), (String)project.self);
        Assert.assertThat((Object)project.avatarUrls, (Matcher)Matchers.equalTo(this.createProjectAvatarUrls(10000L, 10011L)));
    }

    private void assertBug(IssueCreateMeta.IssueType issueType) {
        TestIssueResourceCreateMeta.assertEquals((String)"1", (String)issueType.id);
        TestIssueResourceCreateMeta.assertEquals((String)"Bug", (String)issueType.name);
        TestIssueResourceCreateMeta.assertEquals((String)(this.getBaseUrl() + "/images/icons/issuetypes/bug.png"), (String)issueType.iconUrl);
        TestIssueResourceCreateMeta.assertEquals((String)(this.getBaseUrl() + "/rest/api/2/issuetype/1"), (String)issueType.self);
    }

    private void assertNewFeature(IssueCreateMeta.IssueType issueType) {
        TestIssueResourceCreateMeta.assertEquals((String)"2", (String)issueType.id);
        TestIssueResourceCreateMeta.assertEquals((String)"New Feature", (String)issueType.name);
        TestIssueResourceCreateMeta.assertEquals((String)(this.getBaseUrl() + "/images/icons/issuetypes/newfeature.png"), (String)issueType.iconUrl);
        TestIssueResourceCreateMeta.assertEquals((String)(this.getBaseUrl() + "/rest/api/2/issuetype/2"), (String)issueType.self);
    }

    private void assertTask(IssueCreateMeta.IssueType issueType) {
        TestIssueResourceCreateMeta.assertEquals((String)"3", (String)issueType.id);
        TestIssueResourceCreateMeta.assertEquals((String)"Task", (String)issueType.name);
        TestIssueResourceCreateMeta.assertEquals((String)(this.getBaseUrl() + "/images/icons/issuetypes/task.png"), (String)issueType.iconUrl);
        TestIssueResourceCreateMeta.assertEquals((String)(this.getBaseUrl() + "/rest/api/2/issuetype/3"), (String)issueType.self);
    }

    private void assertImprovement(IssueCreateMeta.IssueType issueType) {
        TestIssueResourceCreateMeta.assertEquals((String)"4", (String)issueType.id);
        TestIssueResourceCreateMeta.assertEquals((String)"Improvement", (String)issueType.name);
        TestIssueResourceCreateMeta.assertEquals((String)(this.getBaseUrl() + "/images/icons/issuetypes/improvement.png"), (String)issueType.iconUrl);
        TestIssueResourceCreateMeta.assertEquals((String)(this.getBaseUrl() + "/rest/api/2/issuetype/4"), (String)issueType.self);
    }

    private void assertSubTask(IssueCreateMeta.IssueType issueType) {
        TestIssueResourceCreateMeta.assertEquals((String)"5", (String)issueType.id);
        TestIssueResourceCreateMeta.assertEquals((String)"Sub-task", (String)issueType.name);
        TestIssueResourceCreateMeta.assertEquals((String)(this.getBaseUrl() + "/images/icons/issuetypes/subtask_alternate.png"), (String)issueType.iconUrl);
        TestIssueResourceCreateMeta.assertEquals((String)(this.getBaseUrl() + "/rest/api/2/issuetype/5"), (String)issueType.self);
    }

    private void assertFieldNamesAndTypes(Map<String, FieldMetaData> fields, Map<String, IssueCreateMeta.JsonType> fieldNamesToTypes) {
        for (Map.Entry<String, FieldMetaData> field : fields.entrySet()) {
            TestIssueResourceCreateMeta.assertTrue((String)("Contains field that should not be visible: " + field.getKey()), (boolean)fieldNamesToTypes.containsKey(field.getKey()));
            TestIssueResourceCreateMeta.assertEquals((String)("Incorrect field type for field: " + field.getKey()), (Object)fieldNamesToTypes.get(field.getKey()), (Object)field.getValue().schema);
            TestIssueResourceCreateMeta.assertEquals((String)("Incorrect name for field: " + field.getKey()), (String)fieldsNamesValues.get(field.getKey()), (String)field.getValue().name);
        }
        for (String expectedKey : fieldNamesToTypes.keySet()) {
            TestIssueResourceCreateMeta.assertTrue((String)("Could not find required key " + expectedKey), (boolean)fields.containsKey(expectedKey));
        }
    }

    private void assertRequiredFields(Map<String, FieldMetaData> fields, Set<String> requiredFieldNames) {
        for (Map.Entry<String, FieldMetaData> field : fields.entrySet()) {
            if (field.getValue().required.booleanValue()) {
                TestIssueResourceCreateMeta.assertTrue((String)("Field \"" + field.getKey() + "\" should be required"), (boolean)requiredFieldNames.contains(field.getKey()));
                continue;
            }
            TestIssueResourceCreateMeta.assertFalse((String)("Field \"" + field.getKey() + "\" should not be required"), (boolean)requiredFieldNames.contains(field.getKey()));
        }
        for (String expectedKey : requiredFieldNames) {
            TestIssueResourceCreateMeta.assertTrue((String)("Could not find required key " + expectedKey), (boolean)fields.containsKey(expectedKey));
        }
    }

    private void assertDefaultValueFields(Map<String, FieldMetaData> fields, Set<String> defaultValueFieldNames) {
        for (Map.Entry<String, FieldMetaData> field : fields.entrySet()) {
            if (field.getValue().hasDefaultValue.booleanValue()) {
                TestIssueResourceCreateMeta.assertTrue((String)("Field \"" + field.getKey() + "\" should have default value"), (boolean)defaultValueFieldNames.contains(field.getKey()));
                continue;
            }
            TestIssueResourceCreateMeta.assertFalse((String)("Field \"" + field.getKey() + "\" should not have default value"), (boolean)defaultValueFieldNames.contains(field.getKey()));
        }
        for (String expectedKey : defaultValueFieldNames) {
            TestIssueResourceCreateMeta.assertTrue((String)("Could not find default value key " + expectedKey), (boolean)fields.containsKey(expectedKey));
        }
    }

    private Map<String, String> createProjectAvatarUrls(Long projectId, Long avatarId) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (DEFAULT_AVATAR_ID.equals(avatarId)) {
            builder.put((Object)"24x24", (Object)this.getBaseUrlPlus("secure/projectavatar?size=small&avatarId=" + avatarId)).put((Object)"16x16", (Object)this.getBaseUrlPlus("secure/projectavatar?size=xsmall&avatarId=" + avatarId)).put((Object)"32x32", (Object)this.getBaseUrlPlus("secure/projectavatar?size=medium&avatarId=" + avatarId)).put((Object)"48x48", (Object)this.getBaseUrlPlus("secure/projectavatar?avatarId=" + avatarId));
        } else {
            builder.put((Object)"24x24", (Object)this.getBaseUrlPlus("secure/projectavatar?size=small&pid=" + projectId + "&avatarId=" + avatarId)).put((Object)"16x16", (Object)this.getBaseUrlPlus("secure/projectavatar?size=xsmall&pid=" + projectId + "&avatarId=" + avatarId)).put((Object)"32x32", (Object)this.getBaseUrlPlus("secure/projectavatar?size=medium&pid=" + projectId + "&avatarId=" + avatarId)).put((Object)"48x48", (Object)this.getBaseUrlPlus("secure/projectavatar?pid=" + projectId + "&avatarId=" + avatarId));
        }
        return builder.build();
    }

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.issueClient = new IssueClient((JIRAEnvironmentData)this.getEnvironmentData());
        this.administration.restoreData("TestIssueResourceCreateMeta.xml");
    }
}

