/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.admin.GeneralConfiguration;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.rest.api.issue.FieldOperation;
import com.atlassian.jira.rest.api.issue.IssueUpdateRequest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Comment;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import com.atlassian.jira.testkit.client.restclient.Visibility;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestIssueResourceComments
extends RestFuncTest {
    private IssueClient issueClient;

    public void testCommentRendering() throws Exception {
        this.administration.restoreData("TestEditComment.xml");
        Issue hsp1 = this.issueClient.get("HSP-1", new Issue.Expand[0]);
        TestIssueResourceComments.assertEquals((String)"I'm a hero!", (String)((Comment)hsp1.fields.comment.getComments().get((int)0)).body);
        Issue expandedHsp1 = this.issueClient.get("HSP-1", new Issue.Expand[]{Issue.Expand.renderedFields});
        TestIssueResourceComments.assertEquals((String)"I'm a hero!", (String)((Comment)expandedHsp1.fields.comment.getComments().get((int)0)).body);
        TestIssueResourceComments.assertEquals((String)"2007-02-13T17:09:12.012+1100", (String)((Comment)expandedHsp1.fields.comment.getComments().get((int)0)).created);
        TestIssueResourceComments.assertEquals((String)"2007-02-13T17:09:12.012+1100", (String)((Comment)expandedHsp1.fields.comment.getComments().get((int)0)).updated);
        TestIssueResourceComments.assertEquals((String)"I&#39;m a hero!", (String)((Comment)expandedHsp1.renderedFields.comment.getComments().get((int)0)).body);
        TestIssueResourceComments.assertEquals((String)"13/Feb/07 5:09 PM", (String)((Comment)expandedHsp1.renderedFields.comment.getComments().get((int)0)).created);
        TestIssueResourceComments.assertEquals((String)"13/Feb/07 5:09 PM", (String)((Comment)expandedHsp1.renderedFields.comment.getComments().get((int)0)).updated);
    }

    public void testSystemTextFieldRendering() throws Exception {
        this.administration.restoreData("TestEditComment.xml");
        this.navigation.issue().setDescription("HSP-1", "I'll have 5<10<15 things?");
        this.navigation.issue().setEnvironment("HSP-1", "I'll have 5<10<15 things?");
        Issue hsp1 = this.issueClient.get("HSP-1", new Issue.Expand[0]);
        TestIssueResourceComments.assertEquals((String)"\r\nI'll have 5<10<15 things?", (String)hsp1.fields.description);
        TestIssueResourceComments.assertEquals((String)"I'll have 5<10<15 things?", (String)hsp1.fields.environment);
        Issue expandedHsp1 = this.issueClient.get("HSP-1", new Issue.Expand[]{Issue.Expand.renderedFields});
        TestIssueResourceComments.assertEquals((String)"\r<br/>\nI&#39;ll have 5&lt;10&lt;15 things?", (String)expandedHsp1.renderedFields.description);
        TestIssueResourceComments.assertEquals((String)"I&#39;ll have 5&lt;10&lt;15 things?", (String)expandedHsp1.renderedFields.environment);
    }

    public void testComment() throws Exception {
        this.administration.restoreBlankInstance();
        this.administration.generalConfiguration().setCommentVisibility(GeneralConfiguration.CommentVisibility.PROJECT_ROLES);
        this.administration.roles().addProjectRoleForUser("monkey", "Administrators", "admin");
        String key = this.navigation.issue().createIssue("monkey", "Bug", "First Test Issue");
        this.navigation.issue().addComment(key, "comment", "Administrators");
        Issue issue = this.issueClient.get(key, new Issue.Expand[0]);
        TestIssueResourceComments.assertEquals((int)1, (int)issue.fields.comment.getComments().size());
        this.tester.gotoPage("/rest/api/2/issue/" + key);
        Comment comment = (Comment)issue.fields.comment.getComments().get(0);
        TestIssueResourceComments.assertEquals((String)"comment", (String)comment.body);
        TestIssueResourceComments.assertEquals((String)"role", (String)comment.visibility.type);
        TestIssueResourceComments.assertEquals((String)"Administrators", (String)comment.visibility.value);
        TestIssueResourceComments.assertNotNull((Object)comment.created);
        TestIssueResourceComments.assertNotNull((Object)comment.updated);
        TestIssueResourceComments.assertEquals((String)(this.getEnvironmentData().getBaseUrl() + "/rest/api/2/issue/10000/comment/10000"), (String)comment.self);
        TestIssueResourceComments.assertEquals((String)"admin", (String)comment.author.name);
        TestIssueResourceComments.assertEquals((String)"Administrator", (String)comment.author.displayName);
        TestIssueResourceComments.assertEquals((String)(this.getEnvironmentData().getBaseUrl() + "/rest/api/2/user?username=admin"), (String)comment.author.self);
        TestIssueResourceComments.assertEquals((String)"admin", (String)comment.updateAuthor.name);
        TestIssueResourceComments.assertEquals((String)"Administrator", (String)comment.updateAuthor.displayName);
        TestIssueResourceComments.assertEquals((String)(this.getEnvironmentData().getBaseUrl() + "/rest/api/2/user?username=admin"), (String)comment.updateAuthor.self);
    }

    public void testEditCommentBody() throws Exception {
        this.administration.restoreData("TestEditComment.xml");
        String issueKey = "HSP-1";
        IssueUpdateRequest issueUpdateRequest = new IssueUpdateRequest();
        HashMap<String, List<FieldOperation>> operations = new HashMap<String, List<FieldOperation>>();
        String commentId = "10041";
        String commentBody = "Test";
        Comment jsonComment = new Comment();
        jsonComment.id = commentId;
        jsonComment.body = commentBody;
        this.addCommentOperation("edit", operations, jsonComment);
        issueUpdateRequest.update(operations);
        this.issueClient.edit(issueKey, issueUpdateRequest);
        Issue issue = this.issueClient.get(issueKey, new Issue.Expand[0]);
        Comment comment = (Comment)issue.fields.comment.getComments().get(2);
        TestIssueResourceComments.assertEquals((String)commentId, (String)comment.id);
        TestIssueResourceComments.assertEquals((String)commentBody, (String)comment.body);
    }

    public void testEditCommentSecurityRoleLevel() throws Exception {
        String commentId;
        this.administration.restoreData("TestEditComment.xml");
        String issueKey = "HSP-1";
        IssueUpdateRequest issueUpdateRequest = new IssueUpdateRequest();
        HashMap<String, List<FieldOperation>> operations = new HashMap<String, List<FieldOperation>>();
        Comment jsonComment = new Comment();
        jsonComment.id = commentId = "10041";
        jsonComment.visibility = new Visibility("role", "Administrators");
        this.addCommentOperation("edit", operations, jsonComment);
        issueUpdateRequest.update(operations);
        this.issueClient.edit(issueKey, issueUpdateRequest);
        Issue issue = this.issueClient.get(issueKey, new Issue.Expand[0]);
        Comment comment = (Comment)issue.fields.comment.getComments().get(2);
        TestIssueResourceComments.assertEquals((String)commentId, (String)comment.id);
        TestIssueResourceComments.assertEquals((String)"role", (String)comment.visibility.type);
        TestIssueResourceComments.assertEquals((String)"Administrators", (String)comment.visibility.value);
    }

    public void testEditCommentSecurityGroupLevel() throws Exception {
        String commentId;
        this.administration.restoreData("TestEditComment.xml");
        String issueKey = "HSP-1";
        IssueUpdateRequest issueUpdateRequest = new IssueUpdateRequest();
        HashMap<String, List<FieldOperation>> operations = new HashMap<String, List<FieldOperation>>();
        Comment jsonComment = new Comment();
        jsonComment.id = commentId = "10041";
        jsonComment.visibility = new Visibility("group", "jira-administrators");
        this.addCommentOperation("edit", operations, jsonComment);
        issueUpdateRequest.update(operations);
        this.issueClient.edit(issueKey, issueUpdateRequest);
        Issue issue = this.issueClient.get(issueKey, new Issue.Expand[0]);
        Comment comment = (Comment)issue.fields.comment.getComments().get(2);
        TestIssueResourceComments.assertEquals((String)commentId, (String)comment.id);
        TestIssueResourceComments.assertEquals((String)"group", (String)comment.visibility.type);
        TestIssueResourceComments.assertEquals((String)"jira-administrators", (String)comment.visibility.value);
    }

    public void testEditCommentSecurityFromRoleToGroupLevel() throws Exception {
        String commentId;
        this.administration.restoreData("TestEditComment.xml");
        String issueKey = "HSP-1";
        IssueUpdateRequest issueUpdateRequest = new IssueUpdateRequest();
        HashMap<String, List<FieldOperation>> operations = new HashMap<String, List<FieldOperation>>();
        Comment jsonComment = new Comment();
        jsonComment.id = commentId = "10041";
        jsonComment.visibility = new Visibility("role", "Administrators");
        this.addCommentOperation("edit", operations, jsonComment);
        issueUpdateRequest.update(operations);
        this.issueClient.edit(issueKey, issueUpdateRequest);
        Issue issue = this.issueClient.get(issueKey, new Issue.Expand[0]);
        Comment comment = (Comment)issue.fields.comment.getComments().get(2);
        Visibility visibility = comment.visibility;
        TestIssueResourceComments.assertEquals((String)"role", (String)visibility.type);
        TestIssueResourceComments.assertEquals((String)"Administrators", (String)visibility.value);
        jsonComment = new Comment();
        jsonComment.id = commentId;
        jsonComment.visibility = new Visibility("group", "jira-administrators");
        this.addCommentOperation("edit", operations, jsonComment);
        issueUpdateRequest.update(operations);
        this.issueClient.edit(issueKey, issueUpdateRequest);
        issue = this.issueClient.get(issueKey, new Issue.Expand[0]);
        comment = (Comment)issue.fields.comment.getComments().get(2);
        visibility = comment.visibility;
        TestIssueResourceComments.assertEquals((String)"group", (String)visibility.type);
        TestIssueResourceComments.assertEquals((String)"jira-administrators", (String)visibility.value);
    }

    public void testEditCommentRemoveSecurityLevel() throws Exception {
        String commentId;
        this.administration.restoreData("TestEditComment.xml");
        String issueKey = "HSP-1";
        IssueUpdateRequest issueUpdateRequest = new IssueUpdateRequest();
        HashMap<String, List<FieldOperation>> operations = new HashMap<String, List<FieldOperation>>();
        Comment jsonComment = new Comment();
        jsonComment.id = commentId = "10041";
        jsonComment.visibility = new Visibility("role", "Administrators");
        this.addCommentOperation("edit", operations, jsonComment);
        issueUpdateRequest.update(operations);
        this.issueClient.edit(issueKey, issueUpdateRequest);
        Issue issue = this.issueClient.get(issueKey, new Issue.Expand[0]);
        Comment comment = (Comment)issue.fields.comment.getComments().get(2);
        Visibility visibility = comment.visibility;
        TestIssueResourceComments.assertEquals((String)"role", (String)visibility.type);
        TestIssueResourceComments.assertEquals((String)"Administrators", (String)visibility.value);
        jsonComment = new Comment();
        jsonComment.id = commentId;
        jsonComment.visibility = null;
        this.addCommentOperation("edit", operations, jsonComment);
        issueUpdateRequest.update(operations);
        this.issueClient.edit(issueKey, issueUpdateRequest);
        issue = this.issueClient.get(issueKey, new Issue.Expand[0]);
        comment = (Comment)issue.fields.comment.getComments().get(2);
        visibility = comment.visibility;
        TestIssueResourceComments.assertNull((String)"No security level expected!", (Object)visibility);
    }

    public void testRemoveComment() throws Exception {
        this.administration.restoreData("TestEditComment.xml");
        String issueKey = "HSP-1";
        String commentId = "10041";
        Issue issue = this.issueClient.get(issueKey, new Issue.Expand[0]);
        TestIssueResourceComments.assertEquals((int)3, (int)issue.fields.comment.getComments().size());
        Comment comment = (Comment)issue.fields.comment.getComments().get(2);
        TestIssueResourceComments.assertEquals((String)commentId, (String)comment.id);
        IssueUpdateRequest issueUpdateRequest = new IssueUpdateRequest();
        HashMap<String, List<FieldOperation>> operations = new HashMap<String, List<FieldOperation>>();
        Comment jsonComment = new Comment();
        jsonComment.id = commentId;
        this.addCommentOperation("remove", operations, jsonComment);
        issueUpdateRequest.update(operations);
        this.issueClient.edit(issueKey, issueUpdateRequest);
        issue = this.issueClient.get(issueKey, new Issue.Expand[0]);
        TestIssueResourceComments.assertEquals((int)2, (int)issue.fields.comment.getComments().size());
    }

    public void testAddCommentWithSecurityLevel() throws Exception {
        this.administration.restoreData("TestEditComment.xml");
        String issueKey = "HSP-1";
        IssueUpdateRequest issueUpdateRequest = new IssueUpdateRequest();
        HashMap<String, List<FieldOperation>> operations = new HashMap<String, List<FieldOperation>>();
        Comment jsonComment = new Comment();
        jsonComment.body = "New Comment!";
        jsonComment.visibility = new Visibility("role", "Administrators");
        this.addCommentOperation("add", operations, jsonComment);
        issueUpdateRequest.update(operations);
        this.issueClient.edit(issueKey, issueUpdateRequest);
        Issue issue = this.issueClient.get(issueKey, new Issue.Expand[0]);
        Comment comment = (Comment)issue.fields.comment.getComments().get(3);
        Visibility visibility = comment.visibility;
        TestIssueResourceComments.assertEquals((String)"role", (String)visibility.type);
        TestIssueResourceComments.assertEquals((String)"Administrators", (String)visibility.value);
    }

    private void addCommentOperation(String operation, Map<String, List<FieldOperation>> operations, Comment comment) {
        ArrayList<FieldOperation> fieldOperations = new ArrayList<FieldOperation>();
        FieldOperation fieldOperation = new FieldOperation();
        fieldOperation.init(operation, (Object)comment);
        fieldOperations.add(fieldOperation);
        operations.put("comment", fieldOperations);
    }

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.issueClient = new IssueClient((JIRAEnvironmentData)this.getEnvironmentData());
    }
}

