/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Attachment;
import com.atlassian.jira.testkit.client.restclient.AttachmentRendered;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestIssueResourceAttachments
extends RestFuncTest {
    private static final String ISSUE_KEY = "MKY-1";
    private IssueClient issueClient;

    public void testAttachmentsExpanded() throws Exception {
        Issue issue = this.issueClient.get(ISSUE_KEY, new Issue.Expand[0]);
        TestIssueResourceAttachments.assertEquals((String)ISSUE_KEY, (String)issue.key);
        TestIssueResourceAttachments.assertEquals((int)3, (int)issue.fields.attachment.size());
        for (Attachment attachment1 : issue.fields.attachment) {
            if (!attachment1.self.endsWith("/10000")) continue;
            TestIssueResourceAttachments.assertEquals((String)(this.getBaseUrl() + "/rest/api/2/attachment/10000"), (String)attachment1.self);
            TestIssueResourceAttachments.assertEquals((String)"attachment.txt", (String)attachment1.filename);
            TestIssueResourceAttachments.assertEquals((String)(this.getBaseUrl() + "/rest/api/2/user?username=admin"), (String)attachment1.author.self);
            TestIssueResourceAttachments.assertEquals((String)"admin", (String)attachment1.author.name);
            TestIssueResourceAttachments.assertEquals((String)"Administrator", (String)attachment1.author.displayName);
            this.assertEqualDateStrings("2010-06-09T15:59:34.602+1000", attachment1.created);
            TestIssueResourceAttachments.assertEquals((long)19L, (long)attachment1.size);
            TestIssueResourceAttachments.assertEquals((String)"text/plain", (String)attachment1.mimeType);
            TestIssueResourceAttachments.assertEquals((String)(this.getBaseUrl() + "/secure/attachment/10000/attachment.txt"), (String)attachment1.content);
            return;
        }
        TestIssueResourceAttachments.fail((String)"attachment 10000 is missing");
    }

    public void testAttachmentsRendered() {
        Issue issue = this.issueClient.get(ISSUE_KEY, new Issue.Expand[]{Issue.Expand.renderedFields});
        TestIssueResourceAttachments.assertEquals((String)ISSUE_KEY, (String)issue.key);
        TestIssueResourceAttachments.assertEquals((int)3, (int)issue.fields.attachment.size());
        int attachCount = 0;
        for (AttachmentRendered attachment1 : issue.renderedFields.attachment) {
            if (attachment1.self.endsWith("/10000")) {
                TestIssueResourceAttachments.assertEquals((String)(this.getBaseUrl() + "/rest/api/2/attachment/10000"), (String)attachment1.self);
                TestIssueResourceAttachments.assertEquals((String)"attachment.txt", (String)attachment1.filename);
                TestIssueResourceAttachments.assertEquals((String)(this.getBaseUrl() + "/rest/api/2/user?username=admin"), (String)attachment1.author.self);
                TestIssueResourceAttachments.assertEquals((String)"admin", (String)attachment1.author.name);
                TestIssueResourceAttachments.assertEquals((String)"Administrator", (String)attachment1.author.displayName);
                this.assertEqualDateStrings("09/Jun/10 3:59 PM", attachment1.created);
                TestIssueResourceAttachments.assertEquals((String)"0.0 kB", (String)attachment1.size);
                TestIssueResourceAttachments.assertEquals((String)"text/plain", (String)attachment1.mimeType);
                TestIssueResourceAttachments.assertEquals((String)(this.getBaseUrl() + "/secure/attachment/10000/attachment.txt"), (String)attachment1.content);
                ++attachCount;
                continue;
            }
            if (attachment1.self.endsWith("/10010")) {
                TestIssueResourceAttachments.assertEquals((String)"123 kB", (String)attachment1.size);
                this.assertEqualDateStrings("28/Jul/11 12:12 PM", attachment1.created);
                ++attachCount;
                continue;
            }
            if (!attachment1.self.endsWith("/10001")) continue;
            TestIssueResourceAttachments.assertEquals((String)"0.0 kB", (String)attachment1.size);
            this.assertEqualDateStrings("09/Jun/10 3:59 PM", attachment1.created);
            ++attachCount;
        }
        if (attachCount != 3) {
            TestIssueResourceAttachments.fail((String)"attachments collection didn't match");
        }
    }

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.issueClient = new IssueClient((JIRAEnvironmentData)this.getEnvironmentData());
        this.administration.restoreData("TestIssueResourceAttachments.xml");
    }
}

