/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Errors;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import com.atlassian.jira.testkit.client.restclient.Response;
import com.atlassian.jira.testkit.client.restclient.User;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import javax.ws.rs.core.Response;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestIssueResourceAssign
extends RestFuncTest {
    private static final String ADMIN = "admin";
    private static final String FRY = "fry";
    private static final String FARNSWORTH = "farnsworth";
    private IssueClient issueClient;

    public void testAssignPermission() throws Exception {
        this.administration.restoreData("TestAssignIssue.xml");
        Response response = ((IssueClient)this.issueClient.loginAs("joe", "joe")).assign("TST-1", new User().name(FRY));
        TestIssueResourceAssign.assertEquals((int)Response.Status.NO_CONTENT.getStatusCode(), (int)response.statusCode);
        Assert.assertThat((Object)this.issueClient.get((String)"TST-1", (Issue.Expand[])new Issue.Expand[0]).fields.assignee.name, (Matcher)CoreMatchers.equalTo((Object)FRY));
        response = ((IssueClient)this.issueClient.loginAs("bill", "bill")).assign("TST-1", new User().name(FRY));
        TestIssueResourceAssign.assertEquals((int)Response.Status.FORBIDDEN.getStatusCode(), (int)response.statusCode);
    }

    public void testAssign() throws Exception {
        this.administration.restoreData("TestAssignIssue.xml");
        Response response = this.issueClient.assign("TST-1", new User().name(ADMIN));
        TestIssueResourceAssign.assertEquals((int)Response.Status.NO_CONTENT.getStatusCode(), (int)response.statusCode);
        Assert.assertThat((Object)this.issueClient.get((String)"TST-1", (Issue.Expand[])new Issue.Expand[0]).fields.assignee.name, (Matcher)CoreMatchers.equalTo((Object)ADMIN));
        this.issueClient.assign("TST-1", new User().name(FRY));
        Assert.assertThat((Object)this.issueClient.get((String)"TST-1", (Issue.Expand[])new Issue.Expand[0]).fields.assignee.name, (Matcher)CoreMatchers.equalTo((Object)FRY));
        this.issueClient.assign("TST-1", new User().name(FARNSWORTH));
        Assert.assertThat((Object)this.issueClient.get((String)"TST-1", (Issue.Expand[])new Issue.Expand[0]).fields.assignee.name, (Matcher)CoreMatchers.equalTo((Object)FARNSWORTH));
        this.issueClient.assign("TST-1", new User().name(null));
        Assert.assertThat((Object)this.issueClient.get((String)"TST-1", (Issue.Expand[])new Issue.Expand[0]).fields.assignee, (Matcher)CoreMatchers.equalTo(null));
        this.issueClient.assign("TST-1", new User().name("-1"));
        Assert.assertThat((Object)this.issueClient.get((String)"TST-1", (Issue.Expand[])new Issue.Expand[0]).fields.assignee.name, (Matcher)CoreMatchers.equalTo((Object)ADMIN));
    }

    public void testAssignErrors() throws Exception {
        this.administration.restoreData("TestAssignIssue.xml");
        Response response = this.issueClient.assign("TST-19", new User().name(ADMIN));
        TestIssueResourceAssign.assertEquals((int)Response.Status.NOT_FOUND.getStatusCode(), (int)response.statusCode);
        response = this.issueClient.assign("TST-1", new User().name("joe"));
        TestIssueResourceAssign.assertEquals((int)Response.Status.BAD_REQUEST.getStatusCode(), (int)response.statusCode);
        TestIssueResourceAssign.assertEquals((Object)new Errors().addError("assignee", "User 'joe' cannot be assigned issues."), (Object)response.entity);
    }

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.issueClient = new IssueClient((JIRAEnvironmentData)this.getEnvironmentData());
    }
}

