/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.meterware.httpunit.WebResponse;
import java.io.IOException;
import java.util.Collections;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestIssueResource
extends RestFuncTest {
    private IssueClient issueClient;

    public void testViewIssueNotFound() throws Exception {
        this.administration.restoreBlankInstance();
        WebResponse resp123 = this.GET("rest/api/2/issue/1");
        TestIssueResource.assertEquals((int)404, (int)resp123.getResponseCode());
        this.assertNoLongerExistsError(resp123);
        WebResponse resp123Xml = this.GET("rest/api/2/issue/1", Collections.singletonMap("Accept", "application/xml;q=0.9,*/*;q=0.8"));
        TestIssueResource.assertEquals((int)404, (int)resp123Xml.getResponseCode());
        this.assertNoLongerExistsError(resp123Xml);
        WebResponse resp415 = this.GET("rest/api/2/issue/1", Collections.singletonMap("Accept", "application/xml;q=0.9"));
        TestIssueResource.assertEquals((int)406, (int)resp415.getResponseCode());
    }

    public void testNotLoggedIn_IssueExists() throws Exception {
        this.administration.restoreBlankInstance();
        String key = this.navigation.issue().createIssue("monkey", "Bug", "test bug");
        this.navigation.logout();
        WebResponse response = this.GET("/rest/api/2/issue/" + key);
        TestIssueResource.assertEquals((int)401, (int)response.getResponseCode());
    }

    public void testCaseInsensitiveKeyLookup() throws Exception {
        this.administration.restoreBlankInstance();
        String key = this.navigation.issue().createIssue("monkey", "Bug", "test bug");
        Issue realissue = this.issueClient.get(key, new Issue.Expand[0]);
        Issue issue = this.issueClient.get(key.toLowerCase(), new Issue.Expand[0]);
        TestIssueResource.assertEquals((String)realissue.id, (String)issue.id);
        TestIssueResource.assertEquals((String)key, (String)issue.key);
        issue = this.issueClient.get(key.toUpperCase(), new Issue.Expand[0]);
        TestIssueResource.assertEquals((String)realissue.id, (String)issue.id);
        TestIssueResource.assertEquals((String)key, (String)issue.key);
    }

    public void testMovedIssueKeyLookup() throws Exception {
        this.administration.restoreBlankInstance();
        String key = this.navigation.issue().createIssue("monkey", "Bug", "test bug");
        Issue origissue = this.issueClient.get(key, new Issue.Expand[0]);
        this.navigation.issue().viewIssue(key);
        this.tester.clickLink("move-issue");
        this.navigation.issue().selectProject("homosapien");
        this.tester.submit("Next >>");
        this.tester.submit("Next >>");
        this.tester.submit("Move");
        Issue issue = this.issueClient.get(key, new Issue.Expand[0]);
        TestIssueResource.assertEquals((String)origissue.id, (String)issue.id);
        TestIssueResource.assertEquals((String)"HSP-1", (String)issue.key);
        issue = this.issueClient.get(key.toLowerCase(), new Issue.Expand[0]);
        TestIssueResource.assertEquals((String)origissue.id, (String)issue.id);
        TestIssueResource.assertEquals((String)"HSP-1", (String)issue.key);
        issue = this.issueClient.get(key.toUpperCase(), new Issue.Expand[0]);
        TestIssueResource.assertEquals((String)origissue.id, (String)issue.id);
        TestIssueResource.assertEquals((String)"HSP-1", (String)issue.key);
    }

    public void testUnassignedIssueHasNoValue() throws Exception {
        this.administration.restoreBlankInstance();
        this.administration.generalConfiguration().setAllowUnassignedIssues(true);
        String key = this.navigation.issue().createIssue("monkey", "Bug", "test bug");
        this.navigation.issue().assignIssue(key, "my comment", "Unassigned");
        Issue issue = this.issueClient.get(key, new Issue.Expand[0]);
        TestIssueResource.assertNull((Object)issue.fields.assignee);
    }

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.issueClient = new IssueClient((JIRAEnvironmentData)this.getEnvironmentData());
    }

    private void assertNoLongerExistsError(WebResponse resp123) throws JSONException, IOException {
        JSONObject content = new JSONObject(resp123.getText());
        TestIssueResource.assertEquals((int)1, (int)content.getJSONArray("errorMessages").length());
        TestIssueResource.assertEquals((String)"Issue Does Not Exist", (String)content.getJSONArray("errorMessages").getString(0));
    }
}

