/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.backdoor.JqlAutoCompleteControl;
import com.atlassian.jira.functest.framework.backdoor.PluginIndexConfigurationControl;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.rest.api.issue.IssueCreateResponse;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.EntityPropertyClient;
import com.atlassian.jira.testkit.client.restclient.SearchRequest;
import com.atlassian.jira.testkit.client.restclient.SearchResult;
import com.atlassian.jira.util.SearchResultMatcher;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.query.operator.Operator;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.core.IsCollectionContaining;
import org.joda.time.format.ISODateTimeFormat;
import org.junit.Assert;

@WebTest(value={Category.FUNC_TEST, Category.ENTITY_PROPERTIES, Category.REST, Category.REFERENCE_PLUGIN})
public class TestIssuePropertyAliasing
extends FuncTestCase {
    private static final Label TEST_LABEL = new Label("propertyAliasing", "description of the label", "2014-10-30", 10L);
    private EntityPropertyClient client;
    private PluginIndexConfigurationControl configurationControl;
    private JqlAutoCompleteControl autoCompleteControl;

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.client = new EntityPropertyClient((JIRAEnvironmentData)this.environmentData, "issue");
        this.configurationControl = new PluginIndexConfigurationControl(this.environmentData);
        this.autoCompleteControl = new JqlAutoCompleteControl(this.environmentData);
        this.backdoor.restoreBlankInstance();
    }

    public void testJqlAliasSearchingForStrings() throws IOException {
        this.setLabelDocumentConfiguration();
        IssueCreateResponse issue = this.backdoor.issues().createIssue("HSP", "Issue with aliases issue property");
        this.setLabelProperty(issue, TEST_LABEL);
        this.assertSearchResultsForAlias("label", Operator.EQUALS, TEST_LABEL.getValue(), issue);
        this.assertSearchResultsForAlias("label", Operator.IN, "('" + TEST_LABEL.getValue() + "')", issue);
    }

    public void testJqlAliasingForRelativeDateQueries() throws Exception {
        this.setLabelDocumentConfiguration();
        IssueCreateResponse issue = this.backdoor.issues().createIssue("HSP", "Issue with aliases issue property");
        this.setLabelProperty(issue, TEST_LABEL);
        this.assertSearchResultsForAlias("labelDate", Operator.GREATER_THAN_EQUALS, "'2014-10-29'", issue);
        this.assertSearchResultsForAlias("labelDate", Operator.LESS_THAN, "'2014-11-01'", issue);
        this.assertSearchResultsForAlias("labelDate", Operator.LESS_THAN, "'2014-11-01'", issue);
    }

    public void testJqlAliasingForJqlFunctionDateQueries() throws Exception {
        this.setLabelDocumentConfiguration();
        IssueCreateResponse issue = this.backdoor.issues().createIssue("HSP", "Issue with aliases issue property");
        String date = ISODateTimeFormat.dateTimeNoMillis().print(System.currentTimeMillis());
        Label label = new Label("val", "description", date, 1L);
        this.setLabelProperty(issue, label);
        this.assertSearchResultsForAlias("labelDate", Operator.GREATER_THAN_EQUALS, "'-2d'", issue);
        this.assertSearchResultsForAlias("labelDate", Operator.GREATER_THAN, "startOfDay()", issue);
        this.assertSearchResultsForAlias("labelDate", Operator.LESS_THAN, "endOfDay()", issue);
        this.assertSearchResultsForAlias("labelDate", Operator.LESS_THAN_EQUALS, "'2d'", issue);
    }

    public void testJqlAliasingForTextValues() throws Exception {
        this.setLabelDocumentConfiguration();
        IssueCreateResponse issue = this.backdoor.issues().createIssue("HSP", "Issue with aliases issue property");
        this.setLabelProperty(issue, TEST_LABEL);
        this.assertSearchResultsForAlias("labelDescription", Operator.LIKE, "description", issue);
        this.assertSearchResultsForAlias("labelDescription", Operator.LIKE, "label", issue);
    }

    public void testJqlAliasSearchingForMultipleIssues() throws Exception {
        this.setLabelDocumentConfiguration();
        IssueCreateResponse firstIssue = this.backdoor.issues().createIssue("HSP", "First issue");
        IssueCreateResponse secondIssue = this.backdoor.issues().createIssue("HSP", "Second issue");
        IssueCreateResponse thirdIssue = this.backdoor.issues().createIssue("HSP", "Third issue");
        String date = ISODateTimeFormat.dateTimeNoMillis().print(System.currentTimeMillis());
        Label firstLabel = new Label("first value", "first description", date, 1L);
        Label secondLabel = new Label("second value", "second description", date, 1L);
        Label thirdLabel = new Label("third value", "third description", date, 1L);
        this.setLabelProperty(firstIssue, firstLabel);
        this.setLabelProperty(secondIssue, secondLabel);
        this.setLabelProperty(thirdIssue, thirdLabel);
        this.assertSearchResultsForAlias("label", Operator.EQUALS, "'" + firstLabel.value + "'", firstIssue);
        this.assertSearchResultsForAlias("labelDescription", Operator.LIKE, "description", firstIssue, secondIssue, thirdIssue);
        this.assertSearchResult(new SearchRequest().jql("label = 'second value' AND labelDescription ~ 'description'"), secondIssue);
        this.assertSearchResult(new SearchRequest().jql("labelDate > '-1d' AND labelDescription ~ 'description'"), firstIssue, secondIssue, thirdIssue);
        this.assertSearchResult(new SearchRequest().jql("labelId = 1"), firstIssue, secondIssue, thirdIssue);
    }

    public void testConflictingJqlAliases() throws Exception {
        this.updatePluginIndexConfiguration("first plugin", "conflict_indexconf1.xml", this.configurationControl);
        this.updatePluginIndexConfiguration("second plugin", "conflict_indexconf2.xml", this.configurationControl);
        IssueCreateResponse firstIssue = this.backdoor.issues().createIssue("HSP", "Some issue");
        IssueCreateResponse secondIssue = this.backdoor.issues().createIssue("HSP", "Some issue");
        String date = ISODateTimeFormat.dateTimeNoMillis().print(System.currentTimeMillis());
        this.client.put(firstIssue.key, "label", new Label("label", "description", date, 1L).toJson());
        this.client.put(secondIssue.key, "conflicting_alias", new Label("conflict", "description", date, 1L).toJson());
        this.assertSearchResultsForAlias("conflict", Operator.EQUALS, "'label'", firstIssue);
        this.assertSearchResultsForAlias("conflict", Operator.EQUALS, "'conflict'", secondIssue);
        this.assertSearchResultsForAlias("issue.property[conflicting_alias].value", Operator.EQUALS, "'conflict'", secondIssue);
        this.assertSearchResultsForAlias("issue.property[label].value", Operator.EQUALS, "'label'", firstIssue);
    }

    public void testAliasAutoCompletionWithoutConflict() throws Exception {
        String[] values;
        this.setLabelDocumentConfiguration();
        String date = ISODateTimeFormat.dateTimeNoMillis().print(System.currentTimeMillis());
        for (String value : values = new String[]{"value1", "value2", "value3", "value4", "value5", "value6"}) {
            IssueCreateResponse issue = this.backdoor.issues().createIssue("HSP", "new issue with label value " + value);
            this.setLabelProperty(issue, new Label(value, "some description", date, 1L));
        }
        this.assertAutoCompletionResult("label", "val", values);
        this.assertAutoCompletionResult("label", "value", values);
        this.assertAutoCompletionResult("label", "value1", "value1");
        this.assertAutoCompletionResult("label", "value2", "value2");
    }

    public void testAliasWithMoreThen15Matches() throws Exception {
        this.setLabelDocumentConfiguration();
        String date = ISODateTimeFormat.dateTimeNoMillis().print(System.currentTimeMillis());
        for (int i = 0; i < 20; ++i) {
            IssueCreateResponse issue = this.backdoor.issues().createIssue("HSP", "new issue " + i);
            this.setLabelProperty(issue, new Label("value" + i, "some description", date, 1L));
        }
        JqlAutoCompleteControl.Results autoCompleteResults = this.autoCompleteControl.getAutoCompleteResults("label", "val");
        Assert.assertThat(autoCompleteResults.getResults(), (Matcher)Matchers.hasSize((Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(15))));
    }

    public void testAutoCompletionWorksForConflictingProperties() throws Exception {
        this.updatePluginIndexConfiguration("first plugin", "conflict_indexconf1.xml", this.configurationControl);
        this.updatePluginIndexConfiguration("second plugin", "conflict_indexconf2.xml", this.configurationControl);
        IssueCreateResponse firstIssue = this.backdoor.issues().createIssue("HSP", "Some issue");
        IssueCreateResponse secondIssue = this.backdoor.issues().createIssue("HSP", "Some issue");
        String date = ISODateTimeFormat.dateTimeNoMillis().print(System.currentTimeMillis());
        this.client.put(firstIssue.key, "label", new Label("some label value", "description", date, 1L).toJson());
        this.client.put(secondIssue.key, "conflicting_alias", new Label("conflict", "description", date, 1L).toJson());
        this.assertAutoCompletionResult("issue.property[label].value", "som", "\"some label value\"");
        this.assertAutoCompletionResult("issue.property[conflicting_alias].value", "conf", "conflict");
        Assert.assertThat(this.autoCompleteControl.getAutoCompleteResults("label", "lab").getResults(), (Matcher)Matchers.emptyIterable());
    }

    public void testAutoCompletionReturnsOnlyDistrinctResults() {
        this.setLabelDocumentConfiguration();
        String date = ISODateTimeFormat.dateTimeNoMillis().print(System.currentTimeMillis());
        for (int i = 0; i < 20; ++i) {
            IssueCreateResponse issue = this.backdoor.issues().createIssue("HSP", "new issue " + i);
            this.setLabelProperty(issue, new Label("value", "some description", date, 1L));
        }
        Assert.assertThat(this.autoCompleteControl.getAutoCompleteResults("label", "val").getResults(), (Matcher)Matchers.hasSize((Matcher)Matchers.equalTo((Object)1)));
    }

    private void assertAutoCompletionResult(String fieldName, String fieldValue, final String ... values) {
        JqlAutoCompleteControl.Results results = this.autoCompleteControl.getAutoCompleteResults(fieldName, fieldValue);
        Assert.assertThat(results.getResults(), (Matcher)new TypeSafeMatcher<List<JqlAutoCompleteControl.AutoCompleteResult>>(){

            protected boolean matchesSafely(List<JqlAutoCompleteControl.AutoCompleteResult> autoCompleteResults) {
                return IsCollectionContaining.hasItems((Object[])values).matches((Object)Lists.transform(autoCompleteResults, (Function)new Function<JqlAutoCompleteControl.AutoCompleteResult, String>(){

                    public String apply(JqlAutoCompleteControl.AutoCompleteResult result) {
                        return result.getValue();
                    }
                }));
            }

            public void describeTo(Description description) {
                description.appendText("Auto complete result does not contain").appendValue((Object)values);
            }
        });
    }

    private void assertSearchResultsForAlias(String alias, Operator operator, String value, IssueCreateResponse ... issues) {
        SearchRequest searchRequest = new SearchRequest().jql(String.format("%s %s %s", alias, operator.getDisplayString(), value));
        this.assertSearchResult(searchRequest, issues);
    }

    private void assertSearchResult(SearchRequest searchRequest, IssueCreateResponse ... issues) {
        SearchResult searchResult = this.backdoor.search().getSearch(searchRequest);
        Assert.assertThat((Object)searchResult, SearchResultMatcher.issues(Lists.transform((List)Lists.newArrayList((Object[])issues), (Function)new Function<IssueCreateResponse, String>(){

            public String apply(IssueCreateResponse issueCreateResponse) {
                return issueCreateResponse.key();
            }
        })));
    }

    private void setLabelDocumentConfiguration() {
        this.updatePluginIndexConfiguration("com.atlassian.jira.dev.reference-plugin", "pluginindexconfiguration1.xml", this.configurationControl);
    }

    private void setLabelProperty(IssueCreateResponse issue, Label label) {
        this.client.put(issue.key, "label", label.toJson());
    }

    private static class Label {
        private final String value;
        private final String description;
        private final String date;
        private final Long id;

        private Label(String value, String description, String date, Long id) {
            this.value = value;
            this.description = description;
            this.date = date;
            this.id = id;
        }

        public JSONObject toJson() {
            return new JSONObject((Map<String, Object>)ImmutableMap.of((Object)"value", (Object)this.value, (Object)"description", (Object)this.description, (Object)"date", (Object)this.date, (Object)"id", (Object)this.id));
        }

        public String getValue() {
            return this.value;
        }

        public String getDescription() {
            return this.description;
        }

        public String getDate() {
            return this.date;
        }

        public Long getId() {
            return this.id;
        }
    }
}

