/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.IssueLinkType;
import com.atlassian.jira.testkit.client.restclient.IssueLinkTypeClient;
import com.atlassian.jira.testkit.client.restclient.IssueLinkTypes;
import com.atlassian.jira.testkit.client.restclient.Response;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Rule;
import org.junit.rules.ExpectedException;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestIssueLinkTypeResource
extends RestFuncTest {
    private IssueLinkTypeClient issueLinkTypeClient;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    public void testGetAllIssueLinkTypes() throws Exception {
        IssueLinkTypes issueLinkTypes = this.issueLinkTypeClient.getIssueLinkTypes();
        List list = issueLinkTypes.issueLinkTypes;
        TestIssueLinkTypeResource.assertEquals((int)2, (int)list.size());
        IssueLinkType type = (IssueLinkType)list.get(0);
        TestIssueLinkTypeResource.assertEquals((String)type.name, (String)"Blocks");
        TestIssueLinkTypeResource.assertEquals((String)"Blocks", (String)type.outward);
        TestIssueLinkTypeResource.assertEquals((String)"Blocked by", (String)type.inward);
        TestIssueLinkTypeResource.assertEquals((int)new Long(10100L).intValue(), (int)type.id.intValue());
        TestIssueLinkTypeResource.assertEquals((String)this.getBaseUrlPlus("rest/api/2/issueLinkType/10100"), (String)type.self.toString());
        type = (IssueLinkType)list.get(1);
        TestIssueLinkTypeResource.assertEquals((String)type.name, (String)"Duplicate");
        TestIssueLinkTypeResource.assertEquals((String)"Duplicates", (String)type.outward);
        TestIssueLinkTypeResource.assertEquals((String)"Duplicated by", (String)type.inward);
        TestIssueLinkTypeResource.assertEquals((int)new Long(10000L).intValue(), (int)type.id.intValue());
        TestIssueLinkTypeResource.assertEquals((String)this.getBaseUrlPlus("rest/api/2/issueLinkType/10000"), (String)type.self.toString());
    }

    public void testGetAllIssueLinkTypesReturns404WhenIssueLinkingDisabled() throws Exception {
        this.oldway_consider_porting.deactivateIssueLinking();
        TestIssueLinkTypeResource.assertEquals((int)404, (int)this.issueLinkTypeClient.getResponseForAllLinkTypes().statusCode);
    }

    public void testGetAllIssueLinkTypesAnonymousUserAllowed() throws Exception {
        IssueLinkTypes issueLinkTypes = ((IssueLinkTypeClient)this.issueLinkTypeClient.anonymous()).getIssueLinkTypes();
        List list = issueLinkTypes.issueLinkTypes;
        TestIssueLinkTypeResource.assertEquals((int)2, (int)list.size());
    }

    public void testGetIssueLinkTypeReturns404WhenIssueLinkingDisabled() throws Exception {
        this.oldway_consider_porting.deactivateIssueLinking();
        TestIssueLinkTypeResource.assertEquals((int)404, (int)this.issueLinkTypeClient.getResponseForLinkType((String)"10000").statusCode);
    }

    public void testCreateIssueLinkType() throws Exception {
        IssueLinkType linkType = this.issueLinkTypeClient.createIssueLinkType("New Thing", "inbound", "outbound");
        MatcherAssert.assertThat((Object)linkType.name, (Matcher)CoreMatchers.is((Object)"New Thing"));
        MatcherAssert.assertThat((Object)linkType.inward, (Matcher)CoreMatchers.is((Object)"inbound"));
        MatcherAssert.assertThat((Object)linkType.outward, (Matcher)CoreMatchers.is((Object)"outbound"));
    }

    public void testDeleteIssueLinkType() throws Exception {
        IssueLinkType linkType = this.issueLinkTypeClient.createIssueLinkType("New Thing", "inbound", "outbound");
        Response response = this.issueLinkTypeClient.deleteIssueLinkType(linkType.id.toString());
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)CoreMatchers.is((Object)204));
        try {
            this.issueLinkTypeClient.getIssueLinkType(linkType.id.toString());
            TestIssueLinkTypeResource.fail();
        }
        catch (UniformInterfaceException e) {
            MatcherAssert.assertThat((Object)e.getResponse().getClientResponseStatus(), (Matcher)CoreMatchers.is((Object)ClientResponse.Status.NOT_FOUND));
        }
    }

    public void testGetIssueLinkType() throws Exception {
        IssueLinkType type = ((IssueLinkTypeClient)this.issueLinkTypeClient.anonymous()).getIssueLinkType("10000");
        TestIssueLinkTypeResource.assertEquals((String)type.name, (String)"Duplicate");
        TestIssueLinkTypeResource.assertEquals((String)"Duplicates", (String)type.outward);
        TestIssueLinkTypeResource.assertEquals((String)"Duplicated by", (String)type.inward);
        TestIssueLinkTypeResource.assertEquals((int)new Long(10000L).intValue(), (int)type.id.intValue());
    }

    public void testGetIssueLinkTypeIssueLinkTypeNotFound() throws Exception {
        Response response = this.issueLinkTypeClient.getResponseForLinkType("10012");
        TestIssueLinkTypeResource.assertEquals((int)404, (int)response.statusCode);
        TestIssueLinkTypeResource.assertEquals((String)"No issue link type with id '10012' found.", (String)((String)response.entity.errorMessages.get(0)));
    }

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.issueLinkTypeClient = new IssueLinkTypeClient((JIRAEnvironmentData)this.getEnvironmentData());
        this.administration.restoreData("TestIssueLinkType.xml");
    }
}

