/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.navigation.issue.FileAttachmentsList;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.restclient.Attachment;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.ByteArrayPartSource;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.PartSource;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestIssueAttachmentsResource
extends RestFuncTest {
    private HttpClient client;

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreBlankInstance();
        this.administration.attachments().enable();
        this.client = new HttpClient();
    }

    public void testAttachSingleAttachment() throws Exception {
        String key = this.navigation.issue().createIssue("monkey", "Bug", "Issue with attachment");
        PostMethod method = this.addAttachments(key, true, new MyAttachment("testfile.txt", "text/plain", "Hello world!!"));
        TestIssueAttachmentsResource.assertEquals((int)200, (int)method.getStatusCode());
        InputStream jsonStream = method.getResponseBodyAsStream();
        ObjectMapper mapper = new ObjectMapper();
        List attachmentList = (List)mapper.readValue(jsonStream, (TypeReference)new TypeReference<List<Attachment>>(){});
        TestIssueAttachmentsResource.assertEquals((int)1, (int)attachmentList.size());
        Attachment attachment = (Attachment)attachmentList.get(0);
        TestIssueAttachmentsResource.assertEquals((String)"10000", (String)attachment.id);
        TestIssueAttachmentsResource.assertEquals((String)"testfile.txt", (String)attachment.filename);
        TestIssueAttachmentsResource.assertEquals((String)(this.getBaseUrl() + "/rest/api/2/attachment/10000"), (String)attachment.self);
        TestIssueAttachmentsResource.assertEquals((String)(this.getBaseUrl() + "/rest/api/2/user?username=admin"), (String)attachment.author.self);
        TestIssueAttachmentsResource.assertEquals((String)"admin", (String)attachment.author.name);
        TestIssueAttachmentsResource.assertEquals((String)"Administrator", (String)attachment.author.displayName);
        List<FileAttachmentsList.FileAttachmentItem> attachments = this.navigation.issue().attachments(key).list().get();
        TestIssueAttachmentsResource.assertEquals((int)1, (int)attachments.size());
        FileAttachmentsList.FileAttachmentItem item = attachments.get(0);
        TestIssueAttachmentsResource.assertEquals((String)"testfile.txt", (String)item.getName());
        TestIssueAttachmentsResource.assertEquals((String)"Hello world!!", (String)this.navigation.issue().attachments(key).manage().downloadAttachmentAsString(item.getId(), item.getName()));
    }

    public void testAttachMultipleAttachments() throws Exception {
        String key = this.navigation.issue().createIssue("monkey", "Bug", "Issue with attachment");
        PostMethod method = this.addAttachments(key, true, new MyAttachment("testfile1.txt", "text/plain", "Hello first world!!"), new MyAttachment("testfile2.txt", "text/plain", "Hello second world!!"));
        TestIssueAttachmentsResource.assertEquals((int)200, (int)method.getStatusCode());
        InputStream jsonStream = method.getResponseBodyAsStream();
        ObjectMapper mapper = new ObjectMapper();
        List attachmentList = (List)mapper.readValue(jsonStream, (TypeReference)new TypeReference<List<Attachment>>(){});
        TestIssueAttachmentsResource.assertEquals((int)2, (int)attachmentList.size());
        Attachment attachment = (Attachment)attachmentList.get(0);
        TestIssueAttachmentsResource.assertEquals((String)"10000", (String)attachment.id);
        TestIssueAttachmentsResource.assertEquals((String)"testfile1.txt", (String)attachment.filename);
        TestIssueAttachmentsResource.assertEquals((String)(this.getBaseUrl() + "/rest/api/2/attachment/10000"), (String)attachment.self);
        TestIssueAttachmentsResource.assertEquals((String)(this.getBaseUrl() + "/rest/api/2/user?username=admin"), (String)attachment.author.self);
        TestIssueAttachmentsResource.assertEquals((String)"admin", (String)attachment.author.name);
        TestIssueAttachmentsResource.assertEquals((String)"Administrator", (String)attachment.author.displayName);
        attachment = (Attachment)attachmentList.get(1);
        TestIssueAttachmentsResource.assertEquals((String)"10001", (String)attachment.id);
        TestIssueAttachmentsResource.assertEquals((String)"testfile2.txt", (String)attachment.filename);
        TestIssueAttachmentsResource.assertEquals((String)(this.getBaseUrl() + "/rest/api/2/attachment/10001"), (String)attachment.self);
        TestIssueAttachmentsResource.assertEquals((String)(this.getBaseUrl() + "/rest/api/2/user?username=admin"), (String)attachment.author.self);
        TestIssueAttachmentsResource.assertEquals((String)"admin", (String)attachment.author.name);
        TestIssueAttachmentsResource.assertEquals((String)"Administrator", (String)attachment.author.displayName);
        List<FileAttachmentsList.FileAttachmentItem> attachments = this.navigation.issue().attachments(key).list().get();
        TestIssueAttachmentsResource.assertEquals((int)2, (int)attachments.size());
        FileAttachmentsList.FileAttachmentItem item1 = attachments.get(0);
        TestIssueAttachmentsResource.assertEquals((String)"testfile1.txt", (String)item1.getName());
        TestIssueAttachmentsResource.assertEquals((String)"Hello first world!!", (String)this.navigation.issue().attachments(key).manage().downloadAttachmentAsString(item1.getId(), item1.getName()));
        FileAttachmentsList.FileAttachmentItem item2 = attachments.get(1);
        TestIssueAttachmentsResource.assertEquals((String)"testfile2.txt", (String)item2.getName());
        TestIssueAttachmentsResource.assertEquals((String)"Hello second world!!", (String)this.navigation.issue().attachments(key).manage().downloadAttachmentAsString(item2.getId(), item2.getName()));
    }

    public void testAttachTooBig() throws Exception {
        this.administration.attachments().enable("500");
        byte[] toobig = new byte[1000];
        for (int i = 0; i < 1000; ++i) {
            toobig[i] = 97;
        }
        String key = this.navigation.issue().createIssue("monkey", "Bug", "Issue with attachment");
        PostMethod method = this.addAttachments(key, true, new MyAttachment("toobig.txt", "text/plain", toobig));
        TestIssueAttachmentsResource.assertEquals((int)404, (int)method.getStatusCode());
        List<FileAttachmentsList.FileAttachmentItem> attachments = this.navigation.issue().attachments(key).list().get();
        TestIssueAttachmentsResource.assertEquals((int)0, (int)attachments.size());
    }

    public void testAttachmentsDisabled() throws Exception {
        this.administration.attachments().disable();
        String key = this.navigation.issue().createIssue("monkey", "Bug", "Issue with attachment");
        PostMethod method = this.addAttachments(key, true, new MyAttachment("testfile.txt", "text/plain", "Hello world!!"));
        TestIssueAttachmentsResource.assertEquals((int)403, (int)method.getStatusCode());
        List<FileAttachmentsList.FileAttachmentItem> attachments = this.navigation.issue().attachments(key).list().get();
        TestIssueAttachmentsResource.assertEquals((int)0, (int)attachments.size());
    }

    public void testXsrf() throws Exception {
        String key = this.navigation.issue().createIssue("monkey", "Bug", "Issue with attachment");
        PostMethod method = this.addAttachments(key, false, new MyAttachment("testfile.txt", "text/plain", "Hello world!!"));
        TestIssueAttachmentsResource.assertEquals((int)404, (int)method.getStatusCode());
        List<FileAttachmentsList.FileAttachmentItem> attachments = this.navigation.issue().attachments(key).list().get();
        TestIssueAttachmentsResource.assertEquals((int)0, (int)attachments.size());
    }

    public void testNoIssue() throws Exception {
        PostMethod method = this.addAttachments("BLAH-123", true, new MyAttachment("testfile.txt", "text/plain", "Hello world!!"));
        TestIssueAttachmentsResource.assertEquals((int)404, (int)method.getStatusCode());
    }

    public void testNoPermission() throws Exception {
        String key = this.navigation.issue().createIssue("monkey", "Bug", "Issue with attachment");
        this.navigation.logout();
        PostMethod method = this.addAttachments(key, true, new MyAttachment("testfile.txt", "text/ plain", "Hello world!!"));
        TestIssueAttachmentsResource.assertEquals((int)401, (int)method.getStatusCode());
        this.navigation.login("admin");
        List<FileAttachmentsList.FileAttachmentItem> attachments = this.navigation.issue().attachments(key).list().get();
        TestIssueAttachmentsResource.assertEquals((int)0, (int)attachments.size());
    }

    private PostMethod addAttachments(String issueKey, boolean addXsrf, MyAttachment ... attachments) throws Exception {
        String sessionId;
        String url = this.getBaseUrlPlus("rest/api/2/issue", issueKey, "attachments");
        PostMethod method = new PostMethod(url);
        ArrayList<FilePart> fileParts = new ArrayList<FilePart>();
        for (MyAttachment attachment : attachments) {
            ByteArrayPartSource partSource = new ByteArrayPartSource(attachment.filename, attachment.contents);
            FilePart filePart = new FilePart("file", (PartSource)partSource, attachment.contentType, "UTF-8");
            fileParts.add(filePart);
        }
        MultipartRequestEntity entity = new MultipartRequestEntity((Part[])fileParts.toArray(new FilePart[fileParts.size()]), new HttpMethodParams());
        method.setRequestEntity((RequestEntity)entity);
        if (addXsrf) {
            method.addRequestHeader("X-Atlassian-Token", "nocheck");
        }
        if ((sessionId = this.getTester().getTestContext().getWebClient().getCookieValue("JSESSIONID")) != null) {
            this.client.getState().addCookie(new Cookie(this.getDomain(), "JSESSIONID", sessionId, "/", null, false));
        }
        if (StringUtils.isNotBlank((String)this.environmentData.getTenant())) {
            method.addRequestHeader("X-Atlassian-Tenant", this.environmentData.getTenant());
        }
        this.client.executeMethod((HttpMethod)method);
        return method;
    }

    private String getDomain() {
        String domain = this.getEnvironmentData().getProperty("jira.host");
        if (domain == null) {
            return "localhost";
        }
        return domain;
    }

    private static class MyAttachment {
        public String filename;
        public String contentType;
        public byte[] contents;

        private MyAttachment(String filename, String contentType, byte[] contents) {
            this.filename = filename;
            this.contentType = contentType;
            this.contents = contents;
        }

        private MyAttachment(String filename, String contentType, String contents) {
            this.filename = filename;
            this.contentType = contentType;
            this.contents = contents.getBytes();
        }
    }
}

