/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestGroupResourceFunc
extends RestFuncTest {
    private static boolean initialized;
    private GroupClient groupClient;
    private final Set<ClientResponse> responses = Sets.newHashSet();

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.environmentData = this.getEnvironmentData();
        this.groupClient = new GroupClient(this.environmentData);
        if (!initialized) {
            this.backdoor.restoreBlankInstance();
            this.createGroup("jedi");
            initialized = true;
        }
    }

    @Override
    protected void tearDownTest() {
        this.groupClient.close();
    }

    public void testGroupResourceAddAndRemoveUserHappyPath() {
        this.ensureGroupExists("jedi");
        this.addUserToGroup("jedi", "fred");
        this.ensureCantAddUserToGroup("jedi", "fred");
        this.removeUserFromGroup("jedi", "fred");
        this.ensureCantRemoveUserFromGroup("jedi", "fred");
    }

    public void testGroupResourceDeleteGroupHappyPath() {
        this.ensureGroupExists("jedi");
        this.deleteGroup("jedi");
        this.ensureNoGroup("jedi");
        this.ensureCantDeleteGroup("jedi");
    }

    private void ensureCantRemoveUserFromGroup(String group, String user) {
        ClientResponse response = this.groupClient.removeUserFromGroup(group, user);
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()));
        response.close();
    }

    private void ensureGroupExists(String group) {
        ClientResponse response = this.groupClient.getGroup(group);
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)Response.Status.OK.getStatusCode()));
        response.close();
    }

    private void ensureNoGroup(String group) {
        ClientResponse response = this.groupClient.getGroup(group);
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)Response.Status.NOT_FOUND.getStatusCode()));
        response.close();
    }

    private void createGroup(String group) {
        ClientResponse response = this.groupClient.createGroup(group);
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)Response.Status.CREATED.getStatusCode()));
        String createResult = (String)((List)response.getHeaders().get((Object)"Location")).get(0);
        String expectedUrl = this.environmentData.getBaseUrl() + "/rest/api/2/group?groupname=" + group;
        Assert.assertThat((Object)createResult, (Matcher)Matchers.startsWith((String)expectedUrl));
        response.close();
    }

    private void addUserToGroup(String group, String user) {
        ClientResponse response = this.groupClient.addUserToGroup(group, user);
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)Response.Status.CREATED.getStatusCode()));
        String createResult = (String)((List)response.getHeaders().get((Object)"Location")).get(0);
        String expectedUrl = this.environmentData.getBaseUrl() + "/rest/api/2/group?groupname=" + group;
        Assert.assertThat((Object)createResult, (Matcher)Matchers.startsWith((String)expectedUrl));
        response.close();
    }

    private void ensureCantAddUserToGroup(String group, String user) {
        ClientResponse response = this.groupClient.addUserToGroup(group, user);
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()));
        response.close();
    }

    private void deleteGroup(String group) {
        ClientResponse response = this.groupClient.deleteGroup(group);
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)Response.Status.OK.getStatusCode()));
        response.close();
    }

    private void ensureCantDeleteGroup(String group) {
        ClientResponse response = this.groupClient.deleteGroup(group);
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)Response.Status.NOT_FOUND.getStatusCode()));
        response.close();
    }

    private void removeUserFromGroup(String group, String user) {
        ClientResponse response = this.groupClient.removeUserFromGroup(group, user);
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)Response.Status.OK.getStatusCode()));
        response.close();
    }

    private class GroupClient
    extends RestApiClient<GroupClient> {
        public static final String GROUP_RESOURCE = "group";
        private static final String GROUP_ADD_USER_RESOURCE = "group/user";
        public static final String GROUP_NAME = "groupname";
        public static final String USER_NAME = "username";
        public static final String NAME = "name";

        public GroupClient(com.atlassian.jira.webtests.util.JIRAEnvironmentData environmentData) {
            super((JIRAEnvironmentData)environmentData);
        }

        public ClientResponse createGroup(String group) {
            WebResource webResource = this.createResource().path(GROUP_RESOURCE);
            ImmutableMap.Builder builder = ImmutableMap.builder();
            builder.put((Object)NAME, (Object)group);
            return this.doPost(webResource, (ImmutableMap.Builder<Object, Object>)builder);
        }

        public ClientResponse deleteGroup(String group) {
            WebResource webResource = this.createResource().path(GROUP_RESOURCE).queryParam(GROUP_NAME, group);
            ImmutableMap.Builder builder = ImmutableMap.builder();
            return this.doDelete(webResource, (ImmutableMap.Builder<Object, Object>)builder);
        }

        public ClientResponse addUserToGroup(String group, String user) {
            WebResource webResource = this.createResource().path(GROUP_ADD_USER_RESOURCE).queryParam(GROUP_NAME, group);
            ImmutableMap.Builder builder = ImmutableMap.builder();
            builder.put((Object)NAME, (Object)user);
            return this.doPost(webResource, (ImmutableMap.Builder<Object, Object>)builder);
        }

        public ClientResponse removeUserFromGroup(String group, String user) {
            WebResource webResource = this.createResource().path(GROUP_ADD_USER_RESOURCE).queryParam(GROUP_NAME, group).queryParam(USER_NAME, user);
            ImmutableMap.Builder builder = ImmutableMap.builder();
            return this.doDelete(webResource, (ImmutableMap.Builder<Object, Object>)builder);
        }

        private ClientResponse doPost(WebResource webResource, ImmutableMap.Builder<Object, Object> builder) {
            ClientResponse clientResponse = (ClientResponse)webResource.type("application/json").post(ClientResponse.class, (Object)builder.build());
            TestGroupResourceFunc.this.responses.add(clientResponse);
            return clientResponse;
        }

        private ClientResponse doDelete(WebResource webResource, ImmutableMap.Builder<Object, Object> builder) {
            ClientResponse clientResponse = (ClientResponse)webResource.type("application/json").delete(ClientResponse.class, (Object)builder.build());
            TestGroupResourceFunc.this.responses.add(clientResponse);
            return clientResponse;
        }

        public ClientResponse getGroup(String group) {
            WebResource webResource = this.createResource().path(GROUP_RESOURCE).queryParam(GROUP_NAME, group);
            ClientResponse clientResponse = (ClientResponse)webResource.get(ClientResponse.class);
            TestGroupResourceFunc.this.responses.add(clientResponse);
            return clientResponse;
        }

        private void close() {
            for (ClientResponse response : TestGroupResourceFunc.this.responses) {
                response.close();
            }
        }
    }
}

