/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.GroupPickerClient;
import com.atlassian.jira.testkit.client.restclient.GroupSuggestion;
import com.atlassian.jira.testkit.client.restclient.GroupSuggestions;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestGroupPickerResource
extends RestFuncTest {
    private GroupPickerClient groupPickerClient;

    public void testGroupSuggestionsOrder() {
        this.administration.restoreBlankInstance();
        this.administration.usersAndGroups().addGroup("jara-users");
        this.administration.usersAndGroups().addGroup("zara-users");
        ArrayList expectedSuggestions = Lists.newArrayList((Object[])new GroupSuggestion[]{new GroupSuggestion().name("jara-users").html("jara-<b>users</b>"), new GroupSuggestion().name("jira-users").html("jira-<b>users</b>"), new GroupSuggestion().name("zara-users").html("zara-<b>users</b>")});
        GroupSuggestions suggestions = this.groupPickerClient.get("users");
        TestGroupPickerResource.assertEquals((String)"Showing 3 of 3 matching groups", (String)suggestions.header);
        TestGroupPickerResource.assertEquals((Object)expectedSuggestions, (Object)suggestions.groups);
    }

    public void testGroupSuggestionsAreHtmlEncoded() {
        this.administration.restoreBlankInstance();
        this.administration.usersAndGroups().addGroup("<script>alert('wtf')</script>");
        ArrayList expectedSuggestions = Lists.newArrayList((Object[])new GroupSuggestion[]{new GroupSuggestion().name("<script>alert('wtf')</script>").html("&lt;script&gt;alert(&#39;<b>wtf</b>&#39;)&lt;/script&gt;")});
        GroupSuggestions suggestions = this.groupPickerClient.get("wtf");
        TestGroupPickerResource.assertEquals((String)"Showing 1 of 1 matching groups", (String)suggestions.header);
        TestGroupPickerResource.assertEquals((Object)expectedSuggestions, (Object)suggestions.groups);
    }

    public void testGroupSuggestionsNoQueryString() {
        this.administration.restoreBlankInstance();
        ArrayList expectedSuggestions = Lists.newArrayList((Object[])new GroupSuggestion[]{new GroupSuggestion().name("jira-administrators").html("jira-administrators"), new GroupSuggestion().name("jira-developers").html("jira-developers"), new GroupSuggestion().name("jira-users").html("jira-users")});
        GroupSuggestions suggestions = this.groupPickerClient.get(null);
        TestGroupPickerResource.assertEquals((String)"Showing 3 of 3 matching groups", (String)suggestions.header);
        TestGroupPickerResource.assertEquals((Object)expectedSuggestions, (Object)suggestions.groups);
    }

    public void testFindGroupsWithNoMatch() {
        this.administration.restoreBlankInstance();
        GroupSuggestions suggestions = this.groupPickerClient.get("lalala");
        TestGroupPickerResource.assertEquals((String)"Showing 0 of 0 matching groups", (String)suggestions.header);
        TestGroupPickerResource.assertEquals(Collections.emptyList(), (Object)suggestions.groups);
    }

    public void testFindGroupsExcessResults() {
        this.administration.restoreData("TestGroupPickerResource.xml");
        GroupSuggestions suggestions = this.groupPickerClient.get("z");
        ArrayList expectedSuggestions = Lists.newArrayList();
        for (int i = 0; i < 20; ++i) {
            String expectedName = "z" + String.format("%02d", i);
            String expectedHtml = "<b>z</b>" + String.format("%02d", i);
            expectedSuggestions.add(new GroupSuggestion().name(expectedName).html(expectedHtml));
        }
        TestGroupPickerResource.assertEquals((String)"Showing 20 of 21 matching groups", (String)suggestions.header);
        TestGroupPickerResource.assertEquals((Object)expectedSuggestions, (Object)suggestions.groups);
    }

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.groupPickerClient = new GroupPickerClient((JIRAEnvironmentData)this.getEnvironmentData());
    }

    @Override
    protected void tearDownTest() {
        super.tearDownTest();
        this.groupPickerClient = null;
    }
}

