/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.backdoor.ColumnControl;
import com.atlassian.jira.functest.framework.matchers.IterableMatchers;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Filter;
import com.atlassian.jira.testkit.client.restclient.FilterClient;
import com.atlassian.jira.testkit.client.restclient.Group;
import com.atlassian.jira.testkit.client.restclient.Project;
import com.atlassian.jira.testkit.client.restclient.ProjectRole;
import com.atlassian.jira.testkit.client.restclient.Response;
import com.atlassian.jira.testkit.client.restclient.User;
import com.atlassian.jira.testkit.client.restclient.matcher.ContainsStringThatStartsWith;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.sun.jersey.api.client.UniformInterfaceException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.hamcrest.Description;
import org.hamcrest.DiagnosingMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestFilterResource
extends RestFuncTest {
    private FilterClient filterClient;

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.filterClient = new FilterClient((JIRAEnvironmentData)this.getEnvironmentData());
        this.administration.restoreData("TestFilterResource.xml");
    }

    public void testAnonymous() {
        this.filterClient.anonymous();
        Response response = this.filterClient.getResponse("10000");
        TestFilterResource.assertEquals((int)400, (int)response.statusCode);
        TestFilterResource.assertEquals((String)"The selected filter is not available to you, perhaps it has been deleted or had its permissions changed.", (String)((String)response.entity.errorMessages.get(0)));
        Filter json = this.filterClient.get("10002", new Filter.Expand[0]);
        TestFilterResource.assertEquals((String)(this.getEnvironmentData().getBaseUrl() + "/rest/api/2/filter/10002"), (String)json.self);
        TestFilterResource.assertEquals((String)"10002", (String)json.id);
        TestFilterResource.assertEquals((String)"Public filter", (String)json.name);
        TestFilterResource.assertEquals((String)"Everyone can see this!", (String)json.description);
        TestFilterResource.assertEquals((String)"admin", (String)json.owner.name);
        TestFilterResource.assertEquals((String)"Administrator", (String)json.owner.displayName);
        TestFilterResource.assertEquals((String)(this.getEnvironmentData().getBaseUrl() + "/rest/api/2/user?username=admin"), (String)json.owner.self);
        TestFilterResource.assertEquals((String)"project = 10000 AND type = bug", (String)json.jql);
        TestFilterResource.assertEquals((String)this.getBaseUrlPlus("secure/IssueNavigator.jspa?mode=hide&requestId=10002"), (String)json.viewUrl);
        TestFilterResource.assertEquals((String)(this.getEnvironmentData().getBaseUrl() + "/rest/api/2/search?jql=project+%3D+10000+AND+type+%3D+bug"), (String)json.searchUrl);
        TestFilterResource.assertFalse((boolean)json.favourite);
    }

    public void testFilterJson() throws Exception {
        Filter json = this.filterClient.get("10000", new Filter.Expand[0]);
        TestFilterResource.assertEquals((String)(this.getEnvironmentData().getBaseUrl() + "/rest/api/2/filter/10000"), (String)json.self);
        TestFilterResource.assertEquals((String)"10000", (String)json.id);
        TestFilterResource.assertEquals((String)"My new awesome filter!", (String)json.name);
        TestFilterResource.assertEquals((String)"And here's a description", (String)json.description);
        TestFilterResource.assertEquals((String)"admin", (String)json.owner.name);
        TestFilterResource.assertEquals((String)"Administrator", (String)json.owner.displayName);
        TestFilterResource.assertEquals((String)(this.getEnvironmentData().getBaseUrl() + "/rest/api/2/user?username=admin"), (String)json.owner.self);
        TestFilterResource.assertEquals((String)"type = Bug", (String)json.jql);
        TestFilterResource.assertEquals((String)this.getBaseUrlPlus("secure/IssueNavigator.jspa?mode=hide&requestId=10000"), (String)json.viewUrl);
        TestFilterResource.assertEquals((String)this.getBaseUrlPlus("rest/api/2/search?jql=type+%3D+Bug"), (String)json.searchUrl);
        TestFilterResource.assertFalse((boolean)json.favourite);
        json = this.filterClient.get("10001", new Filter.Expand[0]);
        TestFilterResource.assertEquals((String)(this.getEnvironmentData().getBaseUrl() + "/rest/api/2/filter/10001"), (String)json.self);
        TestFilterResource.assertEquals((String)"10001", (String)json.id);
        TestFilterResource.assertEquals((String)"All Issues", (String)json.name);
        TestFilterResource.assertEquals(null, (String)json.description);
        TestFilterResource.assertEquals((String)"admin", (String)json.owner.name);
        TestFilterResource.assertEquals((String)"Administrator", (String)json.owner.displayName);
        TestFilterResource.assertEquals((String)(this.getEnvironmentData().getBaseUrl() + "/rest/api/2/user?username=admin"), (String)json.owner.self);
        TestFilterResource.assertEquals((String)"", (String)json.jql);
        TestFilterResource.assertEquals((String)this.getBaseUrlPlus("secure/IssueNavigator.jspa?mode=hide&requestId=10001"), (String)json.viewUrl);
        TestFilterResource.assertEquals((String)this.getBaseUrlPlus("rest/api/2/search?jql="), (String)json.searchUrl);
        TestFilterResource.assertTrue((boolean)json.favourite);
        this.filterClient.loginAs("bob");
        Response response = this.filterClient.getResponse("10000");
        TestFilterResource.assertEquals((int)400, (int)response.statusCode);
        TestFilterResource.assertEquals((String)"The selected filter is not available to you, perhaps it has been deleted or had its permissions changed.", (String)((String)response.entity.errorMessages.get(0)));
        json = this.filterClient.get("10002", new Filter.Expand[0]);
        TestFilterResource.assertEquals((String)(this.getEnvironmentData().getBaseUrl() + "/rest/api/2/filter/10002"), (String)json.self);
        TestFilterResource.assertEquals((String)"10002", (String)json.id);
        TestFilterResource.assertEquals((String)"Public filter", (String)json.name);
        TestFilterResource.assertEquals((String)"Everyone can see this!", (String)json.description);
        TestFilterResource.assertEquals((String)"admin", (String)json.owner.name);
        TestFilterResource.assertEquals((String)"Administrator", (String)json.owner.displayName);
        TestFilterResource.assertEquals((String)(this.getEnvironmentData().getBaseUrl() + "/rest/api/2/user?username=admin"), (String)json.owner.self);
        TestFilterResource.assertEquals((String)"project = homosapien AND type = bug", (String)json.jql);
        TestFilterResource.assertEquals((String)this.getBaseUrlPlus("secure/IssueNavigator.jspa?mode=hide&requestId=10002"), (String)json.viewUrl);
        TestFilterResource.assertEquals((String)this.getBaseUrlPlus("rest/api/2/search?jql=project+%3D+homosapien+AND+type+%3D+bug"), (String)json.searchUrl);
        TestFilterResource.assertTrue((boolean)json.favourite);
        json = this.filterClient.get("10003", new Filter.Expand[0]);
        TestFilterResource.assertEquals((String)(this.getEnvironmentData().getBaseUrl() + "/rest/api/2/filter/10003"), (String)json.self);
        TestFilterResource.assertEquals((String)"10003", (String)json.id);
        TestFilterResource.assertEquals((String)"This is bob's filter!", (String)json.name);
        TestFilterResource.assertEquals(null, (String)json.description);
        TestFilterResource.assertEquals((String)"bob", (String)json.owner.name);
        TestFilterResource.assertEquals((String)"Bob Brown", (String)json.owner.displayName);
        TestFilterResource.assertEquals((String)(this.getEnvironmentData().getBaseUrl() + "/rest/api/2/user?username=bob"), (String)json.owner.self);
        TestFilterResource.assertEquals((String)"text ~ \"some fancy text\"", (String)json.jql);
        TestFilterResource.assertEquals((String)this.getBaseUrlPlus("secure/IssueNavigator.jspa?mode=hide&requestId=10003"), (String)json.viewUrl);
        TestFilterResource.assertEquals((String)this.getBaseUrlPlus("rest/api/2/search?jql=text+~+%22some+fancy+text%22"), (String)json.searchUrl);
    }

    public void testGetFavouriteFilters() throws Exception {
        this.filterClient.anonymous();
        List filters = this.filterClient.getFavouriteFilters(new Filter.Expand[0]);
        TestFilterResource.assertTrue((boolean)filters.isEmpty());
        this.filterClient.loginAs("admin");
        List favouriteFilters = this.filterClient.getFavouriteFilters(new Filter.Expand[0]);
        TestFilterResource.assertEquals((int)3, (int)favouriteFilters.size());
        TestFilterResource.assertEquals((String)"10001", (String)((Filter)favouriteFilters.get((int)0)).id);
        TestFilterResource.assertEquals((String)"10100", (String)((Filter)favouriteFilters.get((int)1)).id);
        TestFilterResource.assertEquals((String)"10002", (String)((Filter)favouriteFilters.get((int)2)).id);
    }

    public void testCreateFilter() throws Exception {
        Filter filter1 = new Filter();
        filter1.name = "test";
        filter1.jql = "project=homosapien";
        filter1.description = "test description";
        filter1.favourite = true;
        Response response = this.filterClient.postFilterResponse(filter1, new Filter.Expand[0]);
        TestFilterResource.assertEquals((String)"test", (String)((Filter)response.body).name);
        TestFilterResource.assertEquals((String)"project = homosapien", (String)((Filter)response.body).jql);
        TestFilterResource.assertEquals((String)"test description", (String)((Filter)response.body).description);
        TestFilterResource.assertEquals((boolean)true, (boolean)((Filter)response.body).favourite);
        filter1.name = "test2";
        filter1.favourite = false;
        response = this.filterClient.postFilterResponse(filter1, new Filter.Expand[0]);
        TestFilterResource.assertEquals((int)200, (int)response.statusCode);
        TestFilterResource.assertEquals((boolean)false, (boolean)((Filter)response.body).favourite);
        filter1.name = "test3";
        filter1.jql = "a=";
        filter1.description = "test description";
        filter1.favourite = true;
        response = this.filterClient.postFilterResponse(filter1, new Filter.Expand[0]);
        TestFilterResource.assertEquals((int)400, (int)response.statusCode);
        Assert.assertThat((Object)response.entity.errorMessages, (Matcher)ContainsStringThatStartsWith.containsStringThatStartsWith((String)"Error in JQL Query:"));
        filter1.name = "test3.1";
        filter1.jql = "1234";
        filter1.description = "test description";
        filter1.favourite = true;
        response = this.filterClient.postFilterResponse(filter1, new Filter.Expand[0]);
        TestFilterResource.assertEquals((int)400, (int)response.statusCode);
        Assert.assertThat((Object)response.entity.errorMessages, (Matcher)ContainsStringThatStartsWith.containsStringThatStartsWith((String)"Error in the JQL Query:"));
        filter1.name = "test4";
        filter1.jql = "";
        response = this.filterClient.postFilterResponse(filter1, new Filter.Expand[0]);
        TestFilterResource.assertEquals((int)200, (int)response.statusCode);
        TestFilterResource.assertEquals((String)"", (String)((Filter)response.body).jql);
        filter1.jql = "project=homosapien";
        filter1.name = "";
        response = this.filterClient.postFilterResponse(filter1, new Filter.Expand[0]);
        TestFilterResource.assertEquals((int)400, (int)response.statusCode);
        TestFilterResource.assertEquals((String)"You must specify a name to save this filter as.", (String)((String)response.entity.errors.get("filterName")));
        filter1.jql = "project=";
        filter1.name = "";
        response = this.filterClient.postFilterResponse(filter1, new Filter.Expand[0]);
        TestFilterResource.assertEquals((int)400, (int)response.statusCode);
        TestFilterResource.assertEquals((int)2, (int)(response.entity.errorMessages.size() + response.entity.errors.size()));
        TestFilterResource.assertEquals((String)"You must specify a name to save this filter as.", (String)((String)response.entity.errors.get("filterName")));
        Assert.assertThat((Object)response.entity.errorMessages, (Matcher)ContainsStringThatStartsWith.containsStringThatStartsWith((String)"Error in JQL Query:"));
        filter1.jql = "project=homosapien";
        filter1.name = "ehdWvkq23yifp2xxXUd1xJcaUM9U2i4U7SUTlKQE1vHw3J8VY03sfkKjvNje6pqqHH69HlUwpO3gbJh5uujOZP00OHH06YxhX8NcTvpjWYzE2qQDa9Ji6MhoZ0kjYA1GmEd7MMAa88s9PJX01Hxtmfg5WiYeDFviROgNX1xy2WeeywetM4jKNuwJV3AFJnzxMcT0wjFi1xWknNicdq9G9qp7SUTm6b6MfOS5XU63MKWmI6RisTIOgAjnFeqEjp4SnzdB";
        response = this.filterClient.postFilterResponse(filter1, new Filter.Expand[0]);
        TestFilterResource.assertEquals((int)400, (int)response.statusCode);
        TestFilterResource.assertEquals((int)1, (int)(response.entity.errorMessages.size() + response.entity.errors.size()));
        TestFilterResource.assertEquals((String)"The entered filter name is too long, it must be less than 255 chars.", (String)((String)response.entity.errors.get("filterName")));
        filter1.jql = "project=homosapien";
        filter1.name = "test";
        response = this.filterClient.postFilterResponse(filter1, new Filter.Expand[0]);
        TestFilterResource.assertEquals((int)400, (int)response.statusCode);
        TestFilterResource.assertEquals((int)1, (int)(response.entity.errorMessages.size() + response.entity.errors.size()));
        TestFilterResource.assertEquals((String)"Filter with same name already exists.", (String)((String)response.entity.errors.get("filterName")));
        filter1.name = "test5";
        filter1.jql = "a=b";
        filter1.description = "test description";
        filter1.favourite = true;
        response = this.filterClient.postFilterResponse(filter1, new Filter.Expand[0]);
        TestFilterResource.assertEquals((int)400, (int)response.statusCode);
        TestFilterResource.assertEquals((int)1, (int)(response.entity.errorMessages.size() + response.entity.errors.size()));
        TestFilterResource.assertEquals((String)"Field 'a' does not exist or you do not have permission to view it.", (String)((String)response.entity.errorMessages.get(0)));
        this.filterClient.anonymous();
        response = this.filterClient.postFilterResponse(filter1, new Filter.Expand[0]);
        TestFilterResource.assertEquals((int)401, (int)response.statusCode);
        TestFilterResource.assertEquals((String)"No user currently logged in.", (String)((String)response.entity.errorMessages.get(0)));
        this.filterClient.loginAs("admin");
        filter1 = new Filter();
        filter1.name = "test6";
        filter1.jql = "project=homosapien";
        filter1.description = "test description";
        filter1.favourite = true;
        String newFilterId = ((Filter)this.filterClient.postFilterResponse((Filter)filter1, (Filter.Expand[])new Filter.Expand[0]).body).id;
        this.filterClient.loginAs("fred");
        response = this.filterClient.getResponse(newFilterId);
        TestFilterResource.assertEquals((int)400, (int)response.statusCode);
        Assert.assertThat((Object)response.entity.errorMessages, (Matcher)ContainsStringThatStartsWith.containsStringThatStartsWith((String)"The selected filter is not available to you"));
    }

    public void testCopyFilter() {
        this.filterClient.loginAs("admin");
        Filter filter = new Filter();
        filter.id = "10100";
        filter.name = "blah clone";
        filter.description = "blah description";
        Response response = this.filterClient.postFilterResponse(filter, new Filter.Expand[0]);
        TestFilterResource.assertEquals((String)"", (String)((Filter)response.body).jql);
        TestFilterResource.assertEquals((String)"blah clone", (String)((Filter)response.body).name);
        TestFilterResource.assertEquals((String)"blah description", (String)((Filter)response.body).description);
        TestFilterResource.assertEquals((String)"Expected the filters column config to also be copied", (Object)Lists.newArrayList((Object[])new String[]{"issuetype", "issuekey", "assignee", "reporter", "priority", "status", "resolution", "created", "updated", "duedate"}), this.backdoor.filters().getColumnsForFilter(((Filter)response.body).id));
        this.filterClient.loginAs("admin");
        filter = new Filter();
        filter.id = "10100";
        filter.name = "only clone columns";
        filter.jql = "project in (HSP, MKY)";
        response = this.filterClient.postFilterResponse(filter, new Filter.Expand[0]);
        TestFilterResource.assertEquals((String)"only clone columns", (String)((Filter)response.body).name);
        TestFilterResource.assertEquals((String)"project in (HSP, MKY)", (String)((Filter)response.body).jql);
        TestFilterResource.assertEquals((String)"Expected the filters column config to also be copied", (Object)Lists.newArrayList((Object[])new String[]{"issuetype", "issuekey", "assignee", "reporter", "priority", "status", "resolution", "created", "updated", "duedate"}), this.backdoor.filters().getColumnsForFilter(((Filter)response.body).id));
        filter = new Filter();
        filter.id = "10002";
        filter.name = "public filter clone";
        response = this.filterClient.postFilterResponse(filter, new Filter.Expand[0]);
        TestFilterResource.assertEquals((String)"project = homosapien AND type = bug", (String)((Filter)response.body).jql);
        TestFilterResource.assertTrue((String)"Expected a different id as we cloned the filter", (!((Filter)response.body).id.equals(filter.id) ? 1 : 0) != 0);
        TestFilterResource.assertEquals((String)"public filter clone", (String)((Filter)response.body).name);
        String privateFilterId = ((Filter)response.body).id;
        TestFilterResource.assertEquals((String)"Expected the user column config", (Object)Lists.newArrayList((Object[])new String[]{"issuetype", "issuekey", "summary", "assignee", "reporter", "priority", "status", "resolution", "created", "updated", "duedate"}), this.backdoor.filters().getColumnsForFilter(privateFilterId));
        filter = new Filter();
        filter.id = "1001322";
        filter.name = "public filter clone";
        response = this.filterClient.postFilterResponse(filter, new Filter.Expand[0]);
        TestFilterResource.assertEquals((String)"Invalid filter id should not throw server error", (int)response.statusCode, (int)400);
        Assert.assertThat((Object)response.entity.errorMessages, (Matcher)ContainsStringThatStartsWith.containsStringThatStartsWith((String)"The selected filter is not available to you"));
        this.filterClient.loginAs("fred");
        filter = new Filter();
        filter.id = privateFilterId;
        filter.name = "public filter clone";
        response = this.filterClient.postFilterResponse(filter, new Filter.Expand[0]);
        TestFilterResource.assertEquals((String)"Private filter id should not throw server error", (int)response.statusCode, (int)400);
        Assert.assertThat((Object)response.entity.errorMessages, (Matcher)ContainsStringThatStartsWith.containsStringThatStartsWith((String)"The selected filter is not available to you"));
    }

    public void testUpdateFilter() {
        String filterId = "10000";
        Filter filter = this.filterClient.get(filterId, new Filter.Expand[0]);
        filter.name = "New Filter Name";
        filter.description = "New Filter Description";
        filter.jql = "project = MKY";
        Response putResponse = this.filterClient.putFilterResponse(filter, new Filter.Expand[0]);
        TestFilterResource.assertNotNull((Object)putResponse);
        TestFilterResource.assertEquals((int)200, (int)putResponse.statusCode);
        this.assertFilterEqual(filter, (Filter)putResponse.body);
        filter.name = "new name";
        filter.jql = null;
        filter.description = null;
        putResponse = this.filterClient.putFilterResponse(filter, new Filter.Expand[0]);
        TestFilterResource.assertNotNull((Object)putResponse);
        TestFilterResource.assertEquals((int)200, (int)putResponse.statusCode);
        filter.description = "New Filter Description";
        filter.jql = "project = MKY";
        this.assertFilterEqual(filter, (Filter)putResponse.body);
        filter.name = null;
        filter.jql = null;
        filter.description = "new description";
        putResponse = this.filterClient.putFilterResponse(filter, new Filter.Expand[0]);
        TestFilterResource.assertNotNull((Object)putResponse);
        TestFilterResource.assertEquals((int)200, (int)putResponse.statusCode);
        filter.jql = "project = MKY";
        filter.name = "new name";
        this.assertFilterEqual(filter, (Filter)putResponse.body);
        filter.name = null;
        filter.jql = "project = HSP";
        filter.description = null;
        putResponse = this.filterClient.putFilterResponse(filter, new Filter.Expand[0]);
        TestFilterResource.assertNotNull((Object)putResponse);
        TestFilterResource.assertEquals((int)200, (int)putResponse.statusCode);
        filter.name = "new name";
        filter.description = "new description";
        this.assertFilterEqual(filter, (Filter)putResponse.body);
        filter.name = "New Filter Name";
        filter.description = "New Filter Description";
        filter.jql = "invalid JQL";
        putResponse = this.filterClient.putFilterResponse(filter, new Filter.Expand[0]);
        TestFilterResource.assertNotNull((Object)putResponse);
        TestFilterResource.assertEquals((int)400, (int)putResponse.statusCode);
        Assert.assertThat((Object)putResponse.entity.errorMessages, (Matcher)ContainsStringThatStartsWith.containsStringThatStartsWith((String)"Error in the JQL Query: Expecting operator but got"));
        filter.jql = "";
        putResponse = this.filterClient.putFilterResponse(filter, new Filter.Expand[0]);
        TestFilterResource.assertNotNull((Object)putResponse);
        TestFilterResource.assertEquals((int)200, (int)putResponse.statusCode);
        this.assertFilterEqual(filter, (Filter)putResponse.body);
        filter.name = "";
        putResponse = this.filterClient.putFilterResponse(filter, new Filter.Expand[0]);
        TestFilterResource.assertEquals((int)400, (int)putResponse.statusCode);
        TestFilterResource.assertEquals((String)"You must specify a name to save this filter as.", (String)((String)putResponse.entity.errors.get("filterName")));
        filter.jql = "project=homosapien";
        filter.name = "ehdWvkq23yifp2xxXUd1xJcaUM9U2i4U7SUTlKQE1vHw3J8VY03sfkKjvNje6pqqHH69HlUwpO3gbJh5uujOZP00OHH06YxhX8NcTvpjWYzE2qQDa9Ji6MhoZ0kjYA1GmEd7MMAa88s9PJX01Hxtmfg5WiYeDFviROgNX1xy2WeeywetM4jKNuwJV3AFJnzxMcT0wjFi1xWknNicdq9G9qp7SUTm6b6MfOS5XU63MKWmI6RisTIOgAjnFeqEjp4SnzdB";
        putResponse = this.filterClient.putFilterResponse(filter, new Filter.Expand[0]);
        TestFilterResource.assertEquals((int)400, (int)putResponse.statusCode);
        TestFilterResource.assertEquals((int)1, (int)(putResponse.entity.errorMessages.size() + putResponse.entity.errors.size()));
        TestFilterResource.assertEquals((String)"The entered filter name is too long, it must be less than 255 chars.", (String)((String)putResponse.entity.errors.get("filterName")));
        filter.jql = "project=homosapien";
        filter.name = "All Issues";
        putResponse = this.filterClient.putFilterResponse(filter, new Filter.Expand[0]);
        TestFilterResource.assertEquals((int)400, (int)putResponse.statusCode);
        TestFilterResource.assertEquals((int)1, (int)(putResponse.entity.errorMessages.size() + putResponse.entity.errors.size()));
        TestFilterResource.assertEquals((String)"Filter with same name already exists.", (String)((String)putResponse.entity.errors.get("filterName")));
        filter.name = "test5";
        filter.jql = "a=b";
        filter.description = "test description";
        filter.favourite = true;
        putResponse = this.filterClient.putFilterResponse(filter, new Filter.Expand[0]);
        TestFilterResource.assertEquals((int)400, (int)putResponse.statusCode);
        TestFilterResource.assertEquals((int)1, (int)(putResponse.entity.errorMessages.size() + putResponse.entity.errors.size()));
        TestFilterResource.assertEquals((String)"Field 'a' does not exist or you do not have permission to view it.", (String)((String)putResponse.entity.errorMessages.get(0)));
        this.filterClient.anonymous();
        filter.jql = "asd";
        filter.name = "";
        putResponse = this.filterClient.putFilterResponse(filter, new Filter.Expand[0]);
        TestFilterResource.assertEquals((int)401, (int)putResponse.statusCode);
        TestFilterResource.assertEquals((String)"No user currently logged in.", (String)((String)putResponse.entity.errorMessages.get(0)));
        this.filterClient.loginAs("admin");
        filter.name = "test6";
        filter.jql = "project=homosapien";
        filter.description = "test description";
        filter.favourite = true;
        String newFilterId = ((Filter)this.filterClient.putFilterResponse((Filter)filter, (Filter.Expand[])new Filter.Expand[0]).body).id;
        this.filterClient.loginAs("fred");
        putResponse = this.filterClient.getResponse(newFilterId);
        TestFilterResource.assertEquals((int)400, (int)putResponse.statusCode);
        Assert.assertThat((Object)putResponse.entity.errorMessages, (Matcher)ContainsStringThatStartsWith.containsStringThatStartsWith((String)"The selected filter is not available to you"));
        this.filterClient.loginAs("admin");
        filter.id = "bad";
        filter.jql = "asd";
        filter.name = "";
        putResponse = this.filterClient.putFilterResponse(filter, new Filter.Expand[0]);
        TestFilterResource.assertEquals((int)404, (int)putResponse.statusCode);
    }

    public void testSharePermissions() {
        this.runSinglePermission(this.backdoor.searchRequests().createFilter("admin", "assignee=currentUser()", "globes", "", "[{\"type\":\"global\"}]"), new Filter.FilterPermission().type("global"));
        this.runSinglePermission(this.backdoor.searchRequests().createFilter("admin", "assignee=currentUser()", "projes", "", "[{\"type\":\"project\", \"param1\":\"10000\"}]"), new Filter.FilterPermission().type("project").project(new Project().id("10000")));
        this.runSinglePermission(this.backdoor.searchRequests().createFilter("admin", "assignee=currentUser()", "projes roles", "", "[{\"type\":\"project\", \"param1\":\"10000\", \"param2\":\"10000\"}]"), new Filter.FilterPermission().type("project").project(new Project().id("10000")).role(new ProjectRole().id(Long.valueOf(10000L))));
        this.runSinglePermission(this.backdoor.searchRequests().createFilter("admin", "assignee=currentUser()", "projes roles", "", "[{\"type\":\"group\", \"param1\":\"jira-administrators\"}]"), new Filter.FilterPermission().type("group").group(new Group("jira-administrators")));
        this.runMultiplePermission(this.backdoor.searchRequests().createFilter("admin", "assignee=currentUser()", "multiman", "", "[{\"type\":\"project\", \"param1\":\"10000\", \"param2\":\"10000\"}, {\"type\":\"group\", \"param1\":\"jira-administrators\"}]"), new Filter.FilterPermission().type("group").group(new Group("jira-administrators")), new Filter.FilterPermission().type("project").project(new Project().id("10000")).role(new ProjectRole().id(Long.valueOf(10000L))));
        String filterId = this.backdoor.searchRequests().createFilter("admin", "assignee=currentUser()", "multi-openproject", "", "[{\"type\":\"project\", \"param1\":\"10000\"}, {\"type\":\"group\", \"param1\":\"jira-users\"}]");
        this.filterClient.loginAs("fred");
        this.runSinglePermission(filterId, new Filter.FilterPermission().type("group").group(new Group("jira-users")));
        this.filterClient.loginAs("admin");
        this.runMultiplePermission(filterId, new Filter.FilterPermission().type("group").group(new Group("jira-users")), new Filter.FilterPermission().type("project").project(new Project().id("10000")));
    }

    public void testFilterSubscriptions() {
        this.filterClient.loginAs("admin");
        String filterId = this.backdoor.searchRequests().createFilter("admin", "assignee=currentUser()", "filter with subs", "", "[{\"type\":\"project\", \"param1\":\"10000\", \"param2\":\"10000\"}, {\"type\":\"group\", \"param1\":\"jira-administrators\"}]");
        this.backdoor.filterSubscriptions().addSubscription(Long.valueOf(filterId), "jira-administrators", "0 0 0 ? 1 MON#3", false);
        Filter filter = this.filterClient.get(filterId, new Filter.Expand[]{Filter.Expand.subscriptions});
        TestFilterResource.assertEquals((long)1L, (long)filter.subscriptions.size);
        TestFilterResource.assertEquals((String)"admin", (String)((Filter.FilterSubscription)filter.subscriptions.items.get((int)0)).user.name);
        TestFilterResource.assertEquals((String)"jira-administrators", (String)((Filter.FilterSubscription)filter.subscriptions.items.get((int)0)).group.name());
        this.backdoor.filterSubscriptions().addSubscription(Long.valueOf(filterId), null, "0 0 0 ? 1 MON#3", false);
        filter = this.filterClient.get(filterId, new Filter.Expand[]{Filter.Expand.subscriptions});
        TestFilterResource.assertEquals((long)2L, (long)filter.subscriptions.size);
        TestFilterResource.assertEquals((String)"admin", (String)((Filter.FilterSubscription)filter.subscriptions.items.get((int)1)).user.name);
        TestFilterResource.assertNull((Object)((Filter.FilterSubscription)filter.subscriptions.items.get((int)1)).group);
    }

    public void testSharedUsersWithGroup() throws Exception {
        String filterId = this.backdoor.searchRequests().createFilter("admin", "assignee=currentUser()", "shared with group", "", "[{\"type\":\"group\", \"param1\":\"jira-administrators\"}]");
        Matcher<Iterable<String>> matcher = IterableMatchers.hasItems(String.class, "admin");
        this.assertSharedUsers(filterId, matcher);
    }

    public void testSharedUsersGlobal() throws Exception {
        String filterId = this.backdoor.searchRequests().createFilter("admin", "assignee=currentUser()", "shared with global", "", "[{\"type\":\"global\"}]");
        Matcher<Iterable<String>> matcher = IterableMatchers.hasItems(String.class, "admin", "bob", "fred");
        this.assertSharedUsers(filterId, matcher);
    }

    public void testSharedUsersWithRole() throws Exception {
        String filterId = this.backdoor.searchRequests().createFilter("admin", "assignee=currentUser()", "shared with role", "", "[{\"type\":\"project\", \"param1\":\"10000\", \"param2\":\"10000\"}]");
        Matcher<Iterable<String>> matcher = IterableMatchers.hasItems(String.class, "admin", "bob", "fred");
        this.assertSharedUsers(filterId, matcher);
    }

    public void testSharedUsersWithProject() throws Exception {
        String filterId = this.backdoor.searchRequests().createFilter("admin", "assignee=currentUser()", "shared with project", "", "[{\"type\":\"project\", \"param1\":\"10000\"}]");
        Matcher<Iterable<String>> matcher = IterableMatchers.hasItems(String.class, "admin", "bob");
        this.assertSharedUsers(filterId, matcher);
    }

    public void testGetAndSetColumns() {
        String filterId = this.backdoor.filters().createFilter("", "myfilter");
        String message = null;
        try {
            this.backdoor.columnControl().getFilterColumns(filterId);
        }
        catch (UniformInterfaceException e) {
            message = e.getMessage();
        }
        TestFilterResource.assertEquals((String)"Client response status: 404", (String)message);
        ArrayList defaultColumns = Lists.newArrayList((Object[])new String[]{"issuetype", "issuekey", "summary", "assignee", "reporter"});
        TestFilterResource.assertTrue((String)"No errors when setting columns to filter", (boolean)this.backdoor.columnControl().setFilterColumns(filterId, defaultColumns));
        List<ColumnControl.ColumnItem> filterColumns = this.backdoor.columnControl().getFilterColumns(filterId);
        for (int i = 0; i < filterColumns.size(); ++i) {
            TestFilterResource.assertEquals((String)((String)defaultColumns.get(0)), (String)filterColumns.get((int)0).value);
        }
        TestFilterResource.assertEquals((int)defaultColumns.size(), (int)filterColumns.size());
        TestFilterResource.assertTrue((String)"No errors when removing all columns of filter", (boolean)this.backdoor.columnControl().setFilterColumns(filterId, Lists.newArrayList()));
        TestFilterResource.assertEquals((int)0, (int)this.backdoor.columnControl().getFilterColumns(filterId).size());
    }

    private void assertSharedUsers(String filterId, Matcher<Iterable<String>> matcher) {
        TestFilterResource.assertEquals((int)0, (int)this.filterClient.get((String)filterId, (Filter.Expand[])new Filter.Expand[0]).sharedUsers.items.size());
        List sharedUsers = this.filterClient.get((String)filterId, (Filter.Expand[])new Filter.Expand[]{Filter.Expand.sharedUsers}).sharedUsers.items;
        Collection sharedUserNames = Collections2.transform((Collection)sharedUsers, (Function)new Function<User, String>(){

            public String apply(@Nullable User user) {
                assert (user != null);
                return user.name;
            }
        });
        Assert.assertThat((Object)sharedUserNames, matcher);
    }

    public void testDefaultShareScope() {
        this.backdoor.permissions().addGlobalPermission(22, "jira-users");
        this.filterClient.loginAs("fred");
        Map result = this.filterClient.getDefaultShareScope();
        TestFilterResource.assertEquals((String)"PRIVATE", (String)((String)result.get("scope")));
        LinkedHashMap<String, String> scope = new LinkedHashMap<String, String>();
        scope.put("scope", "GLOBAL");
        result = this.filterClient.setDefaultShareScope(scope);
        TestFilterResource.assertEquals((String)"GLOBAL", (String)((String)result.get("scope")));
        result = this.filterClient.getDefaultShareScope();
        TestFilterResource.assertEquals((String)"GLOBAL", (String)((String)result.get("scope")));
        this.backdoor.permissions().removeGlobalPermission(22, "jira-users");
        result = this.filterClient.getDefaultShareScope();
        TestFilterResource.assertEquals((String)"PRIVATE", (String)((String)result.get("scope")));
    }

    private void runSinglePermission(String filterId, Filter.FilterPermission expected) {
        Filter filter = this.filterClient.get(filterId, new Filter.Expand[0]);
        Assert.assertThat(filter.sharePermissions.get(0), TestFilterResource.matchesFilterPermission(expected));
    }

    private void runMultiplePermission(String filterId, Filter.FilterPermission ... expected) {
        Filter filter = this.filterClient.get(filterId, new Filter.Expand[0]);
        TestFilterResource.assertEquals((int)expected.length, (int)filter.sharePermissions.size());
        List<Filter.FilterPermission> expectedFilterPermissions = Arrays.asList(expected);
        for (Filter.FilterPermission expectedFilterPermission : expectedFilterPermissions) {
            Assert.assertThat((Object)filter.sharePermissions, (Matcher)Matchers.hasItem(TestFilterResource.matchesFilterPermission(expectedFilterPermission)));
        }
    }

    public static Matcher<Filter.FilterPermission> matchesFilterPermission(final Filter.FilterPermission expected) {
        return new DiagnosingMatcher<Filter.FilterPermission>(){
            protected Filter.FilterPermission theExpected;
            {
                this.theExpected = expected;
            }

            public boolean matches(Object actualObj, Description mismatch) {
                Filter.FilterPermission actual = (Filter.FilterPermission)actualObj;
                if (!expected.type.equals(actual.type)) {
                    return false;
                }
                if (null == expected.project) {
                    if (actual.project != null) {
                        return false;
                    }
                } else {
                    if (actual.project == null) {
                        return false;
                    }
                    if (!actual.project.id.equals(expected.project.id)) {
                        return false;
                    }
                }
                if (null == expected.role) {
                    if (actual.role != null) {
                        return false;
                    }
                } else {
                    if (actual.role == null) {
                        return false;
                    }
                    if (actual.role.id.longValue() != expected.role.id.longValue()) {
                        return false;
                    }
                }
                if (null == expected.group) {
                    if (actual.group != null) {
                        return false;
                    }
                } else {
                    if (actual.group == null) {
                        return false;
                    }
                    if (!actual.group.name().equals(expected.group.name())) {
                        return false;
                    }
                }
                return true;
            }

            public void describeTo(Description description) {
                description.appendText("Id=").appendValue((Object)expected.id);
                description.appendText(", Type=").appendText(expected.type);
                if (expected.project != null) {
                    description.appendText(", Project=").appendText(expected.project.id);
                } else {
                    description.appendText(", Project=null");
                }
                if (expected.role != null) {
                    description.appendText(", Role=").appendValue((Object)expected.role.id);
                } else {
                    description.appendText(", Role=null");
                }
                if (expected.group != null) {
                    description.appendText(", Group=").appendValue((Object)expected.group.name());
                } else {
                    description.appendText(", Group=null");
                }
            }
        };
    }

    private void assertFilterEqual(Filter expectedFilter, Filter actualFilter) {
        TestFilterResource.assertNotNull((Object)actualFilter.id);
        TestFilterResource.assertNotNull((Object)actualFilter.self);
        TestFilterResource.assertEquals((String)expectedFilter.name, (String)actualFilter.name);
        TestFilterResource.assertEquals((String)expectedFilter.description, (String)actualFilter.description);
        TestFilterResource.assertEquals((String)expectedFilter.jql, (String)actualFilter.jql);
    }
}

