/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Field;
import com.atlassian.jira.testkit.client.restclient.FieldClient;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import java.util.Arrays;
import java.util.List;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestFieldResource
extends RestFuncTest {
    private static final String[] UNSEARCHABLE = new String[]{"Key", "Votes", "Watchers", "Images"};
    private static final String[] UNNAVIGABLE = new String[]{"Comment", "Attachment"};
    private static final String[] UNORDERABLE = new String[]{"Key", "Votes", "Resolved", "Updated", "Created", "Status", "Work Ratio", "Project", "Images", "Watchers"};
    private FieldClient fieldClient;

    public void testAllFields() throws Exception {
        List fields = this.fieldClient.get();
        TestFieldResource.assertTrue((fields.size() > 40 ? 1 : 0) != 0);
        this.assertFieldsContain(fields, "Affects Version/s", false);
        this.assertFieldsContain(fields, "Assignee", false);
        this.assertFieldsContain(fields, "Attachment", false);
        this.assertFieldsContain(fields, "Comment", false);
        this.assertFieldsContain(fields, "Component/s", false);
        this.assertFieldsContain(fields, "Created", false);
        this.assertFieldsContain(fields, "CSF", true);
        this.assertFieldsContain(fields, "Description", false);
        this.assertFieldsContain(fields, "DP", true);
        this.assertFieldsContain(fields, "DT", true);
        this.assertFieldsContain(fields, "Due Date", false);
        this.assertFieldsContain(fields, "Environment", false);
        this.assertFieldsContain(fields, "Fix Version/s", false);
        this.assertFieldsContain(fields, "FTF", true);
        this.assertFieldsContain(fields, "GP", true);
        this.assertFieldsContain(fields, "II", true);
        this.assertFieldsContain(fields, "Images", false);
        this.assertFieldsContain(fields, "Issue Type", false);
        this.assertFieldsContain(fields, "Key", false);
        this.assertFieldsContain(fields, "Labels", false);
        this.assertFieldsContain(fields, "Linked Issues", false);
        this.assertFieldsContain(fields, "MC", true);
        this.assertFieldsContain(fields, "MGP", true);
        this.assertFieldsContain(fields, "MS", true);
        this.assertFieldsContain(fields, "MUP", true);
        this.assertFieldsContain(fields, "NF", true);
        this.assertFieldsContain(fields, "PP", true);
        this.assertFieldsContain(fields, "Priority", false);
        this.assertFieldsContain(fields, "Project", false);
        this.assertFieldsContain(fields, "RB", true);
        this.assertFieldsContain(fields, "Reporter", false);
        this.assertFieldsContain(fields, "Resolution", false);
        this.assertFieldsContain(fields, "Resolved", false);
        this.assertFieldsContain(fields, "ROTF", true);
        this.assertFieldsContain(fields, "Security Level", false);
        this.assertFieldsContain(fields, "SL", true);
        this.assertFieldsContain(fields, "Status", false);
        this.assertFieldsContain(fields, "Summary", false);
        this.assertFieldsContain(fields, "SVP", true);
        this.assertFieldsContain(fields, "TF", true);
        this.assertFieldsContain(fields, "Updated", false);
        this.assertFieldsContain(fields, "UP", true);
        this.assertFieldsContain(fields, "URL", true);
        this.assertFieldsContain(fields, "Votes", false);
        this.assertFieldsContain(fields, "VP", true);
        this.assertFieldsContain(fields, "Watchers", false);
        this.assertFieldsContain(fields, "Work Ratio", false);
    }

    public void testAvailableFields() throws Exception {
        List fields = ((FieldClient)this.fieldClient.loginAs("admin", "admin")).get();
        this.assertFieldsContain(fields, "Salary", true);
        fields = ((FieldClient)this.fieldClient.loginAs("fred", "fred")).get();
        for (Field field : fields) {
            if (!field.name().equals("Salary")) continue;
            TestFieldResource.fail((String)"Field 'Salary' should be hidden from user Fred");
        }
    }

    private void assertFieldsContain(List<Field> fields, String name, boolean custom) {
        for (Field field : fields) {
            if (!field.name().equals(name)) continue;
            TestFieldResource.assertEquals((boolean)custom, (boolean)field.custom());
            TestFieldResource.assertEquals((String)(field.name() + " orderability"), (!Arrays.asList(UNORDERABLE).contains(field.name()) ? 1 : 0) != 0, (boolean)field.orderable());
            TestFieldResource.assertEquals((String)(field.name() + " navigability"), (!Arrays.asList(UNNAVIGABLE).contains(field.name()) ? 1 : 0) != 0, (boolean)field.navigable());
            TestFieldResource.assertEquals((String)(field.name() + " searchability"), (!Arrays.asList(UNSEARCHABLE).contains(field.name()) ? 1 : 0) != 0, (boolean)field.searchable());
            return;
        }
        TestFieldResource.fail((String)("Field " + name + " not in list"));
    }

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.fieldClient = new FieldClient((JIRAEnvironmentData)this.getEnvironmentData());
        this.administration.restoreData("TestFieldResource.xml");
    }
}

