/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.matcher.URIMatcher;
import com.atlassian.jira.rest.api.dashboard.DashboardBean;
import com.atlassian.jira.rest.api.dashboard.DashboardsBean;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.DashboardClient;
import com.atlassian.jira.testkit.client.restclient.Response;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import java.net.URI;
import java.util.Collections;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

@WebTest(value={Category.FUNC_TEST, Category.DASHBOARDS})
public class TestDashboardResource
extends RestFuncTest {
    private static final int PAGE_SIZE = 2;
    private DashboardClient dashboardClient;

    public void testDashboardResourceShouldAllowGettingFavouriteDashboards() throws Exception {
        Response badFilterResponse = this.dashboardClient.getListResponse("zzz", Integer.valueOf(0), Integer.valueOf(-1));
        Assert.assertThat((Object)badFilterResponse.statusCode, (Matcher)CoreMatchers.equalTo((Object)400));
        Assert.assertThat((Object)badFilterResponse.entity.errorMessages, (Matcher)Matchers.hasItem((Object)"Bad value 'zzz' for query parameter 'filter'. Valid values are: 'favourite', 'my'"));
        Object[] favouriteDashboards = new DashboardBean[]{this.createDashboardBean("10011", "Private Dashboard owned by admin"), this.createDashboardBean("10010", "Shared Dashboard with group jira-administrators owned by admin"), this.createDashboardBean("10019", "Shared Dashboard with role Users on homosapien owned by fred")};
        DashboardsBean noResultsBean = this.dashboardClient.getList("favourite", Integer.valueOf(0), Integer.valueOf(0));
        Assert.assertThat((String)"clients should be able to pass maxResults=0 to get dashboard count and no results", (Object)noResultsBean.total(), (Matcher)CoreMatchers.equalTo((Object)favouriteDashboards.length));
        Assert.assertThat((String)"clients should be able to pass maxResults=0 to get dashboard count and no results", (Object)noResultsBean.dashboards().size(), (Matcher)CoreMatchers.equalTo((Object)0));
        DashboardsBean favourites = this.dashboardClient.getList("favourite", Integer.valueOf(0), Integer.valueOf(-1));
        Assert.assertThat((Object)favourites.startAt(), (Matcher)CoreMatchers.equalTo((Object)0));
        Assert.assertThat((Object)favourites.total(), (Matcher)CoreMatchers.equalTo((Object)favouriteDashboards.length));
        Assert.assertThat((String)"clients should be able to pass ?filter=favourite to get only favourite dashboards", (Object)favourites.dashboards(), (Matcher)Matchers.hasItems((Object[])favouriteDashboards));
        Assert.assertThat((Object)favourites.dashboards().size(), (Matcher)CoreMatchers.equalTo((Object)favouriteDashboards.length));
        DashboardsBean page0 = this.dashboardClient.getList("favourite", Integer.valueOf(0), Integer.valueOf(2));
        Assert.assertThat((String)"page 0 should have 2 results", (Object)page0.dashboards().size(), (Matcher)CoreMatchers.equalTo((Object)2));
        Assert.assertThat((Object)page0.prev(), (Matcher)CoreMatchers.equalTo(null));
        Assert.assertThat((Object)URI.create(page0.next()), (Matcher)URIMatcher.isSameURI(this.getRestApiUri("/dashboard?startAt=2&filter=favourite&maxResults=2")));
        DashboardsBean page1 = this.dashboardClient.getList("favourite", Integer.valueOf(2), Integer.valueOf(2));
        Assert.assertThat((String)"page 1 should have 1 results", (Object)page1.dashboards().size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)URI.create(page1.prev()), (Matcher)URIMatcher.isSameURI(this.getRestApiUri("/dashboard?startAt=0&filter=favourite&maxResults=2")));
        Assert.assertThat((Object)page1.next(), (Matcher)CoreMatchers.equalTo(null));
        Assert.assertThat((String)"page 2 should have 0 results", (Object)this.dashboardClient.getList("favourite", Integer.valueOf(4), Integer.valueOf(2)).dashboards().size(), (Matcher)CoreMatchers.equalTo((Object)0));
        DashboardsBean anonymousFavourites = ((DashboardClient)this.dashboardClient.anonymous()).getList("favourite", Integer.valueOf(0), Integer.valueOf(-1));
        Assert.assertThat((Object)anonymousFavourites.total(), (Matcher)CoreMatchers.equalTo((Object)0));
        Assert.assertThat((Object)anonymousFavourites.dashboards(), (Matcher)CoreMatchers.equalTo(Collections.emptyList()));
    }

    public void testDashboardResourceShouldAllowGettingAllDashboards() throws Exception {
        Object[] allDashboards = new DashboardBean[]{this.createDashboardBean("10011", "Private Dashboard owned by admin"), this.createDashboardBean("10013", "Shared Dashboard with all roles on Monkey owned by developer"), this.createDashboardBean("10014", "Shared Dashboard with Anyone owned by developer"), this.createDashboardBean("10010", "Shared Dashboard with group jira-administrators owned by admin"), this.createDashboardBean("10018", "Shared Dashboard with group jira-users owned by fred"), this.createDashboardBean("10019", "Shared Dashboard with role Users on homosapien owned by fred"), this.createDashboardBean("10000", "System Dashboard")};
        DashboardsBean noResultsBean = this.dashboardClient.getList("", Integer.valueOf(0), Integer.valueOf(0));
        Assert.assertThat((Object)noResultsBean.total(), (Matcher)CoreMatchers.equalTo((Object)allDashboards.length));
        Assert.assertThat((Object)noResultsBean.dashboards().size(), (Matcher)CoreMatchers.equalTo((Object)0));
        DashboardsBean all = this.dashboardClient.getList(null, Integer.valueOf(0), Integer.valueOf(-1));
        Assert.assertThat((Object)all.startAt(), (Matcher)CoreMatchers.equalTo((Object)0));
        Assert.assertThat((Object)all.total(), (Matcher)CoreMatchers.equalTo((Object)allDashboards.length));
        Assert.assertThat((Object)all.dashboards(), (Matcher)Matchers.hasItems((Object[])allDashboards));
        Assert.assertThat((Object)all.dashboards().size(), (Matcher)CoreMatchers.equalTo((Object)allDashboards.length));
        Assert.assertThat((String)"page 0 should have 2 results", (Object)this.dashboardClient.getList("", Integer.valueOf(0), Integer.valueOf(2)).dashboards().size(), (Matcher)CoreMatchers.equalTo((Object)2));
        Assert.assertThat((String)"page 1 should have 2 results", (Object)this.dashboardClient.getList("", Integer.valueOf(2), Integer.valueOf(2)).dashboards().size(), (Matcher)CoreMatchers.equalTo((Object)2));
        Assert.assertThat((String)"page 2 should have 2 results", (Object)this.dashboardClient.getList("", Integer.valueOf(4), Integer.valueOf(2)).dashboards().size(), (Matcher)CoreMatchers.equalTo((Object)2));
        Assert.assertThat((String)"page 3 should have 1 results", (Object)this.dashboardClient.getList("", Integer.valueOf(6), Integer.valueOf(2)).dashboards().size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((String)"page 4 should have 0 results", (Object)this.dashboardClient.getList("", Integer.valueOf(8), Integer.valueOf(2)).dashboards().size(), (Matcher)CoreMatchers.equalTo((Object)0));
        DashboardsBean anonymousMy = ((DashboardClient)this.dashboardClient.anonymous()).getList("", Integer.valueOf(0), Integer.valueOf(-1));
        Assert.assertThat((Object)anonymousMy.total(), (Matcher)CoreMatchers.equalTo((Object)2));
    }

    public void testDashboardResourceShouldAllowGettingMyDashboards() throws Exception {
        Object[] myDashboards = new DashboardBean[]{this.createDashboardBean("10011", "Private Dashboard owned by admin"), this.createDashboardBean("10010", "Shared Dashboard with group jira-administrators owned by admin")};
        DashboardsBean noResultsBean = this.dashboardClient.getList("my", Integer.valueOf(0), Integer.valueOf(0));
        Assert.assertThat((Object)noResultsBean.total(), (Matcher)CoreMatchers.equalTo((Object)myDashboards.length));
        Assert.assertThat((Object)noResultsBean.dashboards().size(), (Matcher)CoreMatchers.equalTo((Object)0));
        DashboardsBean my = this.dashboardClient.getList("my", Integer.valueOf(0), Integer.valueOf(-1));
        Assert.assertThat((Object)my.startAt(), (Matcher)CoreMatchers.equalTo((Object)0));
        Assert.assertThat((Object)my.total(), (Matcher)CoreMatchers.equalTo((Object)myDashboards.length));
        Assert.assertThat((Object)my.dashboards(), (Matcher)Matchers.hasItems((Object[])myDashboards));
        Assert.assertThat((Object)my.dashboards().size(), (Matcher)CoreMatchers.equalTo((Object)myDashboards.length));
        Assert.assertThat((String)"page 0 should have 2 results", (Object)this.dashboardClient.getList("my", Integer.valueOf(0), Integer.valueOf(2)).dashboards().size(), (Matcher)CoreMatchers.equalTo((Object)2));
        Assert.assertThat((String)"page 1 should have 0 results", (Object)this.dashboardClient.getList("my", Integer.valueOf(2), Integer.valueOf(2)).dashboards().size(), (Matcher)CoreMatchers.equalTo((Object)0));
        DashboardsBean anonymousMy = ((DashboardClient)this.dashboardClient.anonymous()).getList("my", Integer.valueOf(0), Integer.valueOf(-1));
        Assert.assertThat((Object)anonymousMy.total(), (Matcher)CoreMatchers.equalTo((Object)0));
        Assert.assertThat((Object)anonymousMy.dashboards(), (Matcher)CoreMatchers.equalTo(Collections.emptyList()));
    }

    public void testDashboardResourceShouldAllowGettingASingleDashboard() throws Exception {
        Response fooResponse = this.dashboardClient.getSingleResponse("foo");
        Assert.assertThat((Object)fooResponse.statusCode, (Matcher)CoreMatchers.equalTo((Object)404));
        Assert.assertThat((Object)fooResponse.entity.errorMessages, (Matcher)Matchers.hasItem((Object)"The dashboard with id 'foo' does not exist."));
        Response minusOneResponse = this.dashboardClient.getSingleResponse("-1");
        Assert.assertThat((Object)minusOneResponse.statusCode, (Matcher)CoreMatchers.equalTo((Object)404));
        Assert.assertThat((Object)minusOneResponse.entity.errorMessages, (Matcher)Matchers.hasItem((Object)"The dashboard with id '-1' does not exist."));
        Assert.assertThat((Object)this.dashboardClient.getSingle("10000"), (Matcher)CoreMatchers.equalTo((Object)this.createDashboardBean("10000", "System Dashboard")));
        DashboardBean anonSystemDashboard = ((DashboardClient)this.dashboardClient.anonymous()).getSingle("10000");
        Assert.assertThat((Object)anonSystemDashboard.name(), (Matcher)CoreMatchers.equalTo((Object)"System Dashboard"));
        Response anonPrivateDashboardResp = ((DashboardClient)this.dashboardClient.anonymous()).getSingleResponse("10010");
        Assert.assertThat((Object)anonPrivateDashboardResp.statusCode, (Matcher)CoreMatchers.equalTo((Object)404));
    }

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestDashboardResource.xml");
        this.dashboardClient = new DashboardClient((JIRAEnvironmentData)this.getEnvironmentData());
    }

    private DashboardBean createDashboardBean(String id, String name) {
        return new DashboardBean().id(id).name(name).self(this.getRestApiUrl("/dashboard/" + id)).view(this.getBaseUrlPlus("/secure/Dashboard.jspa?selectPageId=" + id));
    }
}

