/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.EntityPropertyClient;
import com.atlassian.jira.testkit.client.restclient.EntityPropertyKeys;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.util.PropertyAssertions;
import com.google.common.collect.ImmutableMap;
import com.sun.jersey.api.client.WebResource;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

@WebTest(value={Category.FUNC_TEST, Category.ENTITY_PROPERTIES, Category.REST})
public final class TestDashboardItemPropertyResource
extends FuncTestCase {
    private static final String DASHBOARD_ID = "10010";
    private static final String DASHBOARD_ID_SHARED = "10110";
    private static final String DASHBOARD_ID_NOT_EXITING = "20010";
    private static final String DASHBOARD_ID_SYSTEM = "10000";
    private static final String ITEM_ID_1 = "10010";
    private static final String ITEM_ID_2 = "10011";
    private static final String ITEM_ID_OF_SHARED_DASHBOARD = "10110";
    private static final String ITEM_ID_THAT_DOES_NOT_EXIST = "12345";
    private DashboardItemPropertyClient client;

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.client = new DashboardItemPropertyClient(this.environmentData).dashboardId("10010");
        this.restoreInstanceData();
        this.administration.usersAndGroups().addUser("bob", "bob", "Bob The Builder", "bob@stuff.com.com");
    }

    public void testAddingDashboardItemProperty() {
        this.client.put("10010", "prop1", this.value(1));
        this.client.put("10010", "prop2", this.value(2));
        this.client.put(ITEM_ID_2, "prop3", this.value(3));
        List item1Keys = this.client.getKeys((String)"10010").keys;
        Assert.assertThat((Object)item1Keys, (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((Object)item1Keys, (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{PropertyAssertions.propertyKey("prop1"), PropertyAssertions.propertyKey("prop2")}));
        List item2Keys = this.client.getKeys((String)ITEM_ID_2).keys;
        Assert.assertThat((Object)item2Keys, (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)item2Keys, (Matcher)Matchers.hasItem(PropertyAssertions.propertyKey("prop3")));
    }

    public void testAccessingDashboardItemInWrongDashboardReturns404() {
        this.assertNotFoundResponse(DASHBOARD_ID_NOT_EXITING, "10010");
        this.assertNotFoundResponse(DASHBOARD_ID_SYSTEM, "10010");
    }

    public void testAccessingNonExistingDashboardItemReturns404() {
        this.assertNotFoundResponse("10010", ITEM_ID_THAT_DOES_NOT_EXIST);
    }

    public void testAccessingDashboardAsLoggedInUserWithoutReadPermissionsReturns404() {
        this.client.loginAs("bob");
        this.assertNotFoundResponseOnAccess("10010", "10010");
    }

    public void testAccessingDashboardAsAnonymousWithoutReadPermissionsReturns404() {
        this.client.anonymous();
        this.assertNotFoundResponseOnAccess("10010", "10010");
    }

    public void testAccessingPropertiesOfADashboardItemSharedWithEveryoneAsAnonymousWorks() {
        this.client.anonymous();
        EntityPropertyKeys keys = this.client.dashboardId("10110").getKeys("10110");
        Assert.assertThat((Object)keys.keys, (Matcher)Matchers.hasSize((int)0));
    }

    public void testUserMustHaveWriteAccessToTheDashboardToSetProperties() {
        this.client.dashboardId("10110");
        this.client.loginAs("bob");
        PropertyAssertions.assertUniformInterfaceException(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TestDashboardItemPropertyResource.this.client.put("10110", "prop1", TestDashboardItemPropertyResource.this.value(1));
                return null;
            }
        }, Response.Status.FORBIDDEN);
    }

    public void testUserMustHaveReadAccessToTheDashboardToAccessProperties() {
        this.client.dashboardId("10010").put("10010", "prop1", this.value(1));
        this.client.loginAs("bob");
        PropertyAssertions.assertUniformInterfaceException(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TestDashboardItemPropertyResource.this.client.dashboardId("10010").get("10010", "prop1");
                return null;
            }
        }, Response.Status.NOT_FOUND);
    }

    public void testUserCanReadPropertiesOfSharedDashboard() {
        this.client.dashboardId("10110").put("10110", "prop1", this.value(1));
        this.client.loginAs("bob");
        Assert.assertThat((Object)this.client.dashboardId((String)"10110").get((String)"10110", (String)"prop1").value, (Matcher)Matchers.equalTo(this.valueAsMap(1)));
    }

    public void testPropertyDelete() {
        this.client.put("10010", "prop1", this.value(1));
        this.client.put(ITEM_ID_2, "prop2", this.value(1));
        this.client.delete("10010", "prop1");
        Assert.assertThat((Object)this.client.getKeys((String)"10010").keys, (Matcher)Matchers.hasSize((int)0));
        Assert.assertThat((Object)this.client.getKeys((String)ITEM_ID_2).keys, (Matcher)Matchers.hasSize((int)1));
    }

    public void testUpdatingProperty() {
        this.client.put("10010", "prop1", this.value(1));
        Assert.assertThat((Object)this.client.get((String)"10010", (String)"prop1").value, (Matcher)Matchers.equalTo(this.valueAsMap(1)));
        this.client.put("10010", "prop1", this.value(2));
        Assert.assertThat((Object)this.client.get((String)"10010", (String)"prop1").value, (Matcher)Matchers.equalTo(this.valueAsMap(2)));
    }

    public void testSelfLink() {
        this.client.put("10010", "prop1", this.value(1));
        EntityPropertyKeys.EntityPropertyKey key = (EntityPropertyKeys.EntityPropertyKey)this.client.getKeys((String)"10010").keys.get(0);
        Assert.assertThat((Object)key.self, (Matcher)Matchers.equalTo((Object)String.format(this.environmentData.getBaseUrl().toString() + "/rest/api/%s/dashboard/%s/items/%s/properties/prop1", "2", "10010", "10010")));
    }

    private void assertNotFoundResponse(String dashboardId, final String itemId) {
        this.client.dashboardId(dashboardId);
        PropertyAssertions.assertUniformInterfaceException(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TestDashboardItemPropertyResource.this.client.put(itemId, "prop1", TestDashboardItemPropertyResource.this.value(1));
                return null;
            }
        }, Response.Status.NOT_FOUND, String.format("dashboard %s does not contain item %s or you do not have permissions to view the dashboard", dashboardId, itemId));
    }

    private void assertNotFoundResponseOnAccess(String dashboardId, final String itemId) {
        this.client.dashboardId(dashboardId);
        PropertyAssertions.assertUniformInterfaceException(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TestDashboardItemPropertyResource.this.client.getKeys(itemId);
                return null;
            }
        }, Response.Status.NOT_FOUND, String.format("dashboard %s does not contain item %s or you do not have permissions to view the dashboard", dashboardId, itemId));
    }

    private JSONObject value(int value) {
        return new JSONObject(this.valueAsMap(value));
    }

    private Map<String, Object> valueAsMap(int value) {
        return ImmutableMap.of((Object)"value", (Object)value);
    }

    private void restoreInstanceData() {
        this.administration.restoreData("DashboardItems.xml");
    }

    private static class DashboardItemPropertyClient
    extends EntityPropertyClient {
        private String dashboardId;

        public DashboardItemPropertyClient(JIRAEnvironmentData environmentData) {
            super(environmentData, "items");
        }

        public DashboardItemPropertyClient dashboardId(String id) {
            this.dashboardId = id;
            return this;
        }

        protected WebResource createResource() {
            if (this.dashboardId == null) {
                throw new IllegalArgumentException("dashboardId not specified, use the dashboardId(id) method first");
            }
            return super.createResource().path("dashboard").path(this.dashboardId);
        }
    }
}

