/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.rest.v2.issue.UserBean;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestCurrentUserResource
extends RestFuncTest {
    private static final String SELF = "self";
    private static final String PASSWORD = "password";
    private static final String EMAIL_ADDRESS = "emailAddress";
    private static final String DISPLAY_NAME = "displayName";
    private static final String EMAIL_ADDRESS_CHANGED_VALUE = "charlie2@localhost";
    private static final String DISPLAY_NAME_CHANGED_VALUE = "Charlie of Atlassian II";
    private static final String REST_URL = "/rest/api/2/user?";
    private UserClient userClient;
    private com.atlassian.jira.webtests.util.JIRAEnvironmentData environmentData;

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.environmentData = this.getEnvironmentData();
        this.backdoor.restoreBlankInstance();
        this.backdoor.usersAndGroups().addUser("notadmin", "withpassword", "DisplayNoAdminName", "noadmin@localhost");
        this.userClient = new UserClient(this.environmentData);
        this.userClient.loginAs("notadmin", "withpassword");
    }

    @Override
    protected void tearDownTest() {
        this.userClient.close();
    }

    public void testHappyPathUseCase() {
        this.updateUser();
        this.changeMyPassword();
    }

    private String getJiraExperimentalApiUserPath() {
        return this.environmentData.getBaseUrl() + REST_URL;
    }

    private void updateUser() {
        ClientResponse responseUpdate = this.userClient.updateUser(EMAIL_ADDRESS_CHANGED_VALUE, DISPLAY_NAME_CHANGED_VALUE);
        Assert.assertThat((Object)responseUpdate.getStatus(), (Matcher)Matchers.equalTo((Object)Response.Status.OK.getStatusCode()));
        UserBean userBean = this.getMapEntity(responseUpdate);
        responseUpdate.close();
        Assert.assertThat((Object)userBean, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)userBean.getEmailAddress(), (Matcher)Matchers.equalTo((Object)EMAIL_ADDRESS_CHANGED_VALUE));
        Assert.assertThat((Object)userBean.getDisplayName(), (Matcher)Matchers.equalTo((Object)DISPLAY_NAME_CHANGED_VALUE));
        Assert.assertThat((Object)userBean.getSelf().toString(), (Matcher)Matchers.startsWith((String)this.getJiraExperimentalApiUserPath()));
        Assert.assertThat((Object)userBean.getLocale(), (Matcher)Matchers.equalTo((Object)"en_AU"));
    }

    private void changeMyPassword() {
        ClientResponse response = this.userClient.changePassword("hocuspocus");
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)Response.Status.NO_CONTENT.getStatusCode()));
        response.close();
    }

    private UserBean getMapEntity(ClientResponse responseRead) {
        return (UserBean)responseRead.getEntity(UserBean.class);
    }

    private class UserClient
    extends RestApiClient<UserClient> {
        private static final String CURRENT_USER_PATH = "myself";
        private static final String PASSWORD_PATH = "password";
        private final Set<ClientResponse> responses;

        protected UserClient(com.atlassian.jira.webtests.util.JIRAEnvironmentData environmentData) {
            super((JIRAEnvironmentData)environmentData);
            this.responses = Sets.newHashSet();
        }

        protected WebResource createResource() {
            return this.resourceRoot(TestCurrentUserResource.this.environmentData.getBaseUrl().toExternalForm()).path("rest").path("api").path("2");
        }

        private ClientResponse getUser(String key) {
            Preconditions.checkNotNull((Object)key);
            WebResource webResource = this.createResource().path(CURRENT_USER_PATH);
            ClientResponse clientResponse = (ClientResponse)webResource.get(ClientResponse.class);
            this.responses.add(clientResponse);
            return clientResponse;
        }

        private ClientResponse updateUser(String emailAddress, String displayName) {
            WebResource webResource = this.createResource().path(CURRENT_USER_PATH);
            ImmutableMap.Builder builder = ImmutableMap.builder();
            if (emailAddress != null) {
                builder.put((Object)TestCurrentUserResource.EMAIL_ADDRESS, (Object)emailAddress);
            }
            if (displayName != null) {
                builder.put((Object)TestCurrentUserResource.DISPLAY_NAME, (Object)displayName);
            }
            ClientResponse clientResponse = (ClientResponse)webResource.type("application/json").put(ClientResponse.class, (Object)builder.build());
            this.responses.add(clientResponse);
            return clientResponse;
        }

        private ClientResponse changePassword(String password) {
            WebResource webResource = this.createResource().path("myself/password");
            ImmutableMap.Builder builder = ImmutableMap.builder();
            if (password != null) {
                builder.put((Object)"password", (Object)password);
            }
            ClientResponse clientResponse = (ClientResponse)webResource.type("application/json").put(ClientResponse.class, (Object)builder.build());
            this.responses.add(clientResponse);
            return clientResponse;
        }

        private void close() {
            for (ClientResponse response : this.responses) {
                response.close();
            }
        }
    }
}

