/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.CurrentUserPreferencesClient;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.sun.jersey.api.client.ClientResponse;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestCurrentUserPreferencesResource
extends RestFuncTest {
    private static final String SOME_KEY = "someKey";
    private static final String SOME_VALUE = "someValue";
    private CurrentUserPreferencesClient preferencesClient;

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.preferencesClient = new CurrentUserPreferencesClient((JIRAEnvironmentData)this.getEnvironmentData());
        this.backdoor.restoreBlankInstance();
    }

    @Override
    protected void tearDownTest() {
        this.preferencesClient.close();
    }

    public void testHappyPathUseCase() {
        ClientResponse responseGet1 = this.preferencesClient.getPreference(SOME_KEY);
        Assert.assertThat((Object)responseGet1.getStatus(), (Matcher)CoreMatchers.equalTo((Object)ClientResponse.Status.NOT_FOUND.getStatusCode()));
        ClientResponse responsePut = this.preferencesClient.setPreference(SOME_KEY, SOME_VALUE);
        TestCurrentUserPreferencesResource.assertNotNull((Object)responsePut);
        Assert.assertThat((Object)responsePut.getStatus(), (Matcher)CoreMatchers.equalTo((Object)ClientResponse.Status.NO_CONTENT.getStatusCode()));
        ClientResponse responseGet2 = this.preferencesClient.getPreference(SOME_KEY);
        Assert.assertThat((Object)responseGet2.getStatus(), (Matcher)CoreMatchers.equalTo((Object)ClientResponse.Status.OK.getStatusCode()));
        String message = (String)responseGet2.getEntity(String.class);
        Assert.assertThat((Object)message, (Matcher)CoreMatchers.equalTo((Object)SOME_VALUE));
        ClientResponse responseDelete1 = this.preferencesClient.removePreference(SOME_KEY);
        Assert.assertThat((Object)responseDelete1.getStatus(), (Matcher)CoreMatchers.equalTo((Object)ClientResponse.Status.NO_CONTENT.getStatusCode()));
        ClientResponse responseGet3 = this.preferencesClient.getPreference(SOME_KEY);
        Assert.assertThat((Object)responseGet3.getStatus(), (Matcher)CoreMatchers.equalTo((Object)ClientResponse.Status.NOT_FOUND.getStatusCode()));
    }
}

