/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.ConfigurationBean;
import com.atlassian.jira.testkit.client.restclient.ConfigurationClient;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestConfigurationResource
extends RestFuncTest {
    private ConfigurationClient configurationClient;

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.backdoor.restoreBlankInstance();
        this.configurationClient = new ConfigurationClient((JIRAEnvironmentData)this.getEnvironmentData());
    }

    public void testGettingJIRAConfiguration() {
        this.backdoor.attachments().disable();
        this.backdoor.issueLinking().disable();
        this.backdoor.subtask().enable();
        this.backdoor.applicationProperties().setOption("jira.option.timetracking", true);
        this.backdoor.applicationProperties().setOption("jira.option.allowunassigned", true);
        ConfigurationBean configuration = this.configurationClient.getConfiguration();
        TestConfigurationResource.assertFalse((boolean)configuration.attachmentsEnabled);
        TestConfigurationResource.assertFalse((boolean)configuration.issueLinkingEnabled);
        TestConfigurationResource.assertTrue((boolean)configuration.subTasksEnabled);
        TestConfigurationResource.assertTrue((boolean)configuration.timeTrackingEnabled);
        TestConfigurationResource.assertTrue((boolean)configuration.unassignedIssuesAllowed);
        TestConfigurationResource.assertTrue((boolean)configuration.votingEnabled);
        TestConfigurationResource.assertTrue((boolean)configuration.watchingEnabled);
        TestConfigurationResource.assertEquals((Object)configuration.timeTrackingConfiguration.defaultUnit, (Object)ConfigurationBean.TimeTrackingConfigurationBean.TimeTrackingUnit.minute);
        TestConfigurationResource.assertEquals((Object)configuration.timeTrackingConfiguration.timeFormat, (Object)ConfigurationBean.TimeTrackingConfigurationBean.TimeFormat.pretty);
        TestConfigurationResource.assertEquals((double)configuration.timeTrackingConfiguration.workingDaysPerWeek, (double)7.0, (double)Math.pow(10.0, -5.0));
        TestConfigurationResource.assertEquals((double)configuration.timeTrackingConfiguration.workingHoursPerDay, (double)24.0, (double)Math.pow(10.0, -5.0));
    }

    public void testTimeTrackingDisabled() {
        this.backdoor.applicationProperties().setOption("jira.option.timetracking", false);
        ConfigurationBean configuration = this.configurationClient.getConfiguration();
        TestConfigurationResource.assertFalse((boolean)configuration.timeTrackingEnabled);
        TestConfigurationResource.assertNull((Object)configuration.timeTrackingConfiguration);
    }
}

