/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.admin.GeneralConfiguration;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.rest.api.issue.IssueCreateResponse;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Comment;
import com.atlassian.jira.testkit.client.restclient.CommentClient;
import com.atlassian.jira.testkit.client.restclient.CommentsWithPaginationBean;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import com.atlassian.jira.testkit.client.restclient.Response;
import com.atlassian.jira.testkit.client.restclient.Visibility;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.google.inject.internal.Lists;
import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.HttpNotFoundException;
import com.meterware.httpunit.WebRequest;
import java.util.HashMap;
import junit.framework.AssertionFailedError;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestCommentResource
extends RestFuncTest {
    private CommentClient commentClient;

    public void testViewCommentNotFound() throws Exception {
        this.administration.restoreData("TestEditComment.xml");
        Response content1 = this.commentClient.getResponse("HSP-1", "1");
        TestCommentResource.assertEquals((int)404, (int)content1.statusCode);
        TestCommentResource.assertEquals((int)1, (int)content1.entity.errorMessages.size());
        TestCommentResource.assertTrue((boolean)content1.entity.errorMessages.contains("Can not find a comment for the id: 1."));
        Response contentPiolho = this.commentClient.getResponse("HSP-1", "piolho");
        TestCommentResource.assertEquals((int)404, (int)contentPiolho.statusCode);
        TestCommentResource.assertEquals((int)1, (int)contentPiolho.entity.errorMessages.size());
        TestCommentResource.assertTrue((boolean)contentPiolho.entity.errorMessages.contains("Can not find a comment for the id: piolho."));
    }

    public void testAnonymousComment() throws Exception {
        this.administration.restoreData("TestRESTAnonymous.xml");
        Response comment = this.commentClient.get("HSP-1", "10000");
        TestCommentResource.assertNull((Object)((Comment)comment.body).author);
    }

    public void testAnonymous() throws Exception {
        this.administration.restoreBlankInstance();
        this.administration.generalConfiguration().setCommentVisibility(GeneralConfiguration.CommentVisibility.PROJECT_ROLES);
        this.administration.roles().addProjectRoleForUser("monkey", "Administrators", "admin");
        String key = this.navigation.issue().createIssue("monkey", "Bug", "First Test Issue");
        this.navigation.issue().addComment(key, "comment", "Administrators");
        this.navigation.logout();
        try {
            String url = this.getEnvironmentData().getBaseUrl() + "/rest/api/2/issue/HSP-1/comment/10000";
            this.tester.getDialog().getWebClient().sendRequest((WebRequest)new GetMethodWebRequest(url));
            TestCommentResource.fail();
        }
        catch (HttpNotFoundException httpNotFoundException) {
            // empty catch block
        }
    }

    public void testViewCommentJson() throws Exception {
        this.administration.restoreBlankInstance();
        this.administration.generalConfiguration().setCommentVisibility(GeneralConfiguration.CommentVisibility.PROJECT_ROLES);
        this.administration.roles().addProjectRoleForUser("monkey", "Administrators", "admin");
        String key = this.navigation.issue().createIssue("monkey", "Bug", "First Test Issue");
        this.navigation.issue().addComment(key, "comment", "Administrators");
        Response response = this.commentClient.get("MKY-1", "10000");
        Comment json = (Comment)response.body;
        TestCommentResource.assertNotNull((Object)json.created);
        TestCommentResource.assertNotNull((Object)json.updated);
        TestCommentResource.assertEquals((String)(this.getEnvironmentData().getBaseUrl() + "/rest/api/2/issue/10000/comment/10000"), (String)json.self);
        TestCommentResource.assertEquals((String)"10000", (String)json.id);
        TestCommentResource.assertEquals((String)"comment", (String)json.body);
        TestCommentResource.assertEquals((String)"role", (String)json.visibility.type);
        TestCommentResource.assertEquals((String)"Administrators", (String)json.visibility.value);
        TestCommentResource.assertEquals((String)"admin", (String)json.author.name);
        TestCommentResource.assertEquals((String)"Administrator", (String)json.author.displayName);
        TestCommentResource.assertEquals((String)(this.getEnvironmentData().getBaseUrl() + "/rest/api/2/user?username=admin"), (String)json.author.self);
        TestCommentResource.assertEquals((String)"admin", (String)json.updateAuthor.name);
        TestCommentResource.assertEquals((String)"Administrator", (String)json.updateAuthor.displayName);
        TestCommentResource.assertEquals((String)(this.getEnvironmentData().getBaseUrl() + "/rest/api/2/user?username=admin"), (String)json.updateAuthor.self);
    }

    public void testViewComments() {
        this.administration.restoreData("TestEditComment.xml");
        Response response = this.commentClient.getComments("HSP-1");
        TestCommentResource.assertEquals((int)3, (int)((CommentsWithPaginationBean)response.body).getMaxResults());
        TestCommentResource.assertEquals((int)3, (int)((CommentsWithPaginationBean)response.body).getTotal());
        TestCommentResource.assertEquals((int)3, (int)((CommentsWithPaginationBean)response.body).getComments().size());
        Comment comment = (Comment)((CommentsWithPaginationBean)response.body).getComments().get(0);
        TestCommentResource.assertNotNull((Object)comment.created);
        TestCommentResource.assertNotNull((Object)comment.updated);
        TestCommentResource.assertEquals((String)(this.getEnvironmentData().getBaseUrl() + "/rest/api/2/issue/10000/comment/10031"), (String)comment.self);
        TestCommentResource.assertEquals((String)"10031", (String)comment.id);
        TestCommentResource.assertEquals((String)"I'm a hero!", (String)comment.body);
        TestCommentResource.assertNull((Object)comment.visibility);
        TestCommentResource.assertEquals((String)"admin", (String)comment.author.name);
        TestCommentResource.assertEquals((String)"admin", (String)comment.updateAuthor.name);
    }

    public void testGetCommentExpandRendered() {
        String body = "*Bolded comment body*";
        String renderedBody = "<p><b>Bolded comment body</b></p>";
        this.administration.restoreData("TestEditComment.xml");
        this.administration.fieldConfigurations().defaultFieldConfiguration().setRenderer("Comment", "Wiki Style Renderer");
        Comment newComment = new Comment();
        newComment.body = "*Bolded comment body*";
        Response post = this.commentClient.post("HSP-1", newComment);
        Response get = this.commentClient.get("HSP-1", ((Comment)post.body).id, "renderedBody");
        TestCommentResource.assertEquals((String)"<p><b>Bolded comment body</b></p>", (String)((Comment)get.body).renderedBody);
    }

    public void testGetCommentsExpandRendered() {
        String body = "*Bolded comment body*";
        String renderedBody = "<p><b>Bolded comment body</b></p>";
        this.administration.restoreData("TestEditComment.xml");
        this.administration.fieldConfigurations().defaultFieldConfiguration().setRenderer("Comment", "Wiki Style Renderer");
        Comment newComment = new Comment();
        newComment.body = "*Bolded comment body*";
        Response post = this.commentClient.post("HSP-1", newComment);
        Response response = this.commentClient.getComments("HSP-1", "renderedBody");
        Comment comment = (Comment)((CommentsWithPaginationBean)response.body).getComments().get(((CommentsWithPaginationBean)response.body).getComments().size() - 1);
        TestCommentResource.assertEquals((String)"<p><b>Bolded comment body</b></p>", (String)comment.renderedBody);
    }

    public void testEditComment() {
        this.administration.restoreData("TestEditComment.xml");
        Response comparison = this.commentClient.get("HSP-1", "10031");
        Comment newComment = new Comment();
        newComment.body = "new comment body";
        newComment.visibility = new Visibility("group", "jira-administrators");
        newComment.id = ((Comment)comparison.body).id;
        ((Comment)comparison.body).body = newComment.body;
        ((Comment)comparison.body).visibility = newComment.visibility;
        Response put = this.commentClient.put("HSP-1", newComment);
        TestCommentResource.assertNotNull((Object)put);
        TestCommentResource.assertEquals((int)200, (int)put.statusCode);
        this.assertCommentsEqual((Comment)comparison.body, (Comment)put.body);
        Response reget = this.commentClient.get("HSP-1", "10031");
        this.assertCommentsEqual((Comment)comparison.body, (Comment)reget.body);
    }

    public void testEditCommentExpandRendered() {
        String body = "*Bolded comment body*";
        String renderedBody = "<p><b>Bolded comment body</b></p>";
        this.administration.restoreData("TestEditComment.xml");
        this.administration.fieldConfigurations().defaultFieldConfiguration().setRenderer("Comment", "Wiki Style Renderer");
        Response comparison = this.commentClient.get("HSP-1", "10031");
        Comment newComment = new Comment();
        newComment.body = "*Bolded comment body*";
        newComment.id = ((Comment)comparison.body).id;
        Response post = this.commentClient.put("HSP-1", newComment, "renderedBody");
        TestCommentResource.assertEquals((String)"<p><b>Bolded comment body</b></p>", (String)((Comment)post.body).renderedBody);
    }

    public void testEditCommentWhenRoleDoesntExist() {
        this.administration.restoreData("TestEditComment.xml");
        Response comment = this.commentClient.get("HSP-1", "10031");
        Comment newComment = new Comment();
        newComment.id = ((Comment)comment.body).id;
        newComment.body = "new comment body";
        newComment.visibility = new Visibility("role", "not-existing-role");
        Response post = this.commentClient.put("HSP-1", newComment);
        TestCommentResource.assertEquals((int)400, (int)post.statusCode);
        TestCommentResource.assertEquals((int)1, (int)post.entity.errors.size());
    }

    public void testEditCommentWhenGroupDoesntExist() {
        this.administration.restoreData("TestEditComment.xml");
        Response comment = this.commentClient.get("HSP-1", "10031");
        Comment newComment = new Comment();
        newComment.id = ((Comment)comment.body).id;
        newComment.body = "new comment body";
        newComment.visibility = new Visibility("group", "not-existing-group");
        Response post = this.commentClient.put("HSP-1", newComment);
        TestCommentResource.assertEquals((int)400, (int)post.statusCode);
        TestCommentResource.assertEquals((int)1, (int)post.entity.errors.size());
    }

    public void testAddComment() {
        this.administration.restoreData("TestEditComment.xml");
        Comment newComment = new Comment();
        newComment.body = "new comment body";
        newComment.visibility = new Visibility("group", "jira-administrators");
        Response post = this.commentClient.post("HSP-1", newComment);
        TestCommentResource.assertNotNull((Object)post);
        TestCommentResource.assertEquals((int)201, (int)post.statusCode);
        TestCommentResource.assertNotNull((Object)post.body);
        TestCommentResource.assertEquals((String)"new comment body", (String)((Comment)post.body).body);
        TestCommentResource.assertEquals((String)"group", (String)((Comment)post.body).visibility.type);
        TestCommentResource.assertEquals((String)"jira-administrators", (String)((Comment)post.body).visibility.value);
        Response reget = this.commentClient.get("HSP-1", ((Comment)post.body).id);
        this.assertCommentsEqual((Comment)post.body, (Comment)reget.body);
        newComment = new Comment();
        post = this.commentClient.post("HSP-1", newComment);
        TestCommentResource.assertEquals((int)400, (int)post.statusCode);
        TestCommentResource.assertEquals((int)1, (int)post.entity.errors.size());
    }

    public void testAddCommentExpandRendered() {
        String body = "*Bolded comment body*";
        String renderedBody = "<p><b>Bolded comment body</b></p>";
        this.administration.restoreData("TestEditComment.xml");
        this.administration.fieldConfigurations().defaultFieldConfiguration().setRenderer("Comment", "Wiki Style Renderer");
        Comment newComment = new Comment();
        newComment.body = "*Bolded comment body*";
        Response post = this.commentClient.post("HSP-1", newComment, "renderedBody");
        TestCommentResource.assertEquals((String)"<p><b>Bolded comment body</b></p>", (String)((Comment)post.body).renderedBody);
    }

    public void testAddCommentWhenRoleDoesntExist() {
        this.administration.restoreData("TestEditComment.xml");
        Comment newComment = new Comment();
        newComment.body = "new comment body";
        newComment.visibility = new Visibility("role", "not-existing-role");
        Response post = this.commentClient.post("HSP-1", newComment);
        TestCommentResource.assertEquals((int)400, (int)post.statusCode);
        TestCommentResource.assertEquals((int)1, (int)post.entity.errors.size());
    }

    public void testAddCommentWhenGroupDoesntExist() {
        this.administration.restoreData("TestEditComment.xml");
        Comment newComment = new Comment();
        newComment.body = "new comment body";
        newComment.visibility = new Visibility("group", "not-existing-group");
        Response post = this.commentClient.post("HSP-1", newComment);
        TestCommentResource.assertEquals((int)400, (int)post.statusCode);
        TestCommentResource.assertEquals((int)1, (int)post.entity.errors.size());
    }

    public void testDeleteComment() {
        this.administration.restoreData("TestEditComment.xml");
        Comment newComment = new Comment();
        newComment.body = "new comment body";
        newComment.visibility = new Visibility("group", "jira-administrators");
        Response put = this.commentClient.post("HSP-1", newComment);
        Response deleteResponse = this.commentClient.delete("HSP-1", (Comment)put.body);
        TestCommentResource.assertEquals((int)204, (int)deleteResponse.statusCode);
        Response response = this.commentClient.getResponse("HSP-1", ((Comment)put.body).id);
        TestCommentResource.assertEquals((int)404, (int)response.statusCode);
        TestCommentResource.assertEquals((int)1, (int)response.entity.errorMessages.size());
        TestCommentResource.assertTrue((boolean)((String)response.entity.errorMessages.get(0)).startsWith("Can not find a comment for the id: 10050."));
        deleteResponse = this.commentClient.delete("HSP-1", (Comment)put.body);
        TestCommentResource.assertEquals((int)404, (int)deleteResponse.statusCode);
        TestCommentResource.assertEquals((int)1, (int)deleteResponse.entity.errorMessages.size());
        TestCommentResource.assertTrue((boolean)((String)deleteResponse.entity.errorMessages.get(0)).startsWith("Can not find a comment for the id: 10050."));
    }

    public void testIncorrectIssueKey() {
        Response response = this.commentClient.getComments("NONEXISTANT-1");
        TestCommentResource.assertEquals((int)404, (int)response.statusCode);
        TestCommentResource.assertEquals((int)1, (int)response.entity.errorMessages.size());
        TestCommentResource.assertTrue((boolean)((String)response.entity.errorMessages.get(0)).startsWith("Issue Does Not Exist"));
        Response response2 = this.commentClient.get("NONEXISTANT-1", "00000");
        TestCommentResource.assertEquals((int)404, (int)response2.statusCode);
        TestCommentResource.assertEquals((int)1, (int)response2.entity.errorMessages.size());
        TestCommentResource.assertTrue((boolean)((String)response2.entity.errorMessages.get(0)).startsWith("Issue Does Not Exist"));
    }

    public void testGetCommentFromWrongIssue() {
        this.administration.restoreData("TestEditComment.xml");
        Response goodResponse = this.commentClient.getComments("HSP-1");
        Comment comment = (Comment)((CommentsWithPaginationBean)goodResponse.body).getComments().get(0);
        Response response = this.commentClient.get("HSP-2", comment.id);
        TestCommentResource.assertEquals((int)404, (int)response.statusCode);
        TestCommentResource.assertEquals((int)1, (int)response.entity.errorMessages.size());
        TestCommentResource.assertTrue((boolean)((String)response.entity.errorMessages.get(0)).startsWith("No comment with given ID found for issue HSP-2"));
    }

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.commentClient = new CommentClient((JIRAEnvironmentData)this.getEnvironmentData());
    }

    public void testAdminCanEditAndDeleteAllComments() throws Exception {
        this.administration.restoreData("TestCommentPermissions.xml");
        Response comments = this.commentClient.getComments("RAT-2");
        TestCommentResource.assertEquals((int)3, (int)((CommentsWithPaginationBean)comments.body).getComments().size());
        Response original = this.commentClient.get("RAT-2", "10000");
        ((Comment)original.body).body = "admin edited comment";
        Response updated = this.commentClient.put("RAT-2", (Comment)original.body);
        this.assertCommentsEqual((Comment)updated.body, (Comment)original.body);
        TestCommentResource.assertEquals((int)200, (int)updated.statusCode);
        original = this.commentClient.get("RAT-2", "10001");
        ((Comment)original.body).body = "admin edited comment";
        updated = this.commentClient.put("RAT-2", (Comment)original.body);
        this.assertCommentsEqual((Comment)updated.body, (Comment)original.body);
        TestCommentResource.assertEquals((int)200, (int)updated.statusCode);
        original = this.commentClient.get("RAT-2", "10002");
        ((Comment)original.body).body = "admin edited comment";
        updated = this.commentClient.put("RAT-2", (Comment)original.body);
        this.assertCommentsEqual((Comment)updated.body, (Comment)original.body);
        TestCommentResource.assertEquals((int)200, (int)updated.statusCode);
        Response deleteResponse = this.commentClient.delete("RAT-2", "10001");
        TestCommentResource.assertEquals((int)204, (int)deleteResponse.statusCode);
        deleteResponse = this.commentClient.delete("RAT-2", "10002");
        TestCommentResource.assertEquals((int)204, (int)deleteResponse.statusCode);
        deleteResponse = this.commentClient.delete("RAT-2", "10000");
        TestCommentResource.assertEquals((int)204, (int)deleteResponse.statusCode);
    }

    public void testFredCanEditAndDeleteOwnComments() throws Exception {
        this.administration.restoreData("TestCommentPermissions.xml");
        this.commentClient.loginAs("fred");
        Response comments = this.commentClient.getComments("RAT-2");
        TestCommentResource.assertEquals((int)3, (int)((CommentsWithPaginationBean)comments.body).getComments().size());
        Response original = this.commentClient.get("RAT-2", "10001");
        ((Comment)original.body).body = "fred edited comment";
        Response updated = this.commentClient.put("RAT-2", (Comment)original.body);
        this.assertCommentsEqual((Comment)updated.body, (Comment)original.body);
        TestCommentResource.assertEquals((int)200, (int)updated.statusCode);
        original = this.commentClient.get("RAT-2", "10000");
        String originalBody = ((Comment)original.body).body;
        ((Comment)original.body).body = "fred edited comment";
        updated = this.commentClient.put("RAT-2", (Comment)original.body);
        TestCommentResource.assertEquals((int)400, (int)updated.statusCode);
        TestCommentResource.assertEquals((int)1, (int)updated.entity.errorMessages.size());
        TestCommentResource.assertTrue((boolean)((String)updated.entity.errorMessages.get(0)).contains("do not have the permission to edit this comment."));
        ((Comment)original.body).body = originalBody;
        Response reget = this.commentClient.get("RAT-2", "10000");
        this.assertCommentsEqual((Comment)reget.body, (Comment)original.body);
        Response deleteResponse = this.commentClient.delete("RAT-2", "10001");
        TestCommentResource.assertEquals((int)204, (int)deleteResponse.statusCode);
        original = this.commentClient.get("RAT-2", "10002");
        deleteResponse = this.commentClient.delete("RAT-2", "10002");
        TestCommentResource.assertEquals((int)400, (int)deleteResponse.statusCode);
        TestCommentResource.assertEquals((int)1, (int)deleteResponse.entity.errorMessages.size());
        TestCommentResource.assertTrue((boolean)((String)deleteResponse.entity.errorMessages.get(0)).contains("You do not have permission to delete comment with id"));
        reget = this.commentClient.get("RAT-2", "10002");
        TestCommentResource.assertEquals((int)200, (int)reget.statusCode);
        TestCommentResource.assertNotNull((Object)reget.body);
        this.assertCommentsEqual((Comment)original.body, (Comment)reget.body);
    }

    public void testAnonCanEditAndDeleteNothing() throws Exception {
        this.administration.restoreData("TestCommentPermissions.xml");
        this.commentClient.anonymous();
        Response comments = this.commentClient.getComments("RAT-2");
        TestCommentResource.assertEquals((int)3, (int)((CommentsWithPaginationBean)comments.body).getComments().size());
        Response original = this.commentClient.get("RAT-2", "10000");
        String originalBody = ((Comment)original.body).body;
        ((Comment)original.body).body = "fred edited comment";
        Response updated = this.commentClient.put("RAT-2", (Comment)original.body);
        TestCommentResource.assertEquals((int)400, (int)updated.statusCode);
        TestCommentResource.assertEquals((int)1, (int)updated.entity.errorMessages.size());
        TestCommentResource.assertTrue((boolean)((String)updated.entity.errorMessages.get(0)).startsWith("You do not have the permission to edit this comment."));
        ((Comment)original.body).body = originalBody;
        Response reget = this.commentClient.get("RAT-2", "10000");
        this.assertCommentsEqual((Comment)reget.body, (Comment)original.body);
        original = this.commentClient.get("RAT-2", "10000");
        originalBody = ((Comment)original.body).body;
        ((Comment)original.body).body = "fred edited comment";
        updated = this.commentClient.put("RAT-2", (Comment)original.body);
        TestCommentResource.assertEquals((int)400, (int)updated.statusCode);
        TestCommentResource.assertEquals((int)1, (int)updated.entity.errorMessages.size());
        TestCommentResource.assertTrue((boolean)((String)updated.entity.errorMessages.get(0)).startsWith("You do not have the permission to edit this comment."));
        ((Comment)original.body).body = originalBody;
        reget = this.commentClient.get("RAT-2", "10000");
        this.assertCommentsEqual((Comment)reget.body, (Comment)original.body);
        original = this.commentClient.get("RAT-2", "10002");
        Response deleteResponse = this.commentClient.delete("RAT-2", "10002");
        TestCommentResource.assertEquals((int)400, (int)deleteResponse.statusCode);
        TestCommentResource.assertEquals((int)1, (int)deleteResponse.entity.errorMessages.size());
        TestCommentResource.assertTrue((boolean)((String)deleteResponse.entity.errorMessages.get(0)).startsWith("You do not have permission to delete comment with id"));
        reget = this.commentClient.get("RAT-2", "10002");
        TestCommentResource.assertEquals((int)200, (int)reget.statusCode);
        TestCommentResource.assertNotNull((Object)reget.body);
        this.assertCommentsEqual((Comment)original.body, (Comment)reget.body);
        original = this.commentClient.get("RAT-2", "10002");
        deleteResponse = this.commentClient.delete("RAT-2", "10002");
        TestCommentResource.assertEquals((int)400, (int)deleteResponse.statusCode);
        TestCommentResource.assertEquals((int)1, (int)deleteResponse.entity.errorMessages.size());
        TestCommentResource.assertTrue((boolean)((String)deleteResponse.entity.errorMessages.get(0)).startsWith("You do not have permission to delete comment with id"));
        reget = this.commentClient.get("RAT-2", "10002");
        TestCommentResource.assertEquals((int)200, (int)reget.statusCode);
        TestCommentResource.assertNotNull((Object)reget.body);
        this.assertCommentsEqual((Comment)original.body, (Comment)reget.body);
    }

    public void testCanAddCommentWhenNoIssueEditPerm() {
        this.administration.restoreData("TestIssueResourceEditMeta.xml");
        IssueClient issueClient = new IssueClient((JIRAEnvironmentData)this.getEnvironmentData());
        Issue issue = ((IssueClient)issueClient.loginAs("farnsworth")).get("PH-1", new Issue.Expand[]{Issue.Expand.editmeta});
        TestCommentResource.assertNotNull((Object)issue.editmeta);
        TestCommentResource.assertTrue((boolean)issue.editmeta.fields.isEmpty());
        Comment newComment = new Comment();
        newComment.body = "new comment body";
        Response post = ((CommentClient)this.commentClient.loginAs("farnsworth")).post("PH-1", newComment);
        TestCommentResource.assertNotNull((Object)post);
        TestCommentResource.assertEquals((int)201, (int)post.statusCode);
        TestCommentResource.assertNotNull((Object)post.body);
        TestCommentResource.assertEquals((String)"new comment body", (String)((Comment)post.body).body);
        Response reget = ((CommentClient)this.commentClient.loginAs("farnsworth")).get("PH-1", ((Comment)post.body).id);
        this.assertCommentsEqual((Comment)post.body, (Comment)reget.body);
    }

    public void testSettingPropertyDuringCreate() {
        this.administration.restoreBlankInstance();
        this.setupPermissionsToEditComments();
        IssueCreateResponse issue = this.backdoor.issues().createIssue("HSP", "Issue with comments properties");
        Comment comment = new Comment();
        comment.body = "comment with properties";
        HashMap<String, Object> commentPropValue = new HashMap<String, Object>();
        commentPropValue.put("value", "proper-val");
        Comment.CommentProperty commentProperty = new Comment.CommentProperty("key", new JSONObject(commentPropValue).toString());
        comment.properties = Lists.newArrayList((Object[])new Comment.CommentProperty[]{commentProperty});
        Comment commentResponse = (Comment)this.commentClient.post((String)issue.key, (Comment)comment, (String)"properties").body;
        Assert.assertThat((Object)commentResponse.body, (Matcher)Matchers.is((Object)"comment with properties"));
        Assert.assertThat((Object)commentResponse.properties, (Matcher)Matchers.hasItem((Matcher)Matchers.allOf((Matcher)Matchers.hasProperty((String)"key", (Matcher)Matchers.is((Object)"key")), (Matcher)Matchers.hasProperty((String)"value", (Matcher)Matchers.containsString((String)"proper-val")))));
    }

    public void testUpdateCommentWithProperty() {
        this.administration.restoreBlankInstance();
        this.setupPermissionsToEditComments();
        IssueCreateResponse issue = this.backdoor.issues().createIssue("HSP", "Issue with comments properties");
        Comment comment = new Comment();
        comment.body = "comment with properties";
        Comment commentCreateResponse = (Comment)this.commentClient.post((String)issue.key, (Comment)comment, (String)"properties").body;
        Assert.assertThat((Object)commentCreateResponse.body, (Matcher)Matchers.is((Object)"comment with properties"));
        Assert.assertThat((Object)commentCreateResponse.properties, (Matcher)Matchers.hasSize((int)0));
        Comment updatedComment = new Comment();
        updatedComment.body = "comment with updated properties";
        updatedComment.id = commentCreateResponse.id;
        HashMap<String, Object> commentPropValue = new HashMap<String, Object>();
        commentPropValue.put("value", "proper-val");
        Comment.CommentProperty commentProperty = new Comment.CommentProperty("key", new JSONObject(commentPropValue).toString());
        updatedComment.properties = Lists.newArrayList((Object[])new Comment.CommentProperty[]{commentProperty});
        Comment updatedCommentResponse = (Comment)this.commentClient.put((String)issue.key, (Comment)updatedComment, (String)"properties").body;
        Assert.assertThat((Object)updatedCommentResponse.body, (Matcher)Matchers.is((Object)"comment with updated properties"));
        Assert.assertThat((Object)updatedCommentResponse.properties, (Matcher)Matchers.hasItem((Matcher)Matchers.allOf((Matcher)Matchers.hasProperty((String)"key", (Matcher)Matchers.is((Object)"key")), (Matcher)Matchers.hasProperty((String)"value", (Matcher)Matchers.containsString((String)"proper-val")))));
    }

    private void setupPermissionsToEditComments() {
        Long permSchemeId = this.backdoor.permissionSchemes().copyDefaultScheme("comment perm scheme");
        Long projectId = this.backdoor.project().getProjectId("HSP");
        this.backdoor.permissionSchemes().addGroupPermission(permSchemeId, ProjectPermissions.EDIT_ALL_COMMENTS, "jira-users");
        this.backdoor.project().setPermissionScheme(projectId, permSchemeId);
    }

    public void assertCommentsEqual(Comment comment1, Comment comment2) {
        TestCommentResource.assertEquals((String)comment1.self, (String)comment2.self);
        TestCommentResource.assertEquals((String)comment1.id, (String)comment2.id);
        TestCommentResource.assertEquals((String)comment1.body, (String)comment2.body);
        if (comment1.author == null && comment2.author != null || comment1.author != null && comment2.author == null) {
            throw new AssertionFailedError("Authors not the same, one null, the other not");
        }
        if (comment1.author != null && comment2.author != null) {
            TestCommentResource.assertEquals((String)comment1.author.displayName, (String)comment1.author.displayName);
        }
        if (comment1.visibility == null && comment2.visibility != null || comment1.visibility != null && comment2.visibility == null) {
            throw new AssertionFailedError("Visibility not the same, one null, the other not");
        }
        if (comment1.visibility != null && comment2.visibility != null) {
            TestCommentResource.assertEquals((String)comment1.visibility.type, (String)comment2.visibility.type);
            TestCommentResource.assertEquals((String)comment1.visibility.value, (String)comment2.visibility.value);
        }
    }
}

