/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.rest.api.issue.IssueCreateResponse;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Comment;
import com.atlassian.jira.testkit.client.restclient.EntityProperty;
import com.atlassian.jira.testkit.client.restclient.EntityPropertyClient;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.util.PropertyAssertions;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

@WebTest(value={Category.FUNC_TEST, Category.ENTITY_PROPERTIES, Category.REST})
public class TestCommentPropertyResource
extends FuncTestCase {
    public static final String PROPERTY_KEY = "comment.meta";
    public static final String PROJECT_KEY = "HSP";
    private EntityPropertyClient client;

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.client = new EntityPropertyClient((JIRAEnvironmentData)this.environmentData, "comment");
    }

    public void testCreatingNewCommentProperty() {
        this.administration.restoreBlankInstance();
        this.setupPermissionsToEditComments();
        IssueCreateResponse issue = this.backdoor.issues().createIssue(PROJECT_KEY, "Issue with comment");
        final Comment comment = (Comment)this.backdoor.issues().commentIssue((String)issue.key, (String)"comment with property").body;
        Assert.assertThat((Object)this.client.getKeys((String)comment.id).keys, (Matcher)Matchers.empty());
        JSONObject jsonObject = new JSONObject((Map<String, Object>)ImmutableMap.of((Object)"visible", (Object)0));
        this.client.put(comment.id, PROPERTY_KEY, jsonObject);
        EntityProperty entityProperty = this.client.get(comment.id, PROPERTY_KEY);
        Assert.assertThat((Object)entityProperty.key, (Matcher)Matchers.is((Object)PROPERTY_KEY));
        Assert.assertThat((Object)jsonObject, (Matcher)Matchers.is((Object)new JSONObject(entityProperty.value)));
        List keys = this.client.getKeys((String)comment.id).keys;
        Assert.assertThat((Object)keys, (Matcher)Matchers.hasItem(PropertyAssertions.propertyKey(PROPERTY_KEY)));
        PropertyAssertions.assertUniformInterfaceException(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ((EntityPropertyClient)TestCommentPropertyResource.this.client.anonymous()).getKeys(comment.id);
                return null;
            }
        }, Response.Status.UNAUTHORIZED);
        PropertyAssertions.assertUniformInterfaceException(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ((EntityPropertyClient)TestCommentPropertyResource.this.client.anonymous()).get(comment.id, TestCommentPropertyResource.PROPERTY_KEY);
                return null;
            }
        }, Response.Status.UNAUTHORIZED);
    }

    public void testDeletingProperties() {
        this.administration.restoreBlankInstance();
        this.setupPermissionsToEditComments();
        IssueCreateResponse issue = this.backdoor.issues().createIssue(PROJECT_KEY, "Issue with comment");
        final Comment comment = (Comment)this.backdoor.issues().commentIssue((String)issue.key, (String)"comment with property").body;
        Assert.assertThat((Object)this.client.getKeys((String)comment.id).keys, (Matcher)Matchers.empty());
        JSONObject jsonObject = new JSONObject((Map<String, Object>)ImmutableMap.of((Object)"visible", (Object)0));
        this.client.put(comment.id, PROPERTY_KEY, jsonObject);
        EntityProperty entityProperty = this.client.get(comment.id, PROPERTY_KEY);
        Assert.assertThat((Object)entityProperty.key, (Matcher)Matchers.is((Object)PROPERTY_KEY));
        Assert.assertThat((Object)jsonObject, (Matcher)Matchers.is((Object)new JSONObject(entityProperty.value)));
        this.client.delete(comment.id, PROPERTY_KEY);
        Assert.assertThat((Object)this.client.getKeys((String)comment.id).keys, (Matcher)Matchers.empty());
        PropertyAssertions.assertUniformInterfaceException(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TestCommentPropertyResource.this.client.get(comment.id, TestCommentPropertyResource.PROPERTY_KEY);
                return null;
            }
        }, Response.Status.NOT_FOUND);
    }

    public void testForbiddenForUserWithoutPermissionsToProject() {
        this.backdoor.restoreBlankInstance();
        this.administration.usersAndGroups().addUser("bob", "bob", "Bob The Builder", "bob@stuff.com.com");
        IssueCreateResponse issue = this.backdoor.issues().createIssue(PROJECT_KEY, "Issue with comment");
        final Comment comment = (Comment)this.backdoor.issues().commentIssue((String)issue.key, (String)"comment with property").body;
        PropertyAssertions.assertUniformInterfaceException(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ((EntityPropertyClient)TestCommentPropertyResource.this.client.loginAs("bob", "bob")).put(comment.id, TestCommentPropertyResource.PROPERTY_KEY, new JSONObject((Map<String, Object>)ImmutableMap.of((Object)"visible", (Object)0)));
                return null;
            }
        }, Response.Status.FORBIDDEN);
    }

    public void testCommentPropertyRemovedWhenCommentRemoved() {
        this.backdoor.restoreBlankInstance();
        this.setupPermissionsToEditComments();
        this.administration.usersAndGroups().addUser("bob", "bob", "Bob The Builder", "bob@stuff.com.com");
        IssueCreateResponse issue = this.backdoor.issues().createIssue(PROJECT_KEY, "Issue with comment");
        final Comment comment = (Comment)this.backdoor.issues().commentIssue((String)issue.key, (String)"comment with property").body;
        JSONObject jsonObject = new JSONObject((Map<String, Object>)ImmutableMap.of((Object)"visible", (Object)0));
        this.client.put(comment.id, PROPERTY_KEY, jsonObject);
        EntityProperty entityProperty = this.client.get(comment.id, PROPERTY_KEY);
        Assert.assertThat((Object)entityProperty.key, (Matcher)Matchers.is((Object)PROPERTY_KEY));
        Assert.assertThat((Object)jsonObject, (Matcher)Matchers.is((Object)new JSONObject(entityProperty.value)));
        this.backdoor.issues().deleteIssue(issue.key, true);
        PropertyAssertions.assertUniformInterfaceException(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TestCommentPropertyResource.this.client.get(comment.id, TestCommentPropertyResource.PROPERTY_KEY);
                return null;
            }
        }, Response.Status.NOT_FOUND);
    }

    private void setupPermissionsToEditComments() {
        Long permSchemeId = this.backdoor.permissionSchemes().copyDefaultScheme("comment perm scheme");
        Long projectId = this.backdoor.project().getProjectId(PROJECT_KEY);
        this.backdoor.permissionSchemes().addGroupPermission(permSchemeId, ProjectPermissions.EDIT_ALL_COMMENTS, "jira-administrators");
        this.backdoor.project().setPermissionScheme(projectId, permSchemeId);
    }
}

