/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Attachment;
import com.atlassian.jira.testkit.client.restclient.AttachmentClient;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import com.atlassian.jira.testkit.client.restclient.Response;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestAttachmentResource
extends RestFuncTest {
    private AttachmentClient attachmentClient;
    private IssueClient issueClient;

    public void testViewAttachment() throws Exception {
        Issue mky1 = this.issueClient.get("MKY-1", new Issue.Expand[0]);
        Assert.assertThat((Object)mky1.fields.attachment.size(), (Matcher)CoreMatchers.equalTo((Object)3));
        Attachment attachment1 = this.attachmentClient.get("10000");
        TestAttachmentResource.assertEquals((String)(this.getBaseUrl() + "/rest/api/2/attachment/10000"), (String)attachment1.self);
        TestAttachmentResource.assertEquals((String)"attachment.txt", (String)attachment1.filename);
        TestAttachmentResource.assertEquals((String)(this.getBaseUrl() + "/rest/api/2/user?username=admin"), (String)attachment1.author.self);
        TestAttachmentResource.assertEquals((String)"admin", (String)attachment1.author.name);
        TestAttachmentResource.assertEquals((String)"Administrator", (String)attachment1.author.displayName);
        this.assertEqualDateStrings("2010-06-09T15:59:34.602+1000", attachment1.created);
        TestAttachmentResource.assertEquals((long)19L, (long)attachment1.size);
        TestAttachmentResource.assertEquals((String)"text/plain", (String)attachment1.mimeType);
        TestAttachmentResource.assertEquals((String)(this.getBaseUrl() + "/secure/attachment/10000/attachment.txt"), (String)attachment1.content);
        TestAttachmentResource.assertTrue((boolean)((Boolean)attachment1.properties.get("magickey1")));
        TestAttachmentResource.assertEquals((Object)11, attachment1.properties.get("magickey2"));
        TestAttachmentResource.assertEquals((Object)1212121, attachment1.properties.get("magickey3"));
        TestAttachmentResource.assertEquals((Object)3.14, attachment1.properties.get("magickey4"));
        TestAttachmentResource.assertEquals((Object)"Picture of an elephant", attachment1.properties.get("magickey5"));
        TestAttachmentResource.assertEquals((Object)"Picture of an big long elephant", attachment1.properties.get("magickey6"));
        TestAttachmentResource.assertEquals((Object)"2011-07-28T08:31:58.487+1000", attachment1.properties.get("magickey7"));
    }

    public void testViewAttachmentNotFound() throws Exception {
        Response response123 = this.attachmentClient.getResponse("123");
        TestAttachmentResource.assertEquals((int)404, (int)response123.statusCode);
        TestAttachmentResource.assertEquals((int)1, (int)response123.entity.errorMessages.size());
        TestAttachmentResource.assertTrue((boolean)response123.entity.errorMessages.contains("The attachment with id '123' does not exist"));
        Response responseAbc = this.attachmentClient.getResponse("abc");
        TestAttachmentResource.assertEquals((int)404, (int)responseAbc.statusCode);
        TestAttachmentResource.assertEquals((int)1, (int)responseAbc.entity.errorMessages.size());
        TestAttachmentResource.assertTrue((boolean)responseAbc.entity.errorMessages.contains("The attachment with id 'abc' does not exist"));
    }

    public void testViewAttachmentNotAuthorised() throws Exception {
        Response response = ((AttachmentClient)this.attachmentClient.anonymous()).getResponse("10000");
        TestAttachmentResource.assertEquals((int)403, (int)response.statusCode);
        TestAttachmentResource.assertEquals((int)1, (int)response.entity.errorMessages.size());
        TestAttachmentResource.assertTrue((boolean)response.entity.errorMessages.contains("You do not have permission to view attachment with id: 10000"));
    }

    public void testRemoveAttachment() throws Exception {
        Issue mky1 = this.issueClient.get("MKY-1", new Issue.Expand[0]);
        Assert.assertThat((Object)mky1.fields.attachment.size(), (Matcher)CoreMatchers.equalTo((Object)3));
        Attachment attachment1 = this.attachmentClient.get("10000");
        TestAttachmentResource.assertEquals((String)"attachment.txt", (String)attachment1.filename);
        Response response = this.attachmentClient.deleteResponse("10000");
        TestAttachmentResource.assertEquals((int)204, (int)response.statusCode);
        response = this.attachmentClient.getResponse("10000");
        TestAttachmentResource.assertEquals((int)404, (int)response.statusCode);
        mky1 = this.issueClient.get("MKY-1", new Issue.Expand[0]);
        Assert.assertThat((Object)mky1.fields.attachment.size(), (Matcher)CoreMatchers.equalTo((Object)2));
    }

    public void testDeleteAttachmentNotFound() throws Exception {
        Response response123 = this.attachmentClient.deleteResponse("123");
        TestAttachmentResource.assertEquals((int)404, (int)response123.statusCode);
        TestAttachmentResource.assertEquals((int)1, (int)response123.entity.errorMessages.size());
        TestAttachmentResource.assertTrue((boolean)response123.entity.errorMessages.contains("The attachment with id '123' does not exist"));
        Response responseAbc = this.attachmentClient.deleteResponse("abc");
        TestAttachmentResource.assertEquals((int)404, (int)responseAbc.statusCode);
        TestAttachmentResource.assertEquals((int)1, (int)responseAbc.entity.errorMessages.size());
        TestAttachmentResource.assertTrue((boolean)responseAbc.entity.errorMessages.contains("The attachment with id 'abc' does not exist"));
    }

    public void testGetMeta() throws Exception {
        Map responseMeta = this.attachmentClient.getMeta();
        TestAttachmentResource.assertEquals((Object)true, responseMeta.get("enabled"));
        TestAttachmentResource.assertEquals((Object)0xA00000, responseMeta.get("uploadLimit"));
    }

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.issueClient = new IssueClient((JIRAEnvironmentData)this.getEnvironmentData());
        this.attachmentClient = new AttachmentClient((JIRAEnvironmentData)this.getEnvironmentData());
        this.administration.restoreData("TestIssueResourceAttachments.xml");
    }
}

