/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.rest.api.gadget.AdminGadget;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.AdminGadgetClient;

@WebTest(value={Category.FUNC_TEST, Category.REST, Category.GADGETS})
public class TestAdminGadget
extends FuncTestCase {
    private AdminGadgetClient adminGadgetClient;

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.adminGadgetClient = new AdminGadgetClient(this.getEnvironmentData());
    }

    public void testAdminGadgetAfterInstall() {
        this.administration.restoreData("TestAdminGadgetInstall.xml");
        this.executeAdminGadget();
    }

    public void testAdminGadgetAfterUpgrade() {
        this.administration.restoreData("TestAdminGadgetUpdate.xml");
        this.executeAdminGadget();
    }

    private void executeAdminGadget() {
        this.adminGadgetClient.setTaskListDone("gettingstarted");
        this.adminGadgetClient.setTaskListDone("domore");
        AdminGadget adminGadget = this.adminGadgetClient.get();
        assert (adminGadget.tasks.getGettingStarted().isDismissed());
        assert (adminGadget.tasks.getDoMore().isDismissed());
        this.adminGadgetClient.setTaskListUnDone("gettingstarted");
        this.adminGadgetClient.setTaskListUnDone("domore");
        adminGadget = this.adminGadgetClient.get();
        TestAdminGadget.assertFalse((boolean)adminGadget.tasks.getGettingStarted().isDismissed());
        TestAdminGadget.assertFalse((boolean)adminGadget.tasks.getDoMore().isDismissed());
    }
}

