/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.HeaderOnlyWebRequest;
import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.PostMethodWebRequest;
import com.meterware.httpunit.PutMethodWebRequest;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.SAXException;

public abstract class RestFuncTest
extends FuncTestCase {
    private String baseUrl;

    protected RestFuncTest() {
    }

    protected String getBaseUrl() {
        return this.baseUrl;
    }

    protected String getBaseUrlPlus(String ... paths) {
        return this.getBaseUrlPlus(Arrays.asList(paths));
    }

    protected String getBaseUrlPlus(Iterable<String> paths) {
        Iterable pathsNoLeadingSlashes = Iterables.transform(paths, (Function)new Function<String, String>(){

            public String apply(String path) {
                return path.startsWith("/") ? path.substring(1) : path;
            }
        });
        String path = pathsNoLeadingSlashes != null ? StringUtils.join((Collection)Lists.newArrayList((Iterable)pathsNoLeadingSlashes), (char)'/') : "";
        return String.format("%s/%s", this.getBaseUrl(), path);
    }

    protected URI getBaseUriPlus(Iterable<String> paths) {
        try {
            return new URI(this.getBaseUrlPlus(paths));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    protected URI getBaseUriPlus(String ... paths) {
        return this.getBaseUriPlus(Arrays.asList(paths));
    }

    protected String getRestApiUrl(String ... paths) {
        List<String> list = CollectionBuilder.newBuilder("rest", "api", "2").addAll(paths).asList();
        return this.getBaseUrlPlus(list);
    }

    protected URI getRestApiUri(String ... paths) {
        return this.getRestApiUri(Arrays.asList(paths));
    }

    protected URI getRestApiUri(Iterable<String> paths) {
        ArrayList all = Lists.newArrayList((Object[])new String[]{"rest", "api", "2"});
        all.addAll(Lists.newArrayList(paths));
        return this.getBaseUriPlus(all);
    }

    public JSONObject getJSON(String url, String ... expand) throws JSONException {
        String queryString = expand != null && expand.length > 0 ? "?expand=" + StringUtils.join((Object[])expand, (char)',') : "";
        this.tester.gotoPage(url + queryString);
        return new JSONObject(this.tester.getDialog().getResponseText());
    }

    public WebResponse GET(String url) throws IOException, SAXException {
        return this.GET(url, Collections.emptyMap());
    }

    public WebResponse GET(String url, Map<String, String> headers) throws IOException, SAXException {
        this.tester.getDialog().getWebClient().setExceptionsThrownOnErrorStatus(false);
        HttpUnitOptions.setExceptionsThrownOnErrorStatus((boolean)false);
        for (Map.Entry<String, String> headerField : headers.entrySet()) {
            this.tester.getDialog().getWebClient().setHeaderField(headerField.getKey(), headerField.getValue());
        }
        GetMethodWebRequest request = new GetMethodWebRequest(this.getBaseUrlPlus(url));
        return this.tester.getDialog().getWebClient().sendRequest((WebRequest)request);
    }

    public WebResponse DELETE(String url) throws IOException, SAXException {
        this.tester.getDialog().getWebClient().setExceptionsThrownOnErrorStatus(false);
        HttpUnitOptions.setExceptionsThrownOnErrorStatus((boolean)false);
        HeaderOnlyWebRequest delete = new HeaderOnlyWebRequest(this.getBaseUrlPlus(url)){

            public String getMethod() {
                return "DELETE";
            }

            protected void completeRequest(URLConnection connection) throws IOException {
                ((HttpURLConnection)connection).setRequestMethod(this.getMethod());
                super.completeRequest(connection);
            }
        };
        return this.tester.getDialog().getWebClient().sendRequest((WebRequest)delete);
    }

    public WebResponse POST(String url, JSONObject json) throws IOException, SAXException {
        return this.POST(url, json.toString());
    }

    public WebResponse POST(String url, String postBody) throws IOException, SAXException {
        this.tester.getDialog().getWebClient().setExceptionsThrownOnErrorStatus(false);
        HttpUnitOptions.setExceptionsThrownOnErrorStatus((boolean)false);
        PostMethodWebRequest request = new PostMethodWebRequest(this.getBaseUrlPlus(url), (InputStream)new ByteArrayInputStream(postBody.getBytes()), "application/json");
        return this.tester.getDialog().getWebClient().sendRequest((WebRequest)request);
    }

    public WebResponse PUT(String url, JSONObject json) throws IOException, SAXException {
        return this.PUT(url, json.toString());
    }

    public WebResponse PUT(String url, String postBody) throws IOException, SAXException {
        this.tester.getDialog().getWebClient().setExceptionsThrownOnErrorStatus(false);
        HttpUnitOptions.setExceptionsThrownOnErrorStatus((boolean)false);
        PutMethodWebRequest request = new PutMethodWebRequest(this.getBaseUrlPlus(url), (InputStream)new ByteArrayInputStream(postBody.getBytes()), "application/json");
        return this.tester.getDialog().getWebClient().sendRequest((WebRequest)request);
    }

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.baseUrl = this.getEnvironmentData().getBaseUrl().toExternalForm();
    }

    @Override
    protected void setUpHttpUnitOptions() {
        HttpUnitOptions.setDefaultCharacterSet((String)"UTF-8");
    }

    @Override
    protected void tearDownTest() {
        HttpUnitOptions.resetDefaultCharacterSet();
        super.tearDownTest();
    }

    protected void assertEqualDateStrings(String expected, String actual) {
        String[] expected_split = expected.split("(\\+|\\-)\\d{4}$");
        String[] actual_split = actual.split("(\\+|\\-)\\d{4}$");
        RestFuncTest.assertEquals((String)expected_split[0], (String)actual_split[0]);
    }

    @Override
    protected boolean isDumpHTML() {
        return false;
    }
}

