/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.applinks;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rules.RestRule;
import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.jira.util.json.JSONObject;
import com.meterware.httpunit.WebResponse;
import java.util.ArrayList;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebTest(value={Category.FUNC_TEST, Category.APP_LINKS})
public class TestAppLinksHostApplication
extends FuncTestCase {
    private static final String FUNC_TEST_PLUGIN_NAME = "com.atlassian.jira.dev.func-test-plugin";
    private static final String PROJECT_ENTITY_TYPE_NAME = "com.atlassian.applinks.api.application.jira.JiraProjectEntityType";
    private static final Logger log = LoggerFactory.getLogger(TestAppLinksHostApplication.class);
    private RestRule restRule;

    public void testDocumentationBaseUrlShouldPointToAppLinksDocs() throws Exception {
        if (!this.isBackdoorAvailable()) {
            return;
        }
        WebResponse docBaseUrl = this.restRule.GET("rest/func-test/1.0/applinks/getDocumentationBaseUrl");
        Assert.assertThat((Object)docBaseUrl.getText(), (Matcher)CoreMatchers.equalTo((Object)"http://confluence.atlassian.com/display/APPLINKS"));
    }

    public void testApplicationNameShouldReturnJiraName() throws Exception {
        if (!this.isBackdoorAvailable()) {
            return;
        }
        WebResponse name = this.restRule.GET("rest/func-test/1.0/applinks/getName");
        Assert.assertThat((Object)name.getText(), (Matcher)CoreMatchers.equalTo((Object)"jWebTest JIRA installation"));
    }

    public void testApplicationTypeShouldReturnJira() throws Exception {
        if (!this.isBackdoorAvailable()) {
            return;
        }
        WebResponse name = this.restRule.GET("rest/func-test/1.0/applinks/getType");
        JSONObject type = new JSONObject(name.getText());
        Assert.assertThat((Object)type.getString("i18nKey"), (Matcher)CoreMatchers.equalTo((Object)"applinks.jira"));
    }

    public void testLocalEntitiesShouldReturnAllProjects() throws Exception {
        if (!this.isBackdoorAvailable()) {
            return;
        }
        WebResponse response = this.restRule.GET("rest/func-test/1.0/applinks/getLocalEntities");
        JSONArray entities = new JSONObject(response.getText()).getJSONArray("entities");
        Assert.assertThat((Object)entities.length(), (Matcher)CoreMatchers.equalTo((Object)2));
        ArrayList<String> projectKeys = new ArrayList<String>();
        for (int i = 0; i < entities.length(); ++i) {
            JSONObject project = entities.getJSONObject(i);
            projectKeys.add(project.getString("key"));
        }
        Assert.assertThat(projectKeys, (Matcher)Matchers.hasItems((Object[])new String[]{"HSP", "MKY"}));
    }

    public void testHasPublicSignup() throws Exception {
        if (!this.isBackdoorAvailable()) {
            return;
        }
        WebResponse response = this.restRule.GET("rest/func-test/1.0/applinks/hasPublicSignup");
        Assert.assertThat((Object)response.getText(), (Matcher)CoreMatchers.equalTo((Object)"true"));
    }

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.restRule = new RestRule(this);
        this.restRule.before();
        this.administration.restoreBlankInstance();
        this.navigation.gotoAdmin();
    }

    @Override
    public void tearDownTest() {
        this.restRule.after();
    }

    protected final boolean isBackdoorAvailable() {
        boolean available = this.administration.plugins().isPluginInstalled(FUNC_TEST_PLUGIN_NAME);
        if (!available) {
            log.info(String.format("Plugin '%s' is not installed", FUNC_TEST_PLUGIN_NAME));
        }
        return available;
    }
}

