/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bulk;

import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.JIRAWebTest;

@WebTest(value={Category.FUNC_TEST, Category.BULK_OPERATIONS})
public class TestBulkOperationsIndexing
extends JIRAWebTest {
    public TestBulkOperationsIndexing(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.restoreData("TestBulkOperationsIndexing.xml");
    }

    public void testBulkEditIndexing() {
        this.findAndVerifyIssuesArePresent(false);
        this.navigation.issueNavigator().bulkChange(IssueNavigatorNavigation.BulkChangeOption.ALL_PAGES);
        this.checkCheckbox("bulkedit_10003", "on");
        this.checkCheckbox("bulkedit_10002", "on");
        this.checkCheckbox("bulkedit_10001", "on");
        this.checkCheckbox("bulkedit_10000", "on");
        this.submit("Next");
        this.checkCheckbox("operation", "bulk.edit.operation.name");
        this.submit("Next");
        this.checkCheckbox("actions", "comment");
        this.setFormElement("comment", "whatsminesay");
        this.submit("Next");
        this.submit("Confirm");
        this.waitAndReloadBulkOperationProgressPage();
        this.navigation.issueNavigator().createSearch("comment~whatsminesay");
        this.assertTextPresent("HSP-1");
        this.assertTextPresent("HSP-2");
        this.assertTextPresent("Test issue 1");
        this.assertTextPresent("Test Issue 2");
        this.assertTextPresent("HSP-3");
        this.assertTextPresent("HSP-4");
        this.assertTextPresent("Subtask 1");
        this.assertTextPresent("Subtask 2");
    }

    public void testBulkMoveIndexing() {
        this.findAndVerifyIssuesArePresent(true);
        this.navigation.issueNavigator().bulkChange(IssueNavigatorNavigation.BulkChangeOption.ALL_PAGES);
        this.checkCheckbox("bulkedit_10003", "on");
        this.checkCheckbox("bulkedit_10002", "on");
        this.checkCheckbox("bulkedit_10001", "on");
        this.checkCheckbox("bulkedit_10000", "on");
        this.checkCheckbox("bulkedit_10010", "on");
        this.submit("Next");
        this.checkCheckbox("operation", "bulk.move.operation.name");
        this.submit("Next");
        this.navigation.issue().selectProject("monkey", "10010_1_pid");
        this.submit("Next");
        this.submit("Next");
        this.submit("Next");
        this.submit("Next");
        this.submit("Next");
        this.waitAndReloadBulkOperationProgressPage();
        this.navigation.issueNavigator().createSearch("project=monkey");
        this.assertTextPresent("MKY-1");
        this.assertTextPresent("MKY-2");
        this.assertTextPresent("MKY-3");
        this.assertTextPresent("Test issue 1");
        this.assertTextPresent("Test Issue 2");
        this.assertTextPresent("MKY-4");
        this.assertTextPresent("MKY-5");
        this.assertTextPresent("Subtask 1");
        this.assertTextPresent("Subtask 2");
        this.assertTextPresent("Test Monkey Issue 1");
        this.navigation.issueNavigator().createSearch("project=homosapian");
        this.assertElementNotPresent("issuetable");
    }

    public void testBulkWorkflowTransitionIndexing() {
        this.findAndVerifyIssuesArePresent(true);
        this.navigation.issueNavigator().bulkChange(IssueNavigatorNavigation.BulkChangeOption.ALL_PAGES);
        this.checkCheckbox("bulkedit_10003", "on");
        this.checkCheckbox("bulkedit_10002", "on");
        this.checkCheckbox("bulkedit_10001", "on");
        this.checkCheckbox("bulkedit_10000", "on");
        this.checkCheckbox("bulkedit_10010", "on");
        this.submit("Next");
        this.checkCheckbox("operation", "bulk.workflowtransition.operation.name");
        this.submit("Next");
        this.checkCheckbox("wftransition", "classic default workflow_5_5");
        this.submit("Next");
        this.selectOption("resolution", "Fixed");
        this.submit("Next");
        this.submit("Next");
        this.waitAndReloadBulkOperationProgressPage();
        this.navigation.issueNavigator().createSearch("resolution=Fixed AND status = Resolved");
        this.assertTextPresent("HSP-1");
        this.assertTextPresent("HSP-2");
        this.assertTextPresent("Test issue 1");
        this.assertTextPresent("Test Issue 2");
        this.assertTextPresent("HSP-3");
        this.assertTextPresent("HSP-4");
        this.assertTextPresent("Subtask 1");
        this.assertTextPresent("Subtask 2");
        this.assertTextPresent("MKY-1");
        this.assertTextPresent("Test Monkey Issue 1");
    }

    private void findAndVerifyIssuesArePresent(boolean all) {
        if (!all) {
            this.navigation.issueNavigator().createSearch("project=homosapien");
        } else {
            this.navigation.issueNavigator().displayAllIssues();
        }
        this.assertTextPresent("HSP-1");
        this.assertTextPresent("HSP-2");
        this.assertTextPresent("Test issue 1");
        this.assertTextPresent("Test Issue 2");
        this.assertTextPresent("HSP-3");
        this.assertTextPresent("HSP-4");
        this.assertTextPresent("Subtask 1");
        this.assertTextPresent("Subtask 2");
        if (all) {
            this.assertTextPresent("MKY-1");
            this.assertTextPresent("Test Monkey Issue 1");
        }
    }
}

