/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bulk;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import java.net.URL;
import java.net.URLEncoder;

@WebTest(value={Category.FUNC_TEST, Category.BULK_OPERATIONS, Category.ISSUES})
public class TestBulkOperationRedirections
extends FuncTestCase {
    private static final int HSP_2_ID = 10020;
    private String returnUrl;

    @Override
    public void setUpTest() {
        this.administration.restoreData("TestBulkEditIssues.xml");
        this.returnUrl = "/secure/AboutPage.jspa";
    }

    public void testFlowForBulkMigrateWithRedirect() throws Exception {
        this.gotoPageWithReturnUrl("/views/bulkedit/BulkMigrateDetails.jspa?singleIssueId=10020");
        this.getTester().assertSubmitButtonPresent("Next");
        this.getTester().assertLinkPresent("cancel");
        this.getTester().clickLink("cancel");
        this.assertAtPage(this.returnUrl);
        this.gotoPageWithReturnUrl("/views/bulkedit/BulkMigrateDetails.jspa?singleIssueId=10020");
        this.getTester().submit("Next");
        this.assertNotAtPage(this.returnUrl);
        this.assertAtPage("BulkMigrateSetFields!default.jspa");
        this.getTester().assertSubmitButtonPresent("Next");
        this.getTester().assertLinkPresent("cancel");
        this.getTester().clickLink("cancel");
        this.assertAtPage(this.returnUrl);
    }

    private void gotoPageWithReturnUrl(String url) throws Exception {
        this.getTester().gotoPage(url + "&returnUrl=" + URLEncoder.encode(this.returnUrl, "UTF-8"));
    }

    private void assertAtPage(String page) {
        this.getAssertions().getTextAssertions().assertTextPresent(this.getUrl().getPath(), page);
    }

    private void assertNotAtPage(String page) {
        this.getAssertions().getTextAssertions().assertTextNotPresent(this.getUrl().getPath(), page);
    }

    private URL getUrl() {
        return this.getTester().getDialog().getResponse().getURL();
    }
}

