/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bulk;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.JIRAWebTest;
import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.WebForm;
import com.meterware.httpunit.WebTable;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.BULK_OPERATIONS, Category.FIELDS})
public class TestBulkOperationCustomField
extends JIRAWebTest {
    private static final String TABLE_EDITFIELDS_ID = "screen-tab-1-editfields";
    private static final String CHANGE_CF_FOR_PROJECT_A = "Change CF for project A";
    private static final String CHANGE_CF_FOR_PROJECT_B = "Change CF for project B";
    private static final String FIELD_NOT_AVAILABLE = "The field is not available for all issues with the same configuration.";
    private static final String TABLE_UNAVAILABLE_ACTIONS_ID = "unavailableActionsTable";

    public TestBulkOperationCustomField(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.restoreData("TestBulkOperationCustomField.xml");
        HttpUnitOptions.setScriptingEnabled((boolean)true);
    }

    @Override
    public void tearDown() {
        this.restoreBlankInstance();
        super.tearDown();
    }

    public void testBulkEdit() {
        this.displayAllIssues();
        this.bulkChangeIncludeAllPages();
        this.selectAllIssuesToEdit();
        this.submit("Next");
        this.checkCheckbox("operation", "bulk.edit.operation.name");
        this.assertRadioOptionSelected("operation", "bulk.edit.operation.name");
        this.submit("Next");
        this.assertTextNotInElement(TABLE_UNAVAILABLE_ACTIONS_ID, CHANGE_CF_FOR_PROJECT_A);
        this.assertTextNotInElement(TABLE_UNAVAILABLE_ACTIONS_ID, CHANGE_CF_FOR_PROJECT_B);
        this.assertTextNotInElement(TABLE_UNAVAILABLE_ACTIONS_ID, FIELD_NOT_AVAILABLE);
    }

    private void selectAllIssuesToEdit() {
        String[] parameterNames;
        this.tester.setWorkingForm("bulkedit");
        WebForm form = this.tester.getDialog().getForm();
        for (String name : parameterNames = form.getParameterNames()) {
            if (!name.startsWith("bulkedit_")) continue;
            this.checkCheckbox(name);
        }
    }

    public void testBulkTransition() {
        this.displayAllIssues();
        this.bulkChangeIncludeAllPages();
        this.selectAllIssuesToEdit();
        this.submit("Next");
        this.checkCheckbox("operation", "bulk.workflowtransition.operation.name");
        this.assertRadioOptionSelected("operation", "bulk.workflowtransition.operation.name");
        this.submit("Next");
        this.checkCheckbox("wftransition", "classic default workflow_5_5");
        this.submit("Next");
        try {
            WebTable editFieldsTable = this.getDialog().getResponse().getTableWithID(TABLE_EDITFIELDS_ID);
            this.assertTextInTable(TABLE_EDITFIELDS_ID, CHANGE_CF_FOR_PROJECT_A);
            this.assertTextInTable(TABLE_EDITFIELDS_ID, CHANGE_CF_FOR_PROJECT_B);
            this.assertTextInTable(TABLE_EDITFIELDS_ID, FIELD_NOT_AVAILABLE);
            for (int i = 0; i < editFieldsTable.getRowCount(); ++i) {
                String field = editFieldsTable.getCellAsText(i, 1).trim();
                if (field.equals(CHANGE_CF_FOR_PROJECT_A)) {
                    TestBulkOperationCustomField.assertTrue((editFieldsTable.getCellAsText(i, 2).trim().indexOf(FIELD_NOT_AVAILABLE) != -1 ? 1 : 0) != 0);
                    continue;
                }
                if (!field.equals(CHANGE_CF_FOR_PROJECT_B)) continue;
                TestBulkOperationCustomField.assertTrue((editFieldsTable.getCellAsText(i, 2).trim().indexOf(FIELD_NOT_AVAILABLE) != -1 ? 1 : 0) != 0);
            }
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }
}

