/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bulk;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.webtests.JIRAWebTest;

@WebTest(value={Category.FUNC_TEST, Category.BULK_OPERATIONS})
public class TestBulkMoveWithMultiContexts
extends JIRAWebTest {
    public TestBulkMoveWithMultiContexts(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.restoreData("IssuesWithSubTasksWorkflowScheme.xml");
    }

    public void testBulkMoveWithMultiContexts() throws Exception {
        this.administration.addGlobalPermission(GlobalPermissionKey.BULK_CHANGE, "jira-users");
        this.displayAllIssues();
        this.bulkChangeIncludeAllPages();
        this.bulkChangeChooseIssuesAll();
        this.clickOnNext();
        this.checkCheckbox("operation", "bulk.move.operation.name");
        this.clickOnNext();
        this.assertTextPresent("Select Projects and Issue Types");
        this.navigation.issue().selectProject("monkey", "10000_1_pid");
        this.clickOnNext();
        this.assertTextPresent("Select Projects and Issue Types for Sub-Tasks");
        this.assertTextPresent("Super Sub Task");
        this.assertTextPresent("Mega Sub Task");
        this.navigation.issue().selectIssueType("Sub-task", "10000_6_10001_issuetype");
        this.navigation.issue().selectIssueType("Sub-task", "10000_7_10001_issuetype");
        this.clickOnNext();
        this.assertTextPresent("Map Status for Target Project 'monkey' - Issue Type 'Bug'");
        this.selectOption("10000", "Open");
        this.clickOnNext();
        this.assertTextPresent("All field values will be retained");
        this.clickOnNext();
        this.assertTextPresent("Map Status for Target Project 'monkey' - Issue Type 'Sub-task'");
        this.assertTextPresentBeforeText("Current Status", "Mega Open");
        this.assertTextPresentBeforeText("Current Status", "Super Open");
        this.clickOnNext();
        this.assertTextPresent("All field values will be retained");
        this.clickOnNext();
        this.assertTextPresent("Confirmation");
        this.clickOnNext();
        this.waitAndReloadBulkOperationProgressPage();
        this.assertTextPresent("Issue Navigator");
        this.assertTextPresent("MKY-1");
        this.clickLinkWithText("MKY-1");
        this.assertTextPresentBeforeText("Status", "Open");
        this.clickLinkWithText("Super Sub Task Issue");
        this.assertTextPresentBeforeText("Type", "Sub-task");
        this.assertTextPresentBeforeText("Status", "Open");
        this.assertTextPresent("monkey");
        this.administration.removeGlobalPermission(GlobalPermissionKey.BULK_CHANGE, "jira-users");
    }

    public void testBulkMoveIssueWithoutVersionPermission() {
        this.restoreData("TestMoveIssueWithoutVersionPermission.xml");
        this.gotoIssue("HSP-1");
        this.tester.assertTextPresent("Test issue 1");
        this.tester.assertTextPresent("New Version 1");
        this.tester.assertTextPresent("New Version 4");
        this.displayAllIssues();
        this.bulkChangeIncludeAllPages();
        this.tester.checkCheckbox("bulkedit_10000", "on");
        this.tester.submit("Next");
        this.tester.checkCheckbox("operation", "bulk.move.operation.name");
        this.tester.submit("Next");
        this.navigation.issue().selectProject("monkey", "10000_1_pid");
        this.tester.submit("Next");
        this.assertTextSequence(new String[]{"Fix Version/s", "The value of this field must be changed to be valid in the target project, but you are not able to update this field in the target project. It will be set to the field's default value for the affected issues."});
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.waitAndReloadBulkOperationProgressPage();
        this.tester.clickLinkWithText("MKY-1");
        this.tester.assertTextPresent("Test issue 1");
        this.tester.assertTextNotPresent("New Version 1");
        this.tester.assertTextNotPresent("New Version 4");
    }
}

