/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bulk;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.assertions.ViewIssueAssertions;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;

@WebTest(value={Category.FUNC_TEST, Category.BULK_OPERATIONS, Category.ISSUES})
public class TestBulkMoveMappingVersionsAndComponents
extends FuncTestCase {
    private static final String BULK_EDIT_KEY = "10000_1_";
    private static final String UNKNOWN = "Unknown";

    public void testBulkMoveDistinctValuesMapped() throws Exception {
        this.administration.restoreData("TestBulkMoveMappingVersionsAndComponents.xml");
        String hsp1 = this.navigation.issue().createIssue("homosapien", "Bug", "first issue");
        this.navigation.issue().setAffectsVersions(hsp1, "New Version 1", "New Version 2");
        this.navigation.issue().setFixVersions(hsp1, "New Version 1", "New Version 3");
        this.navigation.issue().setComponents(hsp1, "New Component 1", "New Component 2");
        this.navigation.issue().setIssueMultiSelectField(hsp1, "customfield_10003", "New Version 1", "New Version 5");
        String hsp2 = this.navigation.issue().createIssue("homosapien", "Bug", "second issue");
        this.navigation.issue().setAffectsVersions(hsp2, "New Version 1", "New Version 3");
        this.navigation.issue().setFixVersions(hsp2, "New Version 1", "New Version 4");
        this.navigation.issue().setComponents(hsp2, "New Component 1", "New Component 3");
        this.navigation.issue().setIssueMultiSelectField(hsp2, "customfield_10003", "New Version 2");
        String mky1 = this.navigation.issue().createIssue("monkey", "Bug", "third issue");
        this.navigation.issue().setAffectsVersions(mky1, "New Version 3");
        this.navigation.issue().setFixVersions(mky1, "New Version 5");
        this.navigation.issue().setComponents(mky1, "New Component 4");
        this.navigation.issue().setIssueMultiSelectField(mky1, "customfield_10003", "New Version 6");
        this.bulkMoveAllIssuesToProject("monkey");
        this.assertDefaultOption("fixVersions", "10000", UNKNOWN);
        this.assertDefaultOption("fixVersions", "10003", "New Version 3");
        this.assertDefaultOption("fixVersions", "10004", UNKNOWN);
        this.assertDefaultOption("versions", "10000", UNKNOWN);
        this.assertDefaultOption("versions", "10001", UNKNOWN);
        this.assertDefaultOption("versions", "10003", "New Version 3");
        this.assertDefaultOption("components", "10000", UNKNOWN);
        this.assertDefaultOption("components", "10001", UNKNOWN);
        this.assertDefaultOption("components", "10002", "New Component 3");
        this.assertDefaultOption("customfield_10003", "10000", UNKNOWN);
        this.assertDefaultOption("customfield_10003", "10001", UNKNOWN);
        this.assertDefaultOption("customfield_10003", "10005", "New Version 5");
        this.tester.selectOption("fixVersions_10000", "New Version 5");
        this.tester.selectOption("fixVersions_10004", "New Version 6");
        this.tester.selectOption("versions_10000", "New Version 5");
        this.tester.selectOption("versions_10001", "New Version 6");
        this.tester.selectOption("components_10000", "New Component 4");
        this.tester.selectOption("components_10001", "New Component 4");
        this.tester.selectOption("customfield_10003_10000", "New Version 5");
        this.tester.selectOption("customfield_10003_10001", "New Version 6");
        this.completeBulkMoveWizard();
        this.waitAndReloadBulkOperationProgressPage();
        this.assertIssueValuesAfterMove("MKY-1", "New Version 3", "New Version 5", "New Component 4", "New Version 6");
        String firstIssueKey = this.oldway_consider_porting.getIssueKeyWithSummary("first issue", "MKY");
        this.assertIssueValuesAfterMove(firstIssueKey, "New Version 5, New Version 6", "New Version 3, New Version 5", "New Component 4", "New Version 5");
        String secondIssueKey = this.oldway_consider_porting.getIssueKeyWithSummary("second issue", "MKY");
        this.assertIssueValuesAfterMove(secondIssueKey, "New Version 3, New Version 5", "New Version 5, New Version 6", "New Component 3, New Component 4", "New Version 6");
    }

    public void testBulkMoveWithUserCFType() throws Exception {
        this.administration.restoreData("TestBulkMoveMappingVersionsAndComponentsAndUsers.xml");
        String hsp1 = this.navigation.issue().createIssue("homosapien", "Bug", "first issue");
        this.navigation.issue().setAffectsVersions(hsp1, "New Version 1", "New Version 2");
        this.navigation.issue().setFixVersions(hsp1, "New Version 1", "New Version 3");
        this.navigation.issue().setComponents(hsp1, "New Component 1", "New Component 2");
        this.navigation.issue().setIssueMultiSelectField(hsp1, "customfield_10003", "New Version 1", "New Version 5");
        this.navigation.issue().setFreeTextCustomField(hsp1, "customfield_10010", "admin");
        String hsp2 = this.navigation.issue().createIssue("homosapien", "Bug", "second issue");
        this.navigation.issue().setAffectsVersions(hsp2, "New Version 1", "New Version 3");
        this.navigation.issue().setFixVersions(hsp2, "New Version 1", "New Version 4");
        this.navigation.issue().setComponents(hsp2, "New Component 1", "New Component 3");
        this.navigation.issue().setIssueMultiSelectField(hsp2, "customfield_10003", "New Version 2");
        this.bulkMoveAllIssuesToProject("monkey");
        this.assertDefaultOption("fixVersions", "10000", UNKNOWN);
        this.assertDefaultOption("fixVersions", "10003", "New Version 3");
        this.assertDefaultOption("fixVersions", "10004", UNKNOWN);
        this.assertDefaultOption("versions", "10000", UNKNOWN);
        this.assertDefaultOption("versions", "10001", UNKNOWN);
        this.assertDefaultOption("versions", "10003", "New Version 3");
        this.assertDefaultOption("components", "10000", UNKNOWN);
        this.assertDefaultOption("components", "10001", UNKNOWN);
        this.assertDefaultOption("components", "10002", "New Component 3");
        this.assertDefaultOption("customfield_10003", "10000", UNKNOWN);
        this.assertDefaultOption("customfield_10003", "10001", UNKNOWN);
        this.assertDefaultOption("customfield_10003", "10005", "New Version 5");
        this.tester.selectOption("fixVersions_10000", "New Version 5");
        this.tester.selectOption("fixVersions_10004", "New Version 6");
        this.tester.selectOption("versions_10000", "New Version 5");
        this.tester.selectOption("versions_10001", "New Version 6");
        this.tester.selectOption("components_10000", "New Component 4");
        this.tester.selectOption("components_10001", "New Component 4");
        this.tester.selectOption("customfield_10003_10000", "New Version 5");
        this.tester.selectOption("customfield_10003_10001", "New Version 6");
        this.tester.setFormElement("customfield_10010", "admin");
        this.completeBulkMoveWizard();
        this.waitAndReloadBulkOperationProgressPage();
        String firstIssueKey = this.oldway_consider_porting.getIssueKeyWithSummary("first issue", "MKY");
        this.assertIssueValuesAfterMoveWithUserPicker(firstIssueKey, "New Version 5, New Version 6", "New Version 3, New Version 5", "New Component 4", "Administrator", "New Version 5");
        String secondIssueKey = this.oldway_consider_porting.getIssueKeyWithSummary("second issue", "MKY");
        this.assertIssueValuesAfterMoveWithUserPicker(secondIssueKey, "New Version 3, New Version 5", "New Version 5, New Version 6", "New Component 3, New Component 4", "Administrator", "New Version 6");
    }

    public void testBulkMoveTwoContextsDifferentMappings() throws Exception {
        this.administration.restoreData("TestBulkMoveMappingVersionsAndComponents.xml");
        String hsp1 = this.navigation.issue().createIssue("homosapien", "Bug", "first issue");
        this.navigation.issue().setAffectsVersions(hsp1, "New Version 1", "New Version 2", "New Version 3");
        this.navigation.issue().setFixVersions(hsp1, "New Version 1", "New Version 2", "New Version 3");
        this.navigation.issue().setComponents(hsp1, "New Component 1", "New Component 2", "New Component 3");
        this.navigation.issue().setIssueMultiSelectField(hsp1, "customfield_10003", "New Version 1", "New Version 2", "New Version 5");
        String hsp2 = this.navigation.issue().createIssue("homosapien", "New Feature", "second issue");
        this.navigation.issue().setAffectsVersions(hsp2, "New Version 1", "New Version 2", "New Version 3");
        this.navigation.issue().setFixVersions(hsp2, "New Version 1", "New Version 2", "New Version 3");
        this.navigation.issue().setComponents(hsp2, "New Component 1", "New Component 2", "New Component 3");
        this.navigation.issue().setIssueMultiSelectField(hsp2, "customfield_10003", "New Version 1", "New Version 2", "New Version 5");
        this.navigation.issueNavigator().createSearch("project = HSP");
        this.oldway_consider_porting.bulkChangeIncludeAllPages();
        this.oldway_consider_porting.bulkChangeChooseIssuesAll();
        this.oldway_consider_porting.chooseOperationBulkMove();
        this.isStepSelectProjectIssueType();
        this.navigation.issue().selectProject("monkey", "10000_1_pid");
        this.navigation.issue().selectProject("monkey", "10000_2_pid");
        this.navigation.clickOnNext();
        this.isStepSetFields();
        this.assertDefaultOption("fixVersions", "10000", UNKNOWN);
        this.assertDefaultOption("fixVersions", "10001", UNKNOWN);
        this.assertDefaultOption("fixVersions", "10003", "New Version 3");
        this.assertDefaultOption("versions", "10000", UNKNOWN);
        this.assertDefaultOption("versions", "10001", UNKNOWN);
        this.assertDefaultOption("versions", "10003", "New Version 3");
        this.assertDefaultOption("components", "10000", UNKNOWN);
        this.assertDefaultOption("components", "10001", UNKNOWN);
        this.assertDefaultOption("components", "10002", "New Component 3");
        this.assertDefaultOption("customfield_10003", "10000", UNKNOWN);
        this.assertDefaultOption("customfield_10003", "10001", UNKNOWN);
        this.assertDefaultOption("customfield_10003", "10005", "New Version 5");
        this.tester.selectOption("fixVersions_10000", "New Version 5");
        this.tester.selectOption("fixVersions_10001", "New Version 5");
        this.tester.selectOption("fixVersions_10003", "New Version 6");
        this.tester.selectOption("versions_10000", "New Version 5");
        this.tester.selectOption("versions_10001", "New Version 6");
        this.tester.selectOption("versions_10003", UNKNOWN);
        this.tester.selectOption("components_10001", "New Component 4");
        this.tester.selectOption("customfield_10003_10000", "New Version 5");
        this.tester.selectOption("customfield_10003_10001", "New Version 5");
        this.tester.selectOption("customfield_10003_10005", "New Version 6");
        this.navigation.clickOnNext();
        this.assertDefaultOption("fixVersions", "10000", "New Version 5");
        this.assertDefaultOption("fixVersions", "10001", "New Version 5");
        this.assertDefaultOption("fixVersions", "10003", "New Version 6");
        this.assertDefaultOption("versions", "10000", "New Version 5");
        this.assertDefaultOption("versions", "10001", "New Version 6");
        this.assertDefaultOption("versions", "10003", UNKNOWN);
        this.assertDefaultOption("components", "10000", UNKNOWN);
        this.assertDefaultOption("components", "10001", "New Component 4");
        this.assertDefaultOption("components", "10002", "New Component 3");
        this.assertDefaultOption("customfield_10003", "10000", "New Version 5");
        this.assertDefaultOption("customfield_10003", "10001", "New Version 5");
        this.assertDefaultOption("customfield_10003", "10005", "New Version 6");
        this.tester.selectOption("fixVersions_10000", UNKNOWN);
        this.tester.selectOption("versions_10000", UNKNOWN);
        this.tester.selectOption("customfield_10003_10001", "New Version 3");
        this.navigation.clickOnNext();
        this.oldway_consider_porting.isStepConfirmation();
        this.assertConfirmationMapping(BULK_EDIT_KEY, "fixVersions", "New Version 1", "New Version 5", "New Version 2", "New Version 5", "New Version 3", "New Version 6");
        this.assertConfirmationMapping(BULK_EDIT_KEY, "versions", "New Version 1", "New Version 5", "New Version 2", "New Version 6", "New Version 3", UNKNOWN);
        this.assertConfirmationMapping(BULK_EDIT_KEY, "components", "New Component 1", UNKNOWN, "New Component 2", "New Component 4", "New Component 3", "New Component 3");
        this.assertConfirmationMapping(BULK_EDIT_KEY, "customfield_10003", "New Version 1", "New Version 5", "New Version 2", "New Version 5", "New Version 5", "New Version 6");
        this.assertConfirmationMapping("10000_2_", "fixVersions", "New Version 1", UNKNOWN, "New Version 2", "New Version 5", "New Version 3", "New Version 6");
        this.assertConfirmationMapping("10000_2_", "versions", "New Version 1", UNKNOWN, "New Version 2", "New Version 6", "New Version 3", UNKNOWN);
        this.assertConfirmationMapping("10000_2_", "components", "New Component 1", UNKNOWN, "New Component 2", "New Component 4", "New Component 3", "New Component 3");
        this.assertConfirmationMapping("10000_2_", "customfield_10003", "New Version 1", "New Version 5", "New Version 2", "New Version 3", "New Version 5", "New Version 6");
        this.navigation.clickOnNext();
        this.waitAndReloadBulkOperationProgressPage();
        String firstIssueKey = this.oldway_consider_porting.getIssueKeyWithSummary("first issue", "MKY");
        this.assertIssueValuesAfterMove(firstIssueKey, "New Version 5, New Version 6", "New Version 5, New Version 6", "New Component 3, New Component 4", "New Version 5", "New Version 6");
        String secondIssueKey = this.oldway_consider_porting.getIssueKeyWithSummary("second issue", "MKY");
        this.assertIssueValuesAfterMove(secondIssueKey, "New Version 6", "New Version 5, New Version 6", "New Component 3, New Component 4", "New Version 5", "New Version 3", "New Version 6");
    }

    public void testBulkMoveThreeContextsDifferentMappings() throws Exception {
        this.administration.restoreData("TestBulkMoveMappingVersionsAndComponents.xml");
        String hsp1 = this.navigation.issue().createIssue("homosapien", "Bug", "first issue");
        this.navigation.issue().setAffectsVersions(hsp1, "New Version 1", "New Version 2", "New Version 3");
        this.navigation.issue().setFixVersions(hsp1, "New Version 1", "New Version 2", "New Version 3");
        this.navigation.issue().setComponents(hsp1, "New Component 1", "New Component 2", "New Component 3");
        this.navigation.issue().setIssueMultiSelectField(hsp1, "customfield_10003", "New Version 1", "New Version 2", "New Version 5");
        String hsp2 = this.navigation.issue().createIssue("homosapien", "New Feature", "second issue");
        this.navigation.issue().setAffectsVersions(hsp2, "New Version 1");
        this.navigation.issue().setFixVersions(hsp2, "New Version 1");
        this.navigation.issue().setComponents(hsp2, "New Component 1");
        this.navigation.issue().setIssueMultiSelectField(hsp2, "customfield_10003", "New Version 1");
        String hsp3 = this.navigation.issue().createIssue("homosapien", "Task", "third issue");
        this.navigation.issue().setAffectsVersions(hsp3, "New Version 1", "New Version 2", "New Version 3");
        this.navigation.issue().setFixVersions(hsp3, "New Version 1", "New Version 2", "New Version 3");
        this.navigation.issue().setComponents(hsp3, "New Component 1", "New Component 2", "New Component 3");
        this.navigation.issue().setIssueMultiSelectField(hsp3, "customfield_10003", "New Version 1", "New Version 2", "New Version 5");
        this.navigation.issueNavigator().createSearch("project = HSP");
        this.oldway_consider_porting.bulkChangeIncludeAllPages();
        this.oldway_consider_porting.bulkChangeChooseIssuesAll();
        this.oldway_consider_porting.chooseOperationBulkMove();
        this.isStepSelectProjectIssueType();
        this.navigation.issue().selectProject("monkey", "10000_1_pid");
        this.navigation.issue().selectProject("monkey", "10000_2_pid");
        this.navigation.issue().selectProject("monkey", "10000_3_pid");
        this.navigation.clickOnNext();
        this.isStepSetFields();
        this.assertDefaultOption("fixVersions", "10000", UNKNOWN);
        this.assertDefaultOption("fixVersions", "10001", UNKNOWN);
        this.assertDefaultOption("fixVersions", "10003", "New Version 3");
        this.assertDefaultOption("versions", "10000", UNKNOWN);
        this.assertDefaultOption("versions", "10001", UNKNOWN);
        this.assertDefaultOption("versions", "10003", "New Version 3");
        this.assertDefaultOption("components", "10000", UNKNOWN);
        this.assertDefaultOption("components", "10001", UNKNOWN);
        this.assertDefaultOption("components", "10002", "New Component 3");
        this.assertDefaultOption("customfield_10003", "10000", UNKNOWN);
        this.assertDefaultOption("customfield_10003", "10001", UNKNOWN);
        this.assertDefaultOption("customfield_10003", "10005", "New Version 5");
        this.tester.selectOption("fixVersions_10000", "New Version 5");
        this.tester.selectOption("fixVersions_10001", "New Version 6");
        this.tester.selectOption("versions_10000", "New Version 5");
        this.tester.selectOption("versions_10001", "New Version 6");
        this.tester.selectOption("versions_10003", UNKNOWN);
        this.tester.selectOption("components_10001", "New Component 4");
        this.tester.selectOption("customfield_10003_10000", "New Version 5");
        this.tester.selectOption("customfield_10003_10001", "New Version 6");
        this.navigation.clickOnNext();
        this.assertDefaultOption("fixVersions", "10000", "New Version 5");
        this.assertDefaultOption("versions", "10000", "New Version 5");
        this.assertDefaultOption("components", "10000", UNKNOWN);
        this.assertDefaultOption("customfield_10003", "10000", "New Version 5");
        this.tester.selectOption("fixVersions_10000", UNKNOWN);
        this.navigation.clickOnNext();
        this.assertDefaultOption("fixVersions", "10000", UNKNOWN);
        this.assertDefaultOption("fixVersions", "10001", "New Version 6");
        this.assertDefaultOption("fixVersions", "10003", "New Version 3");
        this.assertDefaultOption("versions", "10000", "New Version 5");
        this.assertDefaultOption("versions", "10001", "New Version 6");
        this.assertDefaultOption("versions", "10003", UNKNOWN);
        this.assertDefaultOption("components", "10000", UNKNOWN);
        this.assertDefaultOption("components", "10001", "New Component 4");
        this.assertDefaultOption("components", "10002", "New Component 3");
        this.assertDefaultOption("customfield_10003", "10000", "New Version 5");
        this.assertDefaultOption("customfield_10003", "10001", "New Version 6");
        this.assertDefaultOption("customfield_10003", "10005", "New Version 5");
    }

    private void assertConfirmationMapping(String uniqueContextId, String fieldId, String ... mappingValues) {
        this.text.assertTextSequence(new IdLocator(this.tester, uniqueContextId + fieldId), mappingValues);
    }

    public void testBulkMoveIssuesFromTwoProjects() throws Exception {
        this.administration.restoreData("TestBulkMoveMappingVersionsAndComponents.xml");
        this.administration.project().addVersion("NDT", "XYZ", null, null);
        this.administration.project().addComponent("NDT", "ABC", null, null);
        String hsp1 = this.navigation.issue().createIssue("homosapien", "Bug", "first issue");
        this.navigation.issue().setAffectsVersions(hsp1, "New Version 3");
        this.navigation.issue().setFixVersions(hsp1, "New Version 3");
        this.navigation.issue().setComponents(hsp1, "New Component 3");
        this.navigation.issue().setIssueMultiSelectField(hsp1, "customfield_10003", "New Version 3");
        String mky1 = this.navigation.issue().createIssue("monkey", "Bug", "second issue");
        this.navigation.issue().setAffectsVersions(mky1, "New Version 3");
        this.navigation.issue().setFixVersions(mky1, "New Version 3");
        this.navigation.issue().setComponents(mky1, "New Component 3");
        this.navigation.issue().setIssueMultiSelectField(mky1, "customfield_10003", "New Version 3");
        this.bulkMoveAllIssuesToProject("neanderthal");
        this.assertDefaultOption("fixVersions", "10002", "New Version 3", "monkey", UNKNOWN);
        this.assertDefaultOption("fixVersions", "10003", "New Version 3", "homosapien", UNKNOWN);
        this.assertDefaultOption("versions", "10002", "New Version 3", "monkey", UNKNOWN);
        this.assertDefaultOption("versions", "10003", "New Version 3", "homosapien", UNKNOWN);
        this.assertDefaultOption("components", "10010", "New Component 3", "monkey", UNKNOWN);
        this.assertDefaultOption("components", "10002", "New Component 3", "homosapien", UNKNOWN);
        this.assertDefaultOption("customfield_10003", "10002", "New Version 3", "monkey", UNKNOWN);
        this.assertDefaultOption("customfield_10003", "10003", "New Version 3", "homosapien", UNKNOWN);
        this.tester.selectOption("fixVersions_10002", "XYZ");
        this.tester.selectOption("versions_10002", "XYZ");
        this.tester.selectOption("components_10010", "ABC");
        this.tester.selectOption("customfield_10003_10002", "XYZ");
        this.completeBulkMoveWizard();
        this.waitAndReloadBulkOperationProgressPage();
        String firstIssueKey = this.oldway_consider_porting.getIssueKeyWithSummary("first issue", "NDT");
        this.assertIssueValuesAfterMove(firstIssueKey, "None", "None", "None", null);
        String secondIssueKey = this.oldway_consider_porting.getIssueKeyWithSummary("second issue", "NDT");
        this.assertIssueValuesAfterMove(secondIssueKey, "XYZ", "XYZ", "ABC", "XYZ");
    }

    public void testBulkMoveIssuesFromTwoProjectsDestinationRequired() throws Exception {
        this.administration.restoreData("TestBulkMoveMappingVersionsAndComponents.xml");
        this.administration.project().addVersion("NDT", "XYZ", null, null);
        this.administration.project().addVersion("NDT", "XYZ1", null, null);
        this.administration.project().addComponent("NDT", "ABC", null, null);
        this.administration.project().addComponent("NDT", "ABC1", null, null);
        this.navigation.issue().createIssue("homosapien", "Bug", "first issue");
        String mky1 = this.navigation.issue().createIssue("monkey", "Bug", "second issue");
        this.navigation.issue().setAffectsVersions(mky1, "New Version 3");
        this.navigation.issue().setFixVersions(mky1, "New Version 3");
        this.navigation.issue().setComponents(mky1, "New Component 3");
        this.navigation.issue().setIssueMultiSelectField(mky1, "customfield_10003", "New Version 3");
        this.setFieldsToBeRequired();
        this.bulkMoveAllIssuesToProject("neanderthal");
        this.assertDefaultOption("fixVersions", "10002", "New Version 3", "monkey", "XYZ", true);
        this.assertDefaultOption("fixVersions", "-1", "No Version", null, "XYZ", true);
        this.assertDefaultOption("versions", "10002", "New Version 3", "monkey", "XYZ", true);
        this.assertDefaultOption("versions", "-1", "No Version", null, "XYZ", true);
        this.assertDefaultOption("components", "10010", "New Component 3", "monkey", "ABC", true);
        this.assertDefaultOption("components", "-1", "No Component", null, "ABC", true);
        this.assertDefaultOption("customfield_10003", "10002", "New Version 3", "monkey", "XYZ", true);
        this.assertDefaultOption("customfield_10003", "-1", "No Version", null, "XYZ", true);
        this.tester.selectOption("fixVersions_10002", "XYZ1");
        this.tester.selectOption("versions_10002", "XYZ1");
        this.tester.selectOption("components_10010", "ABC1");
        this.tester.selectOption("customfield_10003_10002", "XYZ1");
        this.completeBulkMoveWizard();
        this.waitAndReloadBulkOperationProgressPage();
        String firstIssueKey = this.oldway_consider_porting.getIssueKeyWithSummary("first issue", "NDT");
        this.assertIssueValuesAfterMove(firstIssueKey, "XYZ", "XYZ", "ABC", "XYZ");
        String secondIssueKey = this.oldway_consider_porting.getIssueKeyWithSummary("second issue", "NDT");
        this.assertIssueValuesAfterMove(secondIssueKey, "XYZ1", "XYZ1", "ABC1", "XYZ1");
    }

    public void testBulkMoveIssuesWithNoDestinationValues() throws Exception {
        this.administration.restoreData("TestBulkMoveMappingVersionsAndComponents.xml");
        String hsp1 = this.navigation.issue().createIssue("homosapien", "Bug", "first issue");
        this.navigation.issue().setAffectsVersions(hsp1, "New Version 3");
        this.navigation.issue().setFixVersions(hsp1, "New Version 3");
        this.navigation.issue().setComponents(hsp1, "New Component 3");
        this.navigation.issue().setIssueMultiSelectField(hsp1, "customfield_10003", "New Version 3");
        this.bulkMoveAllIssuesToProject("neanderthal");
        this.assertNoOption("fixVersions");
        this.assertNoOption("versions");
        this.assertNoOption("components");
        this.assertNoOption("customfield_10003");
        this.completeBulkMoveWizard();
        this.waitAndReloadBulkOperationProgressPage();
        String firstIssueKey = this.oldway_consider_porting.getIssueKeyWithSummary("first issue", "NDT");
        ViewIssueAssertions viewIssueAssertions = this.assertions.getViewIssueAssertions();
        this.navigation.issue().viewIssue(firstIssueKey);
        viewIssueAssertions.assertComponentsAbsent();
        viewIssueAssertions.assertAffectsVersionAbsent();
        viewIssueAssertions.assertFixVersionAbsent();
    }

    public void testBulkMoveIssuesWithNoDestinationValuesButRequired() throws Exception {
        this.administration.restoreData("TestBulkMoveMappingVersionsAndComponents.xml");
        String hsp1 = this.navigation.issue().createIssue("homosapien", "Bug", "first issue");
        this.navigation.issue().setAffectsVersions(hsp1, "New Version 3");
        this.navigation.issue().setFixVersions(hsp1, "New Version 3");
        this.navigation.issue().setComponents(hsp1, "New Component 3");
        this.navigation.issue().setIssueMultiSelectField(hsp1, "customfield_10003", "New Version 3");
        this.setFieldsToBeRequired();
        this.bulkMoveAllIssuesToProject("neanderthal");
        this.assertNoOption("fixVersions");
        this.assertNoOption("versions");
        this.assertNoOption("components");
        this.assertNoOption("customfield_10003");
        this.navigation.clickOnNext();
        String versionErrorMsg = "\"%s\" field is required and the project \"neanderthal\" does not have any versions.";
        String componentErrorMsg = "\"%s\" field is required and the project \"neanderthal\" does not have any components.";
        this.text.assertTextPresent(new WebPageLocator(this.tester), String.format("\"%s\" field is required and the project \"neanderthal\" does not have any versions.", "Affects Version/s"));
        this.text.assertTextPresent(new WebPageLocator(this.tester), String.format("\"%s\" field is required and the project \"neanderthal\" does not have any versions.", "Fix Version/s"));
        this.text.assertTextPresent(new WebPageLocator(this.tester), String.format("\"%s\" field is required and the project \"neanderthal\" does not have any components.", "Component/s"));
        this.text.assertTextPresent(new WebPageLocator(this.tester), "Multi VP is required.");
        String firstIssueKey = this.oldway_consider_porting.getIssueKeyWithSummary("first issue", "HSP");
        this.assertIssueValuesAfterMove(firstIssueKey, "New Version 3", "New Version 3", "New Component 3", "New Version 3");
    }

    private void setFieldsToBeRequired() {
        this.administration.fieldConfigurations().defaultFieldConfiguration().requireField("Affects Version/s");
        this.administration.fieldConfigurations().defaultFieldConfiguration().requireField("Fix Version/s");
        this.administration.fieldConfigurations().defaultFieldConfiguration().requireField("Component/s");
        this.administration.fieldConfigurations().defaultFieldConfiguration().requireField("Multi VP");
    }

    private void assertIssueValuesAfterMove(String issueKey, String affectsVersions, String fixVersions, String components, String ... multiVersionCFValues) {
        this.navigation.issue().viewIssue(issueKey);
        this.assertions.getViewIssueAssertions().assertAffectsVersions(affectsVersions);
        this.assertions.getViewIssueAssertions().assertFixVersions(fixVersions);
        this.assertions.getViewIssueAssertions().assertComponents(components);
        if (multiVersionCFValues == null) {
            this.text.assertTextNotPresent(new WebPageLocator(this.tester), "Multi VP");
        } else {
            for (String multiVersionCFValue : multiVersionCFValues) {
                this.assertions.getViewIssueAssertions().assertCustomFieldValue("customfield_10003", multiVersionCFValue);
            }
        }
    }

    private void assertIssueValuesAfterMoveWithUserPicker(String issueKey, String affectsVersions, String fixVersions, String components, String userPickerValues, String ... multiVersionCFValues) {
        this.navigation.issue().viewIssue(issueKey);
        this.assertions.getViewIssueAssertions().assertAffectsVersions(affectsVersions);
        this.assertions.getViewIssueAssertions().assertFixVersions(fixVersions);
        this.assertions.getViewIssueAssertions().assertComponents(components);
        this.assertions.getViewIssueAssertions().assertCustomFieldValue("customfield_10010", userPickerValues);
        if (multiVersionCFValues == null) {
            this.text.assertTextNotPresent(new WebPageLocator(this.tester), "Multi VP");
        } else {
            for (String multiVersionCFValue : multiVersionCFValues) {
                this.assertions.getViewIssueAssertions().assertCustomFieldValue("customfield_10003", multiVersionCFValue);
            }
        }
    }

    private void bulkMoveAllIssuesToProject(String projectName) {
        this.navigation.issueNavigator().displayAllIssues();
        this.oldway_consider_porting.bulkChangeIncludeAllPages();
        this.oldway_consider_porting.bulkChangeChooseIssuesAll();
        this.oldway_consider_porting.chooseOperationBulkMove();
        this.isStepSelectProjectIssueType();
        this.tester.checkCheckbox("sameAsBulkEditBean", BULK_EDIT_KEY);
        this.navigation.issue().selectProject(projectName, "10000_1_pid");
        this.navigation.clickOnNext();
        this.isStepSetFields();
    }

    private void completeBulkMoveWizard() {
        this.navigation.clickOnNext();
        this.oldway_consider_porting.isStepConfirmation();
        this.navigation.clickOnNext();
    }

    private void isStepSelectProjectIssueType() {
        this.tester.assertTextPresent("Select Projects and Issue Types");
    }

    private void isStepSetFields() {
        this.tester.assertTextPresent("Update Fields for Target Project");
        this.log("Step Set Fields");
    }

    private void assertDefaultOption(String fieldId, String originalId, String expected) {
        this.assertDefaultOption(fieldId, originalId, null, null, expected);
    }

    private void assertNoOption(String fieldId) {
        this.text.assertTextPresent(new IdLocator(this.tester, fieldId + "_container"), "None");
    }

    private void assertDefaultOption(String fieldId, String originalId, String originalName, String originalProject, String expected) {
        this.assertDefaultOption(fieldId, originalId, originalName, originalProject, expected, false);
    }

    private void assertDefaultOption(String fieldId, String originalId, String originalName, String originalProject, String expected, boolean isUnknownDisallowed) {
        String uniqueId = fieldId + "_" + originalId;
        if (originalName != null && originalProject != null) {
            this.text.assertTextSequence(new IdLocator(this.tester, "rowFor_" + uniqueId), originalName, "[", "Project:", originalProject);
        } else if (originalName != null) {
            this.text.assertTextPresent(new IdLocator(this.tester, "rowFor_" + uniqueId), originalName);
        }
        TestBulkMoveMappingVersionsAndComponents.assertEquals((String)expected, (String)this.tester.getDialog().getSelectedOption(uniqueId));
        String[] options = this.tester.getDialog().getOptionsFor(uniqueId);
        boolean unknownFound = false;
        for (String option : options) {
            if (!UNKNOWN.equals(option.trim())) continue;
            if (isUnknownDisallowed) {
                TestBulkMoveMappingVersionsAndComponents.fail((String)("Found Unknown option when it shouldn't have been present for input '" + uniqueId + "'"));
                continue;
            }
            unknownFound = true;
        }
        if (!isUnknownDisallowed && !unknownFound) {
            TestBulkMoveMappingVersionsAndComponents.fail((String)("Did not find Unknown option when it should have been present for input '" + uniqueId + "'"));
        }
    }
}

