/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bulk;

import com.atlassian.jira.functest.framework.navigation.BulkChangeWizard;
import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.EmailFuncTestCase;
import java.util.List;
import javax.mail.internet.MimeMessage;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

@WebTest(value={Category.FUNC_TEST, Category.BULK_OPERATIONS, Category.ISSUES})
public class TestBulkMoveIssuesNotifications
extends EmailFuncTestCase {
    public static final String TEXT_ON_ISSUE_MOVED_MAIL = "moved";
    public static final String TEXT_ON_ISSUE_UPDATED_MAIL = "updated";

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestBulkMoveIssuesNotifications.xml");
        this.configureAndStartSmtpServer();
    }

    public void testMovingIssuesSendsEmailWhenWeChangeProject() throws Exception {
        this.loginAs("test");
        this.moveIssueToADifferentProject();
        this.expectEmailWitText(TEXT_ON_ISSUE_MOVED_MAIL);
    }

    public void testMovingIssuesSendsEmailWhenWeDoNotChangeProject() throws Exception {
        this.loginAs("test");
        this.moveTwoIssuesToTheSameProjectChangingTheIssueTypes();
        this.expectEmailWitText(TEXT_ON_ISSUE_UPDATED_MAIL);
    }

    private void loginAs(String user) {
        this.navigation.login(user);
    }

    private void moveIssueToADifferentProject() {
        this.navigation.issueNavigator().displayAllIssues();
        this.navigation.issueNavigator().bulkChange(IssueNavigatorNavigation.BulkChangeOption.ALL_PAGES).selectAllIssues().chooseOperation(BulkChangeWizard.BulkOperationsImpl.MOVE).chooseTargetContextForAll("project2").finaliseFields().complete();
        this.waitAndReloadBulkOperationProgressPage();
    }

    private void moveTwoIssuesToTheSameProjectChangingTheIssueTypes() {
        this.navigation.issueNavigator().displayAllIssues();
        this.navigation.issueNavigator().bulkChange(IssueNavigatorNavigation.BulkChangeOption.ALL_PAGES).selectAllIssues().chooseOperation(BulkChangeWizard.BulkOperationsImpl.MOVE).chooseTargetContextForAll("project1", "Task").finaliseFields().complete();
        this.waitAndReloadBulkOperationProgressPage();
    }

    private void expectEmailWitText(String text) throws Exception {
        this.flushMailQueueAndWait(1);
        List<MimeMessage> messagesForRecipient = this.getMessagesForRecipient("admin@example.com");
        MatcherAssert.assertThat((Object)messagesForRecipient.size(), (Matcher)Matchers.is((Object)1));
        this.assertEmailBodyContains(messagesForRecipient.get(0), text);
    }
}

