/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bulk;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.functest.framework.NavigationImpl;
import com.atlassian.jira.functest.framework.assertions.AssertionsImpl;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.webtests.ztests.bulk.BulkChangeIssues;

@WebTest(value={Category.FUNC_TEST, Category.BULK_OPERATIONS, Category.ISSUES})
public class TestBulkMoveIssuesForEnterprise
extends BulkChangeIssues {
    public static final String CONFIRMATION_TEXT = "Please confirm that the correct changes have been entered.";
    private static final String SAME_FOR_ALL = "sameAsBulkEditBean";
    private static final String BULK_EDIT_KEY = "10000_1_";
    protected static final String TARGET_PROJECT_ID = "10000_1_pid";
    protected static final String TARGET_ISSUE_TYPE_ID = "10000_1_issuetype";
    protected static final String STD_ISSUE_SELECTION = "Select Projects and Issue Types";
    protected static final String ENT_SUB_TASK_SELECTION = " Move Issues: Select Projects and Issue Types for Sub-Tasks";
    protected static final String ENT_UPDATE_FIELDS_PROJECT = "Update Fields for Target Project '";
    protected static final String ENT_UPDATE_FIELDS_ISSUE_TYPE = "' - Issue Type '";
    protected static final String ENT_UPDATE_FIELDS_END = "'";

    public TestBulkMoveIssuesForEnterprise(String name) {
        super(name);
    }

    public void testBulkMoveChangeAssignee() throws Exception {
        this.restoreData("TestBulkMoveAssigneeChange.xml");
        NavigationImpl nav = new NavigationImpl(this.tester, this.getEnvironmentData());
        IssueNavigatorNavigation navigatorNavigation = nav.issueNavigator();
        AssertionsImpl assertions = new AssertionsImpl(this.tester, this.getEnvironmentData(), nav, this.locator);
        this.startBulkMoveForIssue(navigatorNavigation, 10000L);
        this.setTargetProject("Source");
        this.assertRetainAssignees();
        this.next();
        this.assertConfirmationScreen();
        this.next();
        this.waitAndReloadBulkOperationProgressPage();
        nav.issue().viewIssue("SRC-5");
        assertions.getViewIssueAssertions().assertAssignee("Source User");
    }

    public void testBulkMoveSubTasks() {
        this.restoreData("TestBulkMoveSubTasks.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.displayAllIssues();
        this.assertTextSequence(new String[]{"RAT-4", "No more milk", "Level Mouse"});
        this.assertTextSequence(new String[]{"RAT-3", "Get new milk bucket", "Level Mouse"});
        this.bulkChangeIncludeAllPages();
        this.checkCheckbox("bulkedit_10033", "on");
        this.next();
        this.checkCheckbox("operation", "bulk.move.operation.name");
        this.next();
        this.assertTextSequence(new String[]{"Improvement", "Rattus"});
        this.navigation.issue().selectProject("Bovine", "10022_4_pid");
        this.next();
        this.assertTextSequence(new String[]{"Sub-task", "Rattus"});
        this.next();
        this.assertTextSequence(new String[]{"Improvement", "Rattus"});
        this.assertTextPresent("Security Level");
        this.assertFormElementPresent("security");
        this.next();
        this.assertTextSequence(new String[]{"Sub-task", "Rattus"});
        this.assertTextSequence(new String[]{"Security Level", "The security level of subtasks is inherited from parents."});
        this.next();
        this.assertTextPresent("Step 4 of 4: Confirmation");
        this.next();
        this.waitAndReloadBulkOperationProgressPage();
        this.assertTextPresent("Issue Navigator");
        this.assertTextNotPresent("RAT-4");
        this.assertTextNotPresent("RAT-3");
        this.assertTextNotPresent("Level Mouse");
        this.assertTextSequence(new String[]{"COW-35", "No more milk"});
        this.assertTextSequence(new String[]{"COW-34", "Get new milk bucket"});
    }

    public void testBulkMoveIssuesForEnterprise() {
        this.restoreData("TestBulkMoveIssuesForEnterprise.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        TestBulkMoveIssuesForEnterprise.log("Bulk Move - Tests for Enterprise Version");
        this._testBulkMoveParentIssuesProjectAndIssueType();
        this._testBulkMoveSubTaskAndItsParentSelectParents();
        this._testMoveSessionTimeouts();
        this._testMoveIssueTypeWithAndWithoutSubtasks();
    }

    public void _testMoveSessionTimeouts() {
        TestBulkMoveIssuesForEnterprise.log("Bulk Move - Test that you get redirected to the session timeout page when jumping into the wizard");
        this.beginAt("secure/views/bulkedit/BulkMigrateDetails.jspa");
        this.verifyAtSessionTimeoutPage();
        this.beginAt("secure/views/bulkedit/BulkMigrateChooseSubTaskContext!default.jspa?subTaskPhase=false");
        this.verifyAtSessionTimeoutPage();
        this.beginAt("secure/views/bulkedit/BulkMigrateSetFields!default.jspa?subTaskPhase=false");
        this.verifyAtSessionTimeoutPage();
        this.beginAt("secure/views/bulkedit/BulkMigrateSetFields!default.jspa?subTaskPhase=true");
        this.verifyAtSessionTimeoutPage();
        this.beginAt("secure/views/bulkedit/BulkMigrateSetFields.jspa");
        this.verifyAtSessionTimeoutPage();
        this.beginAt("secure/views/bulkedit/BulkMigratePerform.jspa");
        this.verifyAtSessionTimeoutPage();
    }

    private void verifyAtSessionTimeoutPage() {
        this.assertTextPresent("Your session timed out while performing bulk operation on issues.");
    }

    public void _testMoveIssueTypeWithAndWithoutSubtasks() {
        TestBulkMoveIssuesForEnterprise.log("Bulk Move - Move multiple issue types where at least one (but not all) issue types do not have sub tasks");
        this.getAdministration().restoreBlankInstance();
        this.administration.addGlobalPermission(GlobalPermissionKey.BULK_CHANGE, "jira-users");
        String issueKey1 = this.addIssue("monkey", "MKY", "Bug", "issueKey1", "Major", null, null, null, null, "", "", null, null, null);
        String issueKey2 = this.addIssue("monkey", "MKY", "Improvement", "issueKey2", "Major", null, null, null, null, "", "", null, null, null);
        String subTaskKey1 = this.addSubTaskToIssue(issueKey1, "Sub-task", "subtask1", "");
        this.resetFields();
        this.displayAllIssues();
        this.bulkChangeIncludeAllPages();
        this.bulkChangeChooseIssuesAll();
        this.chooseOperationBulkMove();
        this.assertTextPresent(STD_ISSUE_SELECTION);
        this.navigation.issue().selectProject("homosapien", "10001_1_pid");
        this.navigation.issue().selectIssueType("Bug", "10001_1_issuetype");
        this.navigation.issue().selectProject("homosapien", "10001_4_pid");
        this.navigation.issue().selectIssueType("Improvement", "10001_4_issuetype");
        this.clickOnNext();
        this.clickOnNext();
        this.assertTextPresent("Update Fields for Target Project 'homosapien' - Issue Type 'Bug'");
        this.clickOnNext();
        this.assertTextPresent("Update Fields for Target Project 'homosapien' - Issue Type 'Sub-task'");
        this.clickOnNext();
        this.assertTextPresent("Update Fields for Target Project 'homosapien' - Issue Type 'Improvement'");
        this.clickOnNext();
        this.isStepConfirmation();
        this.clickOnNext();
        this.waitAndReloadBulkOperationProgressPage();
        this.gotoIssue(issueKey1);
        this.assertLinkPresentWithText("homosapien");
        this.assertLinkNotPresentWithText("monkey");
        this.gotoIssue(issueKey2);
        this.assertLinkPresentWithText("homosapien");
        this.assertLinkNotPresentWithText("monkey");
        this.gotoIssue(subTaskKey1);
        this.assertLinkPresentWithText("homosapien");
        this.assertLinkNotPresentWithText("monkey");
        this.administration.removeGlobalPermission(GlobalPermissionKey.BULK_CHANGE, "jira-users");
    }

    public void _testBulkMoveParentIssuesProjectAndIssueType() {
        TestBulkMoveIssuesForEnterprise.log("Bulk Move - Test bulk move Parent issues - Move the parents Project and Issue type");
        String issueKey1 = "NDT-1";
        String issueId1 = "10000";
        String issueKey2 = "HSP-1";
        String issueId2 = "10001";
        String issueKey3 = "HSP-2";
        String issueId3 = "10002";
        String issueKey4 = "NDT-2";
        String issueId4 = "10003";
        String issueKey5 = "MKY-1";
        String issueId5 = "10004";
        this.activateSubTasks();
        this.displayAllIssues();
        this.bulkChangeIncludeAllPages();
        this.isStepChooseIssues();
        this.selectCheckbox("bulkedit_" + issueId1);
        this.selectCheckbox("bulkedit_" + issueId2);
        this.assertCheckboxNotSelected("bulkedit_" + issueId3);
        this.assertCheckboxNotSelected("bulkedit_" + issueId4);
        this.selectCheckbox("bulkedit_" + issueId5);
        this.clickOnNext();
        this.chooseOperationBulkMove();
        this.assertTextPresent("Target Project");
        this.checkCheckbox(SAME_FOR_ALL, BULK_EDIT_KEY);
        this.navigation.issue().selectProject("homosapien", TARGET_PROJECT_ID);
        this.navigation.issue().selectIssueType("Improvement", TARGET_ISSUE_TYPE_ID);
        this.clickOnNext();
        this.assertTextPresent("All field values will be retained");
        this.clickOnNext();
        this.clickOnNext();
        this.waitAndReloadBulkOperationProgressPage();
        this.assertLastChangeHistoryIs(issueKey1, "Project", "neanderthal", "homosapien");
        this.assertLastChangeHistoryIs(issueKey5, "Project", "monkey", "homosapien");
        this.assertLastChangeHistoryIs(issueKey1, "Type", "New Feature", "Improvement");
        this.assertLastChangeHistoryIs(issueKey2, "Type", "Bug", "Improvement");
        this.assertLastChangeNotMadeToField(issueKey2, "Project");
        this.assertLastChangeNotMadeToField(issueKey5, "Type");
        this.assertNoChangesForIssue(issueKey3);
        this.assertNoChangesForIssue(issueKey4);
    }

    public void _testBulkMoveSubTaskAndItsParentSelectParents() {
        TestBulkMoveIssuesForEnterprise.log("Bulk Move - Test bulk move subtask and its parent - Move the parents Project and Issue type");
        String issueKey1 = "NDT-3";
        String issueId1 = "10010";
        String subTaskKey1 = "NDT-4";
        String subTaskId1 = "10011";
        String subTaskKey2 = "NDT-5";
        String subTaskId2 = "10012";
        String issueKey2 = "HSP-3";
        String issueId2 = "10013";
        String issueKey3 = "HSP-4";
        String issueId3 = "10014";
        String subTaskKey3 = "HSP-5";
        String subTaskId3 = "10015";
        String issueKey4 = "NDT-6";
        String issueId4 = "10016";
        this.activateSubTasks();
        this.displayAllIssues();
        this.bulkChangeIncludeAllPages();
        this.isStepChooseIssues();
        this.selectCheckbox("bulkedit_" + issueId1);
        this.selectCheckbox("bulkedit_" + subTaskId1);
        this.selectCheckbox("bulkedit_" + subTaskId2);
        this.selectCheckbox("bulkedit_" + issueId2);
        this.assertCheckboxNotSelected("bulkedit_" + issueId3);
        this.assertCheckboxNotSelected("bulkedit_" + subTaskId3);
        this.assertCheckboxNotSelected("bulkedit_" + issueId4);
        this.clickOnNext();
        this.chooseOperationBulkMove();
        this.assertTextPresent("Target Project");
        this.checkCheckbox(SAME_FOR_ALL, BULK_EDIT_KEY);
        this.navigation.issue().selectProject("homosapien", TARGET_PROJECT_ID);
        this.navigation.issue().selectIssueType("Improvement", TARGET_ISSUE_TYPE_ID);
        this.clickOnNext();
        this.assertTextPresent("Select Projects and Issue Types for Sub-Tasks");
        this.navigation.issue().selectIssueType("Sub-task", "10001_5_10000_issuetype");
        this.clickOnNext();
        this.assertTextPresent("All field values will be retained");
        this.clickOnNext();
        this.assertTextPresent("All field values will be retained");
        this.clickOnNext();
        this.assertTextPresent(CONFIRMATION_TEXT);
        this.clickOnNext();
        this.waitAndReloadBulkOperationProgressPage();
        this.assertLastChangeHistoryIs(issueKey1, "Project", "neanderthal", "homosapien");
        this.assertLastChangeHistoryIs(subTaskKey1, "Project", "neanderthal", "homosapien");
        this.assertLastChangeHistoryIs(subTaskKey2, "Project", "neanderthal", "homosapien");
        this.assertLastChangeHistoryIs(issueKey1, "Type", "New Feature", "Improvement");
        this.assertLastChangeHistoryIs(issueKey2, "Type", "Bug", "Improvement");
        this.assertLastChangeNotMadeToField(issueKey2, "Project");
        this.assertNoChangesForIssue(issueKey3);
        this.assertNoChangesForIssue(subTaskKey3);
        this.assertNoChangesForIssue(issueKey4);
        this.deactivateSubTasks();
    }

    public void testBulkMoveIssuesWithSecurityLevels() {
        this.restoreData("TestBulkMoveIssuesForEnterpriseIssueLevelSecurity.xml");
        String issueKey1 = this.addIssue("homosapien", "HSP", "Bug", "Summary for Bug", null, null, null, null, null, "", "", null, null, null);
        String issueKey2 = this.addIssue("homosapien", "HSP", "New Feature", "Summary for New Feature", null, null, null, null, null, "", "", null, null, null);
        this.displayAllIssues();
        this.bulkChangeIncludeAllPages();
        this.bulkChangeChooseIssuesAll();
        this.chooseOperationBulkMove();
        this.assertTextPresent(STD_ISSUE_SELECTION);
        this.navigation.issue().selectProject("monkey", TARGET_PROJECT_ID);
        this.navigation.issue().selectProject("monkey", "10000_2_pid");
        this.next();
        this.selectOption("security", "Medium");
        this.next();
        this.selectOption("security", "High");
        this.next();
        this.assertTextPresent("Medium");
        this.assertTextPresent("High");
        this.next();
        this.waitAndReloadBulkOperationProgressPage();
        this.gotoIssue(issueKey1);
        this.assertTextPresent("Medium");
        this.gotoIssue(issueKey2);
        this.assertTextPresent("High");
        this.assertIndexedFieldCorrect("//item", EasyMap.build((Object)"key", (Object)"MKY-6", (Object)"security", (Object)"Medium"), null, "MKY-6");
        this.assertIndexedFieldCorrect("//item", EasyMap.build((Object)"key", (Object)"MKY-7", (Object)"security", (Object)"High"), null, "MKY-7");
    }

    public void testBulkMoveWithCustomFieldContextBehaviour() {
        this.restoreData("TestBulkMoveIssuesForEnterpriseCustomFieldContextBehaviour.xml");
        this.displayAllIssues();
        this.bulkChangeIncludeAllPages();
        this.checkCheckbox("bulkedit_10011", "on");
        this.checkCheckbox("bulkedit_10000", "on");
        this.clickOnNext();
        this.checkCheckbox("operation", "bulk.move.operation.name");
        this.clickOnNext();
        this.navigation.issue().selectProject("homosapien", "10001_1_pid");
        this.clickOnNext();
        this.navigation.issue().selectIssueType("Sub-task", "10001_5_10000_issuetype");
        this.clickOnNext();
        this.clickOnNext();
        this.assertTextPresent("Man Bug Custom Field");
        this.selectOption("customfield_10002", "Yes");
        this.clickOnNext();
        this.assertTextPresent("All field values will be retained");
        this.clickOnNext();
        this.clickOnNext();
        this.waitAndReloadBulkOperationProgressPage();
        this.displayAllIssues();
        this.clickLinkWithText("Another Monkey Bug!");
        this.text.assertTextPresent(new IdLocator(this.tester, "rowForcustomfield_10001"), "Monkey Option");
        this.text.assertTextPresent(new IdLocator(this.tester, "rowForcustomfield_10002"), "Yes");
    }

    public void testBulkMoveRetainWarning() {
        this.restoreData("TestBulkMoveRetainWarningTest.xml");
        this.displayAllIssues();
        this.bulkChangeIncludeAllPages();
        this.bulkChangeChooseIssuesAll();
        this.chooseOperationBulkMove();
        this.assertTextPresent(STD_ISSUE_SELECTION);
        this.navigation.issue().selectProject("monkey", TARGET_PROJECT_ID);
        this.navigation.clickOnNext();
        this.assertTextNotPresent("Issues not in the project <strong>monkey</strong> will not retain values for <strong>Fix Version/s</strong>");
        this.assertTextNotPresent("Issues not in the project <strong>monkey</strong> will not retain values for <strong>Affects Version/s</strong>");
        this.assertTextNotPresent("Issues not in the project <strong>monkey</strong> will not retain values for <strong>Component/s</strong>");
        this.assertTextNotPresent("Issues not in the project <strong>monkey</strong> will not retain values for <strong>Description</strong>");
    }

    public void testBulkMoveAndChangeStatus() {
        this.restoreData("TestBulkMoveMapWorkflows.xml");
        this.assertIndexedFieldCorrect("//item", EasyMap.build((Object)"key", (Object)"HSP-13", (Object)"type", (Object)"Bug", (Object)"status", (Object)"Totally Open", (Object)"summary", (Object)"bugs3"), EasyMap.build((Object)"key", (Object)"MKY-13"), "HSP-13");
        this.showIssues("project=homosapien");
        this.bulkChangeIncludeAllPages();
        this.checkAllIssuesOnPage();
        this.moveIssuesToMonkey();
        this.assertStatusMapped("MKY-11");
        String movedIssueKey = this.getIssueKeyWithSummary("bugs3", "MKY");
        this.assertIndexedFieldCorrect("//item", EasyMap.build((Object)"key", (Object)movedIssueKey, (Object)"type", (Object)"Bug", (Object)"status", (Object)"Open", (Object)"summary", (Object)"bugs3"), EasyMap.build((Object)"key", (Object)"HSP-14"), movedIssueKey);
    }

    private void assertStatusMapped(String issue) {
        this.gotoIssue(issue);
        this.assertTextPresent("Open");
        this.assertTextNotPresent("Totally Open");
    }

    private void moveIssuesToMonkey() {
        this.next();
        this.checkCheckbox("operation", "bulk.move.operation.name");
        this.next();
        this.navigation.issue().selectProject("monkey", TARGET_PROJECT_ID);
        this.next();
        this.next();
        this.next();
        this.next();
        this.waitAndReloadBulkOperationProgressPage();
    }

    private void checkAllIssuesOnPage() {
        this.checkCheckbox("bulkedit_10022", "on");
        this.checkCheckbox("bulkedit_10023", "on");
        this.checkCheckbox("bulkedit_10024", "on");
        this.checkCheckbox("bulkedit_10025", "on");
    }

    private void next() {
        this.submit("Next");
    }

    private void startBulkMoveForIssue(IssueNavigatorNavigation navigatorNavigation, long id) {
        navigatorNavigation.displayAllIssues();
        this.bulkChangeIncludeAllPages();
        this.assertTextSequence(new String[]{"Bulk Operation", "Choose Issues"});
        this.checkCheckbox("bulkedit_" + id, "on");
        this.next();
        this.assertTextSequence(new String[]{"Bulk Operation", "Choose Operation"});
        this.checkCheckbox("operation", "bulk.move.operation.name");
        this.next();
    }

    private void setTargetProject(String option) {
        this.assertSelectProjectScreen();
        this.navigation.issue().selectProject(option, "10010_1_pid");
        this.next();
    }

    private void assertConfirmationScreen() {
        this.assertTextSequence(new String[]{"Move Issues", "Confirmation"});
    }

    private void assertSelectProjectScreen() {
        this.assertTextSequence(new String[]{"Move Issues", STD_ISSUE_SELECTION});
    }

    private void assertRetainAssignees() {
        this.assertTextPresent("All field values will be retained");
    }

    private void assertTargetAssignees() {
        this.assertTextSequence(new String[]{"Move Issues", "Update Fields"});
    }
}

