/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bulk;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.navigation.BulkChangeWizard;
import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;
import com.atlassian.jira.functest.framework.navigation.issue.FileAttachmentsList;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rules.CopyAttachmentsRule;

@WebTest(value={Category.FUNC_TEST, Category.ATTACHMENTS, Category.BULK_OPERATIONS})
public class TestBulkMoveAttachments
extends FuncTestCase {
    public CopyAttachmentsRule copyAttachmentsRule;

    @Override
    public void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestAttachmentEncoding.xml");
        this.copyAttachmentsRule = new CopyAttachmentsRule(this);
        this.copyAttachmentsRule.before();
        this.copyAttachmentsRule.copyAttachmentsFrom("TestAttachmentEncoding/attachments");
    }

    @Override
    protected void tearDownTest() {
        this.copyAttachmentsRule.after();
        super.tearDownTest();
    }

    public void testBulkMove() throws Exception {
        this.navigation.issueNavigator().displayAllIssues();
        BulkChangeWizard wizard = this.navigation.issueNavigator().bulkChange(IssueNavigatorNavigation.BulkChangeOption.ALL_PAGES);
        wizard.selectAllIssues().chooseOperation(BulkChangeWizard.BulkOperationsImpl.MOVE).chooseTargetContextForAll("monkey").finaliseFields().complete();
        this.waitAndReloadBulkOperationProgressPage();
        for (FileAttachmentsList.FileAttachmentItem fileAttachmentItem : this.navigation.issue().attachments("MKY-1").list().get()) {
            this.tester.gotoPage("/secure/attachment/" + fileAttachmentItem.getId() + "/" + fileAttachmentItem.getName());
        }
    }

    public void testBulkMoveFromRenamedProject() throws Exception {
        this.backdoor.project().editProjectKey(this.backdoor.project().getProjectId("HSP"), "OTHER");
        this.navigation.issueNavigator().displayAllIssues();
        BulkChangeWizard wizard = this.navigation.issueNavigator().bulkChange(IssueNavigatorNavigation.BulkChangeOption.ALL_PAGES);
        wizard.selectAllIssues().chooseOperation(BulkChangeWizard.BulkOperationsImpl.MOVE).chooseTargetContextForAll("monkey").finaliseFields().complete();
        this.waitAndReloadBulkOperationProgressPage();
        for (FileAttachmentsList.FileAttachmentItem fileAttachmentItem : this.navigation.issue().attachments("MKY-1").list().get()) {
            this.tester.gotoPage("/secure/attachment/" + fileAttachmentItem.getId() + "/" + fileAttachmentItem.getName());
        }
    }

    public void testBulkMoveToRenamedProject() throws Exception {
        this.backdoor.project().editProjectKey(this.backdoor.project().getProjectId("MKY"), "OTHER");
        this.navigation.issueNavigator().displayAllIssues();
        BulkChangeWizard wizard = this.navigation.issueNavigator().bulkChange(IssueNavigatorNavigation.BulkChangeOption.ALL_PAGES);
        wizard.selectAllIssues().chooseOperation(BulkChangeWizard.BulkOperationsImpl.MOVE).chooseTargetContextForAll("monkey").finaliseFields().complete();
        this.waitAndReloadBulkOperationProgressPage();
        for (FileAttachmentsList.FileAttachmentItem fileAttachmentItem : this.navigation.issue().attachments("OTHER-1").list().get()) {
            this.tester.gotoPage("/secure/attachment/" + fileAttachmentItem.getId() + "/" + fileAttachmentItem.getName());
        }
    }

    public void testBulkMoveFromRenamedToRenamedProject() throws Exception {
        this.backdoor.project().editProjectKey(this.backdoor.project().getProjectId("HSP"), "HASP");
        this.backdoor.project().editProjectKey(this.backdoor.project().getProjectId("MKY"), "MONKEY");
        this.navigation.issueNavigator().displayAllIssues();
        BulkChangeWizard wizard = this.navigation.issueNavigator().bulkChange(IssueNavigatorNavigation.BulkChangeOption.ALL_PAGES);
        wizard.selectAllIssues().chooseOperation(BulkChangeWizard.BulkOperationsImpl.MOVE).chooseTargetContextForAll("monkey").finaliseFields().complete();
        this.waitAndReloadBulkOperationProgressPage();
        for (FileAttachmentsList.FileAttachmentItem fileAttachmentItem : this.navigation.issue().attachments("MONKEY-1").list().get()) {
            this.tester.gotoPage("/secure/attachment/" + fileAttachmentItem.getId() + "/" + fileAttachmentItem.getName());
        }
    }
}

