/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bulk;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.navigation.BulkChangeWizard;
import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;

@WebTest(value={Category.FUNC_TEST, Category.BULK_OPERATIONS, Category.ISSUES})
public class TestBulkDeleteIssues
extends FuncTestCase {
    private static final String SESSION_TIMEOUT_MESSAGE = "Your session timed out while performing bulk operation on issues.";
    private static final int SETUP_ISSUE_COUNT = 51;

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.backdoor.restoreBlankInstance();
        this.produceIssues("HSP", 51);
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
    }

    private void produceIssues(String projectKey, int howMany) {
        for (int i = 0; i < howMany; ++i) {
            String summary = Integer.toBinaryString(i);
            if (this.backdoor.issues().createIssue(projectKey, summary).id() != null) continue;
            TestBulkDeleteIssues.fail((String)String.format("Failed at adding issue: '%s' while adding %d out of %d issues.", summary, i + 1, 51));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBulkDeleteIssuesLimited() throws Exception {
        this.produceIssues("MKY", 123);
        String overflowProtectionPropertyKey = "jira.bulk.edit.limit.issue.count";
        String currentLimitSetting = this.backdoor.applicationProperties().getString("jira.bulk.edit.limit.issue.count");
        this.backdoor.applicationProperties().setString("jira.bulk.edit.limit.issue.count", "100");
        try {
            this.navigation.issueNavigator().runSearch("project=MKY");
            BulkChangeWizard wizard = this.navigation.issueNavigator().bulkChange(IssueNavigatorNavigation.BulkChangeOption.ALL_PAGES);
            this.tester.assertTextPresent("Bulk changes are currently limited to 100 issues.");
            wizard.selectAllIssues().chooseOperation(BulkChangeWizard.BulkOperationsImpl.DELETE).complete();
            this.waitAndReloadBulkOperationProgressPage();
            this.tester.assertLinkPresentWithText("MKY-23");
            this.tester.assertLinkNotPresentWithText("MKY-24");
            this.assertions.getURLAssertions().assertCurrentURLMatchesRegex(".*/issues/\\?jql=project.*MKY");
        }
        finally {
            this.backdoor.applicationProperties().setString("jira.bulk.edit.limit.issue.count", currentLimitSetting);
        }
    }

    public void testBulkDeleteAllIssuesInCurrentPage() {
        this.navigation.issueNavigator().displayAllIssues();
        this.navigation.issueNavigator().bulkChange(IssueNavigatorNavigation.BulkChangeOption.CURRENT_PAGE).selectAllIssues().chooseOperation(BulkChangeWizard.BulkOperationsImpl.DELETE).complete();
        this.waitAndReloadBulkOperationProgressPage();
        this.assertions.getURLAssertions().assertCurrentURLMatchesRegex(".*/issues/\\?jql.*");
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.assertLinkNotPresentWithText(Integer.toBinaryString(25));
        this.tester.assertLinkPresentWithText(Integer.toBinaryString(0));
        this.assertIssueNotIndexed("HSP-10");
    }

    public void testBulkDeleteAllIssuesInAllPages() {
        this.navigation.issueNavigator().displayAllIssues();
        this.navigation.issueNavigator().bulkChange(IssueNavigatorNavigation.BulkChangeOption.ALL_PAGES).selectAllIssues().chooseOperation(BulkChangeWizard.BulkOperationsImpl.DELETE).complete();
        this.waitAndReloadBulkOperationProgressPage();
        this.assertions.getURLAssertions().assertCurrentURLMatchesRegex(".*/issues/\\?jql.*");
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.assertElementNotPresent("issuetable");
    }

    public void testBulkDeleteSessionTimeouts() {
        this.log("Bulk Delete - Test that you get redirected to the session timeout page when jumping into the wizard");
        this.navigation.gotoPage("secure/views/bulkedit/BulkDeleteDetails.jspa");
        this.tester.assertTextPresent(SESSION_TIMEOUT_MESSAGE);
        this.navigation.gotoPage("secure/BulkDeleteDetailsValidation.jspa");
        this.tester.assertTextPresent(SESSION_TIMEOUT_MESSAGE);
    }

    private void assertIssueNotIndexed(String key) {
        this.log("Checking that item " + key + " was deleted in the index.");
        try {
            this.navigation.gotoPage("/si/jira.issueviews:issue-xml/" + key + "/" + key + ".xml?jira.issue.searchlocation=index");
            TestBulkDeleteIssues.fail((String)"Unexpectedly - issue page exists, issue was not deleted.");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }
}

