/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bulk;

import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.rest.api.issue.IssueCreateResponse;
import com.atlassian.jira.webtests.JIRAWebTest;
import org.jsoup.Jsoup;

public abstract class BulkChangeIssues
extends JIRAWebTest {
    protected static final int NUM_RESULTS_PER_PG = 50;
    protected static final String ERROR_NEXT_CHOOSE_ISSUE = "You must select at least one issue to bulk edit.";
    protected static final String ERROR_NEXT_CHOOSE_OPERATION = "Please choose an operation from the list below.";
    protected static final String ERROR_NEXT_OPERATION_DETAILS = "You must select at least one bulk action to perform";
    protected static final String NOTE_MULTIPLE_PROJECTS = "This operation can be performed only on issues from ONE project.";
    protected static final String FORM_QUICK_SEARCH = "quicksearch";
    protected static final String FIELD_SEARCH_STRING = "searchString";
    protected static final String OPTION_VERSION_ONE = "New Version 1";
    protected static final String OPTION_VERSION_TWO = "New Version 2";
    protected static final String OPTION_COMPONENT_ONE = "New Component 1";
    protected static final String OPTION_UNASSIGNED = "Unassigned";
    protected static final String OPTION_PRIORITY_ONE = "Blocker";
    protected static final String OPTION_PRIORITY_TWO = "Critical";
    protected static final String OPTION_PRIORITY_THREE = "Major";
    protected static final String OPTION_PRIORITY_FOUR = "Minor";
    protected static final String OPTION_PRIORITY_FIVE = "Trivial";
    protected static final String TYPE_PRIORITY_ONE = "Blocker";
    protected static final String TYPE_PRIORITY_TWO = "Critical";
    protected static final String TYPE_PRIORITY_THREE = "Major";
    protected static final String TYPE_PRIORITY_FOUR = "Minor";
    protected static final String TYPE_PRIORITY_FIVE = "Trivial";
    protected static final String FIELDS_UPDATE_AUTO = "All field values will be retained";

    public BulkChangeIssues(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
    }

    @Override
    public void tearDown() {
        super.tearDown();
    }

    protected void bulkChangeSetup() {
        BulkChangeIssues.log("Bulk Change - Set Up: deleting ALL issues and adding projects, components, & versions");
        this.restoreData("TestBulkChangeSetup.xml");
    }

    protected String addIssue(String summary) {
        return this.addIssueForResponse((String)summary).key;
    }

    protected IssueCreateResponse addIssueForResponse(String summary) {
        return this.addIssueViaRestForResponse("homosapien", "HSP", "Bug", summary, "Major", "admin", "test environment", "description for " + summary);
    }

    protected void addIssues(int numOfIssues) {
        for (int i = 0; i < numOfIssues; ++i) {
            this.addIssueViaRest("homosapien", "HSP", "Bug", "random_" + numOfIssues, "Major", "admin", "test environment", "\"generated by loop\"");
        }
    }

    protected void addIssues(String prefix, int numOfIssues) {
        long start = System.currentTimeMillis();
        BulkChangeIssues.log("Creating " + numOfIssues + " issues ");
        for (int i = 0; i < numOfIssues; ++i) {
            this.addIssueViaRest("homosapien", "HSP", "Bug", prefix + i, "Major", "admin", "test environment", "\"generated by loop with prefix\"");
        }
        BulkChangeIssues.log("Created " + numOfIssues + " issues in " + String.valueOf(System.currentTimeMillis() - start));
    }

    protected String addIssueInProject(String summary, String project, String projectKey) {
        return this.addIssueViaRest(project, projectKey, "Bug", summary, "Critical", "admin", "environment", "this issue is not in project " + project);
    }

    protected void addCurrentPageLink() {
        String tableString = this.issueTableClient.setSessionSearch("").getIssueTable().getTable();
        while (tableString == null || Jsoup.parse((String)tableString).getElementsByClass("icon-next").size() == 0) {
            this.addIssue("add current page link");
            tableString = this.issueTableClient.setSessionSearch("").getIssueTable().getTable();
        }
    }

    protected boolean checkIssueIsDeleted(String summary) {
        if (!this.getDialog().hasForm(FORM_QUICK_SEARCH) || !this.getDialog().hasFormParameterNamed(FIELD_SEARCH_STRING)) {
            this.login("admin", "admin");
        }
        this.setWorkingForm(FORM_QUICK_SEARCH);
        this.setFormElement(FIELD_SEARCH_STRING, summary);
        this.submit();
        return !this.getDialog().isLinkPresentWithText(summary);
    }

    protected void bulkChangeNextWithoutFormCompletionStepChooseIssue() {
        this.clickOnNext();
        this.assertions.assertNodeHasText(new CssLocator(this.tester, ".aui-message.error"), ERROR_NEXT_CHOOSE_ISSUE);
    }

    protected void bulkChangeNextWithoutFormCompletionStepChooseOperation() {
        this.clickOnNext();
        this.assertions.assertNodeHasText(new CssLocator(this.tester, ".aui-message.error"), ERROR_NEXT_CHOOSE_OPERATION);
    }

    protected void bulkChangeNextWithoutFormCompletionStepOperationDetails() {
        this.clickOnNext();
        this.assertions.assertNodeHasText(new CssLocator(this.tester, ".aui-message.error"), ERROR_NEXT_OPERATION_DETAILS);
    }

    protected void checkLabelForStepIssueNavigator(int page, int totalIssues) {
        int fromIssue = (page - 1) * 50 + 1;
        int toIssue = totalIssues - fromIssue < 50 ? totalIssues : fromIssue + 50 - 1;
        this.assertIssueNavigatorDisplaying(String.valueOf(fromIssue), String.valueOf(toIssue), String.valueOf(totalIssues));
        this.assertLinkPresentWithText("all " + totalIssues + " issue(s)");
        if (this.getDialog().isTextInResponse("Next >>")) {
            this.assertLinkPresent("bulkedit_curr_pg");
        }
    }

    protected void checkIssuesAreListed(String prefix, int max) {
        for (int i = 0; i < max; ++i) {
            this.assertLinkPresentWithText(prefix + i);
        }
    }

    protected void checkIssuesAreNotListed(String prefix, int max) {
        for (int i = 0; i < max; ++i) {
            this.assertLinkNotPresentWithText(prefix + i);
        }
    }

    protected void checkSideBarLinksInStepChooseIssues() {
        this.isStepChooseIssues();
        this.assertLinkNotPresentWithText("Choose Issues");
        this.assertLinkNotPresentWithText("Choose Operation");
        this.assertLinkNotPresentWithText("Operation Details");
        this.assertLinkNotPresentWithText("Confirmation");
    }

    protected void checkSideBarLinksInStepChooseOperation() {
        this.isStepChooseOperation();
        this.assertLinkPresentWithText("Choose Issues");
        this.assertLinkNotPresentWithText("Choose Operation");
        this.assertLinkNotPresentWithText("Operation Details");
        this.assertLinkNotPresentWithText("Confirmation");
    }

    protected void checkSideBarLinksInStepOperationDetails() {
        this.isStepOperationDetails();
        this.assertLinkPresentWithText("Choose Issues");
        this.assertLinkPresentWithText("Choose Operation");
        this.assertLinkNotPresentWithText("Operation Details");
        this.assertLinkNotPresentWithText("Confirmation");
    }

    protected void checkSideBarLinksInStepConfirmationForDeleteOp() {
        this.isStepConfirmation();
        this.assertLinkPresentWithText("Choose Issues");
        this.assertLinkPresentWithText("Choose Operation");
        this.assertLinkPresentWithText("Operation Details");
        this.assertLinkNotPresentWithText("Confirmation");
    }

    protected void checkSideBarLinksInStepConfirmationForEditOp() {
        this.isStepConfirmation();
        this.assertLinkPresentWithText("Choose Issues");
        this.assertLinkPresentWithText("Choose Operation");
        this.assertLinkPresentWithText("Operation Details");
        this.assertLinkNotPresentWithText("Confirmation");
    }

    protected void checkMultipleProjectNote() {
        this.assertTextPresent(NOTE_MULTIPLE_PROJECTS);
        this.assertFormElementNotPresent("fixVersions");
        this.assertFormElementNotPresent("versions");
        this.assertFormElementNotPresent("components");
    }

    protected void checkLinkToStepChooseIssues() {
        this.clickLinkWithText("Choose Issues");
        this.isStepChooseIssues();
    }

    protected void checkLinkToStepChooseOperation() {
        this.clickLinkWithText("Choose Operation");
        this.isStepChooseOperation();
    }

    protected void checkLinkToStepOperationDetails() {
        this.clickLinkWithText("Operation Details");
        this.isStepOperationDetails();
    }
}

