/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.avatar;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rules.RestRule;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.User;
import com.atlassian.jira.testkit.client.restclient.UserClient;
import com.google.common.collect.Lists;
import com.meterware.httpunit.ClientProperties;
import com.meterware.httpunit.WebResponse;
import java.util.ArrayList;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.w3c.dom.Node;

@WebTest(value={Category.FUNC_TEST})
public class TestGravatarSupport
extends FuncTestCase {
    private static final String ADMIN_MD5 = "e64c7d89f26bd1972efa854d13d7dd61";
    private static final String FRED_MD5 = "6255165076a5e31273cbda50bb9f9636";
    private String adminGravatarSmall;
    private String adminGravatarNormal;
    private String adminGravatarLarge;
    private String fredGravatarSmall;
    private String fredGravatarNormal;
    private String fredGravatarLarge;
    private RestRule restRule;

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.restRule = new RestRule(this);
        this.restRule.before();
        String defaultUserAvatar = "mm";
        this.adminGravatarSmall = String.format("http://www.gravatar.com/avatar/%s?d=%s&s=16", ADMIN_MD5, defaultUserAvatar);
        this.adminGravatarNormal = String.format("http://www.gravatar.com/avatar/%s?d=%s&s=24", ADMIN_MD5, defaultUserAvatar);
        this.adminGravatarLarge = String.format("http://www.gravatar.com/avatar/%s?d=%s&s=48", ADMIN_MD5, defaultUserAvatar);
        this.fredGravatarSmall = String.format("http://www.gravatar.com/avatar/%s?d=%s&s=16", FRED_MD5, defaultUserAvatar);
        this.fredGravatarNormal = String.format("http://www.gravatar.com/avatar/%s?d=%s&s=24", FRED_MD5, defaultUserAvatar);
        this.fredGravatarLarge = String.format("http://www.gravatar.com/avatar/%s?d=%s&s=48", FRED_MD5, defaultUserAvatar);
        this.administration.restoreBlankInstance();
        this.administration.generalConfiguration().useGravatars(true);
    }

    @Override
    public void tearDownTest() {
        this.restRule.after();
    }

    public void testGravatarShouldBeDisplayedInUserProfile() throws Exception {
        this.navigation.userProfile().gotoUserProfile("admin");
        Assert.assertThat((Object)this.locator.css("img.avatar-image").getNode().getAttributes().getNamedItem("src").getTextContent(), (Matcher)CoreMatchers.equalTo((Object)this.adminGravatarLarge));
        Assert.assertThat((Object)this.locator.css("#content > header .aui-avatar img").getNode().getAttributes().getNamedItem("src").getTextContent(), (Matcher)CoreMatchers.equalTo((Object)this.adminGravatarLarge));
    }

    public void testGravatarShouldBeDisplayedInIssueComments() throws Exception {
        String key = this.navigation.issue().createIssue("homosapien", "Bug", "an issue");
        this.navigation.issue().addComment(key, "comment 10000");
        Node adminAvatarLink = this.locator.css("#commentauthor_10000_verbose").getNode();
        ArrayList adminAvatarChildClasses = Lists.newArrayList((Object[])adminAvatarLink.getFirstChild().getAttributes().getNamedItem("class").getTextContent().split("\\s+"));
        Node adminAvatarImage = this.locator.css("#commentauthor_10000_verbose img").getNode();
        Assert.assertThat((String)"An AUI avatar is output within the verbose author link", (Object)adminAvatarChildClasses, (Matcher)CoreMatchers.hasItem((Object)"aui-avatar"));
        TestGravatarSupport.assertEquals((String)adminAvatarImage.getAttributes().getNamedItem("src").getTextContent(), (String)this.adminGravatarSmall);
        this.navigation.login("fred");
        this.navigation.issue().addComment(key, "comment 10001");
        Node fredAvatarLink = this.locator.css("#commentauthor_10001_concise").getNode();
        ArrayList fredAvatarChildClasses = Lists.newArrayList((Object[])adminAvatarLink.getFirstChild().getAttributes().getNamedItem("class").getTextContent().split("\\s+"));
        Node fredAvatarImage = this.locator.css("#commentauthor_10001_concise img").getNode();
        Assert.assertThat((String)"An AUI avatar is output within the concise author link", (Object)fredAvatarChildClasses, (Matcher)CoreMatchers.hasItem((Object)"aui-avatar"));
        TestGravatarSupport.assertEquals((String)fredAvatarImage.getAttributes().getNamedItem("src").getTextContent(), (String)this.fredGravatarSmall);
    }

    public void testGravatarShouldBeDisplayedInApplicationHeaderProfileLink() {
        Node adminAvatarLink = this.locator.css("#header-details-user-fullname img").getNode();
        TestGravatarSupport.assertEquals((String)adminAvatarLink.getAttributes().getNamedItem("src").getTextContent(), (String)this.adminGravatarNormal);
        this.navigation.login("fred");
        Node fredAvatarLink = this.locator.css("#header-details-user-fullname img").getNode();
        TestGravatarSupport.assertEquals((String)fredAvatarLink.getAttributes().getNamedItem("src").getTextContent(), (String)this.fredGravatarNormal);
    }

    public void testGravatarShouldBeDisplayedInUserResource() throws Exception {
        UserClient userClient = new UserClient((JIRAEnvironmentData)this.environmentData);
        User fred = userClient.get("fred", new User.Expand[0]);
        Assert.assertThat((Object)fred.avatarUrls, (Matcher)Matchers.hasEntry((Object)"16x16", (Object)this.fredGravatarSmall));
        Assert.assertThat((Object)fred.avatarUrls, (Matcher)Matchers.hasEntry((Object)"24x24", (Object)this.fredGravatarNormal));
        Assert.assertThat((Object)fred.avatarUrls, (Matcher)Matchers.hasEntry((Object)"48x48", (Object)this.fredGravatarLarge));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAvatarServletShouldRedirectToGravatar() throws Exception {
        ClientProperties clientProperties = this.tester.getDialog().getWebClient().getClientProperties();
        boolean redirect = clientProperties.isAutoRedirect();
        clientProperties.setAutoRedirect(false);
        try {
            WebResponse largeAvatarResponse = this.restRule.GET(String.format("secure/useravatar?ownerId=%s", "fred"));
            Assert.assertThat((Object)largeAvatarResponse.getResponseCode(), (Matcher)CoreMatchers.equalTo((Object)302));
            Assert.assertThat((Object)largeAvatarResponse.getHeaderField("Location"), (Matcher)CoreMatchers.equalTo((Object)this.fredGravatarLarge));
            WebResponse smallAvatarResponse = this.restRule.GET(String.format("secure/useravatar?ownerId=%s&size=xsmall", "fred"));
            Assert.assertThat((Object)smallAvatarResponse.getResponseCode(), (Matcher)CoreMatchers.equalTo((Object)302));
            Assert.assertThat((Object)smallAvatarResponse.getHeaderField("Location"), (Matcher)CoreMatchers.equalTo((Object)this.fredGravatarSmall));
            WebResponse normalAvatarResponse = this.restRule.GET(String.format("secure/useravatar?ownerId=%s&size=small", "fred"));
            Assert.assertThat((Object)normalAvatarResponse.getResponseCode(), (Matcher)CoreMatchers.equalTo((Object)302));
            Assert.assertThat((Object)normalAvatarResponse.getHeaderField("Location"), (Matcher)CoreMatchers.equalTo((Object)this.fredGravatarNormal));
            this.navigation.logout();
            WebResponse anonAvatarResponse = this.restRule.GET(String.format("secure/useravatar?ownerId=%s", "fred"));
            Assert.assertThat((Object)anonAvatarResponse.getResponseCode(), (Matcher)CoreMatchers.equalTo((Object)404));
        }
        finally {
            clientProperties.setAutoRedirect(redirect);
        }
    }
}

