/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.avatar;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

@WebTest(value={Category.FUNC_TEST, Category.UPGRADE_TASKS})
public class TestAvatarSettingsMigration
extends RestFuncTest {
    static final ImmutableList<String> USERS = ImmutableList.of((Object)"user_with_avatar", (Object)"user_without_avatar");
    static final Map<String, String> GRAVATAR_ON = ImmutableMap.of((Object)"user_with_avatar", (Object)"http://www.gravatar.com/avatar/3b273c72f359240538caceb63b6384ef?d=mm&s=48", (Object)"user_without_avatar", (Object)"http://www.gravatar.com/avatar/13570ed7405a9e0a95744ea68e55017e?d=mm&s=48");
    static final Map<String, String> GRAVATAR_OFF = ImmutableMap.of((Object)"user_with_avatar", (Object)"/secure/useravatar?avatarId=10040", (Object)"user_without_avatar", (Object)"/secure/useravatar?avatarId=10062");

    public void testGravatarsRemainOnAfterUpgrade() throws Exception {
        this.backdoor.restoreDataFromResource("avatar/GravatarsOn.xml");
        for (String user : USERS) {
            TestAvatarSettingsMigration.assertEquals((String)(user + " should keep their gravatar after upgrade"), (String)GRAVATAR_ON.get(user), (String)this.backdoor.userProfile().getAvatarUrl(user));
        }
    }

    public void testGravatarsRemainOffAfterUpgradeWhenExplicitlyOff() throws Exception {
        this.backdoor.restoreDataFromResource("avatar/GravatarsOff.xml");
        String base = this.getEnvironmentData().getBaseUrl().toString();
        for (String user : ImmutableList.of((Object)"user_with_avatar", (Object)"user_without_avatar")) {
            TestAvatarSettingsMigration.assertEquals((String)(user + " should keep their internal avatar after upgrade"), (String)(base + GRAVATAR_OFF.get(user)), (String)this.backdoor.userProfile().getAvatarUrl(user));
        }
    }

    public void testGravatarsRemainOffAfterUpgradeWhenDefaultedToOff() throws Exception {
        this.backdoor.restoreDataFromResource("avatar/GravatarsDefault.xml");
        String base = this.getEnvironmentData().getBaseUrl().toString();
        for (String user : ImmutableList.of((Object)"user_with_avatar", (Object)"user_without_avatar")) {
            TestAvatarSettingsMigration.assertEquals((String)(user + " should keep their internal avatar after upgrade"), (String)(base + GRAVATAR_OFF.get(user)), (String)this.backdoor.userProfile().getAvatarUrl(user));
        }
    }
}

