/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.attachment;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rules.CopyAttachmentsRule;
import com.google.common.io.LineReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.io.IOUtils;

@WebTest(value={Category.FUNC_TEST, Category.ATTACHMENTS, Category.SECURITY})
public class TestZipAttachmentSecurity
extends FuncTestCase {
    private final HttpClient client = new HttpClient();
    protected CopyAttachmentsRule copyAttachmentsRule;

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestZipAttachmentSecurity/TestZipAttachmentSecurity.xml");
        this.backdoor.attachments().enable();
        this.copyAttachmentsRule = new CopyAttachmentsRule(this);
        this.copyAttachmentsRule.before();
        this.copyAttachmentsRule.copyAttachmentsFrom("TestZipAttachmentSecurity/attachments");
        this.client.getState().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials("admin", "admin"));
        this.client.getParams().setAuthenticationPreemptive(true);
    }

    @Override
    protected void tearDownTest() {
        this.copyAttachmentsRule.after();
        super.tearDownTest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAttachmentUnzippingWithChrome() throws URISyntaxException, IOException {
        GetMethod request = new GetMethod(this.unzipFileUri().toString());
        request.setRequestHeader("User-Agent", "Mozilla/5.0 (X11; Linux x86_64)");
        int status = this.client.executeMethod((HttpMethod)request);
        TestZipAttachmentSecurity.assertEquals((int)200, (int)status);
        InputStream is = request.getResponseBodyAsStream();
        try {
            LineReader lineReader = new LineReader((Readable)new InputStreamReader(is));
            TestZipAttachmentSecurity.assertEquals((String)"1: This is a text file with 1000 lines.", (String)lineReader.readLine());
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAttachmentUnzuppingWithOldIE() throws IOException, URISyntaxException {
        GetMethod request = new GetMethod(this.unzipFileUri().toString());
        request.setRequestHeader("User-Agent", "Mozilla/5.0 (compatible; MSIE 7.01; Windows NT 5.0)");
        int status = this.client.executeMethod((HttpMethod)request);
        TestZipAttachmentSecurity.assertEquals((int)200, (int)status);
        InputStream is = request.getResponseBodyAsStream();
        try {
            LineReader lineReader = new LineReader((Readable)new InputStreamReader(is));
            TestZipAttachmentSecurity.assertEquals((String)"1: This is a text file with 1000 lines.", (String)lineReader.readLine());
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    private URI unzipFileUri() throws URISyntaxException {
        return UriBuilder.fromUri((URI)this.environmentData.getBaseUrl().toURI()).path("secure/attachmentzip/unzip/10010/10000%5B0%5D/file.txt").build(new Object[0]);
    }
}

