/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.attachment;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;

@WebTest(value={Category.FUNC_TEST, Category.ATTACHMENTS, Category.ISSUES})
public class TestIssueFileAttachments
extends FuncTestCase {
    private static final String ATTACHMENT_SETTINGS_TABLE_ID = "table-AttachmentSettings";
    private static final int ALLOW_ATTACHMENTS_VALUE_COLUMN_NUMBER = 1;
    private static final int ALLOW_ATTACHMENTS_ROW_NUMBER = 0;
    private static final int ENABLE_THUMBNAILS_ROW_NUMBER = 3;
    private static final int ENABLE_THUMBNAILS_VALUE_COLUMN_NUMBER = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIssueFileAttachmentEnableThumbnailsAsAdmin() {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.attachments().enable();
            this.navigation.logout();
            this.navigation.login("admin", "admin");
            this.navigation.gotoAdminSection(Navigation.AdminSection.ATTACHMENTS);
            this.assertThatAttachmentsAreEnabled();
            this.navigation.clickLinkWithExactText("Edit Settings");
            this.tester.checkCheckbox("thumbnailsEnabled", "false");
            this.tester.submit("Update");
            this.assertThatThumbnailsAreDisabled();
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    public void testCreateAttachmentsWhenAttachmentsAreDisabled() {
        this.administration.restoreData("TestDeleteAttachments.xml");
        this.tester.gotoPage("/secure/AttachFile!default.jspa?id=10000");
        this.tester.setWorkingForm("attach-file");
        this.tester.submit();
        this.text.assertTextPresent(this.locator.page(), "Attachments have been disabled for this instance of JIRA.");
    }

    private void assertThatAttachmentsAreEnabled() {
        this.text.assertTextPresent(this.locator.cell(ATTACHMENT_SETTINGS_TABLE_ID, 0, 1), "ON");
    }

    private void assertThatThumbnailsAreDisabled() {
        this.text.assertTextSequence(this.locator.cell(ATTACHMENT_SETTINGS_TABLE_ID, 3, 1), "OFF", new String[0]);
    }
}

