/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.attachment;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.page.Error404;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.meterware.httpunit.HttpUnitOptions;
import org.junit.Assert;

@WebTest(value={Category.FUNC_TEST, Category.ATTACHMENTS})
public class TestIssueFileAttachmentErrors
extends FuncTestCase {
    @Override
    protected void setUpHttpUnitOptions() {
        this.log("not running normal test setup for " + this.getName());
        HttpUnitOptions.setExceptionsThrownOnErrorStatus((boolean)false);
        HttpUnitOptions.setScriptingEnabled((boolean)false);
    }

    @Override
    public void setUpTest() {
        super.setUpTest();
        this.tester.getTestContext().setBaseUrl(this.getEnvironmentData().getBaseUrl().toExternalForm());
        this.administration.restoreData("TestDeleteAttachments.xml");
        this.administration.attachments().enable();
    }

    @Override
    public void tearDownTest() {
        this.log("not running normal test teardown for " + this.getName());
        HttpUnitOptions.setExceptionsThrownOnErrorStatus((boolean)true);
    }

    public void testViewAttachmentWithNonNumericId() {
        Assert.assertThat((Object)new Error404(this.tester).visit("/secure/attachment/idontparse/DummyAttachment"), Error404.isOn404Page());
    }

    public void testViewAttachmentWithNoPath() {
        this.assertErrorResponse("/secure/attachment/", 400, "Invalid attachment path");
    }

    public void testTryDownloadAsZipWhenZipDisabled() throws Exception {
        this.administration.attachments().disableZipSupport();
        Assert.assertThat((Object)new Error404(this.tester).visit("/secure/attachmentzip/10000.zip"), Error404.isOn404Page());
    }

    private void assertErrorResponse(String url, int errorCode, String message) {
        this.tester.beginAt(url);
        TestIssueFileAttachmentErrors.assertEquals((int)errorCode, (int)this.tester.getDialog().getResponse().getResponseCode());
        this.assertions.html().assertResponseContains(this.tester, message);
    }
}

