/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.attachment;

import com.atlassian.jira.functest.framework.navigation.issue.AttachmentsBlock;
import com.atlassian.jira.functest.framework.navigation.issue.ImageAttachmentsGallery;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.webtests.ztests.attachment.AbstractTestAttachmentsBlockSortingOnViewIssue;
import java.util.List;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING})
public class TestImageAttachmentsGallerySorting
extends AbstractTestAttachmentsBlockSortingOnViewIssue {
    public void testAttachmentsDefaultToSortingByNameInDescendingOrder() throws Exception {
        List<ImageAttachmentsGallery.ImageAttachmentItem> expectedImageAttachments = CollectionBuilder.newBuilder(new ImageAttachmentsGallery.ImageAttachmentItem("200px-FCB.svg.png", "16 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("235px-Floppy_disk_2009_G1.jpg", "8 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("235px-Floppy_disk_2009_G1.jpg", "8 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("tropical-desktop-wallpaper-1280x1024.jpg", "115 kB")).asList();
        List<ImageAttachmentsGallery.ImageAttachmentItem> actualImageAttachments = this.navigation.issue().attachments("HSP-1").gallery().get();
        TestImageAttachmentsGallerySorting.assertEquals(expectedImageAttachments, actualImageAttachments);
    }

    public void testCanSortAttachmentsByFileNameInAscendingOrder() throws Exception {
        List<ImageAttachmentsGallery.ImageAttachmentItem> expectedImageAttachments = CollectionBuilder.newBuilder(new ImageAttachmentsGallery.ImageAttachmentItem("200px-FCB.svg.png", "16 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("235px-Floppy_disk_2009_G1.jpg", "8 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("235px-Floppy_disk_2009_G1.jpg", "8 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("tropical-desktop-wallpaper-1280x1024.jpg", "115 kB")).asList();
        AttachmentsBlock attachmentsBlock = this.navigation.issue().attachments("HSP-1");
        attachmentsBlock.sort(AttachmentsBlock.Sort.Key.NAME, AttachmentsBlock.Sort.Direction.ASCENDING);
        List<ImageAttachmentsGallery.ImageAttachmentItem> actualImageAttachments = attachmentsBlock.gallery().get();
        TestImageAttachmentsGallerySorting.assertEquals(expectedImageAttachments, actualImageAttachments);
        this.verifySortingSettingIsStickyDuringTheSession(expectedImageAttachments);
    }

    public void testCanSortAttachmentsByFileNameInDescendingOrder() throws Exception {
        List<ImageAttachmentsGallery.ImageAttachmentItem> expectedImageAttachments = CollectionBuilder.newBuilder(new ImageAttachmentsGallery.ImageAttachmentItem("tropical-desktop-wallpaper-1280x1024.jpg", "115 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("235px-Floppy_disk_2009_G1.jpg", "8 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("235px-Floppy_disk_2009_G1.jpg", "8 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("200px-FCB.svg.png", "16 kB")).asList();
        AttachmentsBlock attachmentsBlock = this.navigation.issue().attachments("HSP-1");
        attachmentsBlock.sort(AttachmentsBlock.Sort.Key.NAME, AttachmentsBlock.Sort.Direction.DESCENDING);
        List<ImageAttachmentsGallery.ImageAttachmentItem> actualImageAttachments = attachmentsBlock.gallery().get();
        TestImageAttachmentsGallerySorting.assertEquals(expectedImageAttachments, actualImageAttachments);
        this.verifySortingSettingIsStickyDuringTheSession(expectedImageAttachments);
    }

    public void testCanSortAttachmentsByDateInAscendingOrder() throws Exception {
        List<ImageAttachmentsGallery.ImageAttachmentItem> expectedImageAttachments = CollectionBuilder.newBuilder(new ImageAttachmentsGallery.ImageAttachmentItem("235px-Floppy_disk_2009_G1.jpg", "8 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("200px-FCB.svg.png", "16 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("tropical-desktop-wallpaper-1280x1024.jpg", "115 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("235px-Floppy_disk_2009_G1.jpg", "8 kB")).asList();
        AttachmentsBlock attachmentsBlock = this.navigation.issue().attachments("HSP-1");
        attachmentsBlock.sort(AttachmentsBlock.Sort.Key.DATE, AttachmentsBlock.Sort.Direction.ASCENDING);
        List<ImageAttachmentsGallery.ImageAttachmentItem> actualImageAttachments = attachmentsBlock.gallery().get();
        TestImageAttachmentsGallerySorting.assertEquals(expectedImageAttachments, actualImageAttachments);
        this.verifySortingSettingIsStickyDuringTheSession(expectedImageAttachments);
    }

    public void testCanSortAttachmentsByDateInDescendingOrder() throws Exception {
        List<ImageAttachmentsGallery.ImageAttachmentItem> expectedImageAttachments = CollectionBuilder.newBuilder(new ImageAttachmentsGallery.ImageAttachmentItem("235px-Floppy_disk_2009_G1.jpg", "8 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("tropical-desktop-wallpaper-1280x1024.jpg", "115 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("200px-FCB.svg.png", "16 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("235px-Floppy_disk_2009_G1.jpg", "8 kB")).asList();
        AttachmentsBlock attachmentsBlock = this.navigation.issue().attachments("HSP-1");
        attachmentsBlock.sort(AttachmentsBlock.Sort.Key.DATE, AttachmentsBlock.Sort.Direction.DESCENDING);
        List<ImageAttachmentsGallery.ImageAttachmentItem> actualImageAttachments = attachmentsBlock.gallery().get();
        TestImageAttachmentsGallerySorting.assertEquals(expectedImageAttachments, actualImageAttachments);
        this.verifySortingSettingIsStickyDuringTheSession(expectedImageAttachments);
    }

    private void verifySortingSettingIsStickyDuringTheSession(List<ImageAttachmentsGallery.ImageAttachmentItem> expectedFileAttachmentsList) {
        this.navigation.gotoDashboard();
        AttachmentsBlock attachmentsBlock = this.navigation.issue().attachments("HSP-1");
        List<ImageAttachmentsGallery.ImageAttachmentItem> actualImageAttachments = attachmentsBlock.gallery().get();
        TestImageAttachmentsGallerySorting.assertEquals(expectedFileAttachmentsList, actualImageAttachments);
    }
}

