/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.attachment;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

@WebTest(value={Category.FUNC_TEST, Category.ATTACHMENTS})
public class TestFindingAttachments
extends FuncTestCase {
    private String attachmentPath;

    @Override
    protected void setUpTest() {
        this.administration.restoreData("TestMoveIssueAttachment.xml");
        this.administration.attachments().enable();
        this.attachmentPath = this.administration.getCurrentAttachmentPath();
    }

    public void testFindingAttachmentWithBucketIssueDirectory() throws Exception {
        this.assertAttachedFileFound("This was stored with issue buckets", "/RAT/10000/RAT-1/", "10010");
    }

    public void testFindingAttachmentWithProjectIssueDirectory() throws Exception {
        this.assertAttachedFileFound("This was stored in project/issue", "/RAT/RAT-1/", "10010");
    }

    public void testFindingAttachmentWithLegacyFileName() throws Exception {
        this.assertAttachedFileFound("This was stored with legacy filename", "/RAT/RAT-1/", "10010_info");
    }

    private void assertAttachedFileFound(String fileContents, String filePath, String fileName) throws Exception {
        this.installAttachedFile(fileContents, filePath, fileName);
        this.navigation.issue().viewIssue("RAT-1");
        this.tester.clickLinkWithText("info.txt");
        this.tester.assertTextPresent(fileContents);
        this.deleteAttachment("RAT-1");
        this.tester.assertLinkNotPresentWithText("info.txt");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String installAttachedFile(String contents, String contentsPath, String filename) throws IOException {
        File attachedFile = new File(this.attachmentPath + contentsPath, filename);
        attachedFile.getParentFile().mkdirs();
        PrintWriter out = new PrintWriter(new FileWriter(attachedFile));
        try {
            out.println(contents);
        }
        finally {
            out.flush();
            out.close();
        }
        return this.attachmentPath;
    }

    private void deleteAttachment(String issueKey) {
        this.navigation.issue().viewIssue(issueKey);
        this.tester.clickLink("manage-attachment-link");
        this.tester.clickLink("del_10010");
        this.tester.submit("Delete");
    }
}

