/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.attachment;

import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.JIRAWebTest;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.ATTACHMENTS, Category.BROWSING})
public class TestEditAttachmentSettings
extends JIRAWebTest {
    public TestEditAttachmentSettings(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.restoreData("TestEditAttachmentSettings.xml");
    }

    @Override
    public void tearDown() {
        this.login("admin", "admin");
        this.restoreBlankInstance();
        super.tearDown();
    }

    public void testEditAttachmentSettingsValidation() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.ATTACHMENTS);
        this.clickLinkWithText("Edit Settings");
        this.selectMultiOptionByValue("attachmentPathOption", "DEFAULT");
        this.setFormElement("attachmentSize", "");
        this.setFormElement("thumbnailsEnabled", "true");
        this.submit("Update");
        this.assertTextPresent("Please specify the attachment size.");
        this.selectMultiOptionByValue("attachmentPathOption", "DEFAULT");
        this.setFormElement("attachmentSize", "-1");
        this.setFormElement("thumbnailsEnabled", "true");
        this.submit("Update");
        this.assertTextPresent("Attachment size must be a positive number.");
        this.selectMultiOptionByValue("attachmentPathOption", "DEFAULT");
        this.setFormElement("attachmentSize", "0");
        this.setFormElement("thumbnailsEnabled", "true");
        this.submit("Update");
        this.assertTextPresent("Attachment size must be a positive number.");
        this.selectMultiOptionByValue("attachmentPathOption", "DEFAULT");
        this.setFormElement("attachmentSize", "2147483648");
        this.setFormElement("thumbnailsEnabled", "true");
        this.submit("Update");
        this.assertTextPresent("Attachment size must be a number between 1 to 2147483647");
        this.selectMultiOptionByValue("attachmentPathOption", "DEFAULT");
        this.setFormElement("attachmentSize", "9999999999");
        this.setFormElement("thumbnailsEnabled", "true");
        this.submit("Update");
        this.assertTextPresent("Attachment size must be a number between 1 to 2147483647");
        this.selectMultiOptionByValue("attachmentPathOption", "DISABLED");
        this.setFormElement("attachmentSize", "1");
        this.setFormElement("thumbnailsEnabled", "true");
        this.submit("Update");
        this.assertTextPresent("Attachments must be enabled to enable thumbnails.");
        this.selectMultiOptionByValue("attachmentPathOption", "DISABLED");
        this.setFormElement("attachmentSize", "1");
        this.setFormElement("thumbnailsEnabled", "false");
        this.setFormElement("zipSupport", "true");
        this.submit("Update");
        this.assertTextPresent("Attachments must be enabled to enable ZIP support.");
    }

    public void testSizeIsNotUpdatedIfAttachmentsDisabled() throws SAXException {
        this.navigation.gotoAdminSection(Navigation.AdminSection.ATTACHMENTS);
        this.clickLinkWithText("Edit Settings");
        this.selectMultiOptionByValue("attachmentPathOption", "DEFAULT");
        this.setFormElement("attachmentSize", "12345");
        this.submit("Update");
        this.assertTextPresent("12 kB");
        this.clickLinkWithText("Edit Settings");
        this.selectMultiOptionByValue("attachmentPathOption", "DISABLED");
        this.setFormElement("attachmentSize", "54321");
        this.setFormElement("thumbnailsEnabled", "false");
        this.setFormElement("zipSupport", "false");
        this.submit("Update");
        this.assertTextPresent("12 kB");
        this.clickLinkWithText("Edit Settings");
        this.assertTextPresent("12345");
        this.assertTextNotPresent("54321");
    }

    public void testEditAttachmentSettingsJiraHome() {
        this.logout();
        this.login("sysadmin", "sysadmin");
        this.administration.attachments().enable("2940");
        this.navigation.gotoAdminSection(Navigation.AdminSection.ATTACHMENTS);
        this.clickLinkWithText("Edit Settings");
        this.setFormElement("thumbnailsEnabled", "true");
        this.submit("Update");
        this.assertTextSequence(new String[]{"Allow Attachments", "ON", "Attachment Path", "Default Directory", "Attachment Size", "3 kB", "Enable Thumbnails", "ON"});
    }

    public void testEditAttachmentSettingsWithGlobalAdmin() {
        String attachmentPath = this.getEnvironmentData().getWorkingDirectory().getAbsolutePath() + FS + "attachments";
        this.logout();
        this.login("sysadmin", "sysadmin");
        this.gotoAdmin();
        this.administration.attachments().enable("8765");
        this.navigation.gotoAdminSection(Navigation.AdminSection.ATTACHMENTS);
        this.clickLinkWithText("Edit Settings");
        this.selectMultiOptionByValue("attachmentPathOption", "DISABLED");
        this.setFormElement("thumbnailsEnabled", "false");
        this.setFormElement("zipSupport", "false");
        this.submit("Update");
        this.assertTextSequence(new String[]{"Allow Attachments", "OFF", "Attachment Path", "Attachment Size", "9 kB", "Enable Thumbnails", "OFF"});
        this.logout();
        this.login("globaladmin", "globaladmin");
        this.navigation.gotoAdminSection(Navigation.AdminSection.ATTACHMENTS);
        this.assertTextPresent("You can not enable thumbnails unless attachments are enabled.");
        this.assertLinkNotPresentWithText("Edit Settings");
        this.gotoPage("/secure/admin/jira/EditAttachmentSettings!default.jspa");
        this.assertFormElementNotPresent("attachmentPathOption");
        this.assertFormElementNotPresent("attachmentPath");
        this.setFormElement("attachmentSize", "5678");
        this.setFormElement("thumbnailsEnabled", "true");
        this.submit("Update");
        this.assertTextPresent("Attachments must be enabled to enable thumbnails.");
        this.setFormElement("thumbnailsEnabled", "false");
        this.submit("Update");
        this.assertTextSequence(new String[]{"Allow Attachments", "OFF", "Attachment Path", "Attachment Size", "9 kB", "Enable Thumbnails", "OFF"});
        this.logout();
        this.login("sysadmin", "sysadmin");
        this.navigation.gotoAdminSection(Navigation.AdminSection.ATTACHMENTS);
        this.clickLinkWithText("Edit Settings");
        this.selectMultiOptionByValue("attachmentPathOption", "DEFAULT");
        this.setFormElement("attachmentSize", "1234");
        this.setFormElement("thumbnailsEnabled", "false");
        this.submit("Update");
        this.assertTextSequence(new String[]{"Allow Attachments", "ON", "Attachment Size", "1 kB", "Enable Thumbnails", "OFF"});
        this.logout();
        this.login("globaladmin", "globaladmin");
        this.navigation.gotoAdminSection(Navigation.AdminSection.ATTACHMENTS);
        this.assertLinkPresentWithText("Edit Settings");
        this.clickLinkWithText("Edit Settings");
        this.assertFormElementNotPresent("attachmentPathOption");
        this.assertFormElementNotPresent("attachmentPath");
        this.setFormElement("attachmentSize", "3456");
        this.setFormElement("thumbnailsEnabled", "true");
        this.submit("Update");
        this.assertTextSequence(new String[]{"Allow Attachments", "ON", "Attachment Size", "3 kB", "Enable Thumbnails", "ON"});
    }

    public void testEditAttachmentSize() {
        this.assertAttachmentSize(1, "0.0 kB");
        this.assertAttachmentSize(1024, "1.0 kB");
        this.assertAttachmentSize(2048, "2 kB");
        this.assertAttachmentSize(0x100000, "1024 kB");
        this.assertAttachmentSize(0x100001, "1.00 MB");
        this.assertAttachmentSize(0x18CCCC, "1.55 MB");
        this.assertAttachmentSize(0xA00000, "10.00 MB");
        this.assertAttachmentSize(Integer.MAX_VALUE, "2,048.00 MB");
    }

    private void assertAttachmentSize(int maxSizeInBytes, String maxSizePrettyFormat) {
        this.administration.attachments().enable(String.valueOf(maxSizeInBytes));
        this.assertTextSequence(new String[]{"Allow Attachments", "ON", "Attachment Path", "Attachment Size", maxSizePrettyFormat, "Enable Thumbnails"});
        this.navigation.issue().goToCreateIssueForm(null, null);
        this.assertTextPresent("The maximum file upload size is " + maxSizePrettyFormat + ".");
        this.gotoIssue("HSP-1");
        this.clickLink("attach-file");
        this.assertTextPresent("The maximum file upload size is " + maxSizePrettyFormat + ".");
    }
}

