/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.attachment;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.navigation.issue.AttachmentsBlock;
import com.atlassian.jira.functest.framework.navigation.issue.FileAttachmentsList;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rules.CopyAttachmentsRule;
import java.util.List;

@WebTest(value={Category.FUNC_TEST, Category.ATTACHMENTS})
public class TestAttachmentEncoding
extends FuncTestCase {
    protected CopyAttachmentsRule copyAttachmentsRule;

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestAttachmentEncoding.xml");
        this.copyAttachmentsRule = new CopyAttachmentsRule(this);
        this.copyAttachmentsRule.before();
        this.copyAttachmentsRule.copyAttachmentsFrom("TestAttachmentEncoding/attachments");
    }

    @Override
    protected void tearDownTest() {
        this.copyAttachmentsRule.after();
        super.tearDownTest();
    }

    public void testCheckVariousAttachmentFilenames() {
        AttachmentsBlock attachments = this.navigation.issue().attachments("HSP-1");
        List<FileAttachmentsList.FileAttachmentItem> attachmentsList = attachments.list().get();
        TestAttachmentEncoding.assertEquals((int)3, (int)attachmentsList.size());
        this.tester.gotoPage("/secure/attachment/10000/clover.license");
        this.tester.gotoPage("/secure/attachment/10001/sqltool.rc");
        this.tester.gotoPage("/secure/attachment/10002/svn");
    }

    public void testMoveIssue() throws Exception {
        this.navigation.issue().viewIssue("HSP-1");
        this.tester.clickLink("move-issue");
        this.navigation.issue().selectProject("monkey");
        this.tester.submit("Next >>");
        this.tester.submit("Next >>");
        this.tester.submit("Move");
        for (FileAttachmentsList.FileAttachmentItem fileAttachmentItem : this.navigation.issue().attachments("MKY-1").list().get()) {
            this.tester.gotoPage("/secure/attachment/" + fileAttachmentItem.getId() + "/" + fileAttachmentItem.getName());
        }
    }
}

