/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.ao;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.LicenseKeys;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

@WebTest(value={Category.FUNC_TEST, Category.REFERENCE_PLUGIN, Category.ACTIVE_OBJECTS, Category.PLUGINS})
public class TestActiveObjectsRestore
extends FuncTestCase {
    public TestActiveObjectsRestore(String name) {
        this.setName(name);
    }

    public void testRestoreDataSuccessfully() {
        this.administration.restoreBlankInstance();
        String filePath = "ActiveObjects.zip";
        File file = new File(this.getEnvironmentData().getXMLDataLocation().getAbsolutePath() + "/" + filePath);
        this.copyFileToJiraImportDirectory(file);
        this.getTester().gotoPage("secure/admin/XmlRestore!default.jspa");
        this.getTester().setWorkingForm("restore-xml-data-backup");
        this.getTester().setFormElement("filename", filePath);
        this.getTester().setFormElement("license", LicenseKeys.V2_COMMERCIAL.getLicenseString());
        this.getTester().submit();
        this.administration.waitForRestore();
        this.getTester().assertTextPresent("Your import has been successful");
        this.getTester().assertTextNotPresent("NullPointerException");
    }

    public void testRestoreWithDatabaseErrors() {
        try {
            this.administration.restoreData("ActiveObjectsBadData.zip", false);
        }
        catch (Throwable e) {
            TestActiveObjectsRestore.assertTrue((String)"Active objects bad data", (boolean)e.getMessage().startsWith("Failed to restore JIRA data from"));
        }
        String expectedMessage = "There was a problem restoring ActiveObjects data for the plugin Atlassian JIRA - Plugins - Development Only - Reference Plugin(com.atlassian.jira.dev.reference-plugin) #1.0.0 plugin.";
        if (!this.tester.getDialog().isTextInResponse("There was a problem restoring ActiveObjects data for the plugin Atlassian JIRA - Plugins - Development Only - Reference Plugin(com.atlassian.jira.dev.reference-plugin) #1.0.0 plugin.")) {
            TestActiveObjectsRestore.fail((String)String.format("Could not find '%s' in page. Are you sure you have the jira-reference-plugin installed?", "There was a problem restoring ActiveObjects data for the plugin Atlassian JIRA - Plugins - Development Only - Reference Plugin(com.atlassian.jira.dev.reference-plugin) #1.0.0 plugin."));
        }
        CssLocator cssLocator = new CssLocator(this.getTester(), ".aui-message.error");
        this.assertions.assertNodeHasText(cssLocator, "There was a problem restoring ActiveObjects data for the plugin Atlassian JIRA - Plugins - Development Only - Reference Plugin(com.atlassian.jira.dev.reference-plugin) #1.0.0 plugin.");
        this.assertions.assertNodeHasText(cssLocator, "Importing table AO_98E482_REF_ENTITY failed. Please check the log for details.");
    }

    public void testRestoreWithParseErrors() {
        try {
            this.administration.restoreData("ActiveObjectsBadXml.zip", false);
        }
        catch (Throwable e) {
            TestActiveObjectsRestore.assertTrue((String)"Active objects bad data", (boolean)e.getMessage().startsWith("Failed to restore JIRA data from"));
        }
        CssLocator cssLocator = new CssLocator(this.getTester(), ".aui-message.error");
        this.assertions.assertNodeHasText(cssLocator, "There was a problem restoring ActiveObjects data for the <unknown plugin> plugin.");
        this.assertions.assertNodeHasText(cssLocator, "Caught exception with following message: Unexpected close tag </databaseGARBAGE>; expected </database>.\n at [row,col {unknown-source}]: [10,19].");
        this.assertions.assertNodeHasText(cssLocator, "Please check the log for details.");
    }

    private void copyFileToJiraImportDirectory(File file) {
        File jiraImportDirectory = new File(this.administration.getJiraHomeDirectory(), "import");
        try {
            FileUtils.copyFileToDirectory((File)file, (File)jiraImportDirectory);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not copy file " + file.getAbsolutePath() + " to the import directory in jira home " + jiraImportDirectory, e);
        }
    }
}

