/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.ao;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.client.apache.ApacheHttpClient;
import com.sun.jersey.client.apache.config.DefaultApacheHttpClientConfig;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.codehaus.jackson.jaxrs.JacksonJaxbJsonProvider;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsEmptyCollection;
import org.hamcrest.core.Is;

@WebTest(value={Category.FUNC_TEST, Category.PLUGINS, Category.ACTIVE_OBJECTS, Category.SLOW_IMPORT})
public class TestActiveObjects
extends FuncTestCase {
    private static final GenericType<List<Blog>> BLOG_LIST = new GenericType<List<Blog>>(){};
    private Client client;

    @Override
    protected void setUpTest() {
        DefaultApacheHttpClientConfig config = new DefaultApacheHttpClientConfig();
        config.getProperties().put("com.sun.jersey.impl.client.httpclient.preemptiveAuthentication", Boolean.TRUE);
        config.getState().setCredentials(null, null, -1, "admin", "admin");
        config.getClasses().add(JacksonJaxbJsonProvider.class);
        this.client = ApacheHttpClient.create((ClientConfig)config);
    }

    @Override
    protected void tearDownTest() {
        this.client.destroy();
    }

    public void testCreateEntryWithLongId() throws Exception {
        String AUTHOR = "bride";
        String TEXT = "You an I have unfinished business!";
        WebResource resource = this.createResource();
        this.deleteAll(resource);
        Blog newBlog = new Blog();
        newBlog.setAuthor("bride");
        newBlog.setText("You an I have unfinished business!");
        newBlog.setComments(Collections.emptyList());
        ClientResponse response = (ClientResponse)resource.type(MediaType.APPLICATION_JSON_TYPE).post(ClientResponse.class, (Object)newBlog);
        TestActiveObjects.assertEquals((int)Response.Status.CREATED.getStatusCode(), (int)response.getStatus());
        List blogs = (List)resource.get(BLOG_LIST);
        TestActiveObjects.assertEquals((int)1, (int)blogs.size());
        Blog savedBlog = (Blog)blogs.get(0);
        TestActiveObjects.assertEquals((String)"bride", (String)savedBlog.author);
        TestActiveObjects.assertEquals((String)"You an I have unfinished business!", (String)savedBlog.text);
        TestActiveObjects.assertNotNull((Object)savedBlog.id);
    }

    public void testUpdateEntryWithLongId() throws Exception {
        String author = "bride";
        String text = "You an I have unfinished business!";
        WebResource resource = this.createResource();
        this.deleteAll(resource);
        Blog newBlog = new Blog();
        newBlog.setAuthor(author);
        newBlog.setText(text);
        newBlog.setComments(Collections.emptyList());
        ClientResponse response = (ClientResponse)resource.type(MediaType.APPLICATION_JSON_TYPE).post(ClientResponse.class, (Object)newBlog);
        TestActiveObjects.assertEquals((int)Response.Status.CREATED.getStatusCode(), (int)response.getStatus());
        List blogs = (List)resource.get(BLOG_LIST);
        TestActiveObjects.assertEquals((int)1, (int)blogs.size());
        Blog savedBlog = (Blog)blogs.get(0);
        author = "groom";
        text = "I am leaving on a jet-plane!";
        savedBlog.setAuthor(author);
        savedBlog.setText(text);
        response = (ClientResponse)resource.type(MediaType.APPLICATION_JSON_TYPE).put(ClientResponse.class, (Object)savedBlog);
        TestActiveObjects.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatus());
        blogs = (List)resource.get(BLOG_LIST);
        TestActiveObjects.assertEquals((int)1, (int)blogs.size());
        Blog updatedBlog = (Blog)blogs.get(0);
        TestActiveObjects.assertEquals((String)author, (String)updatedBlog.author);
        TestActiveObjects.assertEquals((String)text, (String)updatedBlog.text);
        TestActiveObjects.assertEquals((Object)savedBlog.id, (Object)updatedBlog.id);
    }

    public void testDelete() throws Exception {
        String author = "bride";
        String text = "You an I have unfinished business!";
        WebResource resource = this.createResource();
        this.deleteAll(resource);
        Blog newBlog = new Blog();
        newBlog.setAuthor(author);
        newBlog.setText(text);
        newBlog.setComments(Collections.emptyList());
        ClientResponse response = (ClientResponse)resource.type(MediaType.APPLICATION_JSON_TYPE).post(ClientResponse.class, (Object)newBlog);
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Is.is((Object)Response.Status.CREATED.getStatusCode()));
        List blogs = (List)resource.get(BLOG_LIST);
        MatcherAssert.assertThat((Object)blogs.size(), (Matcher)Is.is((Object)1));
        Blog savedBlog = (Blog)blogs.get(0);
        response = (ClientResponse)resource.path(savedBlog.getId().toString()).type(MediaType.APPLICATION_JSON_TYPE).delete(ClientResponse.class);
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Is.is((Object)Response.Status.NO_CONTENT.getStatusCode()));
        blogs = (List)resource.get(BLOG_LIST);
        MatcherAssert.assertThat((Object)blogs, (Matcher)IsEmptyCollection.empty());
    }

    public void testCheckAOTablesDeletedOnRestore() throws Exception {
        WebResource resource = this.createResource();
        this.deleteAll(resource);
        Blog newBlog = new Blog();
        newBlog.setAuthor("bill");
        newBlog.setText("I'm the man");
        newBlog.setComments(Collections.emptyList());
        ClientResponse response = (ClientResponse)resource.type("application/json").post(ClientResponse.class, (Object)newBlog);
        TestActiveObjects.assertEquals((int)Response.Status.CREATED.getStatusCode(), (int)response.getStatus());
        this.administration.restoreDataSlowOldWay("blankprojects.xml");
        List blogs = (List)resource.get(BLOG_LIST);
        TestActiveObjects.assertTrue((String)"Blogs should have been cleared on restore.", (boolean)blogs.isEmpty());
    }

    private void deleteAll(WebResource resource) {
        ClientResponse deleteResponse = (ClientResponse)resource.delete(ClientResponse.class);
        TestActiveObjects.assertEquals((int)Response.Status.NO_CONTENT.getStatusCode(), (int)deleteResponse.getStatus());
    }

    private WebResource createResource() {
        return this.client.resource(this.environmentData.getBaseUrl().toExternalForm()).path("rest").path("func-test").path("latest").path("blog");
    }

    public static class Comment {
        private Blog blog;
        private String author;
        private String comment;
        private Date date;

        public Blog getBlog() {
            return this.blog;
        }

        public void setBlog(Blog blog) {
            this.blog = blog;
        }

        public String getAuthor() {
            return this.author;
        }

        public void setAuthor(String author) {
            this.author = author;
        }

        public String getComment() {
            return this.comment;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }

        public Date getDate() {
            return this.date;
        }

        public void setDate(Date date) {
            this.date = date;
        }

        public static Comment build(String author, String comment, Date date) {
            Comment c = new Comment();
            c.author = author;
            c.comment = comment;
            c.date = date;
            return c;
        }
    }

    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    public static class Blog {
        private Long id;
        private String author;
        private String text;
        private List<Comment> comments;

        public String getAuthor() {
            return this.author;
        }

        public void setAuthor(String author) {
            this.author = author;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public List<Comment> getComments() {
            return this.comments;
        }

        public void setComments(List<Comment> comments) {
            this.comments = comments;
        }

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }
}

